/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.jmx;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.management.GemFireProperties;
import com.gemstone.gemfire.management.JVMMetrics;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.OSMetrics;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import hydra.CacheHelper;
import hydra.RemoteTestModule;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import management.Expectations;
import management.jmx.JMXPrms;
import management.operations.ops.JMXOperations;
import management.operations.ops.jmx.AbstractTestMBean;
import management.test.jmx.JMXTest;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class MemberTestMbean
extends AbstractTestMBean<MemberTestMbean> {
    public MemberTestMbean(List<String> attrs, List<Object[]> ops, String ton, String[] tests) {
        super(attrs, ops, MemberTestMbean.class, ton, tests);
    }

    @Override
    public String getType() {
        return gemfireDefinedMBeanTypes[0];
    }

    public void createManager(JMXOperations ops, ObjectName targetMbean) {
        block9: {
            HydraUtil.logInfo(prefix + " Calling createManager : call createManager and then check isManager attribute");
            String url = "<local>";
            ObjectName oldTargetMbean = targetMbean;
            targetMbean = ManagementUtil.getLocalMemberMBeanON();
            HydraUtil.logInfo("Target mbean for test createManager has been changed from " + oldTargetMbean + " to " + targetMbean);
            boolean isManager = (Boolean)ops.getAttribute(url, targetMbean, "Manager");
            if (!isManager) {
                HydraUtil.logInfo(prefix + " Creating manager instance on " + url);
                Object result = this.callJmxOperation(url, ops, this.buildOperationArray("createManager", null, null, null), targetMbean);
                HydraUtil.logInfo("Result of createManager " + HydraUtil.ObjectToString(result));
                ObjectName managerMbean = ManagementUtil.getLocalManagerMBean();
                if (managerMbean == null) {
                    throw new TestException("Could not locate manager mbean after createManager");
                }
                boolean startManagerResult = (Boolean)this.callJmxOperation(url, ops, this.buildOperationArray("start", null, null, null), managerMbean);
                HydraUtil.logInfo("Result of startManager " + HydraUtil.ObjectToString(startManagerResult));
                if (!startManagerResult) {
                    throw new TestException("Could start manager on memberMBean. Returned false");
                }
                HydraUtil.sleepForReplicationJMX();
                isManager = (Boolean)ops.getAttribute(url, targetMbean, "Manager");
                boolean isManagerRunning = (Boolean)ops.getAttribute(url, managerMbean, "Running");
                HydraUtil.logInfo("isManager attribute after startManager : " + isManager);
                HydraUtil.logInfo("isManagerRunning attribute after startManager : " + isManagerRunning);
                if (!isManager || !isManagerRunning) {
                    throw new TestException("createManager JMX OP failed to make Member " + url + " Manager");
                }
                try {
                    MBeanServerConnection server = ops.getMBeanConnection(url);
                    ManagementUtil.checkIfThisMemberIsCompliantManager(server);
                    break block9;
                }
                catch (IOException e) {
                    throw new TestException("error trying to connect member " + url, e);
                }
                catch (TestException e) {
                    throw new TestException("Possible reason Bug #45600 - newly created JMX Manager via Member MBean does not create proxies to managed node in timely manner", e);
                }
            }
            HydraUtil.logInfo("Member " + url + " is already manager. Skipping the testcase");
        }
    }

    public void listDiskStores(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling listDiskStores");
        String url = ops.selectManagingNode();
        Object[] params = new Object[]{true};
        String[] signature = new String[]{"boolean"};
        Object result = this.callJmxOperation(url, ops, this.buildOperationArray("listDiskStores", params, signature, null), targetMbean);
        HydraUtil.logInfo("Result of listDiskStores " + HydraUtil.ObjectToString(result));
    }

    public void fetchLicense(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchLicense");
        String url = ops.selectManagingNode();
        Object result = this.callJmxOperation(url, ops, this.buildOperationArray("viewLicense", null, null, null), targetMbean);
        HydraUtil.logInfo("Result of fetchLicence " + HydraUtil.ObjectToString(result));
    }

    public void fetchLog(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchLog");
        String url = ops.selectManagingNode();
        Object result = this.callJmxOperation(url, ops, this.buildOperationArray("showLog", new Object[]{100}, new String[]{"int"}, null), targetMbean);
        HydraUtil.logInfo("Result of fetchLog " + HydraUtil.ObjectToString(result));
    }

    public void checkGemfireConfig(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireConfig");
        String url = ops.selectManagingNode();
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData gemfireProp = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("listGemFireProperties", null, null, null), targetMbean);
            HydraUtil.logInfo("Gemfire Properties " + HydraUtil.ObjectToString(gemfireProp));
        } else {
            GemFireProperties gemfireProp = (GemFireProperties)this.callJmxOperation(url, ops, this.buildOperationArray("listGemFireProperties", null, null, null), targetMbean);
            HydraUtil.logInfo("Gemfire Properties " + HydraUtil.ObjectToString(gemfireProp));
        }
    }

    public void checkOtherConfig(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"ClassPath", "CurrentTime", "Groups", "Host", "LockLease", "LockTimeout", "Member", "MemberUpTime", "Version"};
        HydraUtil.logInfo(prefix + " Calling checkOtherConfig");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("Other Gemfire Properties " + HydraUtil.ObjectToString(attrList));
    }

    public void checkRegionCounters(JMXOperations ops, ObjectName targetMbean) {
        String[] attributes = new String[]{"PartitionRegionCount", "RootRegionNames", "TotalBucketCount", "TotalHitCount", "TotalMissCount", "TotalNetLoadsCompleted", "TotalNetSearchCompleted", "TotalNumberOfGrantors", "TotalPrimaryBucketCount", "TotalRegionCount", "TotalRegionEntryCount", "TotalLoadsCompleted"};
        HydraUtil.logInfo(prefix + " Calling checkRegionCounters");
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("Region Counters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Calling listRegions");
        String[] listRegions = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listRegions", null, null, null), targetMbean);
        HydraUtil.logInfo("listRegions " + HydraUtil.ObjectToString(listRegions));
    }

    public void fetchJVMMetrics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchJVMMetrics");
        String url = ops.selectManagingNode();
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData jvmMetrics = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showJVMMetrics", null, null, null), targetMbean);
            HydraUtil.logInfo("JvmMetrics " + HydraUtil.ObjectToString(jvmMetrics));
        } else {
            JVMMetrics jvmMetrics = (JVMMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showJVMMetrics", null, null, null), targetMbean);
            HydraUtil.logInfo("JvmMetrics " + HydraUtil.ObjectToString(jvmMetrics));
        }
    }

    public void fetchOSMetrics(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling fetchOSMetrics");
        String url = ops.selectManagingNode();
        if (!JMXPrms.useGemfireProxies()) {
            CompositeData osMetrics = (CompositeData)this.callJmxOperation(url, ops, this.buildOperationArray("showOSMetrics", null, null, null), targetMbean);
            HydraUtil.logInfo("osMetrics " + HydraUtil.ObjectToString(osMetrics));
        } else {
            OSMetrics osMetrics = (OSMetrics)this.callJmxOperation(url, ops, this.buildOperationArray("showOSMetrics", null, null, null), targetMbean);
            HydraUtil.logInfo("osMetrics " + HydraUtil.ObjectToString(osMetrics));
        }
    }

    public void processCommand(JMXOperations ops, ObjectName targetMbean) {
        String[] commands2 = new String[]{"list member", "list region"};
        String command = HydraUtil.getRandomElement(commands2);
        HydraUtil.logInfo(prefix + " Calling processCommand with " + command);
        String url = ops.selectManagingNode();
        Object[] params = new Object[]{command};
        String[] signature = new String[]{"java.lang.String"};
        String jsonResult = (String)this.callJmxOperation(url, ops, this.buildOperationArray("processCommand", params, signature, null), targetMbean);
        HydraUtil.logInfo("String returned by processCommand " + jsonResult);
    }

    @Override
    public void doValidation(JMXOperations ops) {
    }

    public void checkRegionLatencyCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionLatencyCounters");
        String[] attributes = new String[]{"CacheListenerCallsAvgLatency", "CacheWriterCallsAvgLatency", "GetsAvgLatency", "LoadsAverageLatency", "NetLoadsAverageLatency", "NetSearchAverageLatency", "PutAllAvgLatency", "PutsAvgLatency"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionLatencyCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionLatencyCounters test successfully");
    }

    public void checkRegionRateCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkRegionRateCounters");
        String[] attributes = new String[]{"CreatesRate", "DestroysRate", "GetsRate", "PutAllRate", "PutsRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkRegionRateCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkRegionRateCounters test successfully");
    }

    public void checkWANResources(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkWANResources");
        String url = ops.selectManagingNode();
        HydraUtil.logInfo(prefix + " Calling listConnectedGatewayReceivers");
        String[] listConnectedGatewayReceivers = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listConnectedGatewayReceivers", null, null, null), targetMbean);
        HydraUtil.logInfo("listConnectedGatewayReceivers " + HydraUtil.ObjectToString(listConnectedGatewayReceivers));
        HydraUtil.logInfo(prefix + " Calling listConnectedGatewaySenders");
        String[] listConnectedGatewaySenders = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("listConnectedGatewaySenders", null, null, null), targetMbean);
        HydraUtil.logInfo("listConnectedGatewaySenders " + HydraUtil.ObjectToString(listConnectedGatewaySenders));
        HydraUtil.logInfo(prefix + " Completed checkWANResources test successfully");
    }

    public void checkGemfireRateCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireRateCounters");
        String[] attributes = new String[]{"BytesReceivedRate", "BytesSentRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireRateCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireRateCounters test successfully");
    }

    public void checkFunctionCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkFunctionCounters");
        String[] attributes = new String[]{"NumRunningFunctions", "NumRunningFunctionsHavingResults", "FunctionExecutionRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkFunctionCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkFunctionCounters test successfully");
    }

    public void checkGemfireTxCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireTxCounters");
        String[] attributes = new String[]{"TotalTransactionsCount", "TransactionCommitsAvgLatency", "TransactionCommitsRate", "TransactionCommittedTotalCount", "TransactionRolledBackTotalCount"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireTxCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireTxCounters test successfully");
    }

    public void checkGemfireDiskCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireDiskCounters");
        String[] attributes = new String[]{"DiskFlushAvgLatency", "DiskReadsRate", "DiskStores", "DiskWritesRate", "TotalBackupInProgress"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireDiskCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireDiskCounters test successfully");
    }

    public void checkGemfireLockCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireLockCounters");
        String[] attributes = new String[]{"LockRequestQueues", "LockWaitsInProgress", "TotalLockWaitTime", "TotalNumberOfLockService"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireLockCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireLockCounters test successfully");
    }

    public void checkGemfireLruCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireLruCounters");
        String[] attributes = new String[]{"LruDestroyRate", "LruEvictionRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireLruCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireLruCounters test successfully");
    }

    public void checkGIICounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGIICounters");
        String[] attributes = new String[]{"InitialImageTime", "InitialImageKeysReceived", "InitialImagesInProgres"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGIICounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGIICounters test successfully");
    }

    public void checkGemfireSerializationCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkGemfireSerializationCounters");
        String[] attributes = new String[]{"DeserializationAvgLatency", "DeserializationLatency", "DeserializationRate", "PDXDeserializationAvgLatency", "PDXDeserializationRate", "SerializationAvgLatency", "SerializationLatency", "SerializationRate"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkGemfireSerializationCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Completed checkGemfireSerializationCounters test successfully");
    }

    public void checkPlatformCounters(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkPlatformCounters");
        String[] attributes = new String[]{"CpuUsage", "CurrentHeapSize", "FileDescriptorLimit", "FreeHeapSize", "MaximumHeapSize", "TotalBackupCompleted", "TotalDiskTasksWaiting", "TotalFileDescriptorOpen"};
        String url = ops.selectManagingNode();
        AttributeList attrList = (AttributeList)ops.getAttributes(url, targetMbean, attributes);
        HydraUtil.logInfo("checkPlatformCounters " + HydraUtil.ObjectToString(attrList));
        HydraUtil.logInfo(prefix + " Calling fetchJvmThreads");
        String[] fetchJvmThreads = (String[])this.callJmxOperation(url, ops, this.buildOperationArray("fetchJvmThreads", null, null, null), targetMbean);
        HydraUtil.logInfo("fetchJvmThreads " + HydraUtil.ObjectToString(fetchJvmThreads));
        HydraUtil.logInfo(prefix + " Completed checkPlatformCounters test successfully");
    }

    public void cacheStopStart(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling cacheStartStop");
        try {
            JMXTest.cacheStopStart();
        }
        catch (IOException e) {
            throw new TestException("IOEXECPTION", e);
        }
        HydraUtil.logInfo(prefix + " Completed cacheStartStop successfully");
    }

    public void checkSystemAlert(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling checkSystemAlert");
        String url = ops.selectManagingNode();
        targetMbean = MBeanJMXAdapter.getDistributedSystemName();
        int dsId = (Integer)ops.getAttribute(url, targetMbean, "DistributedSystemId");
        String source = "DistributedSystem(" + dsId + ")";
        AbstractTestMBean.InPlaceJMXNotifValidator validator = new AbstractTestMBean.InPlaceJMXNotifValidator("checkSystemAlert", targetMbean, url);
        String message = "MSG" + System.nanoTime();
        validator.expectationList.add(Expectations.forMBean(targetMbean).expectMBeanAt(url).expectNotification("system.alert", (Object)source, message, null, 4));
        Cache cache = CacheHelper.getCache();
        LogWriter writer = cache.getLogger();
        writer.severe(message);
        HydraUtil.sleepForReplicationJMX();
        validator.validateNotifications();
        HydraUtil.logInfo(prefix + " Completed checkSystemAlert test successfully");
    }

    public void doTransition(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling doTransition");
        String clientName = RemoteTestModule.getMyClientName();
        if (clientName.contains("managing")) {
            this.doManagerTransitions(ops, targetMbean);
        } else if (clientName.contains("managed")) {
            this.doManagedTransitions(ops, targetMbean);
        }
        HydraUtil.logInfo(prefix + " Completed doTransition test successfully");
    }

    private void doManagedTransitions(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling doManagedTransitions");
        String url = "<local>";
        HydraUtil.logInfo("Transitioing from Managed to Managing node..");
        ManagementService service = JMXTest.getManagementService();
        this.createAndCheckManager(service);
        HydraUtil.logInfo("Transitioing from Managed to Managing node Complete.");
        HydraUtil.logInfo("Transitioing from Managing to Managed node ..");
        MBeanServerConnection server = ops.getMBeanConnection(url);
        this.stopAndCheckManager(server, service);
        HydraUtil.logInfo("Transitioing from Managing to Managed node Complete.");
        HydraUtil.logInfo(prefix + " Completed doManagedTransitions test successfully");
    }

    private void doManagerTransitions(JMXOperations ops, ObjectName targetMbean) {
        HydraUtil.logInfo(prefix + " Calling doManagerTransitions");
        String url = "<local>";
        HydraUtil.logInfo("Transitioing from Managing to Managed node ..");
        ManagementService service = JMXTest.getManagementService();
        MBeanServerConnection server = ops.getMBeanConnection(url);
        HydraUtil.logInfo("Transitioing from Managing to Managed node Complete.");
        HydraUtil.logInfo("Transitioing from Managed to Managing node..");
        this.stopAndCheckManager(server, service);
        this.createAndCheckManager(service);
        HydraUtil.logInfo("Transitioing from Managed to Managing node Complete.");
        HydraUtil.logInfo(prefix + " Completed doManagerTransitions test successfully");
    }

    private void createAndCheckManager(ManagementService service) {
        if (service.isManager()) {
            throw new TestException("This is supposed to be managed node. Should not host manager");
        }
        service.startManager();
        HydraUtil.sleepForReplicationJMX();
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ManagementUtil.checkIfThisMemberIsCompliantManager(server);
        }
        catch (IOException e) {
            throw new TestException("Error connecting manager", e);
        }
        catch (TestException e) {
            throw e;
        }
    }

    private void stopAndCheckManager(MBeanServerConnection server, ManagementService service) {
        service.stopManager();
        if (service.isManager()) {
            throw new TestException("Stop manager failed. Transition from manager to managed failed..");
        }
        HydraUtil.sleepForReplicationJMX();
        try {
            List<String> list = ManagementUtil.checkForManagedMbeanProxies(server);
            if (list.size() <= 1) {
                throw new TestException("Managed member, after transitioning still contains proxies to managed nodes " + list);
            }
            list = ManagementUtil.checkForManagingMbeanProxies(server);
            if (list.size() <= 1) {
                throw new TestException("Managed member, after transitioning still contains proxies to managing nodes " + list);
            }
            if (ManagementUtil.checkForDistributedMBean(server)) {
                throw new TestException("DistributedSystemMBean is still present in platform mbean server");
            }
        }
        catch (IOException e) {
            throw new TestException("error", e);
        }
        catch (TestException e) {
            throw e;
        }
    }

    static {
        prefix = "MemberTestMbean : ";
    }
}

