/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.List;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.EntryOperations;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.util.HydraUtil;

public class RebalanceExecutor
extends AbstractTestCommandExecutor {
    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
        if ("simulate".equals(op.name)) {
            instance.addOption(op.name, "true");
            return;
        }
        if ("exclude-region".equals(op.name)) {
            instance.addOption(op.name, this.getExistingRegionList());
            return;
        }
        if ("include-region".equals(op.name)) {
            instance.addOption(op.name, this.getExistingRegionList());
            return;
        }
        if ("time-out".equals(op.name)) {
            instance.addOption(op.name, 5 + TestConfig.tab().getRandGen().nextInt(15));
            return;
        }
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        if ("simulate".equals(name)) {
            instance.addOption(name, "true");
            return;
        }
        if ("exclude-region".equals(name)) {
            instance.addOption(name, this.getExistingRegionList());
            return;
        }
        if ("include-region".equals(name)) {
            instance.addOption(name, this.getExistingRegionList());
            return;
        }
    }

    private Object getExistingRegionList() {
        int i;
        StringBuilder sb = new StringBuilder();
        ArrayList<String> selectedList = new ArrayList<String>();
        List<String> regionList = RegionEvents.getAllRegions();
        for (i = 0; i < regionList.size(); ++i) {
            int ijk = TestConfig.tab().getRandGen().nextInt(1000);
            if (ijk % 2 != 0) continue;
            selectedList.add(regionList.get(i));
        }
        if (selectedList.size() == 0) {
            selectedList.add(regionList.get(0));
        }
        for (i = 0; i < selectedList.size(); ++i) {
            sb.append((String)selectedList.get(i));
            if (i == selectedList.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private void performEntryOperationsOnOneRegionOnly() {
        List<String> regionList = RegionEvents.getAllRegions();
        HydraUtil.logInfo("Obtained region list " + regionList);
        int numRegionsToModify = TestConfig.tab().getRandGen().nextInt(regionList.size() - 1);
        HydraUtil.logInfo("Performing entry operations on " + numRegionsToModify + " regions");
        for (int i = 0; i < numRegionsToModify; ++i) {
            int regionNum = TestConfig.tab().getRandGen().nextInt(regionList.size() - 1);
            String regionPath = regionList.get(regionNum);
            HydraUtil.logInfo("Performing entry operations on " + regionPath);
            Region region = CacheHelper.getCache().getRegion(regionPath);
            EntryOperations eOps = CLITest.getEntryOperations(regionPath);
            for (int j = 0; j < 1000; ++j) {
                eOps.doEntryOperation();
            }
        }
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

