/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.management.internal.cli.dto.Key1;
import com.gemstone.gemfire.management.internal.cli.dto.Value2;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import util.TestException;

public class PutExecutor
extends AbstractTestCommandExecutor {
    private static final String keyTemplate = "('id':'?','name':'name?')";
    private static final String valueTemplate = "('stateName':'State?','population':?1,'capitalCity':'capital?','areaInSqKm':?2)";

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
        if ("skip-if-exists".equals(op.name)) {
            instance.addOption(op.name, "true");
            return;
        }
        throw new TestException("Unknown option " + op.name);
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        int keyIndex = HydraUtil.getnextRandomInt(1000);
        String keyPrefix = "KEY_" + keyIndex;
        if (instance.getMode().contains("json")) {
            if ("key".equals(name)) {
                String keyString = keyPrefix;
                String keyJson = keyTemplate.replaceAll("\\?", keyString);
                instance.addOption(name, keyJson);
                return;
            }
            if ("region".equals(name)) {
                CLITest.useRegion(instance, name, CLITest.getJSONRegion());
                return;
            }
            if ("value".equals(name)) {
                String keyString = keyPrefix;
                String population = "" + keyIndex * 100;
                String area = "" + (double)keyIndex * 100.4365;
                String valueJson = valueTemplate.replaceAll("\\?1", population);
                valueJson = valueJson.replaceAll("\\?2", area);
                valueJson = valueJson.replaceAll("\\?", keyString);
                instance.addOption(name, valueJson);
                return;
            }
            if ("key-class".equals(name)) {
                instance.addOption(name, Key1.class.getCanonicalName());
                return;
            }
            if ("value-class".equals(name)) {
                instance.addOption(name, Value2.class.getCanonicalName());
                return;
            }
        } else {
            if ("key".equals(name)) {
                instance.addOption(name, keyPrefix);
                return;
            }
            if ("region".equals(name)) {
                CLITest.useRegion(instance, name, CLITest.getStringRegion());
                return;
            }
            if ("value".equals(name)) {
                instance.addOption(name, "VALUE_" + keyIndex);
                return;
            }
            if ("key-class".equals(name)) {
                throw new TestException("No key-class for this mode test setup check again");
            }
            if ("value-class".equals(name)) {
                throw new TestException("No value-class for this mode test setup check again");
            }
        }
        throw new TestException("Unknown option " + name);
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

