/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.management.internal.cli.dto.Key1;
import com.gemstone.gemfire.management.internal.cli.dto.Value2;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import util.TestException;

public class LocateEntryExecutor
extends AbstractTestCommandExecutor {
    private static final String keyTemplate = "('id':'?','name':'name?')";

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
        if ("recursive".equals(op.name)) {
            instance.addOption(op.name, "true");
            return;
        }
        throw new TestException("Unknown option " + op.name);
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        int keyIndex = HydraUtil.getnextRandomInt(1000);
        String keyPrefix = "KEY_" + keyIndex;
        if (instance.getMode().contains("json")) {
            if ("key".equals(name)) {
                String keyString = keyPrefix;
                String keyJson = keyTemplate.replaceAll("\\?", keyString);
                instance.addOption(name, keyJson);
                return;
            }
            if ("region".equals(name)) {
                CLITest.useRegion(instance, name, CLITest.getJSONRegion());
                return;
            }
            if ("key-class".equals(name)) {
                instance.addOption(name, Key1.class.getCanonicalName());
                return;
            }
            if ("value-class".equals(name)) {
                instance.addOption(name, Value2.class.getCanonicalName());
                return;
            }
        } else {
            if ("key".equals(name)) {
                instance.addOption(name, keyPrefix);
                return;
            }
            if ("region".equals(name)) {
                CLITest.useRegion(instance, name, CLITest.getChildRegion());
                return;
            }
            if ("key-class".equals(name)) {
                throw new TestException("No key-class for this mode test setup check again");
            }
            if ("value-class".equals(name)) {
                throw new TestException("No value-class for this mode test setup check again");
            }
        }
        throw new TestException("Unknown option " + name);
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

