/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import java.util.List;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ReflectionException;
import management.cli.CLIBlackboard;
import management.cli.TestableGfsh;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandInstance;
import management.operations.ops.cli.executors.AbstractTestCommandExecutor;
import management.util.HydraUtil;
import management.util.ManagementUtil;
import util.TestException;

public class ExecFunctionExecutor
extends AbstractTestCommandExecutor {
    private String member = null;
    private String group = null;

    @Override
    public Object verifyCommand(TestableGfsh gfsh, Object object) {
        if (this.member != null || this.group != null) {
            List memberList = CLIBlackboard.getBB().getList("FUNCTION_EXEC_LIST");
            HydraUtil.logInfo("Member Execution List " + memberList);
            if (this.group != null) {
                try {
                    Set<String> members = ManagementUtil.getMembersForGroup(this.group);
                    for (String m : members) {
                        boolean flag = false;
                        for (String minList : memberList) {
                            if (!minList.equals(m)) continue;
                            flag = true;
                        }
                        if (flag) continue;
                        this.addFailure("Member " + m + " is not recorded in Blackboard for functionExecution. List " + memberList);
                    }
                }
                catch (MalformedObjectNameException e) {
                    throw new TestException("Error while getting member for group", e);
                }
                catch (InstanceNotFoundException e) {
                    throw new TestException("Error while getting member for group", e);
                }
                catch (AttributeNotFoundException e) {
                    throw new TestException("Error while getting member for group", e);
                }
                catch (NullPointerException e) {
                    throw new TestException("Error while getting member for group", e);
                }
                catch (MBeanException e) {
                    throw new TestException("Error while getting member for group", e);
                }
                catch (ReflectionException e) {
                    throw new TestException("Error while getting member for group", e);
                }
            } else {
                String member = (String)memberList.get(0);
                if (!member.equals(this.member)) {
                    this.addFailure("Blackboard list indicated different members " + memberList + " expected : " + this.member);
                }
            }
            this.member = null;
            this.group = null;
        }
        return null;
    }

    @Override
    protected void fillOption(TestCommandInstance instance, TestCommand.CommandOption op) {
    }

    @Override
    public Object executeAndVerify(TestCommandInstance instance) {
        CLIBlackboard.getBB().clearList("FUNCTION_EXEC_LIST");
        return super.executeAndVerify(instance);
    }

    @Override
    protected void fillMandatoryOption(TestCommandInstance instance, String name) {
        if ("id".equals(name)) {
            instance.addOption(name, instance.getMode());
            return;
        }
        if ("group".equals(name)) {
            this.group = this.getGroup();
            instance.addOption(name, this.group);
            return;
        }
        if ("member".equals(name)) {
            this.member = this.getMemberId();
            instance.addOption(name, this.member);
            return;
        }
        if ("region".equals(name)) {
            instance.addOption(name, this.getRegion());
            return;
        }
        if ("arguments".equals(name)) {
            instance.addOption(name, instance.getMode());
            return;
        }
        if ("filter".equals(name)) {
            instance.addOption(name, "KEY*");
            return;
        }
        if ("result-collector".equals(name)) {
            instance.addOption(name, "management.operations.ops.FunctionOperations$CustomResultCollector");
            return;
        }
    }

    @Override
    protected void fillArgument(TestCommandInstance instance, String name) {
    }
}

