/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli.executors;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import management.cli.CLIBlackboard;
import management.cli.TestableGfsh;
import management.operations.events.impl.FunctionEvents;
import management.operations.events.impl.RegionEvents;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandExecutor;
import management.operations.ops.cli.TestCommandInstance;
import management.test.cli.CLITest;
import management.test.federation.FederationBlackboard;
import management.util.HydraUtil;
import management.util.ManagementUtil;

public abstract class AbstractTestCommandExecutor
implements TestCommandExecutor {
    private static final long serialVersionUID = 1L;
    public static final String FILE_TYPE_TEXT = ".txt";
    public static final String COLOCATED_ROOT_REGION = "TestPartition_1";
    public static final String COLOCATED_ROOT_DISK_REGION = "TestPersistentPartitionDisk1_2";
    public static final String COLOCATED_REGION_PATTERN = "PartitionColocated";
    String[] diskStores = new String[]{"disk1", "disk2", "disk3", "disk4"};

    @Override
    public void fillOptionValues(TestCommandInstance instance, List<TestCommand.CommandOption> options) {
        for (TestCommand.CommandOption op : options) {
            this.fillOption(instance, op);
        }
    }

    @Override
    public void fillMandotoryOptionValues(TestCommandInstance instance, List<String> mandotoryCommandOptions) {
        for (String op : mandotoryCommandOptions) {
            this.fillMandatoryOption(instance, op);
        }
    }

    @Override
    public void fillArguments(TestCommandInstance instance, List<String> args) {
        for (String op : args) {
            this.fillArgument(instance, op);
        }
    }

    @Override
    public Object verifyGemfire(TestableGfsh gfsh, Object object) {
        return null;
    }

    @Override
    public Object verifyJMX(TestableGfsh gfsh, Object object) {
        return null;
    }

    @Override
    public Object verifyCommand(TestableGfsh gfsh, Object object) {
        return null;
    }

    @Override
    public Object execute(TestCommandInstance instance) {
        return null;
    }

    @Override
    public void setUpGemfire() {
    }

    protected abstract void fillArgument(TestCommandInstance var1, String var2);

    protected abstract void fillOption(TestCommandInstance var1, TestCommand.CommandOption var2);

    protected abstract void fillMandatoryOption(TestCommandInstance var1, String var2);

    @Override
    public Object executeAndVerify(TestCommandInstance instance) {
        TestableGfsh gfsh = CLITest.getTestableShell();
        if (!gfsh.isConnectedAndReady()) {
            CLITest.connectGfshToManagerNode();
        }
        Object[] object = TestableGfsh.execAndLogCommand(gfsh, instance.toString(), CLITest.getGfshOutputFile(), false);
        Map map = (Map)object[0];
        CommandResult result = null;
        Collection values = map.values();
        for (Object r : values) {
            if (!(r instanceof CommandResult)) continue;
            result = (CommandResult)r;
            if (!result.getStatus().equals((Object)Result.Status.OK)) {
                this.addFailure(" Command return status is *NOT* OK. Command execution has failed");
                continue;
            }
            HydraUtil.logInfo("Completed exeuction of <" + instance + "> successfully");
        }
        this.verifyGemfire(gfsh, object);
        this.verifyJMX(gfsh, object);
        this.verifyCommand(gfsh, object);
        return result;
    }

    protected String getMemberId() {
        Collection collection = FederationBlackboard.getBB().getMemberNames().values();
        return (String)HydraUtil.getRandomElement(collection);
    }

    protected String getMemberIds() {
        Collection collection = FederationBlackboard.getBB().getMemberNames().values();
        int members = HydraUtil.getnextRandomInt(collection.size());
        ArrayList<String> finalist = new ArrayList<String>();
        for (int i = 0; i < members; ++i) {
            String t = (String)HydraUtil.getRandomElement(collection);
            if (finalist.contains(t)) continue;
            finalist.add(t);
        }
        if (finalist.size() == 0) {
            finalist.add((String)HydraUtil.getRandomElement(collection));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < finalist.size(); ++i) {
            sb.append((String)finalist.get(i));
            if (i >= finalist.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected String getGroup() {
        String[] array = new String[]{"managing", "managed", "managed2", "locator_managing", "managed1"};
        return HydraUtil.getRandomElement(array);
    }

    protected String getGroups() {
        String[] array = new String[]{"managing", "managed", "managed2", "locator_managing", "managed1"};
        int groups = HydraUtil.getnextRandomInt(array.length);
        ArrayList<String> finalist = new ArrayList<String>();
        for (int i = 0; i < groups; ++i) {
            String a = HydraUtil.getRandomElement(array);
            if (finalist.contains(a)) continue;
            finalist.add(a);
        }
        if (finalist.size() == 0) {
            finalist.add(HydraUtil.getRandomElement(array));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < finalist.size(); ++i) {
            sb.append((String)finalist.get(i));
            if (i >= finalist.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected String getFile(String prefix, String type) {
        long fileNum = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.FILE_COUNTER);
        return prefix + "_" + fileNum + type;
    }

    protected String getDirectory(String prefix) {
        long dirNum = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.DIRECTORY_COUNTER);
        return prefix + "_" + dirNum;
    }

    protected String getNewRegion(String prefix) {
        long regionNum = CLIBlackboard.getBB().getSharedCounters().incrementAndRead(CLIBlackboard.REGION_COUNTER);
        return "/" + prefix + "_" + regionNum;
    }

    protected Object getPrColocatedRootRegion() {
        return COLOCATED_ROOT_REGION;
    }

    protected String getAlreadyExistingRegion() {
        List<String> regionList = RegionEvents.getAllRegions();
        return HydraUtil.getRandomElement(regionList);
    }

    protected String getCurrentRegion() {
        List<String> regionList = RegionEvents.getCurrentRegions();
        return HydraUtil.getRandomElement(regionList);
    }

    protected String getCurrentRegionFilterColocated() {
        List<String> regionList = RegionEvents.getCurrentRegions();
        ArrayList<String> newRegionList = new ArrayList<String>();
        for (String str : regionList) {
            boolean isColocatedChain;
            boolean bl = isColocatedChain = str.contains(COLOCATED_ROOT_REGION) || str.contains(COLOCATED_REGION_PATTERN) || str.contains(COLOCATED_ROOT_DISK_REGION);
            if (!isColocatedChain) {
                newRegionList.add(str);
                continue;
            }
            HydraUtil.logInfo("Filterting region " + str + " as it falls inside Colocated Chain");
        }
        return (String)HydraUtil.getRandomElement(newRegionList);
    }

    protected Object getDiskStore() {
        return HydraUtil.getRandomElement(this.diskStores);
    }

    protected boolean checkDirectory(String directory2) {
        File file = new File(".", directory2);
        return file.exists() && file.isDirectory() && file.list() != null && file.list().length != 0;
    }

    protected boolean checkFile(String fileName) {
        File file = new File(".", fileName);
        return file.exists() && file.isFile() && file.length() != 0L;
    }

    protected void addFailure(String message) {
        CLITest.currentCommand.append(" ").append(message);
        CLITest.hasCommandFailed = true;
    }

    protected String getSenderId() {
        String wanDsName = "GW_SENDER_ID_LIST_" + ManagementUtil.getWanSiteName();
        List list = CLIBlackboard.getBB().getList(wanDsName);
        String senderId = (String)HydraUtil.getRandomElement(list);
        HydraUtil.logInfo("Registered Sender ID# : " + senderId);
        return senderId;
    }

    protected String getRunningSenderId() {
        String wanDsName = "GW_SENDER_RUNNING_" + ManagementUtil.getWanSiteName();
        List list = CLIBlackboard.getBB().getList(wanDsName);
        HydraUtil.logInfo("Running sender List " + list);
        String senderId = null;
        if (list.size() > 0) {
            senderId = (String)HydraUtil.getRandomElement(list);
            list.remove(senderId);
            CLIBlackboard.getBB().saveList(wanDsName, list);
        } else {
            senderId = this.getSenderId();
        }
        HydraUtil.logInfo("Running Sender ID# : " + senderId);
        return senderId;
    }

    protected String getPausedSenderId() {
        String wanDsName = "GW_SENDER_PAUSED_" + ManagementUtil.getWanSiteName();
        List list = CLIBlackboard.getBB().getList(wanDsName);
        String senderId = null;
        if (list.size() > 0) {
            senderId = (String)HydraUtil.getRandomElement(list);
            list.remove(senderId);
            CLIBlackboard.getBB().saveList(wanDsName, list);
        } else {
            senderId = this.getSenderId();
        }
        HydraUtil.logInfo("Paused Sender ID# : " + senderId);
        return senderId;
    }

    protected String getStoppedSenderId() {
        String wanDsName = "GW_SENDER_STOPPED_" + ManagementUtil.getWanSiteName();
        List list = CLIBlackboard.getBB().getList(wanDsName);
        String senderId = null;
        if (list.size() > 0) {
            senderId = (String)HydraUtil.getRandomElement(list);
            list.remove(senderId);
            CLIBlackboard.getBB().saveList(wanDsName, list);
        } else {
            senderId = this.getSenderId();
        }
        HydraUtil.logInfo("Stopped Sender ID# : " + senderId);
        return senderId;
    }

    protected void addToRunningSenderIdList(String senderId) {
        String wanDsName = "GW_SENDER_RUNNING_" + ManagementUtil.getWanSiteName();
        CLIBlackboard.getBB().addToList(wanDsName, senderId);
    }

    protected void addToPausedSenderIdList(String senderId) {
        String wanDsName = "GW_SENDER_PAUSED_" + ManagementUtil.getWanSiteName();
        CLIBlackboard.getBB().addToList(wanDsName, senderId);
    }

    protected void addToStoppedSenderIdList(String senderId) {
        String wanDsName = "GW_SENDER_STOPPED_" + ManagementUtil.getWanSiteName();
        CLIBlackboard.getBB().addToList(wanDsName, senderId);
    }

    protected String getMemberIdInDS() {
        Collection collection = FederationBlackboard.getBB().getMemberNames().values();
        List<Object> col = ManagementUtil.filter(collection, "managing");
        ArrayList<String> list = new ArrayList<String>();
        for (String o : col) {
            list.add(o.toString());
        }
        col = ManagementUtil.filterForThisDS(list);
        return (String)HydraUtil.getRandomElement(col);
    }

    protected String getGroupsNoManaging() {
        String[] array = new String[]{"managed", "managed2", "managed1"};
        int groups = HydraUtil.getnextRandomInt(array.length);
        ArrayList<String> finalist = new ArrayList<String>();
        for (int i = 0; i < groups; ++i) {
            String a = HydraUtil.getRandomElement(array);
            if (finalist.contains(a)) continue;
            finalist.add(a);
        }
        if (finalist.size() == 0) {
            finalist.add(HydraUtil.getRandomElement(array));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < finalist.size(); ++i) {
            sb.append((String)finalist.get(i));
            if (i >= finalist.size() - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected Object getRegion() {
        List<String> regionList = RegionEvents.getAllRegions();
        return HydraUtil.getRandomElement(regionList);
    }

    protected Object getFunctionId() {
        return HydraUtil.getRandomElement(FunctionEvents.getAllRegisteredFunction());
    }
}

