/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops.cli;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import management.operations.ops.cli.TestCommandExecutor;
import management.operations.ops.cli.TestCommandInstance;
import management.util.HydraUtil;
import util.TestException;

public class TestCommand
implements Serializable {
    public String command;
    public String executorName;
    public List<String> arguments;
    public List<String> mandatoryOptions;
    public List<CommandOption> options;
    public Map<String, CommandMode> modes;
    static Random random = new Random();
    private TestCommandExecutor executor = null;

    public TestCommandInstance getRandomCommandInstnance() {
        TestCommandInstance instance = new TestCommandInstance();
        instance.testCommand = this;
        int numMode = this.modes.size();
        int randomMode = random.nextInt(numMode);
        CommandMode mode = null;
        Set<String> keys = this.modes.keySet();
        Iterator<String> keyIterator = keys.iterator();
        int i = 0;
        while (keyIterator.hasNext()) {
            String key = keyIterator.next();
            if (i == randomMode) {
                mode = this.modes.get(key);
                HydraUtil.logInfo("CLIOperations: For command " + this.command + " mode selected is " + key);
                break;
            }
            ++i;
        }
        if (mode == null) {
            throw new TestException("Could not get command mode modes " + this.modes.size() + " rseed " + numMode);
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(this.arguments);
        if (mode.arguments != null) {
            arguments.addAll(mode.arguments);
        }
        ArrayList<String> mandatoryOptions = new ArrayList<String>();
        mandatoryOptions.addAll(mode.mandatoryOptions);
        mandatoryOptions.addAll(this.mandatoryOptions);
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        options.addAll(this.addOptions(mode.options));
        options.addAll(this.addOptions(this.options));
        TestCommandExecutor executor = this.getExecutor();
        HydraUtil.logFine("Creating a instance iwth options " + HydraUtil.ObjectToString(options));
        HydraUtil.logFine("Creating a instance iwth moptions " + HydraUtil.ObjectToString(mandatoryOptions));
        HydraUtil.logFine("Creating a instance iwth arguments " + HydraUtil.ObjectToString(arguments));
        instance.setMode(mode.name);
        executor.fillMandotoryOptionValues(instance, mandatoryOptions);
        executor.fillOptionValues(instance, options);
        executor.fillArguments(instance, arguments);
        return instance;
    }

    private Collection<? extends CommandOption> addOptions(List<CommandOption> options2) {
        ArrayList<CommandOption> options = new ArrayList<CommandOption>();
        HashSet<String> linkedOptions = new HashSet<String>();
        for (CommandOption op : options2) {
            if (linkedOptions.contains(op.name)) continue;
            int r = random.nextInt(101);
            if (r <= op.probability) {
                options.add(op);
            }
            if (op.linkedSet == null || op.linkedSet.size() <= 0) continue;
            for (String s : op.linkedSet) {
                linkedOptions.add(s);
            }
        }
        for (String s : linkedOptions) {
            for (CommandOption op : options2) {
                if (!op.name.equals(s)) continue;
                options.add(op);
            }
        }
        return options;
    }

    public TestCommandExecutor getExecutor() {
        String klass = this.executorName;
        HydraUtil.logFine("Executor " + this.executor + " command " + this);
        if (this.executor == null) {
            this.executor = (TestCommandExecutor)HydraUtil.getInstanceOfClass(klass);
        }
        HydraUtil.logFine("Executor " + this.executor + " command " + this);
        return this.executor;
    }

    public static class CommandOption
    implements Serializable {
        public String name;
        public int probability = 50;
        public List<String> linkedSet;

        public String toString() {
            return " CO [ name : " + this.name + " p : " + this.probability + " linkedoptions : " + (this.linkedSet == null ? null : this.linkedSet.toString());
        }
    }

    public static class CommandMode
    implements Serializable {
        public String name;
        public List<String> arguments;
        public List<String> mandatoryOptions;
        public List<CommandOption> options;
        public int probability = 50;
    }
}

