/*
 * Decompiled with CFR 0.152.
 */
package management.operations.ops;

import hydra.HydraVector;
import hydra.TestConfig;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import management.cli.CLIBlackboard;
import management.cli.GfshPrms;
import management.operations.ops.cli.GfshCommandDescriptorReader;
import management.operations.ops.cli.TestCommand;
import management.operations.ops.cli.TestCommandExecutor;
import management.operations.ops.cli.TestCommandInstance;
import management.test.cli.CLITest;
import management.util.HydraUtil;
import util.TestException;

public class CLIOperations {
    public static final String EXEC_COMMAND_VERIFY = "execCommandVerify";
    public static final String EXEC_SCRIPT_VERIFY = "execScriptVerify";
    public static final String EXEC_SCRIPT_VERIFY_IN_SEPARATE_PROCESS = "execScriptInSeparateProcessVerify";
    public static final String EXEC_SCENARIO = "scenario";
    public static final int MODE_EXEC_COMMAND_VERIFY = 2;
    public static final int MODE_EXEC_SCRIPT_VERIFY = 5;
    public static final int MODE_EXEC_SCRIPT_VERIFY_IN_SEPARATE_PROCESS = 8;
    public static final int MODE_EXEC_SCENARIO = 11;
    public static final String opPrefix = "CLIOperations: ";
    private String selectedMode = null;
    private TestCommand selectedcommand = null;
    private TestCommandInstance selectedcommandMode = null;

    public TestCommandInstance getSelectedcommandMode() {
        return this.selectedcommandMode;
    }

    public String getSelectedMode() {
        return this.selectedMode;
    }

    public TestCommand getSelectedcommand() {
        return this.selectedcommand;
    }

    public static void HydraStartTask_ReadCommandSpecs() {
        HydraVector commandSpecList = TestConfig.tab().vecAt(GfshPrms.commandSpec);
        HydraVector cliList = TestConfig.tab().vecAt(GfshPrms.commandList);
        Iterator iterator = commandSpecList.iterator();
        HashMap<String, TestCommand> commandMap = new HashMap<String, TestCommand>();
        while (iterator.hasNext()) {
            String commandSpec = (String)iterator.next();
            commandSpec = commandSpec.replaceAll("'", "\"");
            HydraUtil.logInfo("Command Descriptor : " + commandSpec);
            TestCommand testCommand = GfshCommandDescriptorReader.parseCommandDescriptor(commandSpec);
            commandMap.put(testCommand.command, testCommand);
        }
        HydraUtil.logInfo("Command list is " + cliList);
        HydraUtil.logInfo("Command map is " + commandMap);
        CLIBlackboard.getBB().saveMap("commandMap", commandMap);
    }

    public String selectMode() {
        String modeStr = TestConfig.tab().stringAt(GfshPrms.cliModes);
        return modeStr;
    }

    public void doCLIOperation() {
        String modeStr = this.selectMode();
        HydraUtil.logInfo("CLIOperations:  Selected mode " + modeStr);
        int mode = -1;
        if (EXEC_COMMAND_VERIFY.equals(modeStr)) {
            mode = 2;
        } else if (EXEC_SCRIPT_VERIFY.equals(modeStr)) {
            mode = 5;
        } else if (EXEC_SCRIPT_VERIFY_IN_SEPARATE_PROCESS.equals(modeStr)) {
            mode = 8;
        } else if (EXEC_SCENARIO.equals(modeStr)) {
            mode = 11;
        }
        if (mode == -1) {
            throw new TestException("Unknown mode selected " + modeStr);
        }
        Object testCommand = null;
        switch (mode) {
            case 2: {
                if (this.selectedcommand == null) {
                    this.selectedcommand = this.selectCommand();
                }
                this.executeAndVerifyCommand(mode, this.selectedcommand);
                break;
            }
            case 5: {
                throw new TestException("CLIOperations:  MODE_EXEC_SCRIPT_VERIFY not implemented yet");
            }
            case 8: {
                throw new TestException("CLIOperations:  MODE_EXEC_SCRIPT_VERIFY_IN_SEPARATE_PROCESS not implemented yet");
            }
            case 11: {
                throw new TestException("CLIOperations:  MODE_EXEC_SCENARIO not implemented yet");
            }
            default: {
                throw new TestException("Unknown CLI mode of operation: " + mode);
            }
        }
    }

    private void executeAndVerifyCommand(int mode, TestCommand testCommand) {
        TestCommandInstance instance = this.selectedcommandMode;
        TestCommandExecutor executor = testCommand.getExecutor();
        HydraUtil.logInfo("CLIOperations:  Executing command {<" + instance.toString() + ">}");
        StringBuilder sb = (StringBuilder)CLITest.commands.get();
        String command = instance.toString();
        command = command.replaceAll(HydraUtil.NEW_LINE, HydraUtil.NEW_LINE + "\t" + "\t");
        Object result = executor.executeAndVerify(instance);
        HydraUtil.logInfo("CLIOperations:  Successfully completed executing command {<" + instance.toString() + ">}");
    }

    public TestCommand selectCommand() {
        String command = TestConfig.tab().stringAt(GfshPrms.cliCommands);
        HydraUtil.logInfo("CLIOperations:  Selected Command " + command);
        HashMap commandMap = (HashMap)CLIBlackboard.getBB().getMap("commandMap");
        if (commandMap.containsKey(command)) {
            TestCommand testCommand = (TestCommand)commandMap.get(command);
            this.selectedcommandMode = testCommand.getRandomCommandInstnance();
            return testCommand;
        }
        throw new TestException("Command descriptor for " + command + " not found. Please check your hydra configurations.");
    }

    private void executeScenario() {
    }

    private List<TestCommand> generateScript() {
        return null;
    }

    private void executeScript(int mode, List<TestCommand> script) {
    }
}

