/*
 * Decompiled with CFR 0.152.
 */
package management.cli;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.CommandManager;
import com.gemstone.gemfire.management.internal.cli.result.CommandResult;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import hydra.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import management.cli.TestableGfsh;
import management.cli.Util;
import management.util.HydraUtil;

public class TestCLI {
    private static void execCommand(String id, TestableGfsh shell, String command) throws IOException, ClassNotFoundException {
        Util.log(id + " : Executing command " + command);
        shell.addChars(command).addChars(";").newline();
        shell.waitForOutput();
        if (shell.hasError()) {
            Util.log("Command failed with error " + shell.getError());
            System.exit(0);
        } else {
            Map<String, List> completorOutput = shell.getCompletorOutput();
            Map<String, Object> commandOutput = shell.getCommandOutput();
            Util.debug(id + " : Command completorOutput for " + command + "--->" + completorOutput);
            Util.debug(id + " : Command outputText for " + command + "--->" + shell.getOutputText());
            Util.log(id + " : Command output for " + command + "--->" + commandOutput);
            Collection<Object> values = commandOutput.values();
            for (Object r : values) {
                CommandResult result;
                if (r instanceof CommandResult) {
                    result = (CommandResult)r;
                    Util.log(id + " : CommandResult  " + HydraUtil.ObjectToString(result));
                    continue;
                }
                if (!(r instanceof Result)) continue;
                result = (Result)r;
                Util.log(id + " : result status " + result.getStatus());
                Util.log(id + " result in toString format " + result.toString());
            }
        }
        shell.clearEvents();
    }

    private static void execCommandWithTestConnect(String id, TestableGfsh shell, String command) throws IOException, ClassNotFoundException {
        TestCLI.execCommand(id, shell, "connect");
        boolean connected = shell.isConnectedAndReady();
        if (connected) {
            TestCLI.execCommand(id, shell, command);
            TestCLI.execCommand(id, shell, "disconnect");
            connected = shell.isConnectedAndReady();
            if (connected) {
                Util.error("Connect command failed to dis-connect to manager");
                System.exit(0);
            }
        } else {
            Util.error("Connect command failed to connect to manager");
            System.exit(0);
        }
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Log.createLogWriter("test", args[0]);
        Gfsh.SUPPORT_MUTLIPLESHELL = true;
        TestableGfsh.setVirtualTerminal(false);
        Set set = CommandManager.getInstance().getCommands().keySet();
        Util.log("Total command loaded " + set.size());
        Util.log("Commands : " + HydraUtil.ObjectToString(set));
        int NUM_COMMANDS = Integer.parseInt(args[1]);
        int NUM_THREAD = Integer.parseInt(args[2]);
        Util.log("Starting with logLevel " + args[0] + " Threds " + NUM_THREAD + " iterations " + NUM_COMMANDS);
        CountDownLatch latch = new CountDownLatch(NUM_COMMANDS * NUM_THREAD);
        String[] commands2 = new String[]{"help", "history", "list member", "list region"};
        ArrayList<Thread> threads = new ArrayList<Thread>();
        for (int i = 0; i < NUM_THREAD; ++i) {
            ShellThread thread1 = new ShellThread("ShellThread" + i);
            thread1.setCommands(commands2);
            thread1.setLatch(latch);
            thread1.setNumIterations(NUM_COMMANDS);
            thread1.setTimeout(5L);
            Thread t1 = new Thread(thread1);
            t1.setName("ShellThread-" + i);
            threads.add(t1);
        }
        for (Thread t : threads) {
            t.start();
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Util.error(e);
        }
    }

    public static class ShellThread
    implements Runnable {
        private TestableGfsh gfsh = null;
        private String[] commands = null;
        private int numIterations = 10;
        private String id = null;
        private CountDownLatch latch = null;

        public void setLatch(CountDownLatch latch) {
            this.latch = latch;
        }

        public void setNumIterations(int numIterations) {
            this.numIterations = numIterations;
        }

        public void setCommands(String[] commands2) {
            this.commands = commands2;
        }

        public void setTimeout(long t) {
            this.gfsh.setTimeout(t);
        }

        public ShellThread(String id) throws ClassNotFoundException, IOException {
            this.id = id;
            String[] argss = new String[]{};
            this.gfsh = new TestableGfsh(id, true, argss);
            this.gfsh.start();
        }

        @Override
        public void run() {
            for (int i = 0; i < this.numIterations; ++i) {
                Util.error("Executing command number " + i);
                String command = HydraUtil.getRandomElement(this.commands);
                try {
                    TestCLI.execCommandWithTestConnect(this.id, this.gfsh, command);
                    this.latch.countDown();
                    continue;
                }
                catch (IOException e) {
                    Util.error(e);
                    System.exit(0);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    Util.error(e);
                    System.exit(0);
                }
            }
            Util.log("Terminating shell - " + this.id);
            this.gfsh.eof();
            Util.log("Terminated shell - " + this.id);
        }
    }
}

