/*
 * Decompiled with CFR 0.152.
 */
package junitExt;

import junit.framework.Assert;
import junitExt.MultiThreadedTestRunner;

public abstract class TestRunnable
extends Assert
implements Runnable {
    private static final Class THIS_CLASS = TestRunnable.class;
    private static int testCount = 0;
    private MultiThreadedTestRunner mttr;
    private int testIndex;
    private boolean ignoreStopErrors = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestRunnable() {
        Class clazz = THIS_CLASS;
        synchronized (clazz) {
            this.testIndex = testCount++;
        }
    }

    TestRunnable(boolean ignoreStopErrors) {
        this();
        this.ignoreStopErrors = ignoreStopErrors;
    }

    public abstract void runTest() throws Throwable;

    @Override
    public final void run() {
        if (this.mttr == null) {
            throw new IllegalStateException("Owning runner never defined. The runnables should only be started through the MultiThreadedTestRunner instance.");
        }
        try {
            this.runTest();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (MultiThreadedTestRunner.TestDeathException tde) {
            if (!this.ignoreStopErrors) {
                throw tde;
            }
        }
        catch (Throwable t) {
            this.mttr.handleException(t);
        }
    }

    public boolean isDone() {
        return this.mttr.areThreadsFinished();
    }

    void setTestRunner(MultiThreadedTestRunner mttr) {
        this.mttr = mttr;
    }
}

