/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.TransactionEvent;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.TransactionWriterException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import jta.JtaBB;
import util.AbstractWriter;
import util.TestException;
import util.TestHelper;

public class JtaTxWriter
extends AbstractWriter
implements TransactionWriter {
    public void beforeCommit(TransactionEvent txEvent) throws TransactionWriterException {
        this.logTxEvent("beforeCommit", txEvent);
        int i = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (i < 10) {
            Log.getLogWriter().info("JtaTxWriter intentionally throwing TransactionWriterException");
            throw new TestException("TransactionWriter intentionally throws TransactionWriterException");
        }
        if (i < 20) {
            Log.getLogWriter().info("JtaTxWriter intentionally throwing NPE (RuntimeException)");
            throw new NullPointerException("TransactionWriter intentionally throws NPE");
        }
    }

    protected void throwException(String errStr) throws TransactionWriterException {
        StringBuffer qualifiedErrStr = new StringBuffer();
        qualifiedErrStr.append("Exception reported in " + RemoteTestModule.getMyClientName() + "\n");
        qualifiedErrStr.append(errStr);
        errStr = qualifiedErrStr.toString();
        SharedMap aMap = JtaBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TransactionWriterException(errStr);
    }

    public void close() {
        Log.getLogWriter().info("JtaTxWriter.close()");
    }
}

