/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.Region;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.Iterator;
import javax.naming.Context;
import javax.transaction.RollbackException;
import javax.transaction.UserTransaction;
import jta.JtaBB;
import jta.JtaCacheTestUtil;
import jta.JtaPrms;
import util.TestException;
import util.TestHelper;

public class JtaCacheHydraTest {
    public static synchronized void initTask() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            }
            catch (Exception e) {
                throw new TestException("Error in Cache initialization in initTask " + TestHelper.getStackTrace(e));
            }
        }
        JtaCacheTestUtil.createRootRegions();
    }

    public static void testTaskRandomRegion() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Log.getLogWriter().info("Beginning Transaction ");
            String regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            Region region = RegionHelper.getRegion(regionName);
            utx.begin();
            new JtaCacheHydraTest().testTask(region, TestConfig.tab().intAt(JtaPrms.numberOfEvents));
            utx.commit();
            Log.getLogWriter().info("Committed Transaction ");
        }
        catch (RollbackException r) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)r);
        }
        catch (Exception e) {
            Log.getLogWriter().error("Exception caught in testTaskRandomRegion", (Throwable)e);
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("Transaction explicitly RolledBack");
                }
                catch (Exception ex) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(ex));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    public static void testTaskReplicateRegion() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Log.getLogWriter().info("Beginning Transaction ");
            String regionName = RegionHelper.getRegionDescription(ConfigPrms.getRegionConfig()).getRegionName();
            Region region = RegionHelper.getRegion(regionName);
            utx.begin();
            new JtaCacheHydraTest().testTask(region, TestConfig.tab().intAt(JtaPrms.numberOfEvents));
            utx.commit();
            Log.getLogWriter().info("Committed Transaction ");
        }
        catch (RollbackException r) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)r);
        }
        catch (Exception e) {
            Log.getLogWriter().error("Exception caught in testTaskReplicateRegion", (Throwable)e);
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("Transaction explicitly RolledBack");
                }
                catch (Exception ex) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(ex));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    public static void testTaskMultipleRandomRegion() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            Iterator itr = cache.rootRegions().iterator();
            for (int i = 0; i < TestConfig.tab().intAt(JtaPrms.numberOfRandomRegions); ++i) {
                Region region = (Region)itr.next();
                Log.getLogWriter().info("Beginning Transaction ");
                utx.begin();
                new JtaCacheHydraTest().testTask(region, TestConfig.tab().intAt(JtaPrms.numberOfEvents));
                utx.commit();
                Log.getLogWriter().info("Committed Transaction ");
            }
        }
        catch (RollbackException r) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)r);
        }
        catch (Exception e) {
            Log.getLogWriter().error("Exception caught in testTaskMultipleRandomRegion", (Throwable)e);
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("Transaction explicitly RolledBack");
                }
                catch (Exception ex) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(ex));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    public static void testTaskMultipleReplicateRegion() {
        UserTransaction utx = null;
        try {
            Cache cache = CacheHelper.getCache();
            Context ctx = cache.getJNDIContext();
            utx = (UserTransaction)ctx.lookup("java:/UserTransaction");
            for (Region region : cache.rootRegions()) {
                if (region.getName().equals("root")) continue;
                Log.getLogWriter().info("Beginning Transaction ");
                utx.begin();
                new JtaCacheHydraTest().testTask(region, TestConfig.tab().intAt(JtaPrms.numberOfEvents));
                utx.commit();
                Log.getLogWriter().info("Committed Transaction on region " + region.getName());
            }
        }
        catch (RollbackException r) {
            Log.getLogWriter().info("Transaction did not commit successfully, rolled back ", (Throwable)r);
        }
        catch (Exception e) {
            Log.getLogWriter().error("Exception caught in testTaskMultipleMirroredRegion", (Throwable)e);
            if (utx != null) {
                try {
                    utx.rollback();
                    Log.getLogWriter().info("Transaction explicitly RolledBack");
                }
                catch (Exception ex) {
                    throw new TestException("Error in Transaction on rollback in testTask " + TestHelper.getStackTrace(ex));
                }
            }
            throw new TestException("Error in testTask " + TestHelper.getStackTrace(e));
        }
    }

    private void testTask(Region region, int total) {
        new JtaCacheTestUtil().doRandomOperation(region, total);
    }

    public static void endTask() {
        JtaBB.getBB().printSharedCounters();
    }
}

