/*
 * Decompiled with CFR 0.152.
 */
package jta;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.Log;
import hydra.Prms;
import hydra.RegionHelper;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.sql.Connection;
import java.util.Map;
import java.util.Set;
import jta.DBUtil;
import jta.JtaBB;
import jta.JtaPrms;
import util.TestException;
import util.TestHelper;
import util.TxHelper;

public class GemFireTxCallback {
    static boolean isSerialExecution;
    private static ThreadLocal dbConnection;

    public static Connection getDBConnection() throws Exception {
        Connection conn = (Connection)dbConnection.get();
        if (conn == null) {
            conn = DBUtil.getXADSConnection();
            GemFireTxCallback.setDBConnection(conn);
        }
        return conn;
    }

    private static void setDBConnection(Connection conn) {
        dbConnection.set(conn);
    }

    public static synchronized void createDatabase() {
        try {
            Cache cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            Log.getLogWriter().info("Creating database table and entries ...");
            String hostName = RemoteTestModule.getMyHost().replace('-', '_');
            GemFireTxCallback.setDBTableName("t_" + hostName + "_" + RemoteTestModule.getMyPid());
            DBUtil.createTable(GemFireTxCallback.getDBTableName());
            Log.getLogWriter().info("Created database table " + GemFireTxCallback.getDBTableName() + " with entries.");
            CacheHelper.closeCache();
        }
        catch (Exception e) {
            throw new TestException("Error in createDatabase() " + TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void dropOracleTable() {
        try {
            Log.getLogWriter().info("Dropping oracle database table " + GemFireTxCallback.getDBTableName());
            DBUtil.dropTable(GemFireTxCallback.getDBTableName());
            Log.getLogWriter().info("Dropped oracle database table");
        }
        catch (Exception e) {
            throw new TestException("Unexpected exception caught in dropTable() " + e);
        }
    }

    public static void setDBTableName(String aName) {
        Log.getLogWriter().info("setDBTableName " + aName);
        JtaBB.getBB().getSharedMap().put(JtaBB.dbTableName, aName);
    }

    public static String getDBTableName() {
        String tableName = (String)JtaBB.getBB().getSharedMap().get(JtaBB.dbTableName);
        return tableName;
    }

    public static synchronized void dumpDatabase() {
        try {
            Cache cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
            DBUtil.displayData(GemFireTxCallback.getDBTableName());
            CacheHelper.closeCache();
        }
        catch (Exception e) {
            throw new TestException("Error in dumpDatabase() " + TestHelper.getStackTrace(e));
        }
    }

    public static synchronized void initTask() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            try {
                TransactionWriter txWriter;
                System.setProperty("derby.locks.waitTimeout", "180");
                cache = CacheHelper.createCacheFromXml(JtaPrms.getCacheXmlFile());
                TransactionListener txListener = JtaPrms.getTxListener();
                if (txListener != null) {
                    cache.getCacheTransactionManager().setListener(txListener);
                    Log.getLogWriter().info("Installed TransactionListener " + txListener);
                }
                if ((txWriter = JtaPrms.getTxWriter()) != null) {
                    cache.getCacheTransactionManager().setWriter(txWriter);
                    Log.getLogWriter().info("Installed TransactionWriter " + txWriter);
                }
                Region root = cache.getRegion("root");
                RegionAttributes ratts = RegionHelper.getRegionAttributes(ConfigPrms.getRegionConfig());
                Log.getLogWriter().info("Creating employee subregion ...");
                Region employee = root.createSubregion("employee", ratts);
                Log.getLogWriter().info("Created employee subregion.");
                if (employee.isEmpty()) {
                    Log.getLogWriter().info("Loading database entries into cache ....");
                    for (int i = 1; i <= 4; ++i) {
                        String key = "key" + i;
                        employee.get((Object)key);
                    }
                    Log.getLogWriter().info("Loaded database entries into cache.");
                }
            }
            catch (Exception e) {
                throw new TestException("Error in initTask() " + TestHelper.getStackTrace(e));
            }
            isSerialExecution = TestConfig.tab().booleanAt(Prms.serialExecution, false);
        }
    }

    public static void testTask() {
        block19: {
            long localCounter = 0L;
            String key = null;
            String dbValue = null;
            String newValue = null;
            boolean isRollBack = false;
            TestHelper.checkForEventError(JtaBB.getBB());
            Cache cache = CacheHelper.getCache();
            Region employee = cache.getRegion("root/employee");
            String tableName = GemFireTxCallback.getDBTableName();
            try {
                TxHelper.begin();
                localCounter = JtaBB.getBB().getSharedCounters().incrementAndRead(JtaBB.COUNTER);
                key = "key" + (localCounter % 4L + 1L);
                newValue = "value" + localCounter;
                dbValue = DBUtil.getDBValue(tableName, key);
                Log.getLogWriter().info("Selected " + key + " for update, original dbValue is " + dbValue + " new value will be " + newValue);
                employee.put((Object)key, (Object)newValue);
                try {
                    if (TestConfig.tab().getRandGen().nextInt(1, 100) < 25) {
                        Log.getLogWriter().info("ROLLING BACK transaction with " + key + "(" + newValue + ")");
                        TxHelper.rollback();
                        Log.getLogWriter().info("ROLLED BACK.");
                        isRollBack = true;
                    } else {
                        Log.getLogWriter().info("COMMITTING transaction with " + key + "(" + newValue + ")");
                        TxHelper.commit();
                        Log.getLogWriter().info("COMMITTED.");
                    }
                }
                catch (ConflictException cce) {
                    boolean isCausedByTransactionWriterException;
                    String errStr = cce.toString();
                    boolean bl = isCausedByTransactionWriterException = errStr.indexOf("intentionally throw") >= 0;
                    if (isSerialExecution && !isCausedByTransactionWriterException) {
                        throw new TestException("Unexpected ConflictException " + (Object)((Object)cce) + " caught in serialExecution test");
                    }
                    Log.getLogWriter().info("testTask caught expected " + (Object)((Object)cce) + ", continuing with test");
                    isRollBack = true;
                }
                catch (Exception e) {
                    Log.getLogWriter().error("testTask caught exception ", (Throwable)e);
                    throw new TestException("Error in testTask during commit/rollback " + TestHelper.getStackTrace(e));
                }
                if (!isSerialExecution) break block19;
                try {
                    Log.getLogWriter().info("Validating data consistency for " + (isRollBack ? "Rollback" : "Commit") + " with " + key + "(" + newValue + ")");
                    if (!GemFireTxCallback.checkData(employee, key, newValue, !isRollBack)) {
                        String s = "Region/DataBase inconsistent for " + (isRollBack ? "Rollback" : "Commit") + " with " + key + "(" + newValue + ")";
                        Log.getLogWriter().info(s);
                        throw new TestException(s + " " + TestHelper.getStackTrace());
                    }
                    Log.getLogWriter().info("data consistency verified after " + (isRollBack ? "Rollback" : "Commit") + " for " + key + "(" + newValue + ")");
                }
                catch (Exception e) {
                    String s = "Exception while retrieving the Data for validation of commit for " + key + "(" + newValue + ")";
                    Log.getLogWriter().info(s, (Throwable)e);
                    throw new TestException(s + " " + TestHelper.getStackTrace(e));
                }
            }
            catch (Exception e) {
                Log.getLogWriter().error("Exception caught in testTask() for " + key + "(" + newValue + ")", (Throwable)e);
                throw new TestException("Error in testTask() " + TestHelper.getStackTrace(e));
            }
            finally {
                try {
                    Connection conn = GemFireTxCallback.getDBConnection();
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (Exception e) {
                    Log.getLogWriter().info("conn.close() threw " + e);
                    throw new TestException("conn.close() threw " + e + " " + TestHelper.getStackTrace(e));
                }
                GemFireTxCallback.setDBConnection(null);
            }
        }
    }

    public static boolean checkData(Region region, String key, String value, boolean isCommit) throws Exception {
        String regionVal = (String)region.get((Object)key);
        String dbValue = DBUtil.getDBValue(GemFireTxCallback.getDBTableName(), key);
        Log.getLogWriter().info("checkData (" + (isCommit ? "commit" : "rollback") + ") for " + key + " and newValue " + value + " found region value " + regionVal + ", database value " + dbValue);
        if (isCommit) {
            if (!regionVal.equals(value)) {
                Log.getLogWriter().info("checkData (on commit): region value for " + key + " is " + regionVal + ", expected " + value);
                return false;
            }
            if (!dbValue.equals(value)) {
                Log.getLogWriter().info("checkData (on commit): dbValue for " + key + " is " + dbValue + ", expected " + value);
                return false;
            }
        } else {
            if (regionVal.equals(value)) {
                Log.getLogWriter().info("checkData (on rollback): region value for " + key + " is " + regionVal + ", did not expect it to be updated to dbValue " + value + " after rollback");
                return false;
            }
            if (dbValue.equals(value)) {
                Log.getLogWriter().info("checkData (on rollback): dbValue for " + key + " is " + dbValue + ", did not expect it to be updated to newValue " + value + " after rollback");
                return false;
            }
        }
        return true;
    }

    public static void closeTask() {
        GemFireTxCallback.validateFinally();
    }

    public static void validateFinally() {
        Cache cache = CacheHelper.getCache();
        Region employee = cache.getRegion("root/employee");
        Set keySet = employee.keySet();
        StringBuffer aStr = new StringBuffer();
        Map map = null;
        try {
            map = DBUtil.getData(GemFireTxCallback.getDBTableName());
        }
        catch (Exception e) {
            throw new TestException("Caught unexpected Exception in validateFinally " + e);
        }
        Set dbKeys = map.keySet();
        if (dbKeys.size() != keySet.size()) {
            aStr.append("Inconsistency detected with database size = " + dbKeys.size() + " and cache size = " + keySet.size());
        }
        for (String key : keySet) {
            if (dbKeys.contains(key)) continue;
            aStr.append(key + " missing from database\n");
        }
        for (String key : dbKeys) {
            if (keySet.contains(key)) continue;
            aStr.append(key + " missing from GemFire cache\n");
        }
        StringBuffer displayStr = new StringBuffer();
        try {
            Log.getLogWriter().info("In validateFinally(), verifying " + map.size() + " entries");
            for (String key : keySet) {
                String regionValue = (String)employee.get((Object)key);
                String dbValue = DBUtil.getDBValue(GemFireTxCallback.getDBTableName(), key);
                displayStr.append("  " + key + " dbValue = " + dbValue + " regionValue = " + regionValue + "\n");
                if (dbValue.equals(regionValue)) continue;
                aStr.append("Data inconsistency detected for " + key + " dbValue = " + dbValue + " and regionValue " + regionValue);
            }
        }
        catch (Exception e) {
            throw new TestException("Exception in validateFinally ", e);
        }
        if (aStr.length() > 0) {
            Log.getLogWriter().info("Validation FAILED\n" + displayStr.toString());
            throw new TestException(aStr.toString() + TestHelper.getStackTrace());
        }
        Log.getLogWriter().info("Validation SUCCESSFUL\n" + displayStr.toString());
    }

    static {
        dbConnection = new ThreadLocal();
    }
}

