/*
 * Decompiled with CFR 0.152.
 */
package hydratest.locators;

import com.gemstone.gemfire.distributed.DistributedSystem;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.GatewayHubHelper;
import hydra.GatewaySenderHelper;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydratest.locators.LocatorBlackboard;
import hydratest.locators.LocatorPrms;
import java.util.List;
import perffmwk.PerfStatMgr;
import perffmwk.PerfStatValue;

public class LocatorClient {
    public static void createLocatorWhenAlreadyMasterManagedTask() {
        try {
            DistributedSystemHelper.createLocator();
            String s = "Failed to prevent client from creating client-managed locator when locators are already master-managed";
            throw new HydraRuntimeException(s);
        }
        catch (HydraConfigException e) {
            String err = "Locators are being managed by the hydra master controller";
            if (e.getMessage().indexOf(err) == -1) {
                throw e;
            }
            return;
        }
    }

    public static void createLocatorTask() {
        DistributedSystemHelper.createLocator();
    }

    public static void startFirstLocatorAndAdminDSTask() {
        long locatorNumber = LocatorBlackboard.getInstance().getSharedCounters().incrementAndRead(LocatorBlackboard.locatorNumber);
        if (locatorNumber == 1L) {
            DistributedSystemHelper.startLocatorAndAdminDS();
        }
    }

    public static void startFirstLocatorAndDSTask() {
        long locatorNumber = LocatorBlackboard.getInstance().getSharedCounters().incrementAndRead(LocatorBlackboard.locatorNumber);
        if (locatorNumber == 1L) {
            DistributedSystemHelper.startLocatorAndDS();
        }
    }

    public static void startLocatorAndAdminDSTask() {
        DistributedSystemHelper.startLocatorAndAdminDS();
    }

    public static void startLocatorAndDSTask() {
        DistributedSystemHelper.startLocatorAndDS();
    }

    public static void stopLocatorTask() {
        DistributedSystemHelper.stopLocator();
    }

    public static void bounceLocatorTask() throws ClientVmNotFoundException {
        ClientVmInfo info = new ClientVmInfo(null, "loc*", null);
        Log.getLogWriter().info("Sleeping 2 seconds before locator stop");
        MasterController.sleepForMs(2000);
        info = ClientVmMgr.stop("Stopping locator: " + info, -21, -31, info);
        Log.getLogWriter().info("Sleeping 2 seconds before locator start");
        MasterController.sleepForMs(2000);
        ClientVmMgr.start("Restarting locator: " + info, info);
    }

    public static void connectTask() {
        DistributedSystemHelper.connect();
    }

    public static void openCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String gatewaySenderConfig = ConfigPrms.getGatewaySenderConfig();
        if (gatewaySenderConfig != null) {
            GatewaySenderHelper.createAndStartGatewaySenders(gatewaySenderConfig);
        }
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createCacheTask() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        String bridgeConfig = ConfigPrms.getBridgeConfig();
        if (bridgeConfig != null) {
            BridgeHelper.startBridgeServer(bridgeConfig);
        }
    }

    public static void createRegionTask() {
        RegionHelper.createRegion(ConfigPrms.getRegionConfig());
    }

    public static void closeCacheTask() {
        CacheHelper.closeCache();
    }

    public static void createGatewayHubTask() {
        String gatewayHubConfig = ConfigPrms.getGatewayHubConfig();
        GatewayHubHelper.createGatewayHub(gatewayHubConfig);
    }

    public static void addGatewaysTask() {
        String gatewayConfig = ConfigPrms.getGatewayConfig();
        GatewayHubHelper.addGateways(gatewayConfig);
    }

    public static void startGatewayHubTask() {
        GatewayHubHelper.startGatewayHub();
    }

    public static void validateExpectedMembersTask() {
        int expected;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        int actual = ds == null ? 0 : DistributedSystemHelper.getMembers().size();
        if (actual != (expected = LocatorPrms.getExpectedMembers())) {
            String s = "Expected " + expected + " members, found " + actual;
            throw new HydraRuntimeException(s);
        }
        String s = "Have expected " + expected + " members";
        Log.getLogWriter().info(s);
    }

    public static void validateExpectedEventsTask() {
        int puts = LocatorClient.readIntStat("cacheperf.CachePerfStats", "puts");
        int events = LocatorClient.readIntStat("cacheperf.CachePerfStats", "updateEvents");
        if (events != puts) {
            String s = "Had " + puts + " puts but " + events + " events";
            throw new HydraRuntimeException(s);
        }
        Log.getLogWriter().info("Had " + events + " puts and events");
    }

    private static int readIntStat(String statType, String statName) {
        MasterController.sleepForMs(10000);
        String spec = "* " + statType + " * " + statName + " " + "filter" + "=" + "none" + " " + "combine" + "=" + "combine" + " " + "ops" + "=" + "max";
        List aList = PerfStatMgr.getInstance().readStatistics(spec, true);
        int value = 0;
        for (int i = 0; i < aList.size(); ++i) {
            PerfStatValue stat = (PerfStatValue)aList.get(i);
            value = (int)((double)value + stat.getMax());
        }
        return value;
    }
}

