/*
 * Decompiled with CFR 0.152.
 */
package hydratest.admin;

import hydra.AdminDescription;
import hydra.AgentHelper;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydratest.admin.AdminPrms;

public class AdminClient {
    public static void connectToNonAdminDS() {
        DistributedSystemHelper.connect();
    }

    public static void connectToAdminDS() {
        DistributedSystemHelper.connectAdmin(ConfigPrms.getAdminConfig());
    }

    public static void startConnectedAgent() {
        AgentHelper.startConnectedAgent(ConfigPrms.getAgentConfig());
    }

    public static void checkEmail() {
        String tg = RemoteTestModule.getCurrentThread().getThreadGroupName();
        AdminDescription ad = TestConfig.getInstance().getAdminDescription(tg);
        AdminClient.checkEmailNotificationEnabled(tg, ad);
        AdminClient.checkEmailNotificationFrom(tg, ad);
        AdminClient.checkEmailNotificationHost(tg, ad);
        AdminClient.checkEmailNotificationToList(tg, ad);
    }

    private static void checkEmailNotificationEnabled(String tg, AdminDescription ad) {
        boolean expected = AdminPrms.getExpectedEmailNotificationEnabled();
        Log.getLogWriter().info(tg + ":\n" + ad);
        boolean value = ad.getEmailNotificationEnabled();
        if (value != expected) {
            String s = tg + " expected emailNotificationEnabled " + expected + ", got " + value;
            throw new HydraRuntimeException(s);
        }
    }

    private static void checkEmailNotificationFrom(String tg, AdminDescription ad) {
        String expected = AdminPrms.getExpectedEmailNotificationFrom();
        String value = ad.getEmailNotificationFrom();
        if (!value.equals(expected)) {
            String s = tg + " expected emailNotificationFrom " + expected + ", got " + value;
            throw new HydraRuntimeException(s);
        }
    }

    private static void checkEmailNotificationHost(String tg, AdminDescription ad) {
        String expected = HostHelper.getCanonicalHostName(EnvHelper.convertHostName(AdminPrms.getExpectedEmailNotificationHost()));
        String value = ad.getEmailNotificationHost();
        if (!value.equals(expected)) {
            String s = tg + " expected emailNotificationHost " + expected + ", got " + value;
            throw new HydraRuntimeException(s);
        }
    }

    private static void checkEmailNotificationToList(String tg, AdminDescription ad) {
        String expected = AdminDescription.getEmailNotificationToList(AdminPrms.getExpectedEmailNotificationToList());
        String value = ad.getEmailNotificationToList();
        if (!value.equals(expected)) {
            String s = tg + " expected emailNotificationToList " + expected + ", got " + value;
            throw new HydraRuntimeException(s);
        }
    }
}

