/*
 * Decompiled with CFR 0.152.
 */
package hydratest;

import hydra.HydraThreadLocal;
import hydra.Log;
import hydra.MasterController;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydratest.BatchPrms;

public class BatchClient {
    private static HydraThreadLocal localcount = new HydraThreadLocal();

    public static void tryItOutBatch() {
        int totalIterations = TestConfig.tab().intAt(BatchPrms.totalIterations);
        int batchSize = TestConfig.tab().intAt(BatchPrms.batchSize);
        BatchClient c = new BatchClient();
        c.tryItOutBatchWork(totalIterations, batchSize);
    }

    public static void tryItOutBatch2() {
        int totalIterations = TestConfig.tab().intAt(BatchPrms.totalIterations2);
        int batchSize = TestConfig.tab().intAt(BatchPrms.batchSize2);
        BatchClient c = new BatchClient();
        c.tryItOutBatchWork(totalIterations, batchSize);
    }

    private void tryItOutBatchWork(int totalIterations, int batchSize) {
        int count = this.getCount();
        for (int i = 0; i < batchSize; ++i) {
            MasterController.sleepForMs(1000);
            if (++count != totalIterations) continue;
            Log.getLogWriter().info("Done: count is " + count);
            throw new StopSchedulingTaskOnClientOrder();
        }
        Log.getLogWriter().info("Not done: count is " + count);
        this.setCount(count);
    }

    private int getCount() {
        Integer n = (Integer)localcount.get();
        if (n == null) {
            n = new Integer(0);
            localcount.set(n);
        }
        return n;
    }

    private void setCount(int n) {
        localcount.set(new Integer(n));
    }
}

