/*
 * Decompiled with CFR 0.152.
 */
package hydra.timeserver;

import hydra.timeserver.ClockSkewStats;
import java.io.IOException;
import java.math.BigInteger;

public class TimeClient
extends Thread {
    private final String serverHost;
    private final int serverPort;
    private final int frequencyMs;
    private final int latencyThresholdMs;
    private final int samplesToAverage;
    ClockSkewStats statistics;
    private long clockSkew = Long.MAX_VALUE;
    private long networkLatency = Long.MAX_VALUE;
    public BigInteger skewSum = BigInteger.valueOf(0L);
    public long networkLatencySum = 0L;
    public long packetCount = 0L;

    public TimeClient(String host, int port, int frequencyMs, int latencyThresholdMs, int samplesToAverage) throws IOException {
        super("TimeClient");
        this.serverHost = host;
        this.serverPort = port;
        this.frequencyMs = frequencyMs;
        this.latencyThresholdMs = latencyThresholdMs;
        this.samplesToAverage = samplesToAverage;
    }

    public int getFrequencyMs() {
        return this.frequencyMs;
    }

    public synchronized long getClockSkew() {
        return this.clockSkew;
    }

    public synchronized long getNetworkLatency() {
        return this.networkLatency;
    }

    private synchronized void setClockSkew(long skew, long networkLatency) {
        boolean initialization = this.clockSkew == Long.MAX_VALUE;
        this.clockSkew = skew;
        this.networkLatency = networkLatency;
        if (this.statistics != null) {
            this.statistics.setClockSkew(skew);
            this.statistics.setLatency(networkLatency);
        }
        if (initialization) {
            this.notify();
        }
    }

    public synchronized void openStatistics() {
        if (this.statistics == null) {
            this.statistics = ClockSkewStats.getInstance();
        }
    }

    public synchronized void closeStatistics() {
        if (this.statistics != null) {
            this.statistics.close();
            this.statistics = null;
        }
    }

    @Override
    public String toString() {
        long skew = this.getClockSkew();
        if (skew == Long.MAX_VALUE) {
            return this.serverHost + ":" + this.serverPort + " (every " + this.frequencyMs + " ms) with current skew uninitialized";
        }
        return this.serverHost + ":" + this.serverPort + " (every " + this.frequencyMs + " ms) with current skew " + this.getClockSkew();
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void sleep() throws InterruptedException {
        if (this.packetCount < (long)this.samplesToAverage) {
            Thread.sleep(this.frequencyMs / this.samplesToAverage);
        } else {
            Thread.sleep(this.frequencyMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForInitialization() throws InterruptedException {
        TimeClient timeClient = this;
        synchronized (timeClient) {
            while (this.getClockSkew() == Long.MAX_VALUE) {
                this.wait();
            }
        }
    }
}

