/*
 * Decompiled with CFR 0.152.
 */
package hydra.blackboard;

import com.gemstone.gemfire.LogWriter;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.blackboard.RmiSharedCondition;
import hydra.blackboard.RmiSharedLock;
import hydra.blackboard.RmiSharedLockImpl;
import hydra.blackboard.SharedCondition;
import hydra.blackboard.SharedLock;
import java.rmi.RemoteException;

public class AnySharedLockImpl
implements SharedLock {
    private String name;
    private int type = -1;
    private LogWriter log;
    private RmiSharedLock rmilock;

    public AnySharedLockImpl(String name, int type) {
        this.name = name;
        this.type = type;
        this.log = Log.getLogWriter();
    }

    protected void setRmiLock(RmiSharedLock rmil) {
        this.rmilock = rmil;
    }

    public static SharedLock bind(String name, int type) {
        switch (type) {
            case 0: {
                try {
                    RmiSharedLockImpl rmil = new RmiSharedLockImpl();
                    RmiSharedLockImpl.bind(name, rmil);
                    AnySharedLockImpl ali = new AnySharedLockImpl(name, type);
                    ali.setRmiLock(rmil);
                    return ali;
                }
                catch (RemoteException e) {
                    String s = "Unable to bind RMI lock: " + name;
                    throw new HydraRuntimeException(s, e);
                }
            }
        }
        String s = "Illegal transport type: " + type;
        throw new HydraInternalException(s);
    }

    public static SharedLock lookup(String name, int type) {
        switch (type) {
            case 0: {
                RmiSharedLock rmil = null;
                try {
                    rmil = RmiSharedLockImpl.lookup(name);
                }
                catch (RemoteException e) {
                    String s = "Unable to look up RMI lock: " + name;
                    throw new HydraRuntimeException(s, e);
                }
                if (rmil == null) {
                    return null;
                }
                AnySharedLockImpl ali = new AnySharedLockImpl(name, type);
                ali.setRmiLock(rmil);
                return ali;
            }
        }
        String s = "Illegal transport type: " + type;
        throw new HydraInternalException(s);
    }

    @Override
    public void lock() {
        switch (this.type) {
            case 0: {
                try {
                    String threadName = Thread.currentThread().getName();
                    int vmid = RemoteTestModule.getMyVmid();
                    RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                    long tid = mod == null ? Thread.currentThread().getId() : (long)mod.getThreadId();
                    this.rmilock.lock(threadName, vmid, tid);
                    break;
                }
                catch (RemoteException e) {
                    String s = "Unable to access RMI lock: " + this.name;
                    throw new HydraRuntimeException(s, e);
                }
            }
            default: {
                String s = "Illegal transport type: " + this.type;
                throw new HydraInternalException(s);
            }
        }
    }

    @Override
    public void unlock() {
        switch (this.type) {
            case 0: {
                try {
                    String threadName = Thread.currentThread().getName();
                    int vmid = RemoteTestModule.getMyVmid();
                    RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                    long tid = mod == null ? Thread.currentThread().getId() : (long)mod.getThreadId();
                    this.rmilock.unlock(threadName, vmid, tid);
                    break;
                }
                catch (RemoteException e) {
                    String s = "Unable to access RMI lock: " + this.name;
                    throw new HydraRuntimeException(s, e);
                }
            }
            default: {
                String s = "Illegal transport type: " + this.type;
                throw new HydraInternalException(s);
            }
        }
    }

    @Override
    public SharedCondition getCondition(String name) {
        switch (this.type) {
            case 0: {
                try {
                    return new RmiSharedConditionWrapper(name, this.rmilock.getCondition(name));
                }
                catch (RemoteException e) {
                    String s = "Unable to access RMI lock: " + this.name;
                    throw new HydraRuntimeException(s, e);
                }
            }
        }
        String s = "Illegal transport type: " + this.type;
        throw new HydraInternalException(s);
    }

    private static class RmiSharedConditionWrapper
    implements SharedCondition {
        private RmiSharedCondition rmiSharedCondition;
        private String name;

        public RmiSharedConditionWrapper(String name, RmiSharedCondition condition) {
            this.name = name;
            this.rmiSharedCondition = condition;
        }

        @Override
        public void await() throws InterruptedException {
            try {
                String threadName = Thread.currentThread().getName();
                int vmid = RemoteTestModule.getMyVmid();
                RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                long tid = mod == null ? Thread.currentThread().getId() : (long)mod.getThreadId();
                this.rmiSharedCondition.await(threadName, vmid, tid);
            }
            catch (RemoteException e) {
                String s = "Unable to access RMI condition: " + this.name;
                throw new HydraRuntimeException(s, e);
            }
        }

        @Override
        public void signal() {
            try {
                String threadName = Thread.currentThread().getName();
                int vmid = RemoteTestModule.getMyVmid();
                RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                long tid = mod == null ? Thread.currentThread().getId() : (long)mod.getThreadId();
                this.rmiSharedCondition.signal(threadName, vmid, tid);
            }
            catch (RemoteException e) {
                String s = "Unable to access RMI condition: " + this.name;
                throw new HydraRuntimeException(s, e);
            }
        }

        @Override
        public void signalAll() {
            try {
                String threadName = Thread.currentThread().getName();
                int vmid = RemoteTestModule.getMyVmid();
                RemoteTestModule mod = RemoteTestModule.getCurrentThread();
                long tid = mod == null ? Thread.currentThread().getId() : (long)mod.getThreadId();
                this.rmiSharedCondition.signalAll(threadName, vmid, tid);
            }
            catch (RemoteException e) {
                String s = "Unable to access RMI condition: " + this.name;
                throw new HydraRuntimeException(s, e);
            }
        }
    }
}

