/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.ClientRecord;
import hydra.ConfigHashtable;
import hydra.HydraInternalException;
import hydra.HydraThreadGroup;
import hydra.Log;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.NumStats;
import hydra.ResultLogger;
import hydra.TestTaskResult;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class TestTask
implements Cloneable,
Serializable {
    protected static final int STARTTASK = 0;
    protected static final int INITTASK = 1;
    protected static final int DYNAMICINITTASK = 2;
    protected static final int TASK = 3;
    protected static final int DYNAMICCLOSETASK = 4;
    protected static final int CLOSETASK = 5;
    protected static final int ENDTASK = 6;
    protected static final int UNITTEST = 7;
    public static final int ALWAYS = 0;
    public static final int ONCE = 1;
    public static final int DYNAMIC = 2;
    protected static final int DEFAULT_RUN_MODE = 1;
    private int taskIndex;
    private int taskType;
    private String receiver;
    private String selector;
    private int totalThreads = -1;
    private ConfigHashtable attributes = new ConfigHashtable();
    private Vector clientNames = null;
    private Vector tgNames;
    private Map tgs;
    private boolean batch = false;
    private boolean sequential = false;
    private int runMode = -1;
    private int maxTimesToRun = -1;
    private int maxThreads = -1;
    private int weight = -1;
    private int startInterval = -1;
    private long startIntervalMs;
    private int endInterval = -1;
    private long endIntervalMs;
    private int numClients = 0;
    private volatile int numTimesInUse = 0;
    private volatile int numTimesRun = 0;
    private NumStats elapsedTimes = new NumStats();
    private long[] startTimes;
    private long[] endTimes;
    private Vector clients;
    private String cachedShortString;

    public Object clone() {
        TestTask clone;
        try {
            clone = (TestTask)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new HydraInternalException("Unable to clone task");
        }
        clone.elapsedTimes = new NumStats();
        return clone;
    }

    public TestTaskResult execute() {
        long beginTime = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(this.getReceiver(), this.getSelector());
        long elapsedTime = System.currentTimeMillis() - beginTime;
        return new TestTaskResult(result, elapsedTime);
    }

    public String toShortString() {
        if (this.cachedShortString == null) {
            this.initCachedShortString();
        }
        return this.cachedShortString;
    }

    private synchronized void initCachedShortString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append(this.getTaskTypeString()).append("[");
        buf.append(this.getTaskIndex()).append("] ");
        buf.append(this.getReceiver()).append(".");
        buf.append(this.getSelector());
        this.cachedShortString = buf.toString();
    }

    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        int n = this.getTaskType();
        String header = null;
        if (n == 7) {
            header = this.getClass().getName() + "." + this.getTaskTypeString() + "." + this.getTaskIndex() + ".";
            map.put(header + "taskClass", this.getReceiver());
            map.put(header + "taskMethod", this.getSelector());
            map.put(header + "threadGroups", this.getThreadGroupNames());
        } else if (n == 0 || n == 6) {
            header = this.getClass().getName() + "." + this.getTaskTypeString() + "." + this.getTaskIndex() + ".";
            map.put(header + "taskClass", this.getReceiver());
            map.put(header + "taskMethod", this.getSelector());
            map.put(header + "clientNames", this.getClientNames());
        } else if (n == 1 || n == 5 || n == 2 || n == 4) {
            header = this.getClass().getName() + "." + this.getTaskTypeString() + "." + this.getTaskIndex() + "." + this.getRunModeString() + ".";
            map.put(header + "taskClass", this.getReceiver());
            map.put(header + "taskMethod", this.getSelector());
            map.put(header + "threadGroups", this.getThreadGroupNames());
            map.put(header + "sequential", this.sequential());
            map.put(header + "batch", this.batch());
        } else if (n == 3) {
            header = this.getClass().getName() + "." + this.getTaskTypeString() + "." + this.getTaskIndex() + ".";
            map.put(header + "taskClass", this.getReceiver());
            map.put(header + "taskMethod", this.getSelector());
            map.put(header + "threadGroups", this.getThreadGroupNames());
            map.put(header + "maxTimesToRun", String.valueOf(this.getMaxTimesToRun()));
            map.put(header + "maxThreads", String.valueOf(this.getMaxThreads()));
            map.put(header + "weight", String.valueOf(this.getWeight()));
            map.put(header + "startInterval", String.valueOf(this.getStartInterval()));
            map.put(header + "endInterval", String.valueOf(this.getEndInterval()));
        }
        SortedMap tab = this.attributes.toSortedMap();
        for (String key : tab.keySet()) {
            Object value = tab.get(key);
            map.put(header + key, value);
        }
        return map;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.toSortedMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }

    public int getTaskIndex() {
        return this.taskIndex;
    }

    public void setTaskIndex(int anIndex) {
        this.taskIndex = anIndex;
    }

    public int getTaskType() {
        return this.taskType;
    }

    public String getTaskTypeString() {
        switch (this.taskType) {
            case 0: {
                return "STARTTASK";
            }
            case 1: {
                return "INITTASK";
            }
            case 2: {
                return "INITTASK";
            }
            case 3: {
                return "TASK";
            }
            case 4: {
                return "CLOSETASK";
            }
            case 5: {
                return "CLOSETASK";
            }
            case 6: {
                return "ENDTASK";
            }
            case 7: {
                return "UNITTEST";
            }
        }
        throw new HydraInternalException("Unknown task type: " + this.taskType);
    }

    public void setTaskType(int aType) {
        this.taskType = aType;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public void setReceiver(String aStr) {
        this.receiver = aStr;
    }

    public String getSelector() {
        return this.selector;
    }

    public void setSelector(String aStr) {
        this.selector = aStr;
    }

    public ConfigHashtable getTaskAttributes() {
        return this.attributes;
    }

    protected void setTaskAttribute(Long key, Object value) {
        this.attributes.put(key, value);
    }

    public int getRunMode() {
        return this.runMode;
    }

    public void setRunMode(int mode) {
        this.runMode = mode;
    }

    public String getRunModeString() {
        switch (this.runMode) {
            case 0: {
                return "always";
            }
            case 1: {
                return "once";
            }
            case 2: {
                return "dynamic";
            }
        }
        return "not set yet";
    }

    public boolean sequential() {
        return this.sequential;
    }

    public void setSequential(boolean flag) {
        this.sequential = flag;
    }

    public boolean batch() {
        return this.batch;
    }

    public void setBatch(boolean flag) {
        this.batch = flag;
    }

    public Vector getClientNames() {
        return this.clientNames;
    }

    public void setClientNames(Vector names) {
        this.clientNames = names;
    }

    public int getMaxTimesToRun() {
        return this.maxTimesToRun;
    }

    public void setMaxTimesToRun(int anInt) {
        this.maxTimesToRun = anInt;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(int anInt) {
        this.maxThreads = anInt;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public int getStartInterval() {
        return this.startInterval;
    }

    public void setStartInterval(int n) {
        this.startInterval = n;
        this.startIntervalMs = n * 1000;
    }

    public int getEndInterval() {
        return this.endInterval;
    }

    public void setEndInterval(int n) {
        this.endInterval = n;
        this.endIntervalMs = n * 1000;
    }

    protected void setNumClients(int numClients) {
        this.numClients = numClients;
    }

    public Vector getThreadGroupNames() {
        return this.tgNames;
    }

    protected void setThreadGroupNames(Vector tgNames) {
        this.tgNames = tgNames;
    }

    protected void addThreadGroupName(String tgName) {
        if (this.tgNames == null) {
            this.tgNames = new Vector();
        }
        this.tgNames.add(tgName);
    }

    public Map getThreadGroups() {
        return this.tgs;
    }

    protected void addThreadGroup(HydraThreadGroup tg) {
        if (this.tgs == null) {
            this.tgs = new HashMap();
        }
        this.tgs.put(tg.getName(), tg);
    }

    protected boolean usesThreadGroup(String name) {
        return this.tgs.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTotalThreads() {
        if (this.totalThreads == -1) {
            TestTask testTask = this;
            synchronized (testTask) {
                if (this.totalThreads == -1) {
                    switch (this.taskType) {
                        case 0: 
                        case 6: 
                        case 7: {
                            this.totalThreads = 1;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            int tmp = 0;
                            for (HydraThreadGroup tg : this.tgs.values()) {
                                tmp += tg.getTotalThreads();
                            }
                            this.totalThreads = tmp;
                            break;
                        }
                        default: {
                            throw new HydraInternalException("Should not happen");
                        }
                    }
                }
            }
        }
        return this.totalThreads;
    }

    public int getTaskThreadGroupId(String tgName, int tgid) {
        int tgnum = this.tgNames.indexOf(tgName);
        int predecessors = 0;
        for (int i = 0; i < tgnum; ++i) {
            String name = (String)this.tgNames.get(i);
            HydraThreadGroup tg = (HydraThreadGroup)this.tgs.get(name);
            predecessors += tg.getTotalThreads();
        }
        return predecessors + tgid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setStartTimes(long t) {
        if (this.startTimes == null) {
            this.initStartTimes();
        }
        if (this.startInterval == 0) return;
        long[] lArray = this.startTimes;
        synchronized (this.startTimes) {
            for (int i = 0; i < this.startTimes.length; ++i) {
                this.startTimes[i] = t;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private synchronized void initStartTimes() {
        if (this.startTimes == null) {
            int totalThreads = 0;
            for (HydraThreadGroup tg : this.getThreadGroups().values()) {
                totalThreads += tg.getTotalThreads();
            }
            this.startTimes = new long[totalThreads];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEndTimes(long t) {
        if (this.endTimes == null) {
            this.initEndTimes();
        }
        if (this.endInterval == 0) return;
        long[] lArray = this.endTimes;
        synchronized (this.endTimes) {
            for (int i = 0; i < this.endTimes.length; ++i) {
                this.endTimes[i] = t;
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    private synchronized void initEndTimes() {
        if (this.endTimes == null) {
            int totalThreads = 0;
            for (HydraThreadGroup tg : this.getThreadGroups().values()) {
                totalThreads += tg.getTotalThreads();
            }
            this.endTimes = new long[totalThreads];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateStartTimes(long now) {
        if (this.taskType != 3 || this.startInterval == 0) return;
        long[] lArray = this.startTimes;
        synchronized (this.startTimes) {
            int i = this.indexWithMinValue(this.startTimes);
            this.startTimes[i] = now;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateEndTimes(long now) {
        if (this.taskType != 3 || this.endInterval == 0) return;
        long[] lArray = this.endTimes;
        synchronized (this.endTimes) {
            int i = this.indexWithMinValue(this.endTimes);
            this.endTimes[i] = now;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfiesStartInterval(long now) {
        if (this.startInterval == 0) {
            return true;
        }
        long diff = now - this.startIntervalMs;
        long[] lArray = this.startTimes;
        synchronized (this.startTimes) {
            for (int i = 0; i < this.startTimes.length; ++i) {
                if (diff <= this.startTimes[i]) continue;
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean satisfiesEndInterval(long now) {
        if (this.endInterval == 0) {
            return true;
        }
        long diff = now - this.endIntervalMs;
        long[] lArray = this.endTimes;
        synchronized (this.endTimes) {
            for (int i = 0; i < this.endTimes.length; ++i) {
                if (diff <= this.endTimes[i]) continue;
                // ** MonitorExit[var5_3] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var5_3] (shouldn't be in output)
            return false;
        }
    }

    private int indexWithMinValue(long[] arr) {
        if (arr.length == 0) {
            throw new HydraInternalException("Unexpectedly empty array");
        }
        long minValue = arr[0];
        int index = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= minValue) continue;
            index = i;
        }
        return index;
    }

    public int getNumTimesRun() {
        return this.numTimesRun;
    }

    public void incrementNumTimesRun() {
        ++this.numTimesRun;
    }

    public int getNumTimesInUse() {
        return this.numTimesInUse;
    }

    public void incrementNumTimesInUse() {
        ++this.numTimesInUse;
    }

    public void decrementNumTimesInUse() {
        --this.numTimesInUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NumStats getElapsedTimes() {
        NumStats numStats = this.elapsedTimes;
        synchronized (numStats) {
            return this.elapsedTimes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addElapsedTime(long t) {
        NumStats numStats = this.elapsedTimes;
        synchronized (numStats) {
            this.elapsedTimes.add(t);
        }
    }

    protected boolean acceptsStopSchedulingOrder() {
        return this.taskType == 3;
    }

    protected boolean acceptsStopSchedulingTaskOnClientOrder() {
        return this.taskType != 0 && this.taskType != 6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean receivedStopSchedulingTaskOnClientOrder() {
        TestTask testTask = this;
        synchronized (testTask) {
            return this.clients != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receivedStopSchedulingTaskOnClientOrder(ClientRecord client) {
        TestTask testTask = this;
        synchronized (testTask) {
            return this.clients != null && this.clients.contains(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveStopSchedulingTaskOnClientOrder(ClientRecord client) {
        TestTask testTask = this;
        synchronized (testTask) {
            if (this.clients == null) {
                this.clients = new Vector();
            }
            if (this.clients.contains(client)) {
                String s = client + " already threw a StopSchedulingTaskOnClientOrder";
                throw new HydraInternalException(s);
            }
            this.clients.add(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean receivedAllStopSchedulingTaskOnClientOrders() {
        TestTask testTask = this;
        synchronized (testTask) {
            return this.clients != null && this.clients.size() == this.numClients;
        }
    }

    protected void logTaskResult(ClientRecord client, TestTaskResult result) {
        ResultLogger.logTaskResult(client, this, result);
    }

    protected void logHangResult(ClientRecord client, TestTaskResult result) {
        ResultLogger.logHangResult(client, this, result);
    }

    public void logHangResult(ClientRecord client, String msg) {
        ResultLogger.logHangResult(client, this, msg);
        if (client.vm().getClientName().equals("controller")) {
            try {
                File dir = new File("failures");
                dir.mkdir();
                File file = new File(dir, "HungDUnitTest.txt");
                file.createNewFile();
                FileWriter fw = new FileWriter(file, true);
                PrintWriter pw = new PrintWriter((Writer)fw, true);
                pw.println("Some DUnit test HUNG.  See end of dunit-progress*.txt");
                pw.flush();
                pw.close();
            }
            catch (IOException ex) {
                String s = "Couldn't log hung DUnit test";
                Log.getLogWriter().severe(s, (Throwable)ex);
            }
        }
    }

    public void logUnitTestResult(TestTaskResult result) {
        if (result.getErrorStatus()) {
            this.log().severe("Unit test result: FAILED ==> " + result);
        } else {
            this.log().info("Unit test result: PASSED ==> " + result);
        }
    }

    private LogWriter log() {
        return Log.getLogWriter();
    }
}

