/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.StatisticsFactory;
import com.gemstone.gemfire.StatisticsType;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.PureJavaMode;
import hydra.FileUtil;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.MasterProxyIF;
import hydra.ProcessMgr;
import hydra.StatMonitorPrms;
import hydra.TestConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import util.TestHelper;

public class StatMonitor
implements Runnable {
    private static boolean DumpedStacks = false;
    private static LogWriter log;
    private static TestConfig testConfig;
    private Vector conditions;
    private String os;
    private MasterProxyIF master;
    private HostDescription hd;
    private static Map AllTypes;
    private static Thread Monitor;
    private static boolean MonitorStop;
    public static final String HAS_CHANGED_BY_LESS_THAN = "hasChangedByLessThan";
    public static final String IS_UNCHANGED = "isUnchanged";
    public static final String IS_LESS_THAN = "isLessThan";
    public static final String IS_GREATER_THAN = "isGreaterThan";
    public static final String IS_EQUAL_TO = "isEqualTo";
    public static final String HALT = "halt";
    public static final String DUMP = "dump";
    public static final String WARN = "warn";
    private static final int _HALT = 0;
    private static final int _DUMP = 1;
    private static final int _WARN = 2;

    public StatMonitor(Vector conditions, HostDescription hd, MasterProxyIF master, TestConfig config) {
        this.conditions = conditions;
        this.hd = hd;
        this.master = master;
        testConfig = config;
        log = Log.getLogWriter();
    }

    @Override
    public void run() {
        Thread.currentThread().setName("StatMonitor");
        try {
            log.info("Statistics monitor is running");
            this.monitor();
            log.info("Statistics monitor is stopped");
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable t) {
            try {
                this.master.reportStatMonitorError(t);
            }
            catch (RemoteException e) {
                log.info(TestHelper.getStackTrace(e));
                throw new HydraRuntimeException("Could not reach master", e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void monitor() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 9[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private StatisticsFactory getStatisticsFactory(int sampleRate, boolean archiveStats) {
        Properties p = new Properties();
        if (archiveStats) {
            String dirName = System.getProperty("user.dir") + "/statmon_" + ProcessMgr.getProcessId();
            FileUtil.mkdir(new File(dirName));
            try {
                this.master.recordDir(this.hd, "statmon", dirName);
            }
            catch (RemoteException e) {
                String s = "Unable to record system directory with master: " + dirName;
                throw new HydraRuntimeException(s, e);
            }
            p.setProperty("statistic-archive-file", dirName + "/statArchive.gfs");
        }
        p.setProperty("statistic-sampling-enabled", "true");
        p.setProperty("statistic-sample-rate", String.valueOf(sampleRate));
        p.setProperty("locators", "");
        p.setProperty("mcast-port", String.valueOf(0));
        DistributedSystem ds = DistributedSystem.connect((Properties)p);
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StatisticsType getStatisticsType(StatisticsFactory factory, String name) {
        StatisticsType type = (StatisticsType)AllTypes.get(name);
        if (type == null) {
            Map map = AllTypes;
            synchronized (map) {
                type = factory.findType(name);
                if (type == null && (type = factory.findType(name)) == null) {
                    throw new HydraConfigException("No statistic with type " + name);
                }
                AllTypes.put(name, type);
            }
        }
        return type;
    }

    protected static Vector parseConditions(Vector conditionsIn) {
        Vector<Condition> conditionsOut = null;
        if (conditionsIn != null) {
            conditionsOut = new Vector<Condition>();
            for (Vector conditionIn : conditionsIn) {
                conditionsOut.add(new Condition(conditionIn));
            }
        }
        return conditionsOut;
    }

    public static void start(HostDescription hd, MasterProxyIF master, TestConfig tc) {
        if (!PureJavaMode.osStatsAreAvailable()) {
            Log.getLogWriter().warning("Skipping statistics monitoring due to running in pure Java mode");
            return;
        }
        Vector conditions = StatMonitorPrms.getConditions(tc);
        boolean archiveStats = StatMonitorPrms.archiveStats(tc);
        if (conditions != null || archiveStats) {
            StatMonitor statmon = new StatMonitor(conditions, hd, master, tc);
            Log.getLogWriter().info("Starting statistics monitor with conditions " + conditions + " and archiving set " + archiveStats);
            Monitor = new Thread(statmon);
            Monitor.start();
            Log.getLogWriter().info("Started statistics monitor with conditions " + conditions + " and archiving set " + archiveStats);
        }
    }

    public static void stop() {
        if (Monitor != null) {
            Log.getLogWriter().info("Stopping statistics monitor");
            MonitorStop = true;
            Monitor.interrupt();
            Monitor = null;
        }
    }

    private void printLocalProcessStacks() {
        String fn = System.getProperty("user.dir") + "/dumprun.sh";
        String localhost = HostHelper.getLocalHost();
        String masterhost = testConfig.getMasterDescription().getVmDescription().getHostDescription().getHostName();
        try {
            String line;
            FileInputStream fis = new FileInputStream(fn);
            BufferedReader br = new BufferedReader(new InputStreamReader(fis));
            while ((line = br.readLine()) != null) {
                if ((!localhost.equals(masterhost) || !line.startsWith("kill")) && (line.startsWith("#") || line.indexOf(localhost) == -1)) continue;
                String pidStr = line.substring(line.indexOf("QUIT") + 5);
                int pid = Integer.valueOf(pidStr);
                ProcessMgr.printProcessStacks(localhost, pid);
            }
            br.close();
        }
        catch (FileNotFoundException e) {
            throw new HydraRuntimeException("Unable to find file: " + fn, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to process file: " + fn, e);
        }
    }

    static {
        AllTypes = new HashMap();
        Monitor = null;
        MonitorStop = false;
    }

    private static class Condition
    implements Serializable {
        private static final int _HAS_CHANGED_BY_LESS_THAN = 0;
        private static final int _IS_UNCHANGED = 1;
        private static final int _IS_LESS_THAN = 2;
        private static final int _IS_GREATER_THAN = 3;
        private static final int _IS_EQUAL_TO = 4;
        String type;
        String stat;
        int op;
        double amount;
        int action;
        double value = -1.0;

        protected Condition(Vector condition) {
            if (condition.size() != 5) {
                String s = "Statistic requires 5 fields: type stat op amount action, for example, SystemStats pagesSwappedIn hasChangedByLessThan 5000 halt";
                throw new HydraConfigException(s);
            }
            this.type = (String)condition.get(0);
            this.stat = (String)condition.get(1);
            if (this.type.equals("SystemStats") || this.type.equals("ProcessStats")) {
                this.type = this.getOS() + this.type;
            }
            this.op = this.toOp((String)condition.get(2));
            try {
                this.amount = Double.valueOf((String)condition.get(3));
            }
            catch (NumberFormatException e) {
                String s = "Statistic amount is not a number: " + condition.get(3);
                throw new HydraConfigException(s);
            }
            this.action = this.toAction((String)condition.get(4));
        }

        public String getType() {
            return this.type;
        }

        public String getStat() {
            return this.stat;
        }

        public int getOp() {
            return this.op;
        }

        public double getAmount() {
            return this.amount;
        }

        public int getAction() {
            return this.action;
        }

        public double getValue() {
            return this.value;
        }

        public boolean verify(double currentValue) {
            switch (this.op) {
                case 0: {
                    return this.verifyHasChangedByLessThan(currentValue);
                }
                case 1: {
                    return this.verifyIsUnchanged(currentValue);
                }
                case 2: {
                    return this.verifyIsLessThan(currentValue);
                }
                case 3: {
                    return this.verifyIsGreaterThan(currentValue);
                }
                case 4: {
                    return this.verifyIsEqualTo(currentValue);
                }
            }
            throw new HydraInternalException("Unhandled op: " + this.op);
        }

        private boolean verifyHasChangedByLessThan(double currentValue) {
            if (this.value == -1.0) {
                this.value = currentValue;
            }
            return Math.abs(currentValue - this.value) < this.amount;
        }

        private boolean verifyIsUnchanged(double currentValue) {
            if (this.value == -1.0) {
                this.value = currentValue;
            }
            return currentValue == this.value;
        }

        private boolean verifyIsLessThan(double currentValue) {
            return currentValue < this.amount;
        }

        private boolean verifyIsGreaterThan(double currentValue) {
            return currentValue > this.amount;
        }

        private boolean verifyIsEqualTo(double currentValue) {
            return currentValue == this.amount;
        }

        public String toString() {
            String s = this.type + " " + this.stat + " " + this.toOpStr(this.op) + " " + this.amount + " " + this.toActionStr(this.action);
            if (this.value != -1.0) {
                s = s + " with value " + this.value;
            }
            return s;
        }

        public String toShortString() {
            return this.type + " " + this.stat;
        }

        private int toOp(String opStr) {
            if (opStr.equalsIgnoreCase(StatMonitor.HAS_CHANGED_BY_LESS_THAN)) {
                return 0;
            }
            if (opStr.equalsIgnoreCase(StatMonitor.IS_UNCHANGED)) {
                return 1;
            }
            if (opStr.equalsIgnoreCase(StatMonitor.IS_LESS_THAN)) {
                return 2;
            }
            if (opStr.equalsIgnoreCase(StatMonitor.IS_GREATER_THAN)) {
                return 3;
            }
            if (opStr.equalsIgnoreCase(StatMonitor.IS_EQUAL_TO)) {
                return 4;
            }
            String s = "Illegal op: " + opStr;
            throw new HydraConfigException(s);
        }

        private String toOpStr(int opType) {
            switch (opType) {
                case 0: {
                    return StatMonitor.HAS_CHANGED_BY_LESS_THAN;
                }
                case 1: {
                    return StatMonitor.IS_UNCHANGED;
                }
                case 2: {
                    return StatMonitor.IS_LESS_THAN;
                }
                case 3: {
                    return StatMonitor.IS_GREATER_THAN;
                }
                case 4: {
                    return StatMonitor.IS_EQUAL_TO;
                }
            }
            throw new HydraInternalException("Should not happen");
        }

        private int toAction(String actionStr) {
            if (actionStr.equalsIgnoreCase(StatMonitor.HALT)) {
                return 0;
            }
            if (actionStr.equalsIgnoreCase(StatMonitor.DUMP)) {
                return 1;
            }
            if (actionStr.equalsIgnoreCase(StatMonitor.WARN)) {
                return 2;
            }
            String s = "Illegal action: " + actionStr;
            throw new HydraConfigException(s);
        }

        private String toActionStr(int actionType) {
            switch (actionType) {
                case 0: {
                    return StatMonitor.HALT;
                }
                case 1: {
                    return StatMonitor.DUMP;
                }
                case 2: {
                    return StatMonitor.WARN;
                }
            }
            throw new HydraInternalException("Should not happen");
        }

        private String getOS() {
            String o = System.getProperty("os.name");
            if (o.contains("Linux")) {
                return "Linux";
            }
            if (o.contains("SunOS")) {
                return "Solaris";
            }
            if (o.contains("Windows")) {
                return "Windows";
            }
            throw new HydraRuntimeException("Unsupported O/S: " + o);
        }
    }
}

