/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Log;
import hydra.MasterController;
import hydra.MasterProxyIF;
import java.io.InvalidClassException;
import java.rmi.AlreadyBoundException;
import java.rmi.ConnectException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RmiRegistryHelper {
    private static final int START_TIMEOUT_SEC = 120;

    public static Registry startRegistry(String name, int port) {
        String host = HostHelper.getLocalHost();
        String url = "rmi://" + host + ":" + port + "/";
        Log.getLogWriter().info("Starting RMI registry " + url);
        Registry registry = null;
        try {
            registry = LocateRegistry.createRegistry(port);
        }
        catch (RemoteException e) {
            String s = "Failed to start RMI registry " + url;
            throw new HydraRuntimeException(s, e);
        }
        Log.getLogWriter().info("Waiting 120 seconds for RMI registry " + url + " to respond");
        long timeout = System.currentTimeMillis() + 120000L;
        do {
            if (RmiRegistryHelper.isAnswering(host, port)) {
                Log.getLogWriter().info("Started RMI registry " + url);
                return registry;
            }
            MasterController.sleepForMs(1000);
        } while (System.currentTimeMillis() < timeout);
        String s = "Failed to start RMI registry " + name;
        throw new HydraTimeoutException(s);
    }

    private static boolean isAnswering(String host, int port) {
        try {
            Registry registry = LocateRegistry.getRegistry(host, port);
            if (registry == null) {
                String s = "Unable to locate RMI registry at " + host + ":" + port;
                throw new HydraRuntimeException(s);
            }
            registry.lookup("test");
            return true;
        }
        catch (NotBoundException e) {
            Log.getLogWriter().info("Connected to RMI registry " + host + ":" + port);
            return true;
        }
        catch (ConnectException e) {
            Log.getLogWriter().info("Waiting to connect to RMI registry " + host + ":" + port);
            return false;
        }
        catch (RemoteException e) {
            throw new HydraRuntimeException("Cannot connect to RMI registry " + host + ":" + port, e);
        }
    }

    public static void bind(Registry registry, String key, Remote val) {
        try {
            registry.bind(key, val);
        }
        catch (AlreadyBoundException e) {
            String s = key + " already bound in RMI registry: " + registry;
            throw new HydraRuntimeException(s, e);
        }
        catch (RemoteException e) {
            String s = "Could not bind " + key + " in RMI registry: " + registry;
            throw new HydraRuntimeException(s, e);
        }
    }

    /*
     * Loose catch block
     */
    public static Remote lookup(String url) {
        if (Log.getLogWriter().finerEnabled()) {
            Log.getLogWriter().finer("Looking up " + url);
        }
        int MAX_RETRY_MS = 20000;
        long retryStartTime = 0L;
        long attemptCount = 0L;
        while (true) {
            try {
                ++attemptCount;
                Remote obj = Naming.lookup(url);
                if (Log.getLogWriter().finerEnabled()) {
                    Log.getLogWriter().finer("Lookup succeeded, got " + obj);
                }
                return obj;
            }
            catch (NotBoundException e) {
                return null;
            }
            catch (UnmarshalException e) {
                String failMessage = RmiRegistryHelper.detectKnownRMIBugs(e);
                if (failMessage != null) {
                    Log.getLogWriter().info("Attempt to lookup " + url + " failed on attempt " + attemptCount + " with cause " + failMessage);
                    if (retryStartTime == 0L) {
                        retryStartTime = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - retryStartTime > 20000L) {
                        throw new HydraRuntimeException("Problem looking up " + url + " after " + attemptCount + " attempts", e);
                    }
                    MasterController.sleepForMs(100);
                    continue;
                }
                throw new HydraRuntimeException("Problem looking up " + url, e);
            }
            break;
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Problem looking up " + url, e);
        }
    }

    protected static String detectKnownRMIBugs(UnmarshalException unmarshalEx) {
        String failMessage = unmarshalEx.getMessage();
        if (failMessage != null && failMessage.contains("Transport return code invalid")) {
            return failMessage;
        }
        Throwable causedBy = unmarshalEx.getCause();
        if (causedBy instanceof InvalidClassException && (failMessage = causedBy.getMessage()) != null && failMessage.contains("Not a proxy")) {
            return failMessage;
        }
        return null;
    }

    private static Registry getMasterRegistry() {
        String host = System.getProperty("rmiHost");
        int port = Integer.getInteger("rmiPort");
        Registry registry = null;
        try {
            registry = LocateRegistry.getRegistry(host, port);
        }
        catch (RemoteException e) {
            String s = "Unable to locate master RMI registry at " + host + ":" + port;
            throw new HydraRuntimeException(s, e);
        }
        if (registry == null) {
            String s = "Unable to locate master RMI registry at " + host + ":" + port;
            throw new HydraRuntimeException(s);
        }
        Log.getLogWriter().info("Got master registry " + registry);
        return registry;
    }

    public static String getMasterRegistryURL() {
        String host = System.getProperty("rmiHost");
        int port = Integer.getInteger("rmiPort");
        return "rmi://" + host + ":" + port + "/";
    }

    public static MasterProxyIF lookupMaster() {
        String url = RmiRegistryHelper.getMasterRegistryURL() + "master";
        return (MasterProxyIF)RmiRegistryHelper.lookup(url);
    }

    public static void bindInMaster(String key, Remote val) {
        Registry registry = RmiRegistryHelper.getMasterRegistry();
        RmiRegistryHelper.bind(registry, key, val);
    }

    public static Remote lookupInMaster(String name) {
        String url = RmiRegistryHelper.getMasterRegistryURL() + name;
        return RmiRegistryHelper.lookup(url);
    }
}

