/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.control.ResourceManager;
import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.HydraVector;
import hydra.ResourceManagerPrms;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;

public class ResourceManagerDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private Float criticalHeapPercentage;
    private Float criticalOffHeapPercentage;
    private Float evictionHeapPercentage;
    private Float evictionOffHeapPercentage;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    private void setCriticalHeapPercentage(Float f) {
        this.criticalHeapPercentage = f;
    }

    private Float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    private void setCriticalOffHeapPercentage(Float f) {
        this.criticalOffHeapPercentage = f;
    }

    private Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    private void setEvictionHeapPercentage(Float f) {
        this.evictionHeapPercentage = f;
    }

    private Float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    private void setEvictionOffHeapPercentage(Float f) {
        this.evictionOffHeapPercentage = f;
    }

    public void configure(ResourceManager rm) {
        if (this.getCriticalHeapPercentage() != null) {
            rm.setCriticalHeapPercentage(this.getCriticalHeapPercentage().floatValue());
        }
        if (this.getCriticalOffHeapPercentage() != null) {
            rm.setCriticalOffHeapPercentage(this.getCriticalOffHeapPercentage().floatValue());
        }
        if (this.getEvictionHeapPercentage() != null) {
            rm.setEvictionHeapPercentage(this.getEvictionHeapPercentage().floatValue());
        }
        if (this.getEvictionOffHeapPercentage() != null) {
            rm.setEvictionOffHeapPercentage(this.getEvictionOffHeapPercentage().floatValue());
        }
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        if (this.criticalHeapPercentage == null) {
            map.put(header + "criticalHeapPercentage", "computed");
        } else {
            map.put(header + "criticalHeapPercentage", this.getCriticalHeapPercentage());
        }
        if (this.criticalOffHeapPercentage == null) {
            map.put(header + "criticalOffHeapPercentage", "computed");
        } else {
            map.put(header + "criticalOffHeapPercentage", this.getCriticalOffHeapPercentage());
        }
        if (this.evictionHeapPercentage == null) {
            map.put(header + "evictionHeapPercentage", "computed");
        } else {
            map.put(header + "evictionHeapPercentage", this.getEvictionHeapPercentage());
        }
        if (this.evictionOffHeapPercentage == null) {
            map.put(header + "evictionOffHeapPercentage", "computed");
        } else {
            map.put(header + "evictionOffHeapPercentage", this.getEvictionOffHeapPercentage());
        }
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(ResourceManagerPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            ResourceManagerDescription rmd = ResourceManagerDescription.createResourceManagerDescription(name, config, i);
            config.addResourceManagerDescription(rmd);
        }
    }

    private static ResourceManagerDescription createResourceManagerDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        ResourceManagerDescription rmd = new ResourceManagerDescription();
        rmd.setName(name);
        Long key = ResourceManagerPrms.criticalHeapPercentage;
        Double d = tab.getDouble(key, tab.getWild(key, index, null));
        if (d != null) {
            rmd.setCriticalHeapPercentage(Float.valueOf(d.floatValue()));
        }
        if ((d = tab.getDouble(key = ResourceManagerPrms.criticalOffHeapPercentage, tab.getWild(key, index, null))) != null) {
            rmd.setCriticalOffHeapPercentage(Float.valueOf(d.floatValue()));
        }
        if ((d = tab.getDouble(key = ResourceManagerPrms.evictionHeapPercentage, tab.getWild(key, index, null))) != null) {
            rmd.setEvictionHeapPercentage(Float.valueOf(d.floatValue()));
        }
        if ((d = tab.getDouble(key = ResourceManagerPrms.evictionOffHeapPercentage, tab.getWild(key, index, null))) != null) {
            rmd.setEvictionOffHeapPercentage(Float.valueOf(d.floatValue()));
        }
        return rmd;
    }
}

