/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DynamicActionUtil;
import hydra.GemFireDescription;
import hydra.HostHelper;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraThread;
import hydra.HydraThreadGroupInfo;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.MasterProxyIF;
import hydra.MethExecutor;
import hydra.MethExecutorResult;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.RMIHydraSocketFactory;
import hydra.RemoteTestModuleIF;
import hydra.ResultLogger;
import hydra.RmiRegistryHelper;
import hydra.TestConfig;
import hydra.TestTask;
import hydra.TestTaskResult;
import hydra.log.LogPrms;
import hydra.timeserver.TimeClient;
import hydra.timeserver.TimeServerPrms;
import java.io.IOException;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import util.TestHelper;

public class RemoteTestModule
extends UnicastRemoteObject
implements RemoteTestModuleIF,
Runnable {
    private static List<List<String>> ClientMapping = null;
    private static String MasterHost;
    private static Class c;
    private static int MasterPid;
    protected static String MyClientName;
    protected static String MyLogicalHost;
    public static String MyHost;
    protected static String MyCanonicalHost;
    protected static int MyVmid;
    public static int MyPid;
    protected static int MyNumThreads;
    public static int MyBaseThreadId;
    public static MasterProxyIF Master;
    protected static TimeClient MyTimeClient;
    protected static String MyLogFileName;
    protected static LogWriter log;
    protected Thread baseClientThread;
    protected boolean busy;
    protected TestTask currentTask;
    protected int myTid = -1;
    protected String myThreadGroupName = null;
    protected int myThreadGroupId = -1;
    protected String myThreadName;
    Map hydraThreadLocals;
    private static boolean waitFlag;
    protected static ThreadLocal rmiMod;

    public static void makeAndStartThreadClients() {
        if (MyNumThreads < 1) {
            return;
        }
        try {
            for (int i = 0; i < MyNumThreads; ++i) {
                int tid;
                RemoteTestModule mod = null;
                for (int retryCnt = 0; retryCnt < 20; ++retryCnt) {
                    try {
                        mod = new RemoteTestModule();
                        break;
                    }
                    catch (RemoteException re) {
                        MasterController.sleepForMs(500);
                        if (retryCnt != 19) continue;
                        throw re;
                    }
                }
                MasterController.sleepForMs(300);
                mod.myTid = tid = MyBaseThreadId + i;
                mod.myThreadName = MasterController.getNameFor(MyVmid, tid, MyClientName, MyHost, MyPid);
                HydraThread t = new HydraThread(mod, mod.myThreadName);
                mod.baseClientThread = t;
                mod.busy = false;
                t.start();
            }
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Unable to create and start client threads", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        HydraThreadGroupInfo info;
        block5: {
            info = null;
            try {
                MasterProxyIF masterProxyIF = Master;
                synchronized (masterProxyIF) {
                    info = Master.registerClient(MyVmid, this.myTid, this);
                }
            }
            catch (RemoteException e) {
                RemoteTestModule.handleRemoteException("Master.registerClient", e);
                if (info != null) break block5;
                String s = "Failed to register successully because the test has already been declared hung and the hydra master is gone.  A possible cause is a problem starting this JVM or it opening its bgexec or vm log file.  Note that the RemoteException logged previously is a symptom of the master being gone.";
                Log.getLogWriter().severe(s);
                System.exit(1);
            }
        }
        this.myThreadGroupName = info.getThreadGroupName();
        this.myThreadGroupId = info.getThreadGroupId();
        Log.getLogWriter().info("Alive and ready for work");
    }

    @Override
    public void executeTask(int tsid, int type, int index) throws RemoteException {
        rmiMod.set(this);
        if (this.busy) {
            throw new HydraInternalException("!!!! Already busy !!!!" + this.myTid);
        }
        this.busy = true;
        this.currentTask = TestConfig.getInstance().getTask(type, index);
        this.executeTask(tsid, this.currentTask);
    }

    protected synchronized void executeTask(final int tsid, final TestTask task) {
        HydraThread myThread = new HydraThread((Runnable)this, this.myThreadName){

            @Override
            public void run() {
                log.info("Received task: " + task.toShortString());
                while (RemoteTestModule.getWaitFlag()) {
                    MasterController.sleepForMs(200);
                }
                TestTaskResult result = task.execute();
                ResultLogger.logTaskResult(task, result);
                try {
                    RemoteTestModule.this.busy = false;
                    Master.reportResult(tsid, MyVmid, RemoteTestModule.this.myTid, result);
                }
                catch (RemoteException e) {
                    RemoteTestModule.handleRemoteException("Master.reportResult", e, false);
                }
                finally {
                    DistributedSystem.releaseThreadsSockets();
                }
            }
        };
        myThread.start();
    }

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName) {
        String name = obj.getClass().getName() + "." + methodName + " : " + obj;
        log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName);
        long delta = System.currentTimeMillis() - start;
        if (result.getResult() == null) {
            log.info("returning from " + name + " (took " + delta + " ms)");
        } else {
            log.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        }
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnObject(Object obj, String methodName, Object[] args) {
        String name = obj.getClass().getName() + "." + methodName + (args != null ? " with " + args.length + " args" : "") + " : " + obj;
        log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.executeObject(obj, methodName, args);
        long delta = System.currentTimeMillis() - start;
        if (result.getResult() == null) {
            log.info("returning from " + name + " (took " + delta + " ms)");
        } else {
            log.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        }
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnClass(String className, String methodName) {
        String name = className + "." + methodName;
        log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName);
        long delta = System.currentTimeMillis() - start;
        if (result.getResult() == null) {
            log.info("returning from " + name + " (took " + delta + " ms)");
        } else {
            log.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        }
        return result;
    }

    @Override
    public MethExecutorResult executeMethodOnClass(String className, String methodName, Object[] args) {
        String name = className + "." + methodName + (args != null ? " with " + args.length + " args" : "");
        log.info("Received method: " + name);
        long start = System.currentTimeMillis();
        MethExecutorResult result = MethExecutor.execute(className, methodName, args);
        long delta = System.currentTimeMillis() - start;
        if (result.getResult() == null) {
            log.info("returning from " + name + " (took " + delta + " ms)");
        } else {
            log.info("Got result: " + result.toString().trim() + " from " + name + " (took " + delta + " ms)");
        }
        return result;
    }

    public static RemoteTestModule getCurrentThread() {
        Thread currThread = Thread.currentThread();
        if (currThread instanceof HydraThread) {
            return ((HydraThread)currThread).getRemoteMod();
        }
        if (rmiMod.get() != null) {
            return (RemoteTestModule)rmiMod.get();
        }
        return null;
    }

    @Override
    public void notifyDynamicActionComplete(int actionId) {
        DynamicActionUtil.notifyDynamicActionComplete(actionId);
    }

    public static synchronized boolean getWaitFlag() {
        return waitFlag;
    }

    public static synchronized void setWaitFlag(boolean val) {
        waitFlag = val;
    }

    @Override
    public synchronized void disconnectVM() throws RemoteException {
        rmiMod.set(this);
        log.info(Thread.currentThread().getName() + " disconnecting vm_" + MyVmid + " at master's request.");
        HydraThread myThread = new HydraThread((Runnable)this, this.myThreadName){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                if (ds != null) {
                    log.info("Disconnecting from the distributed system: " + ds);
                    ds.disconnect();
                }
                try {
                    MasterProxyIF masterProxyIF = Master;
                    synchronized (masterProxyIF) {
                        Master.registerClientDisconnect(MyVmid);
                    }
                }
                catch (RemoteException e) {
                    RemoteTestModule.handleRemoteException("Master.registerClientDisconnect", e);
                }
            }
        };
        myThread.start();
    }

    @Override
    public synchronized void shutDownVM(final boolean disconnect, final boolean runShutdownHook) throws RemoteException {
        rmiMod.set(this);
        if (disconnect) {
            log.info(Thread.currentThread().getName() + " disconnecting and shutting down vm_" + MyVmid + " at master's request.");
        } else {
            log.info(Thread.currentThread().getName() + " shutting down vm_" + MyVmid + " at master's request.");
        }
        HydraThread myThread = new HydraThread((Runnable)this, this.myThreadName){

            @Override
            public void run() {
                log.info("Now terminating process.");
                if (runShutdownHook) {
                    RemoteTestModule.this.runShutdownHook();
                }
                if (disconnect) {
                    log.info("Disconnecting from the distributed system, if connected");
                    InternalDistributedSystem ds = InternalDistributedSystem.getAnyInstance();
                    if (ds != null) {
                        ds.disconnect();
                    }
                }
                RemoteTestModule.this.shutdown();
            }
        };
        myThread.start();
    }

    protected void invokeShutdownHook(Long key, Vector shutdownHook) {
        if (shutdownHook.size() % 2 != 0) {
            String s = BasePrms.nameForKey(key) + " must be a list of class/method pairs";
            throw new HydraConfigException(s);
        }
        for (int i = 0; i < shutdownHook.size(); i += 2) {
            String cls = (String)shutdownHook.get(i);
            String mth = (String)shutdownHook.get(i + 1);
            String hook = cls + "." + mth;
            log.info("Invoking client shutdown hook: " + hook);
            MethExecutorResult result = MethExecutor.execute(cls, mth);
            Throwable t = result.getException();
            if (t != null) {
                String s = "Error invoking " + BasePrms.nameForKey(key) + "=" + hook;
                ResultLogger.reportErr(s, t);
            }
            log.info("Invoked client shutdown hook: " + hook);
        }
    }

    @Override
    public void runShutdownHook() {
        Long shutdownHookKey = Prms.clientShutdownHook;
        HydraVector shutdownHook = RemoteTestModule.tab().vecAt(shutdownHookKey, null);
        if (shutdownHook != null) {
            log.info("Invoking client shutdown hooks: " + shutdownHook);
            this.invokeShutdownHook(shutdownHookKey, shutdownHook);
            log.info("Invoked client shutdown hooks: " + shutdownHook);
        }
    }

    protected void shutdown() {
        log.info("Shutting down from RemoteTestModule");
        int sleepTime = RemoteTestModule.tab().intAt(Prms.finalClientSleepSec);
        if (sleepTime > 0) {
            log.info("Sleeping for " + sleepTime + " seconds.");
            MasterController.sleepForMs(sleepTime * 1000);
        }
        System.exit(0);
    }

    public static List<List<String>> getClientMapping() {
        return ClientMapping;
    }

    public static String getMyHost() {
        return MyHost;
    }

    public static String getMyLogicalHost() {
        return MyLogicalHost;
    }

    public static int getMyPid() {
        return MyPid;
    }

    public static String getMyClientName() {
        return MyClientName;
    }

    public static int getMyVmid() {
        return MyVmid;
    }

    public int getThreadId() {
        return this.myTid;
    }

    public static int getMyBaseThreadId() {
        return MyBaseThreadId;
    }

    public static int getMyNumThreads() {
        return MyNumThreads;
    }

    public int getThreadGroupId() {
        return this.myThreadGroupId;
    }

    public String getThreadGroupName() {
        return this.myThreadGroupName;
    }

    public TestTask getCurrentTask() {
        return this.currentTask;
    }

    protected static ConfigHashtable tab() {
        return TestConfig.getInstance().getParameters();
    }

    public static long getClockSkew() {
        if (MyTimeClient != null) {
            return MyTimeClient.getClockSkew();
        }
        return 0L;
    }

    public static void openClockSkewStatistics() {
        if (MyTimeClient != null) {
            MyTimeClient.openStatistics();
        }
    }

    public static void closeClockSkewStatistics() {
        if (MyTimeClient != null) {
            MyTimeClient.closeStatistics();
        }
    }

    protected static void handleRemoteException(String msg, RemoteException e) {
        RemoteTestModule.handleRemoteException(msg, e, true);
    }

    protected static void handleRemoteException(String msg, RemoteException e, boolean rethrow) {
        String s = Thread.currentThread().getName() + " failed to connect at " + msg;
        try {
            if (ProcessMgr.processExists(MasterHost, MasterPid) || !ResultLogger.hasHangFile()) {
                ResultLogger.reportAsErr(s, e);
                if (rethrow) {
                    throw new HydraRuntimeException(s, e);
                }
            } else {
                Log.getLogWriter().info("safely ignoring " + e + "\n" + TestHelper.getStackTrace(e));
            }
        }
        catch (VirtualMachineError e2) {
            SystemFailure.initiateFailure((Error)e2);
            throw e2;
        }
        catch (Throwable t) {
            s = s + " (attempt to handle encountered " + t + ")";
            ResultLogger.reportAsErr(s, e);
            throw new HydraRuntimeException(s, e);
        }
    }

    private static void setClientMapping() {
        try {
            ClientMapping = Master.getClientMapping();
        }
        catch (RemoteException e) {
            RemoteTestModule.handleRemoteException("Master.setClientMapping", e);
        }
    }

    protected static void initialize() {
        MyHost = HostHelper.getLocalHost();
        MyCanonicalHost = HostHelper.getCanonicalHostName();
        MyPid = ProcessMgr.getProcessId();
        MasterHost = System.getProperty("masterHost");
        MasterPid = Integer.getInteger("masterPid");
        MyClientName = System.getProperty("clientName");
        MyLogicalHost = System.getProperty("hostName");
        MyVmid = Integer.getInteger("vmid");
        Thread.currentThread().setName(MasterController.getNameFor(MyVmid, -1, MyClientName, MyHost, MyPid));
        log = Log.createLogWriter("client", "all");
        log.info(ProcessMgr.processAndBuildInfoString());
        if (Master == null) {
            Master = RmiRegistryHelper.lookupMaster();
        }
        TestConfig tc = TestConfig.getInstance();
        log.info("Random seed = " + tc.getRandomSeed());
        RemoteTestModule.setClientMapping();
        GemFireDescription gfd = tc.getClientDescription(MyClientName).getGemFireDescription();
        if (gfd != null) {
            System.setProperty("gemfireName", gfd.getName());
        }
        log.info("Loading test parameter classes...");
        List<String> classnames = tc.getClassNames();
        String classpath = System.getProperty("java.class.path");
        boolean gemfirexdTest = false;
        try {
            Class<?> c = Class.forName("com.pivotal.gemfirexd.internal.iapi.services.info.ProductVersionHolder");
            gemfirexdTest = true;
        }
        catch (ClassNotFoundException c) {
            // empty catch block
        }
        for (String classname : classnames) {
            if (classname.startsWith("hydra.gemfirexd.") && !gemfirexdTest) continue;
            try {
                Class<?> clazz = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                String s = "Parameter class " + classname + " not found";
                throw new HydraConfigException(s, e);
            }
        }
        int sleepTime = RemoteTestModule.tab().intAt(Prms.initialClientSleepSec);
        if (sleepTime > 0) {
            log.info("Sleeping for " + sleepTime + " seconds.");
            MasterController.sleepForMs(sleepTime * 1000);
        }
        MyBaseThreadId = Integer.getInteger("baseThreadId");
        MyNumThreads = Integer.getInteger("numThreads");
        String purpose = System.getProperty("purpose", "");
        if (!purpose.equals("")) {
            purpose = "_" + purpose;
        }
        MyLogFileName = Thread.currentThread().getName() + purpose;
        log.info("Switching to task log for the remainder of the run: " + MyLogFileName);
        Log.closeLogWriter();
        log = Log.createLogWriter("clienttaskloop", MyLogFileName, RemoteTestModule.tab().booleanAt(LogPrms.file_logging), RemoteTestModule.tab().stringAt(LogPrms.file_logLevel), RemoteTestModule.tab().intAt(LogPrms.file_maxKBPerVM));
        log.info(ProcessMgr.processAndBuildInfoString());
        if (TimeServerPrms.clockSkewUpdateFrequencyMs() > 0) {
            int clockSkewUpdateFrequencyMs = TimeServerPrms.clockSkewUpdateFrequencyMs();
            int clockSkewMaxLatencyMs = TimeServerPrms.clockSkewMaxLatencyMs();
            int clockSkewSamplesToAverage = TimeServerPrms.clockSkewSamplesToAverage();
            try {
                MyTimeClient = new TimeClient(tc.getMasterDescription().getTimeServerHost(), tc.getMasterDescription().getTimeServerPort(), clockSkewUpdateFrequencyMs, clockSkewMaxLatencyMs, clockSkewSamplesToAverage);
                log.info("Starting the time client: " + MyTimeClient);
            }
            catch (IOException e) {
                throw new HydraRuntimeException("Unable to start the time client", e);
            }
            MyTimeClient.start();
            try {
                MyTimeClient.waitForInitialization();
            }
            catch (InterruptedException e) {
                log.error("Interrupted initializing time client");
            }
            log.info("Started time client: " + MyTimeClient + ". Initial clock skew " + MyTimeClient.getClockSkew());
        }
    }

    public static void main(String[] args) {
        RemoteTestModule.initialize();
        RemoteTestModule.makeAndStartThreadClients();
    }

    static {
        c = RMIHydraSocketFactory.class;
        MasterPid = -1;
        MyClientName = null;
        MyLogicalHost = null;
        MyVmid = -1;
        MyPid = -1;
        MyNumThreads = -1;
        MyBaseThreadId = -1;
        Master = null;
        MyTimeClient = null;
        waitFlag = false;
        rmiMod = new ThreadLocal();
    }
}

