/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.internal.NanoTimer;
import hydra.BasePrms;
import hydra.Contact;
import hydra.DistributedSystemHelper;
import hydra.EdgeBlackboard;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolPrms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import hydra.blackboard.SharedLock;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class PoolHelper {
    private static LogWriter log;

    public static synchronized Pool createPool(String poolConfig) {
        PoolFactory factory = PoolHelper.getPoolFactory(poolConfig);
        return PoolHelper.createPool(poolConfig, factory);
    }

    public static synchronized Pool createPool(String poolName, PoolFactory factory) {
        if (poolName == null) {
            throw new IllegalArgumentException("poolName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        Pool pool = PoolManager.find((String)poolName);
        if (pool == null) {
            PoolHelper.log("Creating pool named: " + poolName + " with attributes " + PoolHelper.poolFactoryToString(poolName, factory));
            try {
                pool = factory.create(poolName);
            }
            catch (IllegalStateException e) {
                throw new HydraInternalException("Should not happen", e);
            }
            PoolHelper.log("Created pool named: " + poolName);
        } else if (!PoolDescription.equals(factory, pool)) {
            String desired = PoolHelper.poolFactoryToString(poolName, factory);
            String existing = PoolHelper.poolToString(pool);
            String s = "Pool " + poolName + " already exists with different attributes\n  DESIRED = " + desired + "\n  EXISTING = " + existing;
            throw new HydraRuntimeException(s);
        }
        return pool;
    }

    public static synchronized Pool getPool(String poolName) {
        if (poolName == null) {
            throw new IllegalArgumentException("poolName cannot be null");
        }
        return PoolManager.find((String)poolName);
    }

    public static String poolToString(Pool pool) {
        if (pool == null) {
            throw new IllegalArgumentException("pool cannot be null");
        }
        return PoolDescription.poolToString(pool);
    }

    public static PoolFactory getPoolFactory(String poolConfig) {
        PoolDescription pd = PoolHelper.getPoolDescription(poolConfig);
        PoolFactory factory = PoolManager.createFactory();
        PoolHelper.log("Configuring pool factory for config: " + poolConfig);
        pd.configure(factory);
        PoolHelper.log("Configured pool factory: " + factory);
        return factory;
    }

    private static String poolFactoryToString(String poolName, PoolFactory factory) {
        if (poolName == null) {
            throw new IllegalArgumentException("poolName cannot be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory cannot be null");
        }
        return PoolDescription.poolFactoryToString(poolName, factory);
    }

    public static PoolDescription getPoolDescription(String poolConfig) {
        if (poolConfig == null) {
            throw new IllegalArgumentException("poolConfig cannot be null");
        }
        PoolHelper.log("Looking up pool config: " + poolConfig);
        PoolDescription pd = TestConfig.getInstance().getPoolDescription(poolConfig);
        if (pd == null) {
            String s = poolConfig + " not found in " + BasePrms.nameForKey(PoolPrms.names);
            throw new HydraRuntimeException(s);
        }
        PoolHelper.log("Looked up pool config:\n" + pd);
        return pd;
    }

    public static List getSameContacts(int numContacts, String distributedSystemName) {
        List allContacts = PoolHelper.getAllContacts(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available contacts: " + allContacts);
        }
        if (numContacts > allContacts.size()) {
            PoolHelper.error(numContacts, allContacts, distributedSystemName);
        }
        List sameContacts = numContacts == -1 ? allContacts : allContacts.subList(0, numContacts);
        return new ArrayList(sameContacts);
    }

    public static List getRoundRobinContacts(int numContacts, String distributedSystemName) {
        List allContacts = PoolHelper.getAllContacts(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available contacts: " + allContacts);
        }
        return PoolHelper.getRoundRobinContacts(numContacts, allContacts, distributedSystemName);
    }

    public static List getRoundRobinRemoteHostContacts(int numContacts, String distributedSystemName) {
        List remoteContacts = PoolHelper.getAllContacts(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available contacts: " + remoteContacts);
        }
        String localhost = HostHelper.getLocalHost();
        Iterator i = remoteContacts.iterator();
        while (i.hasNext()) {
            Contact contact = (Contact)i.next();
            if (!contact.getHost().equals(localhost)) continue;
            i.remove();
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Remote host contacts: " + remoteContacts);
        }
        return PoolHelper.getRoundRobinContacts(numContacts, remoteContacts, distributedSystemName);
    }

    public static List getRoundRobinLocalHostContacts(int numContacts, String distributedSystemName) {
        List localContacts = PoolHelper.getAllContacts(distributedSystemName);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("All available contacts: " + localContacts);
        }
        String localhost = HostHelper.getLocalHost();
        Iterator i = localContacts.iterator();
        while (i.hasNext()) {
            Contact contact = (Contact)i.next();
            if (contact.getHost().equals(localhost)) continue;
            i.remove();
        }
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Local host contacts: " + localContacts);
        }
        return PoolHelper.getRoundRobinContacts(numContacts, localContacts, distributedSystemName);
    }

    private static List getRoundRobinContacts(int numContacts, List contacts, String distributedSystemName) {
        if (numContacts == -1 && contacts.size() == 0) {
            return new ArrayList();
        }
        if (numContacts > contacts.size()) {
            PoolHelper.error(numContacts, contacts, distributedSystemName);
        }
        int startIndex = PoolHelper.getRoundRobinStartIndex(contacts.size(), distributedSystemName);
        Collections.rotate(contacts, startIndex);
        if (Log.getLogWriter().fineEnabled()) {
            Log.getLogWriter().fine("Round robin contacts: " + contacts);
        }
        List roundRobinContacts = numContacts == -1 ? contacts : contacts.subList(0, numContacts);
        return new ArrayList(roundRobinContacts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getRoundRobinStartIndex(int numContacts, String distributedSystemName) {
        int startIndex = -1;
        if (distributedSystemName == null) {
            startIndex = (int)EdgeBlackboard.getInstance().getSharedCounters().incrementAndRead(EdgeBlackboard.startIndex);
        } else {
            SharedMap map = EdgeBlackboard.getInstance().getSharedMap();
            String key = "StartIndex_" + distributedSystemName;
            SharedLock lock = EdgeBlackboard.getInstance().getSharedLock();
            try {
                lock.lock();
                Integer index = (Integer)map.get(key);
                startIndex = index == null ? 1 : index + 1;
                map.put(key, startIndex);
            }
            finally {
                lock.unlock();
            }
        }
        return startIndex % numContacts;
    }

    public static List getRandomContacts(int numContacts, String distributedSystemName) {
        List allContacts = PoolHelper.getAllContacts(distributedSystemName);
        if (numContacts > allContacts.size()) {
            PoolHelper.error(numContacts, allContacts, distributedSystemName);
        }
        int n = numContacts == -1 ? allContacts.size() : numContacts;
        Random rng = new Random(NanoTimer.getTime());
        ArrayList randomContacts = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int index = rng.nextInt(allContacts.size());
            randomContacts.add(allContacts.remove(index));
        }
        return randomContacts;
    }

    public static List getRandomContactsInWanHctSite(int numContacts, String distributedSystemName) {
        List allContacts = PoolHelper.getAllContacts(distributedSystemName);
        int myWanSite = PoolHelper.toWanSite(RemoteTestModule.getMyClientName());
        ArrayList<Contact> matchingContacts = new ArrayList<Contact>();
        for (Contact contact : allContacts) {
            if (PoolHelper.toWanSite(contact.getName()) != myWanSite) continue;
            matchingContacts.add(contact);
        }
        if (numContacts > matchingContacts.size()) {
            PoolHelper.error(numContacts, matchingContacts, distributedSystemName);
        }
        int n = numContacts == -1 ? matchingContacts.size() : numContacts;
        Random rng = new Random(NanoTimer.getTime());
        ArrayList randomContacts = new ArrayList();
        for (int i = 0; i < n; ++i) {
            int index = rng.nextInt(matchingContacts.size());
            randomContacts.add(matchingContacts.remove(index));
        }
        return randomContacts;
    }

    private static List getAllContacts(String distributedSystemName) {
        return distributedSystemName == null ? DistributedSystemHelper.getContacts() : DistributedSystemHelper.getContacts(distributedSystemName);
    }

    public static int toWanSite(String clientName) {
        String site = clientName.substring(clientName.indexOf("_") + 1, clientName.lastIndexOf("_"));
        try {
            return Integer.parseInt(site);
        }
        catch (NumberFormatException e) {
            String s = clientName + " is not in the form <name>_<wanSiteNumber>_<itemNumber>";
            throw new HydraRuntimeException(s, e);
        }
    }

    private static void error(int numContacts, List contacts, String distributedSystemName) {
        String s = null;
        s = distributedSystemName == null ? "Cannot find " + numContacts + " contacts, there are only " + contacts.size() + ": " + contacts : "Cannot find " + numContacts + " contacts in " + distributedSystemName + ", there are only " + contacts.size() + ": " + contacts;
        throw new HydraRuntimeException(s);
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }
}

