/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import java.io.Serializable;
import java.util.Collection;
import java.util.Vector;

public class NumVector
extends Vector
implements Serializable {
    public NumVector() {
    }

    public NumVector(Collection c) {
        super(c);
    }

    public NumVector(int initialCapacity) {
        super(initialCapacity);
    }

    public NumVector(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public void addAll(Vector aVector) {
        for (int i = 0; i < aVector.size(); ++i) {
            this.add(aVector.elementAt(i));
        }
    }

    public void add(double arg) {
        super.add(new Double(arg));
    }

    public void add(int arg) {
        super.add(new Integer(arg));
    }

    public void add(long arg) {
        super.add(new Long(arg));
    }

    public double doubleAt(int pos) {
        Object element = super.elementAt(pos);
        if (element instanceof Integer) {
            Integer iElement = (Integer)element;
            return iElement.doubleValue();
        }
        if (element instanceof Double) {
            Double dElement = (Double)element;
            return dElement;
        }
        Long lElement = (Long)element;
        return lElement.doubleValue();
    }

    public long intAt(int pos) {
        Object element = super.elementAt(pos);
        if (element instanceof Integer) {
            Integer iElement = (Integer)element;
            return iElement.intValue();
        }
        if (element instanceof Double) {
            Double dElement = (Double)element;
            return dElement.intValue();
        }
        Long lElement = (Long)element;
        return lElement.intValue();
    }

    public long longAt(int pos) {
        Object element = super.elementAt(pos);
        if (element instanceof Integer) {
            Integer iElement = (Integer)element;
            return iElement.longValue();
        }
        if (element instanceof Double) {
            Double dElement = (Double)element;
            return dElement.longValue();
        }
        Long lElement = (Long)element;
        return lElement;
    }

    public double mean() {
        int num = this.size();
        double sum = this.sum();
        return sum / (double)num;
    }

    public double stddev() {
        double[] statRay = this.stats();
        return statRay[2];
    }

    public String printStats() {
        if (this.size() == 0) {
            return null;
        }
        double[] statRay = this.stats();
        return "Number of task times: " + (int)statRay[0] + "\nMean: " + (float)statRay[1] + " ms\nStandard deviation: " + (float)statRay[2] + " ms\nSum: " + (float)statRay[3] + " ms\nMax Value: " + (float)statRay[4] + " ms\nMin Value: " + (float)statRay[5] + " ms";
    }

    public String printStatsAsTableRow() {
        if (this.size() == 0) {
            return "No data present.";
        }
        double[] statRay = this.stats();
        return "   " + (int)statRay[0] + "    " + (float)statRay[1] + "    " + (float)statRay[2] + "    " + (float)statRay[3] + "    " + (float)statRay[4] + "    " + (float)statRay[5];
    }

    public String printStatsTableHeader() {
        if (this.size() == 0) {
            return "No data present.";
        }
        double[] statRay = this.stats();
        return "Set sz Mean    Std dev    Sum    Max    Min    ";
    }

    public double[] stats() {
        double dev;
        double curr;
        int i;
        double hi;
        double sum = 0.0;
        double[] statRay = new double[6];
        NumVector squares = new NumVector();
        int num = this.size();
        double lo = hi = this.doubleAt(0);
        for (i = 0; i < num; ++i) {
            curr = this.doubleAt(i);
            sum += curr;
            if (curr < lo) {
                lo = curr;
            }
            if (!(curr > hi)) continue;
            hi = curr;
        }
        double mean = sum / (double)num;
        for (i = 0; i < this.size(); ++i) {
            curr = this.doubleAt(i);
            dev = Math.abs(curr - mean);
            double square = dev * dev;
            squares.add(square);
        }
        mean = sum / (double)num;
        double squareMean = squares.mean();
        dev = Math.sqrt(squareMean);
        statRay[0] = this.size();
        statRay[1] = mean;
        statRay[2] = dev;
        statRay[3] = sum;
        statRay[4] = hi;
        statRay[5] = lo;
        return statRay;
    }

    public double sum() {
        double sum = 0.0;
        for (int i = 0; i < this.size(); ++i) {
            double curr = this.doubleAt(i);
            sum += curr;
        }
        return sum;
    }

    public static void main(String[] args) {
        int i;
        NumVector v = new NumVector();
        long l1 = 34L;
        int i1 = 45;
        double d1 = 34.93;
        v.add(l1);
        v.add(i1);
        v.add(d1);
        System.out.println(v.intAt(0));
        System.out.println(v.longAt(0));
        System.out.println(v.elementAt(0));
        System.out.println(v.longAt(1));
        System.out.println(v.doubleAt(2));
        System.out.println(v.doubleAt(1));
        long begin = 0L;
        long end = 0L;
        for (i = 0; i < 100; ++i) {
            v.add(i);
        }
        begin = System.currentTimeMillis();
        for (i = 0; i < v.size(); ++i) {
            v.intAt(i);
        }
        end = System.currentTimeMillis();
        System.out.println("Access time for " + v.size() + " elements " + (end - begin));
        begin = System.currentTimeMillis();
        System.out.println("Mean of values: " + v.mean());
        end = System.currentTimeMillis();
        System.out.println("Time to compute mean for " + v.size() + " elements " + (end - begin));
        begin = System.currentTimeMillis();
        System.out.println(v.printStats());
        end = System.currentTimeMillis();
        System.out.println("Time to compute all stats for " + v.size() + " elements " + (end - begin));
        NumVector newVec = new NumVector();
        newVec.addAll(v);
        System.out.println("After addAll, size is: " + newVec.size());
        System.out.println(newVec.printStatsTableHeader() + "\n");
        System.out.println(newVec.printStatsAsTableRow() + "\n");
    }
}

