/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.FileUtil;
import hydra.HadoopPrms;
import hydra.HostAgentMgr;
import hydra.HostDescription;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.Platform;
import hydra.Prms;
import hydra.TestConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Nuker {
    private static Nuker nuker;
    protected static final String UNIX_SYSDIRS = "unix_sysdirs.txt";
    protected static final String WINDOWS_SYSDIRS = "windows_sysdirs.txt";
    protected static final String HDFS_DIRS = "hdfs_dirs.txt";
    private Platform platform;
    private HostDescription mhd;
    private String commentPrefix;
    private String userDir;
    private String mfn;
    private String nfn;
    private String hmfn;
    private String hnfn;
    private String dfn;
    private String hfn;
    private Set directories = new HashSet();
    private Set hdfs_directories = new HashSet();

    protected static void initialize(HostDescription hd) {
        nuker = new Nuker(hd);
    }

    public static Nuker getInstance() {
        if (nuker == null) {
            String s = "Reserved for the hydra master controller.  Use methods in MasterProxyIF instead";
            throw new UnsupportedOperationException(s);
        }
        return nuker;
    }

    private Nuker(HostDescription hd) {
        this.platform = Platform.getInstance();
        this.mhd = hd;
        this.userDir = this.mhd.getUserDir() + this.mhd.getFileSep();
        String fileExtension = this.platform.getFileExtension();
        this.mfn = this.userDir + "movedirs" + fileExtension;
        this.nfn = this.userDir + "nukerun" + fileExtension;
        this.hmfn = this.userDir + "movehadoop" + fileExtension;
        this.hnfn = this.userDir + "nukehadoop" + fileExtension;
        this.dfn = this.userDir + "dumprun" + fileExtension;
        this.hfn = this.userDir + "heapdumprun" + fileExtension;
        String scriptHeader = this.platform.getScriptHeader();
        this.commentPrefix = this.platform.getCommentPrefix();
        FileUtil.appendToFile(this.mfn, scriptHeader + this.commentPrefix + " execute this script to move all remote directories in this test\n\n");
        FileUtil.appendToFile(this.nfn, scriptHeader + this.commentPrefix + " execute this script to kill with malice all processes in this test\n\n");
        FileUtil.appendToFile(this.hmfn, scriptHeader + this.commentPrefix + " execute this script to clean all Hadoop directories in this test\n\n");
        FileUtil.appendToFile(this.hnfn, scriptHeader + this.commentPrefix + " execute this script to kill with malice all Hadoop processes in this test\n\n");
        FileUtil.appendToFile(this.dfn, scriptHeader + this.commentPrefix + " execute this script to do thread dumps on all processes in this test\n\n");
        FileUtil.appendToFile(this.hfn, scriptHeader + this.commentPrefix + " execute this script to do heap dumps on all processes in this test\n\n");
        this.platform.setExecutePermission(this.mfn);
        this.platform.setExecutePermission(this.nfn);
        this.platform.setExecutePermission(this.hmfn);
        this.platform.setExecutePermission(this.hnfn);
        this.platform.setExecutePermission(this.dfn);
        this.platform.setExecutePermission(this.hfn);
    }

    protected Set getDirectories() {
        return this.directories;
    }

    public synchronized void recordRootCommand(HostDescription hd, String cmd, String dir) {
        int i;
        List<String> lines;
        String wrappedCmd = this.wrapRootCommand(cmd, hd);
        boolean added = false;
        try {
            lines = FileUtil.getTextAsList(this.hmfn);
        }
        catch (IOException e) {
            String s = "Unable to access file: " + this.hmfn;
            throw new HydraInternalException(s);
        }
        for (i = 0; i < lines.size(); ++i) {
            if (!lines.get(i).contains(dir)) continue;
            lines.add(i, wrappedCmd);
            added = true;
            break;
        }
        if (added) {
            for (i = 0; i < lines.size(); ++i) {
                if (i == 0) {
                    FileUtil.writeToFile(this.hmfn, lines.get(i) + "\n");
                    continue;
                }
                FileUtil.appendToFile(this.hmfn, lines.get(i) + "\n");
            }
        } else {
            FileUtil.appendToFile(this.hmfn, wrappedCmd + "\n");
        }
    }

    protected String wrapRootCommand(String cmd, HostDescription hd) {
        if (HostHelper.isLocalHost(hd.getHostName())) {
            return cmd;
        }
        if (this.canUseSSH(hd)) {
            return "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + " " + cmd;
        }
        String s = "Unable to record root command without ssh: " + cmd;
        throw new HydraRuntimeException(s);
    }

    public synchronized void recordHDFSDir(String hadoopDist, String url, boolean moveAfterTest) {
        String src = url + "/user/" + System.getProperty("user.name");
        if (moveAfterTest) {
            String dst = this.userDir + "movedHadoopData";
            String mkdircmd = "/bin/bash mkdir -p " + dst + "\n";
            FileUtil.appendToFile(this.hmfn, mkdircmd);
            String mvcmd = "/bin/bash " + hadoopDist + "/bin/hadoop fs -copyToLocal " + src + " " + dst + "\n";
            FileUtil.appendToFile(this.hmfn, mvcmd);
        }
        String rmcmd = "/bin/bash " + hadoopDist + "/bin/hadoop fs -rm -r -f " + src + "\n";
        FileUtil.appendToFile(this.hmfn, rmcmd);
    }

    protected synchronized void recordHDFSDir(HostDescription hd, HadoopPrms.NodeType nodeType, String dir, boolean moveAfterTest) {
        if (!this.hdfs_directories.contains(dir)) {
            String dirname = this.getDirName(hd, dir);
            String dirpath = this.getDirPath(hd, dir);
            this.recordHDFSDir(hd, nodeType, dir, dirname);
            if (moveAfterTest) {
                this.recordMoveDirCommands(this.hmfn, hd, dir, dirpath, dirname);
            } else {
                this.recordRemoveDirCommands(this.hmfn, hd, dir, dirpath, dirname);
            }
        }
    }

    private void recordHDFSDir(HostDescription hd, HadoopPrms.NodeType nodeType, String dir, String dirname) {
        this.hdfs_directories.add(dir);
        FileUtil.appendToFile(HDFS_DIRS, (Object)((Object)nodeType) + " " + dir + "\n");
    }

    protected synchronized void recordDir(HostDescription hd, String name, String dir) {
        if (!this.directories.contains(dir)) {
            String dirname = this.getDirName(hd, dir);
            String dirpath = this.getDirPath(hd, dir);
            this.recordDir(hd, name, dir, dirname);
            this.recordMoveDirCommands(this.mfn, hd, dir, dirpath, dirname);
        }
    }

    private void recordDir(HostDescription hd, String name, String dir, String dirname) {
        this.directories.add(dir);
        block0 : switch (hd.getOSType()) {
            case unix: {
                FileUtil.appendToFile(UNIX_SYSDIRS, name + " " + dir + "\n");
                switch (this.mhd.getOSType()) {
                    case unix: {
                        break block0;
                    }
                    case windows: {
                        FileUtil.appendToFile(WINDOWS_SYSDIRS, name + " " + this.userDir + dirname + "\n");
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            case windows: {
                FileUtil.appendToFile(WINDOWS_SYSDIRS, name + " " + dir + "\n");
                switch (this.mhd.getOSType()) {
                    case unix: {
                        FileUtil.appendToFile(UNIX_SYSDIRS, name + " " + this.userDir + dirname + "\n");
                        break block0;
                    }
                    case windows: {
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
    }

    private String getDirPath(HostDescription hd, String dir) {
        return dir.substring(0, dir.lastIndexOf(hd.getFileSep()));
    }

    private String getDirName(HostDescription hd, String dir) {
        return dir.substring(dir.lastIndexOf(hd.getFileSep()) + 1, dir.length());
    }

    private void recordMoveDirCommands(String fn, HostDescription hd, String dir, String dirpath, String dirname) {
        String target = this.userDir + dirname;
        if (FileUtil.exists(target)) {
            if (Log.getLogWriter().fineEnabled()) {
                Log.getLogWriter().fine("Already in master user directory: " + dirname);
            }
            return;
        }
        String cmd = null;
        String rmdir = null;
        block0 : switch (hd.getOSType()) {
            case unix: {
                switch (this.mhd.getOSType()) {
                    case unix: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            rmdir = "/bin/rmdir " + dirpath;
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = "/bin/mv " + dir + " " + this.userDir + "\n" + rmdir;
                            break block0;
                        }
                        rmdir = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + " /bin/rm -rf " + dirpath;
                        this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                        cmd = "scp -r " + System.getProperty("user.name") + "@" + hd.getHostName() + ":" + dir + " " + this.userDir + "\n" + rmdir;
                        break block0;
                    }
                    case windows: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            cmd = "@rem please manually move " + dir + " to " + this.userDir;
                            break block0;
                        }
                        cmd = "@rem please manually move " + dirpath + " to " + this.userDir;
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            case windows: {
                switch (this.mhd.getOSType()) {
                    case unix: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            rmdir = this.wrapCommand("cmd.exe /c rmdir /S /Q " + dirpath, hd);
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = this.wrapCommand("cmd.exe /c robocopy " + dir + " " + hd.getUserDir() + "\\" + dirname + " /move", hd) + "\n" + rmdir;
                            break block0;
                        }
                        cmd = "# please manually move " + dirpath + " to " + this.userDir;
                        break block0;
                    }
                    case windows: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            rmdir = "cmd.exe /c rmdir /S /Q " + dirpath;
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = "cmd.exe /c robocopy " + dir + " " + this.userDir + " /move\n" + rmdir;
                            break block0;
                        }
                        cmd = "@rem please manually move " + dirpath + " to " + this.userDir;
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        if (cmd != null) {
            FileUtil.appendToFile(fn, cmd + "\n");
        }
    }

    private void recordRemoveDirCommands(String fn, HostDescription hd, String dir, String dirpath, String dirname) {
        String target = this.userDir + dirname;
        boolean isUserDir = FileUtil.exists(target);
        String cmd = null;
        String rmdir = null;
        block0 : switch (hd.getOSType()) {
            case unix: {
                switch (this.mhd.getOSType()) {
                    case unix: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            if (isUserDir) {
                                cmd = "/bin/rm -rf " + dir;
                                break block0;
                            }
                            rmdir = "/bin/rmdir " + dirpath;
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = "/bin/rm -rf " + dir + "\n" + rmdir;
                            break block0;
                        }
                        if (isUserDir) {
                            cmd = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + "/bin/rm -rf " + dir;
                            break block0;
                        }
                        rmdir = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + " /bin/rm -rf " + dirpath;
                        this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                        cmd = "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + "/bin/rm -rf " + dir + "\n" + rmdir;
                        break block0;
                    }
                    case windows: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            cmd = "@rem please manually remove " + dir;
                            break block0;
                        }
                        cmd = "@rem please manually remove " + dir;
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            case windows: {
                switch (this.mhd.getOSType()) {
                    case unix: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            if (isUserDir) {
                                cmd = this.wrapCommand("cmd.exe /c rmdir /S /Q " + dir + "\\" + dirname, hd);
                                break block0;
                            }
                            rmdir = this.wrapCommand("cmd.exe /c rmdir /S /Q " + dirpath, hd);
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = this.wrapCommand("cmd.exe /c rmdir /S /Q " + dir + "\\" + dirname, hd) + "\n" + rmdir;
                            break block0;
                        }
                        cmd = "# please manually remove " + dir;
                        break block0;
                    }
                    case windows: {
                        if (TestConfig.tab().booleanAt(Prms.useNFS, true)) {
                            if (isUserDir) {
                                cmd = "cmd.exe /c rmdir /S /Q " + dir;
                                break block0;
                            }
                            rmdir = "cmd.exe /c rmdir /S /Q " + dirpath;
                            this.replaceInFile(fn, rmdir, this.commentPrefix + rmdir);
                            cmd = "cmd.exe /c rmdir /S /Q " + dir + "\\" + dirname + "\n" + rmdir;
                            break block0;
                        }
                        cmd = "@rem please manually remove " + dir;
                        break block0;
                    }
                }
                throw new HydraInternalException("Should not happen");
            }
            default: {
                throw new HydraInternalException("Should not happen");
            }
        }
        if (cmd != null) {
            FileUtil.appendToFile(fn, cmd + "\n");
        }
    }

    protected void recordPIDNoDumps(HostDescription hd, int pid) {
        this.recordPID(this.nfn, this.dfn, this.hfn, hd, pid, false, false);
    }

    protected void recordPID(HostDescription hd, int pid) {
        this.recordPID(this.nfn, this.dfn, this.hfn, hd, pid, true, false);
    }

    protected void recordHDFSPIDNoDumps(HostDescription hd, int pid, boolean secure) {
        this.recordPID(this.hnfn, null, null, hd, pid, false, secure);
    }

    private synchronized void recordPID(String nukefn, String dumpfn, String heapfn, HostDescription hd, int pid, boolean includeDumps, boolean secure) {
        String ncmd;
        String string = ncmd = secure ? this.getStopPIDCmd(hd, pid) : this.getNukePIDCmd(hd, pid);
        if (ncmd != null) {
            FileUtil.appendToFile(nukefn, ncmd + "\n");
        }
        if (includeDumps) {
            String hcmd;
            String dcmd = this.getDumpLocksCmd(hd, pid);
            if (dcmd != null) {
                FileUtil.appendToFile(dumpfn, dcmd + "\n");
            }
            if ((dcmd = this.getDumpPIDCmd(hd, pid)) != null) {
                FileUtil.appendToFile(dumpfn, dcmd + "\n");
            }
            if ((hcmd = this.getDumpHeapPIDCmd(hd, pid)) != null) {
                FileUtil.appendToFile(heapfn, hcmd + "\n");
            }
        }
    }

    protected void removePIDNoDumps(String ncmd) {
        this.replaceInFile(this.nfn, ncmd, this.commentPrefix + ncmd);
    }

    protected void removePIDNoDumps(HostDescription hd, int pid) {
        this.removePID(this.nfn, this.dfn, this.hfn, hd, pid, false, false);
    }

    protected void removePID(HostDescription hd, int pid) {
        this.removePID(this.nfn, this.dfn, this.hfn, hd, pid, true, false);
    }

    protected void removeHDFSPIDNoDumps(HostDescription hd, int pid, boolean secure) {
        this.removePID(this.hnfn, null, null, hd, pid, false, secure);
    }

    private synchronized void removePID(String nukefn, String dumpfn, String heapfn, HostDescription hd, int pid, boolean includeDumps, boolean secure) {
        String ncmd;
        String string = ncmd = secure ? this.getStopPIDCmd(hd, pid) : this.getNukePIDCmd(hd, pid);
        if (ncmd != null) {
            this.replaceInFile(nukefn, ncmd, this.commentPrefix + ncmd);
        }
        if (includeDumps) {
            String hcmd;
            String dcmd = this.getDumpLocksCmd(hd, pid);
            if (dcmd != null) {
                this.replaceInFile(dumpfn, dcmd, this.commentPrefix + dcmd);
            }
            if ((dcmd = this.getDumpPIDCmd(hd, pid)) != null) {
                this.replaceInFile(dumpfn, dcmd, this.commentPrefix + dcmd);
            }
            if ((hcmd = this.getDumpHeapPIDCmd(hd, pid)) != null) {
                this.replaceInFile(heapfn, hcmd, this.commentPrefix + hcmd);
            }
        }
    }

    private String getStopPIDCmd(HostDescription hd, int pid) {
        String cmd = this.getShutdownCommand(hd.getHostName(), pid);
        return this.wrapCommand(cmd, hd);
    }

    protected String getNukePIDCmd(HostDescription hd, int pid) {
        String cmd = this.getKillCommand(hd.getHostName(), pid);
        return this.wrapCommand(cmd, hd);
    }

    private String getDumpLocksCmd(HostDescription hd, int pid) {
        String cmd = this.getDumpLocksCommand(hd.getHostName(), pid);
        return this.wrapCommand(cmd, hd);
    }

    private String getDumpPIDCmd(HostDescription hd, int pid) {
        String cmd = this.getPrintStacksCommand(hd.getHostName(), pid);
        return this.wrapCommand(cmd, hd);
    }

    private String getDumpHeapPIDCmd(HostDescription hd, int pid) {
        String options = TestConfig.tab().stringAt(Prms.jmapHeapDumpOptions, null);
        String[] cmdarr = this.getDumpHeapCommand(hd.getHostName(), pid, hd.getUserDir(), options);
        String cmd = null;
        if (cmdarr != null) {
            cmd = "";
            for (int i = 0; i < cmdarr.length; ++i) {
                cmd = cmd + cmdarr[i];
                if (i >= cmdarr.length - 1) continue;
                cmd = cmd + " ";
            }
        }
        return this.wrapCommand(cmd, hd);
    }

    private String getShutdownCommand(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            return this.platform.getShutdownCommand(pid);
        }
        try {
            return HostAgentMgr.getHostAgent(host).getShutdownCommand(pid);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    private String getKillCommand(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            return this.platform.getKillCommand(pid);
        }
        try {
            return HostAgentMgr.getHostAgent(host).getKillCommand(pid);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    private String getDumpLocksCommand(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            return this.platform.getDumpLocksCommand(pid);
        }
        try {
            return HostAgentMgr.getHostAgent(host).getDumpLocksCommand(pid);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    private String getPrintStacksCommand(String host, int pid) {
        if (HostHelper.isLocalHost(host)) {
            return this.platform.getPrintStacksCommand(pid);
        }
        try {
            return HostAgentMgr.getHostAgent(host).getPrintStacksCommand(pid);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    private String[] getDumpHeapCommand(String host, int pid, String userDir, String options) {
        if (HostHelper.isLocalHost(host)) {
            return this.platform.getDumpHeapCommand(pid, userDir, options);
        }
        try {
            return HostAgentMgr.getHostAgent(host).getDumpHeapCommand(pid, userDir, options);
        }
        catch (RemoteException e) {
            String s = "Unable to complete operation using hostagent on " + host;
            throw new HydraRuntimeException(s, e);
        }
    }

    protected String wrapCommand(String cmd, HostDescription hd) {
        if (cmd != null) {
            if (HostHelper.isLocalHost(hd.getHostName())) {
                return this.isWindows(hd) ? "start /WAIT " + cmd : cmd;
            }
            if (this.canUseSSH(hd)) {
                return "ssh -n -x -o PasswordAuthentication=no -o StrictHostKeyChecking=no " + hd.getHostName() + " " + cmd;
            }
            String wcmd = this.isWindows(hd) ? this.wrapCommandAsArg(cmd) : cmd;
            return this.getBootstrapperClientCmd(hd) + " \"" + wcmd + "\"";
        }
        return null;
    }

    private boolean canUseSSH(HostDescription hd) {
        return this.mhd.getOSType() == HostHelper.OSType.unix && hd.getOSType() == HostHelper.OSType.unix;
    }

    private boolean isWindows(HostDescription hd) {
        return hd.getOSType() == HostHelper.OSType.windows;
    }

    private String getBootstrapperClientCmd(HostDescription hd) {
        return System.getProperty("java.home") + File.separator + "bin" + File.separator + "java -classpath " + System.getProperty("java.class.path") + " hydra.BootstrapperClient " + this.getURL(hd);
    }

    private String getURL(HostDescription hd) {
        return "rmi://" + hd.getHostName() + ":" + hd.getBootstrapPort() + "/" + "bootstrapper";
    }

    private String wrapCommandAsArg(String cmd) {
        String s = cmd;
        s = s.replace("\\", "\\\\");
        s = this.winQuote(s);
        return s;
    }

    private String winQuote(String s) {
        if (!this.needsQuoting(s)) {
            return s;
        }
        s = s.replaceAll("([\\\\]*)\"", "$1$1\\\\\"");
        s = s.replaceAll("([\\\\]*)\\z", "$1$1");
        return s;
    }

    private boolean needsQuoting(String s) {
        int len = s.length();
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            switch (s.charAt(i)) {
                case '\t': 
                case ' ': 
                case '\"': 
                case '\\': {
                    return true;
                }
            }
        }
        return false;
    }

    private void replaceInFile(String fn, String prefix, String newtxt) {
        try {
            BufferedReader br = new BufferedReader(new FileReader(fn));
            StringBuffer buf = new StringBuffer();
            String line = null;
            while ((line = br.readLine()) != null) {
                if (line.startsWith(prefix)) {
                    line = newtxt;
                }
                buf.append(line + "\n");
            }
            br.close();
            FileUtil.writeToFile(fn, buf.toString());
        }
        catch (FileNotFoundException e) {
            throw new HydraRuntimeException("Unable to find file: " + fn, e);
        }
        catch (IOException e) {
            throw new HydraRuntimeException("Unable to modify file: " + fn, e);
        }
    }
}

