/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.SchedulingOrder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;

public class MethExecutorResult
implements Serializable {
    public static final Serializable EXCEPTION_OCCURRED = new Serializable(){

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass());
        }

        public String toString() {
            return "EXCEPTION_OCCURRED";
        }
    };
    public static final Throwable NONSERIALIZABLE_EXCEPTION = new Throwable(){

        public boolean equals(Object o) {
            return o != null && this.getClass().equals(o.getClass());
        }

        @Override
        public String toString() {
            return "NONSERIALIZABLE_EXCEPTION";
        }
    };
    private Object result;
    private Throwable exception;
    private String exceptionClassName;
    private String exceptionMessage;
    private String stackTrace;

    public MethExecutorResult() {
        this.result = null;
    }

    public MethExecutorResult(Object result) {
        this.result = result;
    }

    public MethExecutorResult(Throwable thr) {
        this.result = EXCEPTION_OCCURRED;
        this.exceptionClassName = thr.getClass().getName();
        this.exceptionMessage = thr.getMessage();
        StringWriter sw = new StringWriter();
        if (thr instanceof SchedulingOrder) {
            this.stackTrace = "No stack trace for SchedulingOrder\n";
            this.exception = thr;
        } else {
            thr.printStackTrace(new PrintWriter((Writer)sw, true));
            this.stackTrace = sw.toString();
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(thr);
                this.exception = thr;
            }
            catch (IOException ex) {
                sw = new StringWriter();
                ex.printStackTrace(new PrintWriter((Writer)sw, true));
                this.exception = new IOException(sw.toString());
            }
        }
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getResult());
        s.append("\n");
        if (this.getStackTrace() != null) {
            s.append(this.getStackTrace());
        }
        return s.toString();
    }

    public Object getResult() {
        return this.result;
    }

    public String getExceptionClassName() {
        return this.exceptionClassName;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public Throwable getException() {
        return this.exception;
    }

    public boolean exceptionOccurred() {
        return EXCEPTION_OCCURRED.equals(this.result);
    }
}

