/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.ConfigHashtable;
import hydra.EnvHelper;
import hydra.HostDescription;
import hydra.HydraVector;
import hydra.JDKVersionPrms;
import hydra.ProductVersionHelper;
import hydra.TestConfig;
import hydra.VmDescription;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class JDKVersionDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private List<String> javaHomes;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    public List<String> getJavaHomes() {
        return this.javaHomes;
    }

    private void setJavaHomes(List<String> str) {
        this.javaHomes = str;
    }

    protected String getJavaHome(VmDescription vmd, String javaHome) {
        System.out.println("HEY called JDKVersionDescription.getJavaHome with javaHome=" + javaHome);
        if (javaHome.equals("default")) {
            return vmd.getHostDescription().getJavaHome();
        }
        return javaHome;
    }

    protected String getClassPath(VmDescription vmd, String javaHome) {
        String gfh;
        Vector<String> classpath = new Vector<String>();
        HostDescription hd = vmd.getHostDescription().copy();
        hd.setJavaHome(javaHome);
        Vector extra = vmd.getUnconvertedExtraClassPath();
        if (extra != null && extra.size() > 0) {
            extra = EnvHelper.expandEnvVars(extra, hd);
            classpath.addAll(extra);
        }
        classpath.add(hd.getTestDir() + hd.getFileSep() + "junit.jar");
        classpath.add(hd.getTestDir());
        if (hd.getExtraTestDir() != null) {
            classpath.add(hd.getExtraTestDir());
        }
        if ((gfh = vmd.getHostDescription().getGemFireHome()) != null) {
            classpath.add(gfh + hd.getFileSep() + "lib" + hd.getFileSep() + "snappydata-store-" + ProductVersionHelper.getInfo().getProperty("Product-Version") + ".jar");
        }
        return EnvHelper.asPath(classpath, hd);
    }

    protected String getLibPath(VmDescription vmd, String javaHome) {
        Vector<String> libpath = new Vector<String>();
        HostDescription hd = vmd.getHostDescription().copy();
        hd.setJavaHome(javaHome);
        String gfh = vmd.getHostDescription().getGemFireHome();
        libpath.add(gfh + hd.getFileSep() + "lib");
        libpath.add(gfh + hd.getFileSep() + ".." + hd.getFileSep() + "hidden" + hd.getFileSep() + "lib");
        Vector extra = vmd.getUnconvertedExtraLibPath();
        if (extra != null && extra.size() > 0) {
            extra = EnvHelper.expandEnvVars(extra, hd);
            libpath.addAll(extra);
        }
        return EnvHelper.asPath(libpath, hd);
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, List<String>> map = new TreeMap<String, List<String>>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "javaHomes", this.getJavaHomes());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(JDKVersionPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            JDKVersionDescription jvd = JDKVersionDescription.createJDKVersionDescription(name, config, i);
            if (jvd == null) continue;
            config.addJDKVersionDescription(jvd);
        }
    }

    private static JDKVersionDescription createJDKVersionDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        JDKVersionDescription jvd = new JDKVersionDescription();
        jvd.setName(name);
        Long key = JDKVersionPrms.javaHomes;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null && strs.size() > 0) {
            ArrayList<String> tmp = new ArrayList<String>();
            Iterator i = strs.iterator();
            while (i.hasNext()) {
                String str = tab.getString(key, i.next());
                if (str == null) {
                    tmp.add("default");
                    continue;
                }
                tmp.add(str);
            }
            if (tmp.size() == 1 && ((String)tmp.get(0)).equals("default")) {
                tmp = null;
            }
            jvd.setJavaHomes(tmp);
        }
        return jvd.getJavaHomes() == null ? null : jvd;
    }
}

