/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import hydra.HostAgentDescription;
import hydra.HostAgentIF;
import hydra.HostAgentRecord;
import hydra.HostHelper;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.HydraTimeoutException;
import hydra.Java;
import hydra.Log;
import hydra.MasterController;
import hydra.Nuker;
import hydra.Prms;
import hydra.RemoteTestModule;
import hydra.TestConfig;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.Vector;

public class HostAgentMgr {
    private static Vector PendingHostAgents = new Vector();
    private static Hashtable HostAgents = new Hashtable();

    protected static void startHostAgents(Map hads) {
        if (hads == null) {
            return;
        }
        int pauseSec = TestConfig.getHostAgentInstance().getParameters().intAt(Prms.sleepBeforeStartingHostAgentSec, 0);
        HostAgentMgr.log().info("Starting " + hads.size() + " hostagents with a " + pauseSec + " second pause in between each");
        for (HostAgentDescription had : hads.values()) {
            if (!had.getArchiveStats() && HostHelper.isLocalHost(had.getHostDescription().getHostName())) continue;
            if (pauseSec > 0) {
                MasterController.sleepForMs(pauseSec * 1000);
            }
            HostAgentMgr.startHostAgent(had);
        }
        HostAgentMgr.waitForHostAgentsToRegister();
        HostAgentMgr.log().info("Started " + HostAgents.size() + " hostagents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startHostAgent(HostAgentDescription had) {
        String host = had.getHostDescription().getHostName();
        HostAgentMgr.log().info("Starting hostagent on " + host + " using hostagent description " + had);
        int pid = Java.javaHostAgent(had);
        HostAgentMgr.log().info("Started hostagent on " + host);
        Vector vector = PendingHostAgents;
        synchronized (vector) {
            PendingHostAgents.add(host);
            HostAgentMgr.log().info("Added " + host + " to PendingHostAgents");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String getNukePIDCommand(String host) {
        Hashtable hashtable = HostAgents;
        synchronized (hashtable) {
            HostAgentRecord har = (HostAgentRecord)HostAgents.get(host);
            return Nuker.getInstance().getNukePIDCmd(har.getHostDescription(), har.getProcessId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void restartHostAgent(String host) {
        HostAgentMgr.log().info("Restarting hostagent on " + host);
        HostAgentRecord har = null;
        Hashtable hashtable = HostAgents;
        synchronized (hashtable) {
            har = (HostAgentRecord)HostAgents.remove(host);
            if (har == null) {
                String s = "Hostagent for " + host + " not found";
                throw new HydraInternalException(s);
            }
        }
        SortedMap<String, HostAgentDescription> hads = TestConfig.getInstance().getHostAgentDescriptions();
        for (HostAgentDescription had : hads.values()) {
            if (!had.getHostDescription().getHostName().equals(host)) continue;
            HostAgentMgr.startHostAgent(had);
            HostAgentMgr.waitForHostAgentToRegister(host);
            break;
        }
        HostAgentMgr.log().info("Restarted hostagent on " + host);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void registerHostAgent(HostAgentRecord har) {
        Vector vector = PendingHostAgents;
        synchronized (vector) {
            Hashtable hashtable = HostAgents;
            synchronized (hashtable) {
                PendingHostAgents.remove(har.getHostName());
                HostAgents.put(har.getHostName(), har);
            }
        }
        HostAgentMgr.log().info(har + " registered.");
        Nuker.getInstance().recordPIDNoDumps(har.getHostDescription(), har.getProcessId());
    }

    private static void waitForHostAgentsToRegister() {
        int maxWaitSec = TestConfig.getHostAgentInstance().getParameters().intAt(Prms.maxHostAgentStartupWaitSec);
        HostAgentMgr.log().info("Waiting " + maxWaitSec + " seconds for hostagents to register with master.");
        int lastnum = HostAgentMgr.numPendingHostAgents();
        long timeout = System.currentTimeMillis() + (long)(maxWaitSec * 1000);
        while (System.currentTimeMillis() < timeout) {
            MasterController.sleepForMs(1000);
            int currentnum = HostAgentMgr.numPendingHostAgents();
            if (currentnum == 0) {
                HostAgentMgr.log().info("All hostagents have registered.");
                return;
            }
            if (currentnum == lastnum) continue;
            HostAgentMgr.log().info("...waiting for " + currentnum + " hostagents...");
            lastnum = currentnum;
        }
        throw new HydraTimeoutException("Failed to register hostagents within " + maxWaitSec + " seconds.");
    }

    private static void waitForHostAgentToRegister(String host) {
        if (!HostAgentMgr.isRegistered(host)) {
            int maxWaitSec = TestConfig.getHostAgentInstance().getParameters().intAt(Prms.maxHostAgentStartupWaitSec);
            HostAgentMgr.log().info("Waiting " + maxWaitSec + " seconds for hostagent on host " + host + " to register with master.");
            long timeout = System.currentTimeMillis() + (long)(maxWaitSec * 1000);
            while (System.currentTimeMillis() < timeout) {
                MasterController.sleepForMs(1000);
                if (HostAgentMgr.isRegistered(host)) {
                    HostAgentMgr.log().info("Hostagent on host " + host + " has registered.");
                    return;
                }
                HostAgentMgr.log().info("...waiting for hostagent on host " + host + "...");
            }
            String s = "Failed to register hostagent on host" + host + " within " + maxWaitSec + " seconds.";
            throw new HydraTimeoutException(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRegistered(String host) {
        Hashtable hashtable = HostAgents;
        synchronized (hashtable) {
            return HostAgents.containsKey(host);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int numPendingHostAgents() {
        Vector vector = PendingHostAgents;
        synchronized (vector) {
            Hashtable hashtable = HostAgents;
            synchronized (hashtable) {
                Iterator i = PendingHostAgents.iterator();
                while (i.hasNext()) {
                    String host = (String)i.next();
                    if (!HostAgents.containsKey(host)) continue;
                    i.remove();
                }
            }
            return PendingHostAgents.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static HostAgentIF getHostAgent(String host) {
        Hashtable hashtable = HostAgents;
        synchronized (hashtable) {
            if (HostHelper.isLocalHost(host)) {
                String s = "Use Platform instead of HostAgent for localhost";
                throw new HydraInternalException(s);
            }
            if (RemoteTestModule.Master == null) {
                HostAgentRecord har = (HostAgentRecord)HostAgents.get(host);
                if (har == null) {
                    throw new HydraInternalException("No hostagent has been configured for remote host " + host);
                }
                return har.getHostAgent();
            }
            HostAgentIF ha = (HostAgentIF)HostAgents.get(host);
            if (ha == null) {
                try {
                    ha = RemoteTestModule.Master.getHostAgent(host);
                }
                catch (RemoteException e) {
                    String s = "Unable to access master to get remote hostagent";
                    throw new HydraRuntimeException(s);
                }
            }
            return ha;
        }
    }

    public static HostAgentIF getRemoteHostAgentForClient(String host) {
        Hashtable hashtable = HostAgents;
        synchronized (hashtable) {
            if (RemoteTestModule.Master == null) {
                HostAgentRecord har = (HostAgentRecord)HostAgents.get(host);
                if (har == null) {
                    String s = null;
                    if (HostHelper.isLocalHost(host)) {
                        s = "No hostagent has been configured for localhost: " + host;
                        throw new UnsupportedOperationException(s);
                    }
                    s = "No hostagent has been configured for remote host " + host;
                    throw new HydraInternalException(s);
                }
                return har.getHostAgent();
            }
            String s = "This method must not be invoked from a hydra client.";
            throw new HydraRuntimeException(s);
        }
    }

    protected static void shutDownAllHostAgents() {
        SortedMap<String, HostAgentDescription> hads = TestConfig.getHostAgentInstance().getHostAgentDescriptions();
        HostAgentMgr.log().info("Shutting down hostagents");
        if (HostAgentMgr.numPendingHostAgents() > 0) {
            HostAgentMgr.waitForHostAgentsToRegister();
        }
        Iterator i = HostAgents.values().iterator();
        while (i.hasNext()) {
            HostAgentMgr.shutDownHostAgent((HostAgentRecord)i.next());
        }
    }

    private static void shutDownHostAgent(HostAgentRecord har) {
        try {
            har.getHostAgent().shutDownHostAgent();
        }
        catch (UnmarshalException unmarshalException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static LogWriter log() {
        return Log.getLogWriter();
    }
}

