/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import hydra.ConfigHashtable;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.GemFirePrms;
import hydra.HostDescription;
import hydra.JMXManagerHelper;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class GemFireVersionHelper {
    protected static void setJMXManager(Properties p, String val) {
        String key = "jmx-manager";
        p.setProperty(key, val);
    }

    protected static void setJMXManagerAccessFile(Properties p, String fn, HostDescription hd) {
        String key = "jmx-manager-access-file";
        if (fn == null) {
            p.setProperty(key, "");
        } else {
            p.setProperty(key, EnvHelper.expandEnvVars(fn, hd));
        }
    }

    protected static void setJMXManagerPasswordFile(Properties p, String fn, HostDescription hd) {
        String key = "jmx-manager-password-file";
        if (fn == null) {
            p.setProperty(key, "");
        } else {
            p.setProperty(key, EnvHelper.expandEnvVars(fn, hd));
        }
    }

    protected static void setJMXManagerPorts(Properties p, boolean generatePort, boolean generateHttpPort) {
        if (generatePort || generateHttpPort) {
            JMXManagerHelper.Endpoint endpoint = JMXManagerHelper.getEndpoint(generatePort, generateHttpPort);
            p.setProperty("jmx-manager-port", String.valueOf(endpoint.getPort()));
            p.setProperty("jmx-manager-http-port", String.valueOf(endpoint.getHttpPort()));
        } else {
            p.setProperty("jmx-manager-port", String.valueOf(0));
            p.setProperty("jmx-manager-http-port", String.valueOf(0));
        }
    }

    protected static void setJMXManagerSSL(Properties p, String val) {
        String key = "jmx-manager-ssl";
        p.setProperty(key, val);
    }

    protected static void setJMXManagerStart(Properties p, String val) {
        String key = "jmx-manager-start";
        p.setProperty(key, val);
    }

    public static Set getMembers(DM dm) {
        return dm.getNormalDistributionManagerIds();
    }

    protected static void setRemoteLocators(Properties p, List<String> vals) {
        String key = "remote-locators";
        List<String> remoteEndpoints = DistributedSystemHelper.getContacts(vals);
        String val = DistributedSystemHelper.endpointsToString(remoteEndpoints);
        p.setProperty(key, val);
    }

    protected static void setEnforceUniqueHost(Properties p, Boolean val) {
        String key = "enforce-unique-host";
        p.setProperty(key, val.toString());
    }

    protected static void setRedundancyZone(Properties p, String val) {
        String key = "redundancy-zone";
        p.setProperty(key, val.toString());
    }

    protected static Boolean getDeltaPropagation(ConfigHashtable tab, int i) {
        Long key = GemFirePrms.deltaPropagation;
        boolean defaultValue = true;
        boolean val = tab.booleanAtWild(key, i, defaultValue);
        return val;
    }

    protected static void setDeltaPropagation(Properties p, Boolean val) {
        String key = "delta-propagation";
        p.setProperty(key, val.toString());
    }

    protected static void setDistributedSystemId(Properties p, Integer val) {
        String key = "distributed-system-id";
        p.setProperty(key, val.toString());
    }

    protected static String getMembershipPortRange(ConfigHashtable tab, int i) {
        Long key = GemFirePrms.membershipPortRange;
        String defaultValue = DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[0] + "-" + DistributionConfig.DEFAULT_MEMBERSHIP_PORT_RANGE[1];
        return tab.stringAtWild(key, i, defaultValue);
    }

    protected static void setMembershipPortRange(Properties p, String val) {
        String key = "membership-port-range";
        p.setProperty(key, val);
    }

    protected static int getTcpPort(ConfigHashtable tab, int i) {
        Long key = GemFirePrms.tcpPort;
        int defaultValue = 0;
        return tab.intAtWild(key, i, defaultValue);
    }

    protected static void setTcpPort(Properties p, int val) {
        String key = "tcp-port";
        p.setProperty(key, String.valueOf(val));
    }

    protected static void setOffHeapMemorySize(Properties p, String val) {
        String key = "off-heap-memory-size";
        p.setProperty(key, val);
    }

    protected static void setDisableAutoReconnect(Properties p, Boolean val) {
        String key = "disable-auto-reconnect";
        if (val == null) {
            p.setProperty(key, "true");
        } else {
            p.setProperty(key, val.toString());
        }
    }
}

