/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.distributed.internal.InternalLocator;
import hydra.GemFireDistributionLocatorVersion;
import hydra.HostHelper;
import hydra.HydraRuntimeException;
import hydra.Log;
import java.util.Properties;

public class GemFireDistributionLocator {
    private static InternalLocator locator = null;
    private static String distributedSystemName = null;
    private static int locatorPort;

    public static void start(String dsName, int port, Properties dsProperties, boolean serverLocator) {
        distributedSystemName = dsName;
        locatorPort = port;
        try {
            if (dsProperties.getProperty("mcast-port") == null || dsProperties.getProperty("mcast-port").length() == 0) {
                dsProperties.setProperty("mcast-port", "0");
            } else if (dsProperties.getProperty("mcast-port").equals("10334")) {
                Log.getLogWriter().error("Attempt to create locator with default mcast port", (Throwable)new Exception());
                dsProperties.setProperty("mcast-port", "0");
            }
            locator = GemFireDistributionLocatorVersion.startLocator(locatorPort, Log.getLogWriter(), Log.getLogWriter(), HostHelper.getIPAddress(), dsProperties, serverLocator);
            Log.getLogWriter().info("GemFireDistributionLocator for " + distributedSystemName + " started on port " + locatorPort);
        }
        catch (Exception e) {
            throw new HydraRuntimeException("Could not start GemFireDistributionLocator", e);
        }
    }

    public static void stop() {
        locator.stop();
        Log.getLogWriter().info("GemFireDistributionLocator for " + distributedSystemName + " on port " + locatorPort + " stopped");
    }

    private GemFireDistributionLocator() {
    }
}

