/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.cache.wan.GatewayReceiverFactory;
import hydra.BasePrms;
import hydra.CacheHelper;
import hydra.GatewayReceiverDescription;
import hydra.GatewayReceiverPrms;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PortHelper;
import hydra.TestConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class GatewayReceiverHelper {
    private static LogWriter log = Log.getLogWriter();
    private static String TheGatewayReceiverConfig;

    public static synchronized Set<GatewayReceiver> createAndStartGatewayReceivers(String gatewayReceiverConfig) {
        Set<GatewayReceiver> receivers = GatewayReceiverHelper.createGatewayReceivers(gatewayReceiverConfig);
        GatewayReceiverHelper.startGatewayReceivers();
        return receivers;
    }

    public static synchronized Set<GatewayReceiver> createGatewayReceivers(String gatewayReceiverConfig) {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            String s = "Cache has not been created yet";
            throw new HydraRuntimeException(s);
        }
        HashSet<GatewayReceiver> receivers = cache.getGatewayReceivers();
        if (receivers == null || receivers.size() == 0) {
            GatewayReceiverDescription grd = GatewayReceiverHelper.getGatewayReceiverDescription(gatewayReceiverConfig);
            int numInstances = grd.getNumInstances();
            GatewayReceiverFactory f = cache.createGatewayReceiverFactory();
            log.info("Creating " + numInstances + " gateway receivers for " + grd.getName());
            receivers = new HashSet<GatewayReceiver>();
            for (int i = 0; i < numInstances; ++i) {
                receivers.add(GatewayReceiverHelper.createGatewayReceiver(grd, f));
            }
            TheGatewayReceiverConfig = gatewayReceiverConfig;
        } else {
            if (TheGatewayReceiverConfig == null) {
                String s = "Gateway receivers were already created without GatewayReceiverHelper using  an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheGatewayReceiverConfig.equals(gatewayReceiverConfig)) {
                String s = "Gateway receivers already exist using logical gateway receiver configuration named " + TheGatewayReceiverConfig + ", cannot also use " + gatewayReceiverConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return receivers;
    }

    private static GatewayReceiver createGatewayReceiver(GatewayReceiverDescription grd, GatewayReceiverFactory f) {
        log.info("Configuring gateway receiver factory");
        grd.configure(f);
        log.info("Configured gateway receiver factory " + f);
        log.info("Creating gateway receiver");
        GatewayReceiver receiver = f.create();
        log.info("Created gateway receiver " + GatewayReceiverHelper.gatewayReceiverToString(receiver));
        return receiver;
    }

    private static void startGatewayReceivers() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            String s = "Cache has not been created yet";
            throw new HydraRuntimeException(s);
        }
        Set receivers = cache.getGatewayReceivers();
        if (receivers == null || receivers.size() == 0) {
            String s = "Gateway receivers have not been created yet.";
            throw new HydraRuntimeException(s);
        }
        for (GatewayReceiver receiver : receivers) {
            GatewayReceiverHelper.startGatewayReceiver(receiver);
        }
    }

    private static void startGatewayReceiver(GatewayReceiver receiver) {
        if (!receiver.isRunning()) {
            log.info("Starting gateway receiver: " + GatewayReceiverHelper.gatewayReceiverToString(receiver));
            long startTimeMs = System.currentTimeMillis();
            while (true) {
                try {
                    receiver.start();
                    log.info("Started gateway receiver: " + GatewayReceiverHelper.gatewayReceiverToString(receiver));
                }
                catch (IOException e) {
                    if (PortHelper.retrySocketBind(e, startTimeMs)) continue;
                    String s = "Problem starting gateway receiver" + GatewayReceiverHelper.gatewayReceiverToString(receiver);
                    throw new HydraRuntimeException(s, e);
                }
                break;
            }
        }
    }

    public static Set<GatewayReceiver> getGatewayReceivers() {
        Cache cache = CacheHelper.getCache();
        if (cache == null) {
            return null;
        }
        Set receivers = cache.getGatewayReceivers();
        return receivers == null || receivers.size() == 0 ? null : receivers;
    }

    public static synchronized void stopGatewayReceivers() {
        Set receivers = CacheHelper.getCache().getGatewayReceivers();
        if (receivers != null) {
            for (GatewayReceiver receiver : receivers) {
                GatewayReceiverHelper.stopGatewayReceiver(receiver);
            }
        }
    }

    private static void stopGatewayReceiver(GatewayReceiver receiver) {
        if (receiver.isRunning()) {
            log.info("Stopping gateway receiver: " + GatewayReceiverHelper.gatewayReceiverToString(receiver));
            receiver.stop();
            log.info("Stopped gateway receiver: " + GatewayReceiverHelper.gatewayReceiverToString(receiver));
        }
    }

    public static String gatewayReceiverToString(GatewayReceiver gr) {
        return GatewayReceiverDescription.gatewayReceiverToString(gr);
    }

    public static GatewayReceiverDescription getGatewayReceiverDescription(String gatewayReceiverConfig) {
        if (gatewayReceiverConfig == null) {
            throw new IllegalArgumentException("gatewayReceiverConfig cannot be null");
        }
        log.info("Looking up gateway receiver config: " + gatewayReceiverConfig);
        GatewayReceiverDescription grd = TestConfig.getInstance().getGatewayReceiverDescription(gatewayReceiverConfig);
        if (grd == null) {
            String s = gatewayReceiverConfig + " not found in " + BasePrms.nameForKey(GatewayReceiverPrms.names);
            throw new HydraRuntimeException(s);
        }
        log.info("Looked up gateway reeiver config:\n" + grd);
        return grd;
    }
}

