/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ConfigHashtable;
import hydra.DiskStoreDescription;
import hydra.DiskStorePrms;
import hydra.GatewayHelper;
import hydra.GatewayHubHelper;
import hydra.GatewayPrms;
import hydra.HydraConfigException;
import hydra.HydraRuntimeException;
import hydra.HydraVector;
import hydra.TestConfig;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class GatewayDescription
extends AbstractDescription
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static Map listenerInstanceMaps = new HashMap();
    private String name;
    private Integer alertThreshold;
    private Boolean batchConflation;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer concurrencyLevel;
    private DiskStoreDescription diskStoreDescription;
    private String diskStoreName;
    private Boolean enablePersistence;
    private Integer endpointNumPerDs;
    private List listeners;
    private Boolean listenersSingleton;
    private Integer maximumQueueMemory;
    private Gateway.OrderPolicy orderPolicy;
    private Integer socketBufferSize;

    public String getName() {
        return this.name;
    }

    private void setName(String str) {
        this.name = str;
    }

    private Integer getAlertThreshold() {
        return this.alertThreshold;
    }

    private void setAlertThreshold(Integer i) {
        this.alertThreshold = i;
    }

    private Boolean getBatchConflation() {
        return this.batchConflation;
    }

    private void setBatchConflation(Boolean bool) {
        this.batchConflation = bool;
    }

    private Integer getBatchSize() {
        return this.batchSize;
    }

    private void setBatchSize(Integer i) {
        this.batchSize = i;
    }

    private Integer getBatchTimeInterval() {
        return this.batchTimeInterval;
    }

    private void setBatchTimeInterval(Integer i) {
        this.batchTimeInterval = i;
    }

    protected Integer getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    private void setConcurrencyLevel(Integer i) {
        this.concurrencyLevel = i;
    }

    private String getDiskStoreName() {
        return this.diskStoreName;
    }

    private void setDiskStoreName(String str) {
        this.diskStoreName = str;
    }

    public DiskStoreDescription getDiskStoreDescription() {
        return this.diskStoreDescription;
    }

    private void setDiskStoreDescription(DiskStoreDescription dsd) {
        this.diskStoreDescription = dsd;
    }

    private Boolean getEnablePersistence() {
        return this.enablePersistence;
    }

    private void setEnablePersistence(Boolean bool) {
        this.enablePersistence = bool;
    }

    private Integer getEndpointNumPerDs() {
        return this.endpointNumPerDs;
    }

    private void setEndpointNumPerDs(Integer i) {
        this.endpointNumPerDs = i;
    }

    private List getListeners() {
        return this.listeners;
    }

    private void setListeners(List classnames) {
        this.listeners = classnames;
    }

    private Boolean getListenersSingleton() {
        return this.listenersSingleton;
    }

    private void setListenersSingleton(Boolean bool) {
        this.listenersSingleton = bool;
    }

    private Integer getMaximumQueueMemory() {
        return this.maximumQueueMemory;
    }

    private void setMaximumQueueMemory(Integer i) {
        this.maximumQueueMemory = i;
    }

    private Gateway.OrderPolicy getOrderPolicy() {
        return this.orderPolicy;
    }

    private void setOrderPolicy(Gateway.OrderPolicy p) {
        this.orderPolicy = p;
    }

    private Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    private void setSocketBufferSize(Integer i) {
        this.socketBufferSize = i;
    }

    protected void configure(Gateway g, String ds, List endpoints, boolean connect) {
        List instances;
        if (endpoints != null) {
            List list = GatewayHelper.getRandomEndpoints(ds, endpoints, this.getEndpointNumPerDs());
            for (GatewayHubHelper.Endpoint e : list) {
                String id = e.getId() + "_vmid_" + e.getVmid();
                g.addEndpoint(id, e.getAddress(), e.getPort());
            }
        }
        if ((instances = this.getListenerInstances(connect)) != null) {
            for (GatewayEventListener l : instances) {
                g.addListener(l);
            }
        }
        GatewayQueueAttributes gqa = new GatewayQueueAttributes();
        gqa.setAlertThreshold(this.getAlertThreshold().intValue());
        gqa.setBatchConflation(this.getBatchConflation().booleanValue());
        gqa.setBatchSize(this.getBatchSize().intValue());
        gqa.setBatchTimeInterval(this.getBatchTimeInterval().intValue());
        if (this.getDiskStoreDescription() != null) {
            gqa.setDiskStoreName(this.getDiskStoreDescription().getName());
        }
        gqa.setEnablePersistence(this.getEnablePersistence().booleanValue());
        gqa.setMaximumQueueMemory(this.getMaximumQueueMemory().intValue());
        g.setQueueAttributes(gqa);
        if (this.getOrderPolicy() != null) {
            g.setOrderPolicy(this.getOrderPolicy());
        }
        g.setSocketBufferSize(this.getSocketBufferSize().intValue());
    }

    protected static synchronized String gatewayToString(Gateway g) {
        StringBuffer buf = new StringBuffer();
        GatewayQueueAttributes gqa = g.getQueueAttributes();
        buf.append("\n  id: " + g.getId());
        buf.append("\n  gatewayHubId: " + g.getGatewayHubId());
        buf.append("\n  alertThreshold: " + gqa.getAlertThreshold());
        buf.append("\n  batchConflation: " + gqa.getBatchConflation());
        buf.append("\n  batchSize: " + gqa.getBatchSize());
        buf.append("\n  batchTimeInterval: " + gqa.getBatchTimeInterval());
        buf.append("\n  concurrencyLevel: " + g.getConcurrencyLevel());
        buf.append("\n  diskStoreName: " + gqa.getDiskStoreName());
        buf.append("\n  enablePersistence: " + gqa.getEnablePersistence());
        buf.append("\n  endpoints: " + g.getEndpoints());
        buf.append("\n  listeners: " + GatewayDescription.listenersFor(g.getListeners()));
        buf.append("\n  maximumQueueMemory: " + gqa.getMaximumQueueMemory());
        buf.append("\n  orderPolicy: " + g.getOrderPolicy());
        buf.append("\n  socketBufferSize: " + g.getSocketBufferSize());
        return buf.toString();
    }

    private static List listenersFor(List instances) {
        ArrayList<String> classnames = new ArrayList<String>();
        for (GatewayEventListener instance : instances) {
            classnames.add(instance.getClass().getName());
        }
        return classnames;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "alertThreshold", this.getAlertThreshold());
        map.put(header + "batchConflation", this.getBatchConflation());
        map.put(header + "batchSize", this.getBatchSize());
        map.put(header + "batchTimeInterval", this.getBatchTimeInterval());
        map.put(header + "concurrencyLevel", this.getConcurrencyLevel());
        map.put(header + "diskStoreName", this.getDiskStoreName());
        map.put(header + "enablePersistence", this.getEnablePersistence());
        if (this.getEndpointNumPerDs() == -1) {
            map.put(header + "endpointNumPerDs", "all available");
        } else {
            map.put(header + "endpointNumPerDs", this.getEndpointNumPerDs());
        }
        map.put(header + "listeners", this.getListeners());
        map.put(header + "listenersSingleton", this.getListenersSingleton());
        map.put(header + "maximumQueueMemory", this.getMaximumQueueMemory());
        map.put(header + "orderPolicy", this.getOrderPolicy());
        map.put(header + "socketBufferSize", this.getSocketBufferSize());
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(GatewayPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String name = (String)names.elementAt(i);
            GatewayDescription gd = GatewayDescription.createGatewayDescription(name, config, i);
            config.addGatewayDescription(gd);
        }
    }

    private static GatewayDescription createGatewayDescription(String name, TestConfig config, int index) {
        ConfigHashtable tab = config.getParameters();
        GatewayDescription gd = new GatewayDescription();
        gd.setName(name);
        GatewayQueueAttributes defaults = new GatewayQueueAttributes();
        Long key = GatewayPrms.alertThreshold;
        Integer i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(defaults.getAlertThreshold());
        }
        gd.setAlertThreshold(i);
        key = GatewayPrms.batchConflation;
        Boolean bool = tab.getBoolean(key, tab.getWild(key, index, null));
        if (bool == null) {
            bool = defaults.getBatchConflation();
        }
        gd.setBatchConflation(bool);
        key = GatewayPrms.batchSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(defaults.getBatchSize());
        }
        gd.setBatchSize(i);
        key = GatewayPrms.batchTimeInterval;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(defaults.getBatchTimeInterval());
        }
        gd.setBatchTimeInterval(i);
        key = GatewayPrms.concurrencyLevel;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = 1;
        }
        gd.setConcurrencyLevel(i);
        key = GatewayPrms.diskStoreName;
        String str = tab.getString(key, tab.getWild(key, index, null));
        if (str != null && !str.equalsIgnoreCase("none")) {
            gd.setDiskStoreDescription(GatewayDescription.getDiskStoreDescription(str, key, config));
            gd.setDiskStoreName("DiskStoreDescription." + str);
        }
        if ((bool = tab.getBoolean(key = GatewayPrms.enablePersistence, tab.getWild(key, index, null))) == null) {
            bool = defaults.getEnablePersistence();
        }
        gd.setEnablePersistence(bool);
        key = GatewayPrms.endpointNumPerDs;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(-1);
        }
        gd.setEndpointNumPerDs(i);
        key = GatewayPrms.listeners;
        HydraVector strs = tab.vecAtWild(key, index, null);
        if (strs != null) {
            Iterator i2 = strs.iterator();
            while (i2.hasNext()) {
                String str2 = tab.getString(key, i2.next());
                if (str2 != null && !str2.equalsIgnoreCase("none")) continue;
                i2.remove();
            }
            if (strs.size() > 0) {
                gd.setListeners(new ArrayList(strs));
            }
        }
        if ((bool = tab.getBoolean(key = GatewayPrms.listenersSingleton, tab.getWild(key, index, null))) == null) {
            gd.setListenersSingleton(Boolean.FALSE);
        } else {
            gd.setListenersSingleton(bool);
        }
        key = GatewayPrms.maximumQueueMemory;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(defaults.getMaximumQueueMemory());
        }
        gd.setMaximumQueueMemory(i);
        key = GatewayPrms.orderPolicy;
        str = tab.getString(key, tab.getWild(key, index, null));
        gd.setOrderPolicy(GatewayDescription.getOrderPolicy(str, key, gd.getConcurrencyLevel()));
        key = GatewayPrms.socketBufferSize;
        i = tab.getInteger(key, tab.getWild(key, index, null));
        if (i == null) {
            i = new Integer(32768);
        }
        gd.setSocketBufferSize(i);
        if (gd.getDiskStoreName() == null) {
            String s = BasePrms.nameForKey(GatewayPrms.names) + " (" + gd.getName() + ") requires a " + BasePrms.nameForKey(GatewayPrms.diskStoreName);
            throw new HydraRuntimeException(s);
        }
        return gd;
    }

    private static DiskStoreDescription getDiskStoreDescription(String str, Long key, TestConfig config) {
        DiskStoreDescription dsd = config.getDiskStoreDescription(str);
        if (dsd == null) {
            String s = BasePrms.nameForKey(key) + " not found in " + BasePrms.nameForKey(DiskStorePrms.names) + ": " + str;
            throw new HydraConfigException(s);
        }
        return dsd;
    }

    private synchronized List getListenerInstances(boolean connect) {
        List classnames = this.getListeners();
        if (classnames == null) {
            return null;
        }
        HashMap instanceMap = (HashMap)listenerInstanceMaps.get(this.getName());
        Long key = GatewayPrms.listeners;
        ArrayList<Object> instances = new ArrayList<Object>();
        for (String classname : classnames) {
            if (connect && this.getListenersSingleton().booleanValue()) {
                Object instance;
                if (instanceMap == null) {
                    instanceMap = new HashMap();
                }
                if ((instance = instanceMap.get(classname)) == null) {
                    instance = GatewayDescription.getAppListenerInstance(classname);
                    instanceMap.put(classname, instance);
                    instances.add(instance);
                    continue;
                }
                instances.add(instance);
                continue;
            }
            instances.add(GatewayDescription.getAppListenerInstance(classname));
        }
        return instances;
    }

    private static GatewayEventListener getAppListenerInstance(String classname) {
        Long key = GatewayPrms.listeners;
        Object obj = GatewayDescription.getInstance(key, classname);
        try {
            return (GatewayEventListener)obj;
        }
        catch (ClassCastException e) {
            String s = BasePrms.nameForKey(key) + " does not implement GatewayEventListener: " + classname;
            throw new HydraConfigException(s);
        }
    }

    private static Gateway.OrderPolicy getOrderPolicy(String str, Long key, int concurrencyLevel) {
        if (str == null) {
            return concurrencyLevel <= 1 ? null : Gateway.OrderPolicy.KEY;
        }
        if (str.equalsIgnoreCase("key")) {
            return Gateway.OrderPolicy.KEY;
        }
        if (str.equalsIgnoreCase("thread")) {
            return Gateway.OrderPolicy.THREAD;
        }
        String s = BasePrms.nameForKey(key) + " has illegal value: " + str;
        throw new HydraConfigException(s);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.alertThreshold = (Integer)in.readObject();
        this.batchConflation = (Boolean)in.readObject();
        this.batchSize = (Integer)in.readObject();
        this.batchTimeInterval = (Integer)in.readObject();
        this.concurrencyLevel = (Integer)in.readObject();
        this.diskStoreDescription = (DiskStoreDescription)in.readObject();
        this.diskStoreName = (String)in.readObject();
        this.enablePersistence = (Boolean)in.readObject();
        this.endpointNumPerDs = (Integer)in.readObject();
        this.listeners = (List)in.readObject();
        this.listenersSingleton = (Boolean)in.readObject();
        this.maximumQueueMemory = (Integer)in.readObject();
        this.name = (String)in.readObject();
        this.orderPolicy = GatewayDescription.getOrderPolicy((String)in.readObject(), GatewayPrms.orderPolicy, this.concurrencyLevel);
        this.socketBufferSize = (Integer)in.readObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.alertThreshold);
        out.writeObject(this.batchConflation);
        out.writeObject(this.batchSize);
        out.writeObject(this.batchTimeInterval);
        out.writeObject(this.concurrencyLevel);
        out.writeObject(this.diskStoreDescription);
        out.writeObject(this.diskStoreName);
        out.writeObject(this.enablePersistence);
        out.writeObject(this.endpointNumPerDs);
        out.writeObject(this.listeners);
        out.writeObject(this.listenersSingleton);
        out.writeObject(this.maximumQueueMemory);
        out.writeObject(this.name);
        if (this.orderPolicy == null) {
            out.writeObject(this.orderPolicy);
        } else {
            out.writeObject(this.orderPolicy.toString());
        }
        out.writeObject(this.socketBufferSize);
    }
}

