/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.BasePrms;
import hydra.EnvHelper;
import hydra.GsRandom;
import hydra.HostDescription;
import hydra.HydraConfigException;
import hydra.HydraInternalException;
import hydra.HydraTypeException;
import hydra.HydraVector;
import hydra.OneOf;
import hydra.Prms;
import hydra.Range;
import hydra.RemoteTestModule;
import hydra.RobinG;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class ConfigHashtable
implements Serializable {
    private static GsRandom randGen = null;
    private Map _mytab = new HashMap();

    public int size() {
        return this._mytab.size();
    }

    public int intAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.intFor(val, this.getRandGen(), key);
    }

    public int intAt(Long key, int defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.intFor(val, this.getRandGen(), key);
    }

    public static int intFor(Object val, GsRandom rand, Long key) {
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Double) {
            return ((Double)val).intValue();
        }
        if (val instanceof String) {
            double dval;
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use intAt on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            int ival = (int)dval;
            if ((double)ival != dval) {
                String s = "Cannot use intAt on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s);
            }
            return ival;
        }
        if (val instanceof Range) {
            return ((Range)val).nextInt(rand);
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.intFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.intFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use intAt on " + ConfigHashtable.cause(key, val));
    }

    public int intAtWild(Long key, int i, int defaultVal) {
        Object val = this.getWild(key, i, new Integer(defaultVal));
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.intFor(val, this.getRandGen(), key);
    }

    public long longAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.longFor(val, this.getRandGen(), key);
    }

    public long longAt(Long key, long defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.longFor(val, this.getRandGen(), key);
    }

    public static long longFor(Object val, GsRandom rand, Long key) {
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        if (val instanceof Double) {
            return ((Double)val).longValue();
        }
        if (val instanceof String) {
            double dval;
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use longAt on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            long lval = (long)dval;
            if ((double)lval != dval) {
                String s = "Cannot use longAt on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s);
            }
            return lval;
        }
        if (val instanceof Range) {
            return ((Range)val).nextLong(rand);
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.longFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.longFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use longAt on " + ConfigHashtable.cause(key, val));
    }

    public long longAtWild(Long key, int i, long defaultVal) {
        Object val = this.getWild(key, i, new Long(defaultVal));
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.longFor(val, this.getRandGen(), key);
    }

    public double doubleAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.doubleFor(val, this.getRandGen(), key);
    }

    public double doubleAt(Long key, double defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.doubleFor(val, this.getRandGen(), key);
    }

    public static double doubleFor(Object val, GsRandom rand, Long key) {
        if (val instanceof Integer) {
            return ((Integer)val).intValue();
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof String) {
            double dval;
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use doubleAt on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            return dval;
        }
        if (val instanceof Range) {
            return ((Range)val).nextDouble(rand);
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.doubleFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.doubleFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use doubleAt on " + ConfigHashtable.cause(key, val));
    }

    public double doubleAtWild(Long key, int i, double defaultVal) {
        Object val = this.getWild(key, i, new Double(defaultVal));
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.doubleFor(val, this.getRandGen(), key);
    }

    public boolean booleanAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.booleanFor(val, this.getRandGen(), key);
    }

    public boolean booleanAt(Long key, boolean defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.booleanFor(val, this.getRandGen(), key);
    }

    public static boolean booleanFor(Object val, GsRandom rand, Long key) {
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            if (((String)val).equalsIgnoreCase("true")) {
                return true;
            }
            if (((String)val).equalsIgnoreCase("false")) {
                return false;
            }
            throw new HydraTypeException("Cannot use booleanAt on " + ConfigHashtable.cause(key, val));
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.booleanFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.booleanFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use booleanAt on " + ConfigHashtable.cause(key, val));
    }

    public boolean booleanAtWild(Long key, int i, Boolean defaultVal) {
        Object val = this.getWild(key, i, defaultVal);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.booleanFor(val, this.getRandGen(), key);
    }

    public String stringAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.stringFor(val, this.getRandGen(), key);
    }

    public String stringAt(Long key, String defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.stringFor(val, this.getRandGen(), key);
    }

    public static String stringFor(Object val, GsRandom rand, Long key) {
        if (val instanceof Integer) {
            return val.toString();
        }
        if (val instanceof Double) {
            return val.toString();
        }
        if (val instanceof String) {
            return (String)val;
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.stringFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.stringFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use stringAt on " + ConfigHashtable.cause(key, val));
    }

    public String stringAt(Long key, int i, String defaultVal) {
        Object val = this.get(key, i, defaultVal);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.stringFor(val, this.getRandGen(), key);
    }

    public String stringAtWild(Long key, int i, String defaultVal) {
        Object val = this.getWild(key, i, defaultVal);
        if (val == null) {
            if (defaultVal == null) {
                return null;
            }
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.stringFor(val, this.getRandGen(), key);
    }

    public String pathAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.pathFor(val, this.getRandGen(), key);
    }

    public String pathAt(Long key, String defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.pathFor(val, this.getRandGen(), key);
    }

    public static String pathFor(Object val, GsRandom rand, Long key) {
        if (val instanceof String) {
            String clientName = System.getProperty("clientName");
            HostDescription hd = null;
            hd = clientName == null ? TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription() : TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
            return EnvHelper.expandEnvVars((String)val, hd);
        }
        if (val instanceof OneOf) {
            return ConfigHashtable.pathFor(((OneOf)val).next(rand), rand, key);
        }
        if (val instanceof RobinG) {
            return ConfigHashtable.pathFor(((RobinG)val).next(key), rand, key);
        }
        throw new HydraTypeException("Cannot use pathAt on " + ConfigHashtable.cause(key, val));
    }

    public String pathAt(Long key, int i, String defaultVal) {
        Object val = this.get(key, i, defaultVal);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.pathFor(val, this.getRandGen(), key);
    }

    public String pathAtWild(Long key, int i, String defaultVal) {
        Object val = this.getWild(key, i, defaultVal);
        if (val == null) {
            if (defaultVal == null) {
                return null;
            }
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\" at index " + i);
        }
        return ConfigHashtable.pathFor(val, this.getRandGen(), key);
    }

    public HydraVector vecAt(Long key) {
        Object val = this.get(key);
        if (val == null) {
            throw new HydraConfigException("No config param found for key \"" + BasePrms.nameForKey(key) + "\"");
        }
        return ConfigHashtable.vecFor(val);
    }

    public HydraVector vecAt(Long key, HydraVector defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        return ConfigHashtable.vecFor(val);
    }

    public HydraVector vecAt(Long key, int i, HydraVector defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof HydraVector) {
            Object subval = this.get(key, i, null);
            if (subval == null) {
                return defaultVal;
            }
            if (subval instanceof HydraVector) {
                return (HydraVector)subval;
            }
            if (i == 0) {
                return (HydraVector)val;
            }
            return defaultVal;
        }
        if (i == 0) {
            return ConfigHashtable.vecFor(val);
        }
        return defaultVal;
    }

    public HydraVector vecAtWild(Long key, int i, HydraVector defaultVal) {
        Object val = this.get(key);
        if (val == null) {
            return defaultVal;
        }
        if (val instanceof HydraVector) {
            boolean vecvec = false;
            for (Object vecval : (HydraVector)val) {
                if (!(vecval instanceof HydraVector)) continue;
                vecvec = true;
                break;
            }
            if (vecvec) {
                val = this.getWild(key, i, defaultVal);
                if (val instanceof HydraVector) {
                    return (HydraVector)val;
                }
                return ConfigHashtable.vecFor(val);
            }
            return (HydraVector)val;
        }
        return ConfigHashtable.vecFor(val);
    }

    public static HydraVector vecFor(Object val) {
        if (val instanceof HydraVector) {
            return (HydraVector)val;
        }
        return new HydraVector(val);
    }

    public Object get(Long key) {
        return this._mytab.get(key);
    }

    public Object get(Long key, Object defaultVal) {
        Object obj = this._mytab.get(key);
        if (obj == null) {
            obj = defaultVal;
        }
        return obj;
    }

    public Object get(Long key, int i, Object defaultVal) {
        Object result = defaultVal;
        Vector v = (Vector)this._mytab.get(key);
        if (v != null && i < v.size()) {
            result = v.elementAt(i);
        }
        return result;
    }

    public Object getWild(Long key, int i, Object defaultVal) {
        Object o = this._mytab.get(key);
        if (o == null) {
            return defaultVal;
        }
        if (!(o instanceof Vector)) {
            return o;
        }
        return ConfigHashtable.getWild((Vector)o, i, defaultVal);
    }

    public static Object getWild(Vector v, int i, Object defaultVal) {
        int sz = v.size();
        if (sz == 0) {
            return defaultVal;
        }
        if (i < sz) {
            return v.elementAt(i);
        }
        return v.elementAt(sz - 1);
    }

    public Boolean getBoolean(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof String) {
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            if (((String)val).equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (((String)val).equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new HydraTypeException("Cannot use getBoolean on " + ConfigHashtable.cause(key, val));
        }
        if (val instanceof OneOf) {
            return this.getBoolean(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getBoolean(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getBoolean on " + ConfigHashtable.cause(key, val));
    }

    public Double getDouble(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return new Double(((Integer)val).intValue());
        }
        if (val instanceof Double) {
            return (Double)val;
        }
        if (val instanceof String) {
            double dval;
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use getDouble on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            return new Double(dval);
        }
        if (val instanceof Range) {
            return new Double(((Range)val).nextDouble(this.getRandGen()));
        }
        if (val instanceof OneOf) {
            return this.getDouble(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getDouble(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getDouble on " + ConfigHashtable.cause(key, val));
    }

    public Integer getInteger(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return (Integer)val;
        }
        if (val instanceof Double) {
            return new Integer(((Double)val).intValue());
        }
        if (val instanceof String) {
            double dval;
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use getInteger on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            int ival = (int)dval;
            if ((double)ival != dval) {
                String s = "Cannot use getInteger on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s);
            }
            return new Integer(ival);
        }
        if (val instanceof Range) {
            return new Integer(((Range)val).nextInt(this.getRandGen()));
        }
        if (val instanceof OneOf) {
            return this.getInteger(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getInteger(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getInteger on " + ConfigHashtable.cause(key, val));
    }

    public Long getLong(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Long) {
            return (Long)val;
        }
        if (val instanceof Integer) {
            return new Long(((Integer)val).intValue());
        }
        if (val instanceof Double) {
            return new Long(((Double)val).longValue());
        }
        if (val instanceof String) {
            double dval;
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            try {
                dval = Double.parseDouble((String)val);
            }
            catch (NumberFormatException e) {
                String s = "Cannot use getLong on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s, e);
            }
            long lval = (long)dval;
            if ((double)lval != dval) {
                String s = "Cannot use getLong on " + ConfigHashtable.cause(key, val);
                throw new HydraConfigException(s);
            }
            return new Long(lval);
        }
        if (val instanceof Range) {
            return new Long(((Range)val).nextLong(this.getRandGen()));
        }
        if (val instanceof OneOf) {
            return this.getLong(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getLong(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getLong on " + ConfigHashtable.cause(key, val));
    }

    public String getString(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Integer) {
            return val.toString();
        }
        if (val instanceof Double) {
            return val.toString();
        }
        if (val instanceof String) {
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            return (String)val;
        }
        if (val instanceof OneOf) {
            return this.getString(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getString(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getString on " + ConfigHashtable.cause(key, val));
    }

    public Vector getVector(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof Vector) {
            return (Vector)val;
        }
        if (val instanceof Integer) {
            return ConfigHashtable.vecFor(val.toString());
        }
        if (val instanceof Double) {
            return ConfigHashtable.vecFor(val.toString());
        }
        if (val instanceof String) {
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            return ConfigHashtable.vecFor(val);
        }
        throw new HydraTypeException("Cannot use getString on " + ConfigHashtable.cause(key, val));
    }

    protected String getPath(Long key, Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            if (((String)val).equalsIgnoreCase("default")) {
                return null;
            }
            String clientName = System.getProperty("clientName");
            HostDescription hd = null;
            hd = clientName == null ? TestConfig.getInstance().getMasterDescription().getVmDescription().getHostDescription() : TestConfig.getInstance().getClientDescription(clientName).getVmDescription().getHostDescription();
            return EnvHelper.expandEnvVars((String)val, hd);
        }
        if (val instanceof OneOf) {
            return this.getPath(key, ((OneOf)val).next(this.getRandGen()));
        }
        if (val instanceof RobinG) {
            return this.getPath(key, ((RobinG)val).next(key));
        }
        throw new HydraTypeException("Cannot use getPath on " + ConfigHashtable.cause(key, val));
    }

    public void put(Long key, Object val) {
        if (val != null) {
            this._mytab.put(key, val);
        }
    }

    public GsRandom getRandGen() {
        if (randGen == null) {
            long seed = -1L;
            Object val = this.get(Prms.randomSeed);
            if (val instanceof Long) {
                seed = (Long)val;
            } else if (val instanceof String) {
                seed = Long.parseLong((String)val);
            } else {
                throw new HydraTypeException("Cannot getRandGen seed from " + val.getClass().getName());
            }
            String clientName = System.getProperty("clientName");
            if (clientName != null) {
                seed += (long)RemoteTestModule.getMyVmid();
            }
            randGen = new GsRandom(seed);
        }
        return randGen;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        SortedMap map = this.toSortedMap();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            buf.append(key + "=" + val + "\n");
        }
        return buf.toString();
    }

    public SortedMap toSortedMap() {
        return this.toSortedMap(false);
    }

    protected SortedMap toSortedMap(boolean forLatestConf) {
        Hashtable stringers = new Hashtable();
        for (Long key : this._mytab.keySet()) {
            stringers.put(BasePrms.nameForKey(key), this._mytab.get(key));
        }
        TreeMap<String, String> map = new TreeMap<String, String>(stringers);
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj == null) continue;
            StringBuffer buf = new StringBuffer();
            this.appendStrVal(obj, buf, forLatestConf);
            map.put(key, buf.toString());
        }
        return map;
    }

    private void appendStrVal(Object obj, StringBuffer buf, boolean forLatestConf) {
        if (obj instanceof HydraVector) {
            HydraVector vecVal;
            if (!forLatestConf) {
                buf.append(" [ HYDRAVECTOR ");
            }
            if ((vecVal = (HydraVector)obj).size() > 0) {
                if (vecVal.get(0) instanceof HydraVector) {
                    for (int i = 0; i < vecVal.size(); ++i) {
                        this.appendStrVal(vecVal.get(i), buf, forLatestConf);
                        if (i >= vecVal.size() - 1) continue;
                        buf.append(", ");
                    }
                } else {
                    for (int i = 0; i < vecVal.size(); ++i) {
                        this.appendStrVal(vecVal.get(i), buf, forLatestConf);
                        if (i >= vecVal.size() - 1) continue;
                        if (!forLatestConf) {
                            buf.append(",");
                        }
                        buf.append(" ");
                    }
                }
            }
            if (!forLatestConf) {
                buf.append(" ] ");
            }
        } else if (obj instanceof OneOf || obj instanceof Range || obj instanceof RobinG) {
            if (!forLatestConf) {
                buf.append(" [ ");
            }
            buf.append(obj.toString());
            if (!forLatestConf) {
                buf.append(" ] ");
            }
        } else if (obj instanceof Boolean) {
            buf.append(((Boolean)obj).toString().toLowerCase());
        } else if (obj instanceof Double || obj instanceof Integer || obj instanceof Long) {
            buf.append(obj.toString());
        } else if (obj instanceof String) {
            buf.append(obj);
        } else {
            String s = "Unexpected object type: " + obj.getClass().getName();
            throw new HydraInternalException(s);
        }
    }

    private static String cause(Long key, Object val) {
        return val.getClass().getName() + " at key \"" + BasePrms.nameForKey(key) + "\" (a common cause is using a FCN that returns a different type)";
    }
}

