/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import hydra.AbstractDescription;
import hydra.BasePrms;
import hydra.ClientPrms;
import hydra.ConfigHashtable;
import hydra.GemFireDescription;
import hydra.HydraConfigException;
import hydra.HydraVector;
import hydra.JDKVersionDescription;
import hydra.JProbeDescription;
import hydra.Prms;
import hydra.TestConfig;
import hydra.VersionDescription;
import hydra.VmDescription;
import java.io.Serializable;
import java.util.SortedMap;
import java.util.TreeMap;

public class ClientDescription
extends AbstractDescription
implements Serializable {
    private String name;
    private VmDescription vmd;
    private GemFireDescription gfd;
    private JProbeDescription jpd;
    private JDKVersionDescription jvd;
    private VersionDescription vd;
    private int vmQuantity;
    private int vmThreads;

    protected ClientDescription copy() {
        ClientDescription cd = new ClientDescription();
        cd.setName(this.getName());
        cd.setVmDescription(this.getVmDescription());
        cd.setGemFireDescription(this.getGemFireDescription());
        if (TestConfig.tab().booleanAt(Prms.versionStartAndEndTasks, false)) {
            cd.setJDKVersionDescription(this.getJDKVersionDescription());
            cd.setVersionDescription(this.getVersionDescription());
        }
        cd.setJProbeDescription(this.getJProbeDescription());
        cd.setVmQuantity(this.getVmQuantity());
        cd.setVmThreads(this.getVmThreads());
        return cd;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public VmDescription getVmDescription() {
        return this.vmd;
    }

    public void setVmDescription(VmDescription vmd) {
        this.vmd = vmd;
    }

    public GemFireDescription getGemFireDescription() {
        return this.gfd;
    }

    public void setGemFireDescription(GemFireDescription gfd) {
        this.gfd = gfd;
    }

    public JDKVersionDescription getJDKVersionDescription() {
        return this.jvd;
    }

    public void setJDKVersionDescription(JDKVersionDescription jvd) {
        this.jvd = jvd;
    }

    public VersionDescription getVersionDescription() {
        return this.vd;
    }

    public void setVersionDescription(VersionDescription vd) {
        this.vd = vd;
    }

    public JProbeDescription getJProbeDescription() {
        return this.jpd;
    }

    private void setJProbeDescription(JProbeDescription jpd) {
        this.jpd = jpd;
    }

    public int getVmQuantity() {
        return this.vmQuantity;
    }

    protected void setVmQuantity(int n) {
        this.vmQuantity = n;
    }

    public int getVmThreads() {
        return this.vmThreads;
    }

    protected void setVmThreads(int n) {
        this.vmThreads = n;
    }

    @Override
    public SortedMap toSortedMap() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        String header = this.getClass().getName() + "." + this.getName() + ".";
        map.put(header + "vmName", this.getVmDescription().getName());
        if (this.getGemFireDescription() != null) {
            map.put(header + "gemfireName", this.getGemFireDescription().getName());
        }
        if (this.getJDKVersionDescription() != null) {
            map.put(header + "jdkVersionName", this.getJDKVersionDescription().getName());
        }
        if (this.getVersionDescription() != null) {
            map.put(header + "versionName", this.getVersionDescription().getName());
        }
        if (this.getJProbeDescription() != null) {
            map.put(header + "jprobeName", this.getJProbeDescription().getName());
        }
        map.put(header + "vmQuantity", String.valueOf(this.getVmQuantity()));
        map.put(header + "vmThreads", String.valueOf(this.getVmThreads()));
        return map;
    }

    protected static void configure(TestConfig config) {
        ConfigHashtable tab = config.getParameters();
        HydraVector names = tab.vecAt(ClientPrms.names, new HydraVector());
        for (int i = 0; i < names.size(); ++i) {
            String jprobeName;
            String versionName;
            String jdkVersionName;
            ClientDescription cd = new ClientDescription();
            String name = (String)names.elementAt(i);
            cd.setName(name);
            String vmName = tab.stringAtWild(ClientPrms.vmNames, i, null);
            if (vmName == null) {
                throw new HydraConfigException("Missing " + BasePrms.nameForKey(ClientPrms.vmNames));
            }
            VmDescription vmd = config.getVmDescription(vmName);
            if (vmd == null) {
                throw new HydraConfigException("Undefined value in " + BasePrms.nameForKey(ClientPrms.vmNames) + ": " + vmName);
            }
            cd.setVmDescription(vmd);
            String gemfireName = tab.stringAtWild(ClientPrms.gemfireNames, i, "none");
            if (!gemfireName.equals("none")) {
                GemFireDescription gfd = config.getGemFireDescription(gemfireName);
                if (gfd == null) {
                    throw new HydraConfigException("Undefined value in " + BasePrms.nameForKey(ClientPrms.gemfireNames) + ": " + gemfireName);
                }
                cd.setGemFireDescription(gfd);
            }
            if (!(jdkVersionName = tab.stringAtWild(ClientPrms.jdkVersionNames, i, "none")).equals("none")) {
                JDKVersionDescription jvd = config.getJDKVersionDescription(jdkVersionName);
                cd.setJDKVersionDescription(jvd);
            }
            if (!(versionName = tab.stringAtWild(ClientPrms.versionNames, i, "none")).equals("none")) {
                VersionDescription vd = config.getVersionDescription(versionName);
                cd.setVersionDescription(vd);
            }
            if (!(jprobeName = tab.stringAtWild(ClientPrms.jprobeNames, i, "none")).equals("none")) {
                JProbeDescription jpd = config.getJProbeDescription(jprobeName);
                if (jpd == null) {
                    throw new HydraConfigException("Undefined value in " + BasePrms.nameForKey(ClientPrms.jprobeNames) + ": " + jprobeName);
                }
                cd.setJProbeDescription(jpd);
            }
            int vmQuantity = tab.intAtWild(ClientPrms.vmQuantities, i, 1);
            cd.setVmQuantity(vmQuantity);
            if (vmQuantity < 1) {
                throw new HydraConfigException("Illegal value for " + BasePrms.nameForKey(ClientPrms.vmQuantities) + ": " + vmQuantity);
            }
            int vmThreads = tab.intAtWild(ClientPrms.vmThreads, i, 1);
            if (vmThreads < 1) {
                throw new HydraConfigException("Illegal value for " + BasePrms.nameForKey(ClientPrms.vmThreads) + ": " + vmThreads);
            }
            cd.setVmThreads(vmThreads);
            config.addClientDescription(cd);
        }
    }
}

