/*
 * Decompiled with CFR 0.152.
 */
package hydra;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.cache.DiskStore;
import com.gemstone.gemfire.cache.DiskStoreFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlGenerator;
import com.gemstone.gemfire.internal.cache.xmlcache.ClientCacheCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.FunctionServiceCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionAttributesCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.RegionCreation;
import com.gemstone.gemfire.internal.cache.xmlcache.ResourceManagerCreation;
import hydra.BasePrms;
import hydra.ClientCacheDescription;
import hydra.ClientCachePrms;
import hydra.ClientRegionDescription;
import hydra.ClientRegionHelper;
import hydra.DiskStoreDescription;
import hydra.DiskStoreHelper;
import hydra.DistributedSystemHelper;
import hydra.EnvHelper;
import hydra.FileUtil;
import hydra.HydraInternalException;
import hydra.HydraRuntimeException;
import hydra.Log;
import hydra.PoolDescription;
import hydra.PoolHelper;
import hydra.RegionDescription;
import hydra.TestConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ClientCacheHelper {
    protected static String TheCacheConfig;
    private static Map XmlCacheConfigs;
    private static Map XmlRegionConfigs;
    private static Map XmlFunctionConfigs;
    private static LogWriter log;

    public static synchronized ClientCache createCache(String cacheConfig) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        ClientCache cache = ClientCacheHelper.getCache();
        if (cache == null) {
            ClientCacheDescription ccd = ClientCacheHelper.getClientCacheDescription(cacheConfig);
            Properties p = DistributedSystemHelper.getDistributedSystemProperties(null);
            ClientCacheFactory factory = new ClientCacheFactory(p);
            ClientCacheHelper.log("Configuring client cache factory from config: " + cacheConfig);
            ccd.configure(factory);
            ClientCacheHelper.log("Creating client cache");
            cache = factory.create();
            ClientCacheHelper.log("Created client cache: " + ClientCacheHelper.cacheToString(cache));
            DiskStoreDescription dsd = ccd.getDefaultDiskStoreDescription();
            if (dsd != null) {
                String defaultDiskStoreName = dsd.getName();
                DiskStoreFactory diskfactory = DiskStoreHelper.getDiskStoreFactory(dsd.getName());
                DiskStoreHelper.createDiskStore("DEFAULT", diskfactory);
            }
            TheCacheConfig = cacheConfig;
        } else {
            if (TheCacheConfig == null) {
                String s = "Cache was already created without ClientCacheHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheCacheConfig.equals(cacheConfig)) {
                String s = "Cache already exists using cache configuration " + TheCacheConfig + ", cannot also use " + cacheConfig;
                throw new HydraRuntimeException(s);
            }
        }
        return cache;
    }

    public static ClientCache createCacheFromXml(String cacheXmlFile) {
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        ClientCache cache = ClientCacheHelper.getCache();
        if (cache == null) {
            ClientCacheHelper.log("Creating cache from XML: " + fn);
            try {
                Properties p = DistributedSystemHelper.getDistributedSystemProperties(null);
                ClientCacheFactory ccf = new ClientCacheFactory(p);
                cache = ccf.set("cache-xml-file", fn).create();
            }
            catch (IllegalStateException e) {
                String s = "Unable to create cache using: " + fn;
                throw new HydraRuntimeException(s, e);
            }
            ClientCacheHelper.log("Created cache from XML");
            TheCacheConfig = fn;
        } else {
            if (TheCacheConfig == null) {
                String s = "Cache was already created without ClientCacheHelper using an unknown, and possibly different, configuration";
                throw new HydraRuntimeException(s);
            }
            if (!TheCacheConfig.equals(fn)) {
                String s = "Cache already exists using client cache configuration " + TheCacheConfig + ", cannot also use " + fn;
                throw new HydraRuntimeException(s);
            }
        }
        return cache;
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, String cacheXmlFile) {
        ClientCacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, null, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, String regionConfig, List regionNames, String cacheXmlFile) {
        ClientCacheHelper.generateCacheXmlFile(cacheConfig, null, regionConfig, regionNames, null, cacheXmlFile);
    }

    public static synchronized void generateCacheXmlFile(String cacheConfig, DynamicRegionFactory.Config dynamicRegionConfig, String regionConfig, List regionNames, List functions, String cacheXmlFile) {
        ClientCacheCreation dummyCache;
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        if (cacheXmlFile == null) {
            throw new IllegalArgumentException("cacheXmlFile cannot be null");
        }
        String fn = FileUtil.absoluteFilenameFor(EnvHelper.expandEnvVars(cacheXmlFile));
        if (!FileUtil.exists(fn)) {
            DiskStoreDescription dsd;
            ClientCacheHelper.log("Generating XML file: " + fn + " from client cache config: " + cacheConfig + " and region config " + regionConfig);
            DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
            if (ds == null) {
                DistributedSystemHelper.connectWithXml(fn);
            }
            ClientCacheDescription ccd = ClientCacheHelper.getClientCacheDescription(cacheConfig);
            dummyCache = ClientCacheHelper.generateDummyCache(cacheConfig, ccd, dynamicRegionConfig, fn);
            ClientCacheHelper.generateDummyFunctions((ClientCache)dummyCache, functions, fn);
            PoolDescription pd = ccd.getDefaultPoolDescription();
            if (pd != null) {
                ClientCacheHelper.generateDummyPool((ClientCache)dummyCache, pd, fn);
            }
            if ((dsd = ccd.getDefaultDiskStoreDescription()) != null) {
                ClientCacheHelper.generateDummyDiskStore((ClientCache)dummyCache, "DEFAULT", dsd, fn);
            }
            if ((dsd = ccd.getPdxDiskStoreDescription()) != null) {
                ClientCacheHelper.generateDummyDiskStore((ClientCache)dummyCache, dsd.getName(), dsd, fn);
            }
            if (regionConfig != null) {
                DiskStoreDescription dsd2;
                ClientRegionDescription rd = ClientRegionHelper.getClientRegionDescription(regionConfig);
                PoolDescription pd2 = rd.getPoolDescription();
                if (pd2 != null) {
                    ClientCacheHelper.generateDummyPool((ClientCache)dummyCache, pd2, fn);
                }
                if ((dsd2 = rd.getDiskStoreDescription()) != null) {
                    ClientCacheHelper.generateDummyDiskStore((ClientCache)dummyCache, dsd2.getName(), dsd2, fn);
                }
                if (regionNames != null && regionNames.size() > 0) {
                    for (String regionName : regionNames) {
                        ClientCacheHelper.generateDummyRegion((ClientCache)dummyCache, regionConfig, rd, regionName, fn);
                    }
                } else {
                    ClientCacheHelper.generateDummyRegion((ClientCache)dummyCache, regionConfig, rd, null, fn);
                }
            }
        } else {
            if (XmlCacheConfigs.get(fn) == null) {
                String s = "Cache XML file was already created without ClientCacheHelper or from a different JVM using an unknown, and possibly different, configuration: " + fn;
                throw new HydraRuntimeException(s);
            }
            String cc = (String)XmlCacheConfigs.get(fn);
            if (!cc.equals(cacheConfig)) {
                String s = "Cache XML file already exists using cache configuration " + cc + ", cannot also use " + cacheConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            String rc = (String)XmlRegionConfigs.get(fn);
            if (rc == null && regionConfig != null || rc != null && regionConfig == null || rc != null && regionConfig != null && !rc.equals(regionConfig)) {
                String s = "Cache XML file already exists using region configuration " + rc + ", cannot also use " + regionConfig + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            List fc = (List)XmlFunctionConfigs.get(fn);
            List functionNames = ClientCacheHelper.classnamesFor(functions);
            if (fc == null && functionNames != null || fc != null && functionNames == null || fc != null && functionNames != null && (!fc.containsAll(functionNames) || !functionNames.containsAll(fc))) {
                String s = "Cache XML file already exists using functions " + fc + ", cannot also use " + functions + ": " + fn;
                throw new HydraRuntimeException(s);
            }
            return;
        }
        ClientCacheHelper.generateCacheXmlFile(fn, (ClientCache)dummyCache);
    }

    private static ClientCacheCreation generateDummyCache(String cacheConfig, ClientCacheDescription ccd, DynamicRegionFactory.Config dynamicRegionConfig, String fn) {
        if (dynamicRegionConfig != null) {
            ClientCacheHelper.log("Opening the configured DynamicRegionFactory");
            DynamicRegionFactory.get().open(dynamicRegionConfig);
        }
        ClientCacheHelper.log("Adding dummy cache from: " + ccd);
        ClientCacheCreation dummyCache = new ClientCacheCreation();
        ResourceManagerCreation dummyResourceManager = new ResourceManagerCreation();
        dummyCache.setResourceManagerCreation(dummyResourceManager);
        ccd.configureDummy(dummyCache);
        if (dynamicRegionConfig != null) {
            dummyCache.setDynamicRegionFactoryConfig(dynamicRegionConfig);
        }
        ClientCacheHelper.log("Added dummy cache: " + ClientCacheDescription.cacheToString((ClientCache)dummyCache));
        XmlCacheConfigs.put(fn, cacheConfig);
        return dummyCache;
    }

    private static void generateDummyPool(ClientCache dummyCache, PoolDescription pd, String fn) {
        PoolFactory dummyFactory = ((ClientCacheCreation)dummyCache).createPoolFactory();
        pd.configure(dummyFactory);
        String poolName = pd.getName();
        Pool dummyPool = null;
        try {
            dummyPool = dummyFactory.create(poolName);
        }
        catch (IllegalStateException e) {
            String msg = "A pool named \"" + poolName + "\" already exists.";
            throw new HydraRuntimeException(msg, e);
        }
        ClientCacheHelper.log("Added dummy pool: " + PoolHelper.poolToString(dummyPool));
    }

    private static void generateDummyDiskStore(ClientCache dummyCache, String diskStoreName, DiskStoreDescription dsd, String fn) {
        DiskStoreFactory dummyFactory = ((ClientCacheCreation)dummyCache).createDiskStoreFactory();
        dsd.configure(dummyFactory);
        DiskStore dummyDiskStore = null;
        try {
            dummyDiskStore = dummyFactory.create(diskStoreName);
        }
        catch (IllegalStateException e) {
            String msg = "A disk store named \"" + diskStoreName + "\" already exists.";
            throw new HydraRuntimeException(msg, e);
        }
        ClientCacheHelper.log("Added dummy disk store: " + DiskStoreHelper.diskStoreToString(dummyDiskStore));
    }

    private static void generateDummyRegion(ClientCache dummyCache, String regionConfig, ClientRegionDescription rd, String regionName, String fn) {
        if (rd != null) {
            String rName = regionName;
            if (rName == null) {
                rName = rd.getRegionName();
            }
            ClientRegionShortcut shortcut = rd.getClientRegionShortcut();
            ClientCacheHelper.log("Adding dummy region named: " + rName + " from region config " + regionConfig + " using client region shortcut: " + shortcut.toString());
            try {
                Region region = ((ClientCacheCreation)dummyCache).createRegion(rName, shortcut.toString());
                RegionAttributesCreation ratts = new RegionAttributesCreation();
                ((RegionCreation)region).setAttributes((RegionAttributes)ratts, false);
                rd.configure(ratts, false);
                ClientCacheHelper.log("Added dummy region named: " + rName + " with attributes: " + RegionDescription.regionAttributesToString(region.getAttributes()));
            }
            catch (RegionExistsException e) {
                throw new HydraInternalException("Should not happen", (Exception)((Object)e));
            }
            XmlRegionConfigs.put(fn, regionConfig);
        }
    }

    private static void generateDummyFunctions(ClientCache dummyCache, List functions, String fn) {
        if (functions != null) {
            ClientCacheHelper.log("Adding dummy functions: " + functions);
            FunctionServiceCreation fsc = new FunctionServiceCreation();
            for (Function function : functions) {
                fsc.registerFunction(function);
            }
            ((ClientCacheCreation)dummyCache).setFunctionServiceCreation(fsc);
            ClientCacheHelper.log("Added dummy functions: " + fsc.getFunctions());
            XmlFunctionConfigs.put(fn, ClientCacheHelper.classnamesFor(functions));
        }
    }

    private static List classnamesFor(List objs) {
        ArrayList<String> classnames = null;
        if (objs != null) {
            classnames = new ArrayList<String>();
            for (Object obj : objs) {
                classnames.add(obj.getClass().getName());
            }
        }
        return classnames;
    }

    private static void generateCacheXmlFile(String fn, ClientCache dummyCache) {
        ClientCacheHelper.log("Generating XML file: " + fn);
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(new File(fn)));
        }
        catch (IOException e) {
            String s = "Unable to open file: " + fn;
            throw new HydraRuntimeException(s, e);
        }
        CacheXmlGenerator.generate((ClientCache)dummyCache, (PrintWriter)pw);
        ClientCacheHelper.log("Generated XML file: " + fn);
    }

    public static synchronized ClientCache getCache() {
        ClientCache c = null;
        try {
            c = ClientCacheFactory.getAnyInstance();
        }
        catch (CancelException cancelException) {
            // empty catch block
        }
        return c;
    }

    public static synchronized void closeCache() {
        ClientCache cache = ClientCacheHelper.getCache();
        if (cache != null) {
            ClientCacheHelper.log("Closing cache: " + ClientCacheHelper.cacheToString(cache));
            cache.close();
            ClientCacheHelper.log("Closed cache");
            TheCacheConfig = null;
        }
    }

    public static String cacheToString(ClientCache cache) {
        return ClientCacheDescription.cacheToString(cache);
    }

    public static ClientCacheDescription getClientCacheDescription(String cacheConfig) {
        if (cacheConfig == null) {
            throw new IllegalArgumentException("cacheConfig cannot be null");
        }
        ClientCacheHelper.log("Looking up cache config: " + cacheConfig);
        ClientCacheDescription ccd = TestConfig.getInstance().getClientCacheDescription(cacheConfig);
        if (ccd == null) {
            String s = cacheConfig + " not found in " + BasePrms.nameForKey(ClientCachePrms.names);
            throw new HydraRuntimeException(s);
        }
        ClientCacheHelper.log("Looked up client cache config:\n" + ccd);
        return ccd;
    }

    private static synchronized void log(String s) {
        if (log == null) {
            log = Log.getLogWriter();
        }
        if (log.infoEnabled()) {
            log.info(s);
        }
    }

    static {
        XmlCacheConfigs = new HashMap();
        XmlRegionConfigs = new HashMap();
        XmlFunctionConfigs = new HashMap();
    }
}

