/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.HARegion;
import com.gemstone.gemfire.internal.cache.ha.HAHelper;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.HaHelper;
import hct.ha.HAClientQueueBB;
import hydra.DistributedSystemHelper;
import hydra.Log;
import java.util.HashMap;
import java.util.Iterator;

public class HAServerEventListener
extends CacheListenerAdapter {
    public void afterCreate(EntryEvent event) {
        if (event.getKey().equals("last_key")) {
            Cache cache = event.getRegion().getCache();
            Iterator itr = cache.getCacheServers().iterator();
            BridgeServerImpl server = (BridgeServerImpl)itr.next();
            for (CacheClientProxy proxy : server.getAcceptor().getCacheClientNotifier().getClientProxies()) {
                if (!HaHelper.checkPrimary(proxy)) continue;
                ClientProxyMembershipID proxyID = proxy.getProxyID();
                Log.getLogWriter().info("Proxy id : " + proxyID.toString());
                HARegion region = (HARegion)proxy.getHARegion();
                HARegionQueue haRegionQueue = HAHelper.getRegionQueue(region);
                HashMap<String, Long> statMap = new HashMap<String, Long>();
                statMap.put("eventsPut", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsEnqued()));
                statMap.put("eventsConflated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated()));
                statMap.put("eventsRemoved", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsRemoved()));
                statMap.put("eventsExpired", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsExpired()));
                statMap.put("eventsRemovedByQRM", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsRemovedByQrm()));
                statMap.put("NumSequenceViolated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getNumSequenceViolated()));
                statMap.put("eventsTaken", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsTaken()));
                statMap.put("numVoidRemovals", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getNumVoidRemovals()));
                Log.getLogWriter().info("StatMap  : " + statMap.toString());
                String proxyIdStr = proxyID.toString();
                if (DistributedSystemHelper.getGemFireDescription().getEnableNetworkPartitionDetection().booleanValue()) {
                    proxyIdStr = proxyIdStr.substring(proxyIdStr.lastIndexOf("(") + 1, proxyIdStr.indexOf(":"));
                }
                HAClientQueueBB.getBB().getSharedMap().put(proxyIdStr, statMap);
                HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_GLOBAL_CONFLATE, HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated());
            }
        }
    }

    public static void putHAStatsInBlackboard() {
        try {
            Thread.sleep(240000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        Iterator itr = cache.getCacheServers().iterator();
        BridgeServerImpl server = (BridgeServerImpl)itr.next();
        for (CacheClientProxy proxy : server.getAcceptor().getCacheClientNotifier().getClientProxies()) {
            if (!HaHelper.checkPrimary(proxy)) continue;
            ClientProxyMembershipID proxyID = proxy.getProxyID();
            Log.getLogWriter().info("Proxy id : " + proxyID.toString());
            HARegion region = (HARegion)proxy.getHARegion();
            HARegionQueue haRegionQueue = HAHelper.getRegionQueue(region);
            HashMap<String, Long> statMap = new HashMap<String, Long>();
            statMap.put("eventsPut", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsEnqued() - 1L));
            statMap.put("eventsConflated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated()));
            statMap.put("eventsRemoved", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsRemoved() - 1L));
            statMap.put("eventsExpired", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsExpired()));
            statMap.put("eventsRemovedByQRM", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsRemovedByQrm()));
            statMap.put("NumSequenceViolated", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getNumSequenceViolated()));
            statMap.put("eventsTaken", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getEventsTaken()));
            statMap.put("numVoidRemovals", new Long(HAHelper.getRegionQueueStats(haRegionQueue).getNumVoidRemovals()));
            Log.getLogWriter().info("new StatssMap  : " + statMap.toString());
            HAClientQueueBB.getBB().getSharedMap().put(proxyID.toString(), statMap);
            HAClientQueueBB.getBB().getSharedCounters().add(HAClientQueueBB.NUM_GLOBAL_CONFLATE, HAHelper.getRegionQueueStats(haRegionQueue).getEventsConflated());
        }
    }
}

