/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import hct.ha.HAClientQueue;
import hct.ha.HAClientQueueBB;
import hct.ha.Validator;
import hydra.DistributedSystemHelper;
import hydra.Log;
import hydra.blackboard.SharedMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import util.TestException;
import util.TestHelper;

public class HANoFailoverConflationEnabledClientListener
extends CacheListenerAdapter {
    private final Map latestValues = new HashMap();

    public void afterCreate(EntryEvent event) {
        Long value;
        ++Validator.createCount;
        String key = (String)event.getKey();
        if (key.equals("last_key")) {
            HAClientQueue.lastKeyReceived = true;
            Log.getLogWriter().info("'last_key' received at client");
        }
        if ((value = (Long)event.getNewValue()) == null) {
            HANoFailoverConflationEnabledClientListener.throwException("value in afterCreate cannot be null: key = " + key);
            return;
        }
        if (value != 0L) {
            this.validateIncrementedNewValue(key, value);
        }
        this.latestValues.put(key, value);
    }

    public void afterUpdate(EntryEvent event) {
        ++Validator.updateCount;
        String key = (String)event.getKey();
        Long newValue = (Long)event.getNewValue();
        Long oldValue = (Long)event.getOldValue();
        if (newValue == null) {
            HANoFailoverConflationEnabledClientListener.throwException("newValue in afterUpdate cannot be null: key = " + key);
            return;
        }
        if (oldValue == null) {
            this.validateIncrementedNewValue(key, newValue);
        } else if (newValue <= oldValue) {
            HANoFailoverConflationEnabledClientListener.throwException("newValue must be greater than oldValue , but was not for key = " + key + " & newVal = " + newValue + " oldValue = " + oldValue);
            return;
        }
        this.latestValues.put(key, newValue);
    }

    public void afterInvalidate(EntryEvent event) {
        ++Validator.invalidateCount;
        String key = (String)event.getKey();
        Long oldValue = (Long)event.getOldValue();
        if (oldValue == null) {
            HANoFailoverConflationEnabledClientListener.throwException("oldValue in afterInvalidate cannot be null : key = " + key);
            return;
        }
        this.latestValues.put(key, oldValue);
    }

    public void afterDestroy(EntryEvent event) {
        ++Validator.destroyCount;
        String key = (String)event.getKey();
        Long value = (Long)event.getOldValue();
        if (value != null) {
            this.latestValues.put(key, value);
        }
    }

    private void validateIncrementedNewValue(String key, Long newValue) {
        Long oldValue = (Long)this.latestValues.get(key);
        if (oldValue == null) {
            HANoFailoverConflationEnabledClientListener.throwException("oldValue in latestValues cannot be null: key = " + key + " & newVal = " + newValue);
            return;
        }
        long diff = newValue - oldValue;
        if (diff <= 0L) {
            HANoFailoverConflationEnabledClientListener.throwException("newValue must be greater than oldValue , but it was not for key = " + key + " & newVal = " + newValue + " oldValue = " + oldValue);
            return;
        }
    }

    public static void throwException(String reason) {
        ArrayList reasonArray = null;
        DistributedSystem ds = DistributedSystemHelper.getDistributedSystem();
        String clientName = "CLIENT_" + ds.getName();
        SharedMap shMap = HAClientQueueBB.getBB().getSharedMap();
        reasonArray = !shMap.containsKey(clientName) ? new ArrayList() : (ArrayList)shMap.get(clientName);
        reasonArray.add(reason);
        shMap.put(clientName, reasonArray);
        HAClientQueueBB.getBB().getSharedCounters().increment(HAClientQueueBB.NUM_EXCEPTION);
        Log.getLogWriter().info("Exception : " + TestHelper.getStackTrace(new TestException(reason)));
    }
}

