/*
 * Decompiled with CFR 0.152.
 */
package hct.ha;

import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.util.CacheListenerAdapter;
import hct.ha.HAClientQueueBB;
import hydra.Log;
import hydra.MasterController;
import hydra.blackboard.SharedCounters;

public class EmptyQueueListener
extends CacheListenerAdapter {
    public static boolean stableStateAchieved = false;

    public void afterCreate(EntryEvent event) {
        this.verify("afterCreate");
    }

    public void afterUpdate(EntryEvent event) {
        this.verify("afterUpdate");
    }

    public void afterInvalidate(EntryEvent event) {
        this.verify("afterInvalidate");
    }

    public void afterDestroy(EntryEvent event) {
        this.verify("afterDestroy");
    }

    public static void setStableStateAchievedAndSleep() {
        SharedCounters counters = HAClientQueueBB.getBB().getSharedCounters();
        Log.getLogWriter().info("Waiting for feed signal...");
        do {
            MasterController.sleepForMs(3000);
        } while (counters.read(HAClientQueueBB.feedSignal) <= 0L);
        Log.getLogWriter().info("Got feed signal...");
        try {
            Thread.sleep(180000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        stableStateAchieved = true;
        Log.getLogWriter().info("Setting stable signal...");
        counters.increment(HAClientQueueBB.stableSignal);
    }

    public void verify(String operation) {
        if (stableStateAchieved) {
            String reason = "Received an " + operation + " operation when it was not expected";
            long exceptionNumber = HAClientQueueBB.getBB().getSharedCounters().incrementAndRead(HAClientQueueBB.NUM_EXCEPTION);
            HAClientQueueBB.getBB().getSharedMap().put(new Long(exceptionNumber), reason);
        }
    }
}

