/*
 * Decompiled with CFR 0.152.
 */
package hct.backwardCompatibility;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.internal.GemFireVersion;
import cq.CQUtil;
import cq.CQUtilPrms;
import hct.backwardCompatibility.BackwardCompatibilityPrms;
import hct.backwardCompatibility.BackwardCompatibilityVersionHelper;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ConfigPrms;
import hydra.DiskStoreHelper;
import hydra.Log;
import hydra.ProcessMgr;
import hydra.RegionDescription;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import parReg.ParRegPrms;
import util.NameFactory;
import util.RandomValues;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.ValueHolder;

public class BackwardCompatibilityTest {
    static Random rand = new Random();
    static BackwardCompatibilityTest testInstance;
    static Region aRegion;
    protected static final int ENTRY_ADD_OPERATION = 1;
    protected static final int ENTRY_DESTROY_OPERATION = 2;
    protected static final int ENTRY_INVALIDATE_OPERATION = 3;
    protected static final int ENTRY_LOCAL_DESTROY_OPERATION = 4;
    protected static final int ENTRY_LOCAL_INVALIDATE_OPERATION = 5;
    protected static final int ENTRY_UPDATE_OPERATION = 6;
    protected static final int ENTRY_GET_OPERATION = 7;
    protected static final int ENTRY_GET_NEW_OPERATION = 8;
    protected static final int PUT_IF_ABSENT_OPERATION = 9;
    protected static final int REMOVE_OPERATION = 10;
    protected static final int REPLACE_OPERATION = 11;
    protected static final int ENTRY_PUTALL_OPERATION = 12;
    protected static final String getCallbackPrefix = "Get originated in pid ";
    protected static final String createCallbackPrefix = "Create event originated in pid ";
    protected static final String updateCallbackPrefix = "Update event originated in pid ";
    protected static final String invalidateCallbackPrefix = "Invalidate event originated in pid ";
    protected static final String destroyCallbackPrefix = "Destroy event originated in pid ";
    protected static final String regionInvalidateCallbackPrefix = "Region invalidate event originated in pid ";
    protected static final String regionDestroyCallbackPrefix = "Region destroy event originated in pid ";
    protected static final String VmIDStr = "VmId_";
    protected boolean isOldClient = false;
    protected long minTaskGranularitySec;
    protected long minTaskGranularityMS;
    protected int numOpsPerTask;
    protected RandomValues randomValues = new RandomValues();
    protected int upperThreshold;
    protected int lowerThreshold;

    public static synchronized void HydraTask_initializeBridgeServer() {
        if (testInstance == null) {
            testInstance = new BackwardCompatibilityTest();
            testInstance.initializePrms();
            testInstance.initializeBridgeServer();
        }
    }

    protected void initializeBridgeServer() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            AttributesFactory factory = RegionHelper.getAttributesFactory(regionConfig);
            if (this.requiresPersistence(rd)) {
                String diskStoreConfig = ConfigPrms.getDiskStoreConfig();
                DiskStoreHelper.createDiskStore(diskStoreConfig);
                factory.setDiskStoreName(diskStoreConfig);
            }
            aRegion = RegionHelper.createRegion(rd.getRegionName(), factory);
            BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
        }
    }

    public static synchronized void HydraTask_initializeBridgeClient() {
        if (testInstance == null) {
            testInstance = new BackwardCompatibilityTest();
            testInstance.initializePrms();
            testInstance.initializeBridgeClient();
        }
    }

    protected void initializeBridgeClient() {
        if (CacheHelper.getCache() == null) {
            CacheHelper.createCache(ConfigPrms.getCacheConfig());
            String regionConfig = ConfigPrms.getRegionConfig();
            RegionHelper.createRegion(regionConfig);
            RegionDescription rd = RegionHelper.getRegionDescription(regionConfig);
            aRegion = RegionHelper.getRegion(rd.getRegionName());
        }
        if (TestConfig.tab().booleanAt(CQUtilPrms.useCQ, false)) {
            CQUtil.initialize();
            CQUtil.initializeCQService();
            CQUtil.registerCQ(aRegion);
        }
        if (BackwardCompatibilityPrms.registerInterest()) {
            aRegion.registerInterest((Object)"ALL_KEYS", InterestResultPolicy.KEYS_VALUES);
            Log.getLogWriter().info("Registered interest in ALL_KEYS");
        }
    }

    protected boolean requiresPersistence(RegionDescription rd) {
        return rd.getDataPolicy().withPersistence() || rd.getEvictionAttributes() != null && rd.getEvictionAttributes().getAction().isOverflowToDisk();
    }

    public static void HydraTask_doEntryOperations() {
        testInstance.doEntryOperations(aRegion);
    }

    protected void doEntryOperations(Region aRegion) {
        new BackwardCompatibilityVersionHelper().doEntryOperations(testInstance, aRegion);
    }

    protected void doRandomOp(Region aRegion) {
        int whichOp = this.getOperation(BackwardCompatibilityPrms.entryOperations);
        int size = aRegion.size();
        if (size >= this.upperThreshold) {
            whichOp = this.getOperation(BackwardCompatibilityPrms.upperThresholdOperations);
        } else if (size <= this.lowerThreshold) {
            whichOp = this.getOperation(BackwardCompatibilityPrms.lowerThresholdOperations);
        }
        switch (whichOp) {
            case 1: {
                this.addEntry(aRegion);
                break;
            }
            case 3: {
                this.invalidateEntry(aRegion, false);
                break;
            }
            case 2: {
                this.destroyEntry(aRegion, false);
                break;
            }
            case 6: {
                this.updateEntry(aRegion);
                break;
            }
            case 7: {
                this.getKey(aRegion);
                break;
            }
            case 8: {
                this.getNewKey(aRegion);
                break;
            }
            case 5: {
                this.invalidateEntry(aRegion, true);
                break;
            }
            case 4: {
                this.destroyEntry(aRegion, true);
                break;
            }
            case 9: {
                if (this.isOldClient) {
                    this.addEntry(aRegion);
                    break;
                }
                this.putIfAbsent(aRegion, true);
                break;
            }
            case 10: {
                if (this.isOldClient) {
                    this.destroyEntry(aRegion, false);
                    break;
                }
                this.remove(aRegion);
                break;
            }
            case 11: {
                if (this.isOldClient) {
                    this.updateEntry(aRegion);
                    break;
                }
                this.replace(aRegion);
                break;
            }
            case 12: {
                this.putAll(aRegion);
                break;
            }
            default: {
                throw new TestException("Unknown operation " + whichOp);
            }
        }
    }

    public static void HydraTask_testClientServerMessaging() {
        testInstance.testClientServerMessaging();
    }

    protected void testClientServerMessaging() {
        Log.getLogWriter().info("Invoking client/server cmds on " + aRegion.getFullPath());
    }

    public void initializePrms() {
        this.isOldClient = GemFireVersion.getGemFireVersion().equals("6.1.2");
        this.minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, Long.MAX_VALUE);
        this.minTaskGranularityMS = this.minTaskGranularitySec == Long.MAX_VALUE ? Long.MAX_VALUE : this.minTaskGranularitySec * 1000L;
        this.numOpsPerTask = BackwardCompatibilityPrms.numOpsPerTask();
        this.upperThreshold = TestConfig.tab().intAt(BackwardCompatibilityPrms.upperThreshold, Integer.MAX_VALUE);
        this.lowerThreshold = TestConfig.tab().intAt(BackwardCompatibilityPrms.lowerThreshold, -1);
        Log.getLogWriter().info("minTaskGranularitySec " + this.minTaskGranularitySec + ", minTaskGranularityMS " + this.minTaskGranularityMS + ", isOldClient " + this.isOldClient + ", numOpsPerTask " + this.numOpsPerTask + ", upperThreshold " + this.upperThreshold + ", lowerThreshold " + this.lowerThreshold);
    }

    protected void addEntry(Region aRegion) {
        Object key = this.getNewKey();
        ValueHolder anObj = this.getValueForKey(key);
        String callback = createCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + " cacheWriterParam is " + callback + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj, (Object)callback);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            } else {
                Log.getLogWriter().info("addEntry: calling create for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
                aRegion.create(key, (Object)anObj);
                Log.getLogWriter().info("addEntry: done creating key " + key);
            }
        } else if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + " callback is " + callback + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        } else {
            Log.getLogWriter().info("addEntry: calling put for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath());
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("addEntry: done putting key " + key);
        }
    }

    protected void putIfAbsent(Region aRegion, boolean logAddition) {
        Iterator it;
        Set aSet;
        Object key = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        if (randInt <= 25 && (aSet = aRegion.keySet()).size() > 0 && (it = aSet.iterator()).hasNext()) {
            key = it.next();
        }
        if (key == null) {
            key = this.getNewKey();
        }
        ValueHolder anObj = this.getValueForKey(key);
        if (logAddition) {
            Log.getLogWriter().info("putIfAbsent: calling putIfAbsent for key " + key + ", object " + TestHelper.toString(anObj) + ", region is " + aRegion.getFullPath() + ".");
        }
        Object prevVal = null;
        prevVal = aRegion.putIfAbsent(key, (Object)anObj);
    }

    protected void putAll(Region r) {
        int beforeSize = r.size();
        String numPutAllNewKeys = TestConfig.tab().stringAt(ParRegPrms.numPutAllNewKeys);
        int numNewKeysToPut = 0;
        if (numPutAllNewKeys.equalsIgnoreCase("useThreshold")) {
            numNewKeysToPut = this.upperThreshold - beforeSize;
            if (numNewKeysToPut <= 0) {
                numNewKeysToPut = 1;
            } else {
                int max = TestConfig.tab().intAt(ParRegPrms.numPutAllMaxNewKeys, numNewKeysToPut);
                max = Math.min(numNewKeysToPut, max);
                int min = TestConfig.tab().intAt(ParRegPrms.numPutAllMinNewKeys, 1);
                min = Math.min(min, max);
                numNewKeysToPut = TestConfig.tab().getRandGen().nextInt(min, max);
            }
        } else {
            numNewKeysToPut = Integer.valueOf(numPutAllNewKeys);
        }
        Map mapToPut = null;
        int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
        mapToPut = randInt <= 25 ? new HashMap() : (randInt <= 50 ? new Hashtable() : (randInt <= 75 ? new TreeMap() : new LinkedHashMap()));
        StringBuffer newKeys = new StringBuffer();
        for (int i = 1; i <= numNewKeysToPut; ++i) {
            Object key = this.getNewKey();
            ValueHolder anObj = this.getValueForKey(key);
            mapToPut.put(key, anObj);
            newKeys.append(key + " ");
            if (i % 10 != 0) continue;
            newKeys.append("\n");
        }
        int numPutAllExistingKeys = TestConfig.tab().intAt(ParRegPrms.numPutAllExistingKeys);
        List keyList = this.getExistingKeys(r, numPutAllExistingKeys);
        StringBuffer existingKeys = new StringBuffer();
        if (keyList.size() != 0) {
            for (int i = 0; i < keyList.size(); ++i) {
                Object key = keyList.get(i);
                ValueHolder anObj = this.getUpdateObject(r, key);
                mapToPut.put(key, anObj);
                existingKeys.append(key + " ");
                if ((i + 1) % 10 != 0) continue;
                existingKeys.append("\n");
            }
        }
        Log.getLogWriter().info("Region size is " + r.size() + ", map to use as argument to putAll is " + mapToPut.getClass().getName() + " containing " + numNewKeysToPut + " new keys and " + keyList.size() + " existing keys (updates); total map size is " + mapToPut.size() + "\nnew keys are: " + newKeys + "\nexisting keys are: " + existingKeys);
        for (Object key : mapToPut.keySet()) {
            Log.getLogWriter().info("putAll map key " + key + ", value " + TestHelper.toString(mapToPut.get(key)));
        }
        Log.getLogWriter().info("putAll: calling putAll with map of " + mapToPut.size() + " entries");
        r.putAll(mapToPut);
        Log.getLogWriter().info("putAll: done calling putAll with map of " + mapToPut.size() + " entries");
    }

    protected void invalidateEntry(Region aRegion, boolean isLocalInvalidate) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            return;
        }
        try {
            String callback = invalidateCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalInvalidate) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key + " callback is " + callback);
                    aRegion.localInvalidate(key, (Object)callback);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                } else {
                    Log.getLogWriter().info("invalidateEntry: local invalidate for " + key);
                    aRegion.localInvalidate(key);
                    Log.getLogWriter().info("invalidateEntry: done with local invalidate for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key + " callback is " + callback);
                aRegion.invalidate(key, (Object)callback);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            } else {
                Log.getLogWriter().info("invalidateEntry: invalidating key " + key);
                aRegion.invalidate(key);
                Log.getLogWriter().info("invalidateEntry: done invalidating key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void destroyEntry(Region aRegion, boolean isLocalDestroy) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        try {
            String callback = destroyCallbackPrefix + ProcessMgr.getProcessId();
            if (isLocalDestroy) {
                if (TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key + " callback is " + callback);
                    aRegion.localDestroy(key, (Object)callback);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                } else {
                    Log.getLogWriter().info("destroyEntry: local destroy for " + key);
                    aRegion.localDestroy(key);
                    Log.getLogWriter().info("destroyEntry: done with local destroy for " + key);
                }
            } else if (TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("destroyEntry: destroying key " + key + " callback is " + callback);
                aRegion.destroy(key, (Object)callback);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            } else {
                Log.getLogWriter().info("destroyEntry: destroying key " + key);
                aRegion.destroy(key);
                Log.getLogWriter().info("destroyEntry: done destroying key " + key);
            }
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void remove(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("remove: No names in region");
            return;
        }
        try {
            Object name = iter.next();
            Object oldVal = aRegion.get(name);
            this.remove(aRegion, name, oldVal);
        }
        catch (NoSuchElementException e) {
            throw new TestException("Bug 30171 detected: " + TestHelper.getStackTrace(e));
        }
    }

    private void remove(Region aRegion, Object name, Object oldVal) {
        try {
            int randInt = TestConfig.tab().getRandGen().nextInt(1, 100);
            if (randInt <= 25) {
                oldVal = this.getUpdateObject(aRegion, name);
            }
            Log.getLogWriter().info("remove: removing " + name + " with previous value " + oldVal + ".");
            boolean removed = aRegion.remove(name, oldVal);
            Log.getLogWriter().info("remove: done removing " + name);
        }
        catch (EntryNotFoundException e) {
            Log.getLogWriter().info("Caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
            return;
        }
    }

    protected void updateEntry(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        ValueHolder anObj = this.getUpdateObject(aRegion, key);
        String callback = updateCallbackPrefix + ProcessMgr.getProcessId();
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj) + ", callback is " + callback);
            aRegion.put(key, (Object)anObj, (Object)callback);
            Log.getLogWriter().info("Done with call to put (update)");
        } else {
            Log.getLogWriter().info("updateEntry: replacing key " + key + " with " + TestHelper.toString(anObj));
            aRegion.put(key, (Object)anObj);
            Log.getLogWriter().info("Done with call to put (update)");
        }
    }

    protected void replace(Region aRegion) {
        Set aSet = aRegion.keys();
        Iterator iter = aSet.iterator();
        if (!iter.hasNext()) {
            Log.getLogWriter().info("replace: No names in region");
            return;
        }
        Object name = iter.next();
        this.replace(aRegion, name);
    }

    protected void replace(Region aRegion, Object name) {
        Object anObj = null;
        Object prevVal = null;
        boolean replaced = false;
        try {
            anObj = aRegion.get(name);
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        ValueHolder newObj = this.getUpdateObject(aRegion, name);
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                anObj = this.getUpdateObject(aRegion, name);
            }
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + "; old value is " + TestHelper.toString(anObj) + ".");
            replaced = aRegion.replace(name, anObj, (Object)newObj);
        } else {
            if (TestConfig.tab().getRandGen().nextBoolean()) {
                name = this.getNewKey();
            }
            Log.getLogWriter().info("replace: replacing name " + name + " with " + TestHelper.toString(newObj) + ".");
            prevVal = aRegion.replace(name, (Object)newObj);
            if (prevVal != null) {
                replaced = true;
            }
        }
        Log.getLogWriter().info("Done with call to replace");
    }

    protected void getKey(Region aRegion) {
        Object key = this.getExistingKey(aRegion);
        if (key == null) {
            int size = aRegion.size();
            return;
        }
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getKey: getting key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        } else {
            Log.getLogWriter().info("getKey: getting key " + key);
            anObj = aRegion.get(key);
            Log.getLogWriter().info("getKey: got value for key " + key + ": " + TestHelper.toString(anObj));
        }
    }

    protected void getNewKey(Region aRegion) {
        Object key = this.getNewKey();
        String callback = getCallbackPrefix + ProcessMgr.getProcessId();
        int beforeSize = aRegion.size();
        Object anObj = null;
        if (TestConfig.tab().getRandGen().nextBoolean()) {
            Log.getLogWriter().info("getNewKey: getting new key " + key + ", callback is " + callback);
            anObj = aRegion.get(key, (Object)callback);
        } else {
            Log.getLogWriter().info("getNewKey: getting new key " + key);
            anObj = aRegion.get(key);
        }
        Log.getLogWriter().info("getNewKey: done getting value for new key " + key + ": " + TestHelper.toString(anObj));
    }

    public ValueHolder getValueForKey(Object key) {
        return new ValueHolder((String)key, this.randomValues);
    }

    protected Object getNewKey() {
        String key = NameFactory.getNextPositiveObjectName();
        return key;
    }

    protected Object getRecentKey(Region aRegion, int recentHistory) {
        long maxNames = NameFactory.getPositiveNameCounter();
        if (maxNames <= 0L) {
            return null;
        }
        long keyIndex = TestConfig.tab().getRandGen().nextLong(Math.max(maxNames - (long)recentHistory, 1L), maxNames);
        String key = NameFactory.getObjectNameForCounter(keyIndex);
        return key;
    }

    protected ValueHolder getUpdateObject(Region aRegion, Object key) {
        ValueHolder anObj = (ValueHolder)aRegion.get(key);
        ValueHolder newObj = null;
        newObj = anObj == null ? (key instanceof String ? new ValueHolder((String)key, this.randomValues) : new ValueHolder(key, this.randomValues)) : (ValueHolder)anObj.getAlternateValueHolder(this.randomValues);
        return newObj;
    }

    protected int getOperation(Long whichPrm) {
        int op = 0;
        String operation = TestConfig.tab().stringAt(whichPrm);
        if (operation.equals("add")) {
            op = 1;
        } else if (operation.equals("update")) {
            op = 6;
        } else if (operation.equals("invalidate")) {
            op = 3;
        } else if (operation.equals("destroy")) {
            op = 2;
        } else if (operation.equals("get")) {
            op = 7;
        } else if (operation.equals("getNew")) {
            op = 8;
        } else if (operation.equals("localInvalidate")) {
            op = 5;
        } else if (operation.equals("localDestroy")) {
            op = 4;
        } else if (operation.equals("putIfAbsent")) {
            op = 9;
        } else if (operation.equals("remove")) {
            op = 10;
        } else if (operation.equals("replace")) {
            op = 11;
        } else if (operation.equals("putAll")) {
            op = 12;
        } else {
            throw new TestException("Unknown entry operation: " + operation);
        }
        return op;
    }

    protected Object getExistingKey(Region aRegion) {
        Object key = null;
        Object[] keyList = aRegion.keySet().toArray();
        int index = TestConfig.tab().getRandGen().nextInt(0, keyList.length - 1);
        if (index > 0) {
            key = keyList[index];
        }
        return key;
    }

    protected List getExistingKeys(Region aRegion, int numKeysToGet) {
        Log.getLogWriter().info("Trying to get " + numKeysToGet + " existing keys...");
        ArrayList keyList = new ArrayList();
        Set aSet = aRegion.keySet();
        Iterator it = aSet.iterator();
        while (it.hasNext()) {
            keyList.add(it.next());
            if (keyList.size() < numKeysToGet) continue;
            return keyList;
        }
        return keyList;
    }
}

