/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import hct.HctPrms;
import hct.UseCase1BB;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.Log;
import hydra.MasterController;
import hydra.PoolHelper;
import hydra.RegionHelper;
import hydra.TestConfig;
import java.io.File;
import java.rmi.RemoteException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import util.TestException;

public class UseCase1Client {
    public static final String REGION_NAME = "/root/day0";
    static Region edgeRegion;
    static int readMin_;
    static int readMax_;
    static int sleepTime_;
    public static int MAX_DATA_ALLOWED;
    public static final String[] REGION_NAMES;
    public static Region[] _regions;
    public static Random rand;

    public static void initServerCache() {
        String bridgeName = System.getProperty("clientName");
        for (int i = 0; i <= 7; ++i) {
            File aDir = new File(bridgeName + "_diskDir_day" + i);
            aDir.mkdir();
        }
        String cacheXmlFile = "$JTESTS/hct/" + bridgeName + ".xml";
        CacheHelper.createCacheFromXml(cacheXmlFile);
        UseCase1Client.displayRegions();
    }

    protected static void displayRegions() {
        Set rootRegions = CacheHelper.getCache().rootRegions();
        for (Region parentRegion : rootRegions) {
            Log.getLogWriter().info(RegionHelper.regionAttributesToString(parentRegion.getAttributes()));
            Set subRegions = parentRegion.subregions(true);
            for (Region subregion : subRegions) {
                Log.getLogWriter().info(RegionHelper.regionAttributesToString(subregion.getAttributes()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initEdgeCache() throws Exception {
        Cache cache = CacheHelper.createCache("cache");
        Region rootRegion = RegionHelper.createRegion("root", "edgeRoot");
        Class<UseCase1Client> clazz = UseCase1Client.class;
        synchronized (UseCase1Client.class) {
            if (rootRegion.subregions(true).size() == 0) {
                Region day0Region;
                RegionAttributes ratts = RegionHelper.getRegionAttributes("edge");
                if (ratts.getPoolName() != null) {
                    PoolHelper.createPool(ratts.getPoolName());
                }
                edgeRegion = day0Region = rootRegion.createSubregion("day0", ratts);
                for (int i = 0; i < 10; ++i) {
                    day0Region.get((Object)new Long(i));
                    Log.getLogWriter().info("Retrieved entry " + i + " from Region " + day0Region.getName());
                }
                UseCase1Client.displayRegions();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void initFeederCache() throws Exception {
        Cache cache = CacheHelper.createCache("cache");
        Region rootRegion = RegionHelper.createRegion("root", "feedRoot");
        Class<UseCase1Client> clazz = UseCase1Client.class;
        synchronized (UseCase1Client.class) {
            if (rootRegion.subregions(true).size() == 0) {
                RegionAttributes ratts = RegionHelper.getRegionAttributes("feed");
                for (int i = 0; i < REGION_NAMES.length; ++i) {
                    rootRegion.createSubregion(REGION_NAMES[i], ratts);
                }
                UseCase1Client.displayRegions();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static void stopServers() throws ClientVmNotFoundException {
        MasterController.sleepForMs(30000);
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        for (int i = 0; i < endpoints.size() - 1; ++i) {
            BridgeHelper.Endpoint endpoint = endpoints.get(i);
            ClientVmInfo target = new ClientVmInfo(endpoint);
            ClientVmMgr.stop("Stopping cache server", -22, -31, target);
            MasterController.sleepForMs(30000);
            MasterController.sleepForMs(30000);
        }
    }

    public static void invoke() throws RemoteException {
        Integer numEntries = (Integer)UseCase1BB.getInstance().getSharedMap().get(REGION_NAME);
        int entryCount_ = numEntries;
        Log.getLogWriter().info("Retrieved numEntries from BB " + entryCount_);
        int totalGets = 0;
        Random rand = new Random();
        long getsTime = 0L;
        int getCount = readMin_ + rand.nextInt(readMax_ - readMin_);
        long startTime = System.currentTimeMillis() * 1000000L;
        for (int i = 0; i < getCount; ++i) {
            Integer randomKey = new Integer(rand.nextInt(entryCount_));
            UseCase1Client.fetch(randomKey);
            Log.getLogWriter().fine("fetched " + randomKey);
            ++totalGets;
        }
        long endTime = System.currentTimeMillis() * 1000000L;
        getsTime += endTime - startTime;
        long sleeptime = 0L;
        try {
            long s = System.currentTimeMillis() * 1000000L;
            Thread.sleep(sleepTime_);
            long e = System.currentTimeMillis() * 1000000L;
            sleeptime = e - s;
        }
        catch (Exception exception) {
            // empty catch block
        }
        Log.getLogWriter().fine(Long.toString(getsTime) + ":" + Integer.toString(totalGets) + ":sleeptime=" + Long.toString(sleeptime) + ":sleepTime_=" + Integer.toString(sleepTime_));
        Log.getLogWriter().info("totalGets = " + totalGets);
        ClientHelper.release(edgeRegion);
    }

    public static void fetch(int randomKey) throws RemoteException {
        try {
            Region _region = CacheHelper.getCache().getRegion(REGION_NAME);
            _region.get((Object)new Long(randomKey));
        }
        catch (Exception e) {
            throw new TestException("exception in region.get(): ", e);
        }
    }

    public static synchronized void runFeeder() throws Exception {
        rand = new Random();
        Cache myCache = CacheHelper.getCache();
        Region parentRegion = myCache.getRegion("root");
        Set subRegions = parentRegion.subregions(true);
        int i = 0;
        for (Region aRegion : subRegions) {
            UseCase1Client._regions[i] = myCache.getRegion(aRegion.getFullPath());
            Log.getLogWriter().info("Retrieved region: " + _regions[i].getFullPath() + " (scope=" + _regions[i].getAttributes().getScope() + ")");
            ++i;
        }
        int averageSize = TestConfig.tab().intAt(HctPrms.averageSize, 2048);
        for (i = 0; i < REGION_NAMES.length; ++i) {
            int totalData = 0;
            int currentKey = 0;
            Log.getLogWriter().info("Populating " + _regions[i].getName() + " with byte arrays of size within 20% of " + averageSize);
            while (totalData < MAX_DATA_ALLOWED) {
                byte[] value = new byte[UseCase1Client.randomSize(averageSize, 20)];
                _regions[i].put((Object)new Integer(currentKey), (Object)value);
                totalData += value.length;
                ++currentKey;
            }
            _regions[i].put((Object)"NUM_ENTRIES", (Object)new Integer(currentKey));
            Log.getLogWriter().info("Created " + currentKey + " entries in " + _regions[i].getName() + " with " + totalData + " bytes.");
            UseCase1BB.getInstance().getSharedMap().put(_regions[i].getFullPath(), new Integer(currentKey));
        }
        UseCase1BB.getInstance().print();
    }

    public static int randomSize(int average, int rangePercent) {
        int range = 2 * average * rangePercent / 100;
        int lowerBound = average * (100 - rangePercent) / 100;
        return lowerBound + rand.nextInt(range);
    }

    static {
        readMin_ = 50;
        readMax_ = 250;
        sleepTime_ = 1000;
        MAX_DATA_ALLOWED = 0xFA00000;
        REGION_NAMES = new String[]{"day7", "day6", "day5", "day4", "day3", "day2", "day1", "day0"};
        _regions = new Region[8];
        rand = null;
    }
}

