/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ClientHelper;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.ServerLocation;
import cq.CQUtil;
import durableClients.DurableClientsBB;
import durableClients.DurableClientsPrms;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import getInitialImage.InitImageTest;
import hct.BBoard;
import hct.ExpectedRegionContents;
import hct.HctPrms;
import hydra.BridgeHelper;
import hydra.CacheHelper;
import hydra.ClientVmInfo;
import hydra.ClientVmMgr;
import hydra.ClientVmNotFoundException;
import hydra.ConfigPrms;
import hydra.DistributedSystemHelper;
import hydra.HydraVector;
import hydra.Log;
import hydra.MasterController;
import hydra.RegionHelper;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.SilenceListener;
import util.TestException;
import util.TestHelper;

public class InterestPolicyTest
extends InitImageTest {
    protected static final String REGION_NAME = "InterestPolicyRegion";
    protected static ArrayList keyList;
    protected static ArrayList partialKeyList;
    protected static int partial_numDestroyKeys;
    protected static int partial_numInvalidateKeys;
    protected static int partial_numUpdateKeys;
    protected static final int NUM_EXTRA_KEYS = 100;
    protected static volatile InterestResultPolicy policy;
    protected static KeyIntervals intervals;
    protected static int subscription;
    static final int ALL_KEYS = 1;
    static final int LIST = 2;
    static final int PARTIAL_LIST = 3;
    static final int REGEX = 4;
    static long killInterval;
    static Random rand;
    protected static ExpectedRegionContents static_RI_ops_keysValues;
    protected static ExpectedRegionContents static_RI_ops_keys;
    protected static ExpectedRegionContents static_RI_ops_none;
    protected static ExpectedRegionContents staticPartial_RI_ops_keysValues;
    protected static ExpectedRegionContents staticPartial_RI_ops_keys;
    protected static ExpectedRegionContents staticPartial_RI_ops_none;
    protected static ExpectedRegionContents static_RI_noops_keysValues;
    protected static ExpectedRegionContents static_RI_noops_keys;
    protected static ExpectedRegionContents static_RI_noops_none;
    protected static ExpectedRegionContents staticPartial_RI_noops_keysValues;
    protected static ExpectedRegionContents staticPartial_RI_noops_keys;
    protected static ExpectedRegionContents staticPartial_RI_noops_none;
    protected static ExpectedRegionContents static_ops_RI_keysValues;
    protected static ExpectedRegionContents static_ops_RI_keys;
    protected static ExpectedRegionContents static_ops_RI_none;
    protected static ExpectedRegionContents staticPartial_ops_RI_keysValues;
    protected static ExpectedRegionContents staticPartial_ops_RI_keys;
    protected static ExpectedRegionContents staticPartial_ops_RI_none;
    protected static ExpectedRegionContents dynamicKeysValues;
    protected static ExpectedRegionContents dynamicKeys;
    protected static ExpectedRegionContents dynamicNone;
    protected static ExpectedRegionContents dynamicPartialKeysValues;
    protected static ExpectedRegionContents dynamicPartialKeys;
    protected static ExpectedRegionContents dynamicPartialNone;

    public static void StartTask_initialize() {
        int numKeys = TestConfig.tab().intAt(InitImagePrms.numKeys);
        intervals = new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006, 1004, 1002}, numKeys);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.KEY_INTERVALS, intervals);
        Log.getLogWriter().info("Created keyIntervals: " + intervals);
        SharedCounters sc = InitImageBB.getBB().getSharedCounters();
        sc.setIfLarger(InitImageBB.LASTKEY_INVALIDATE, intervals.getFirstKey(1001) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_DESTROY, intervals.getFirstKey(1003) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY, intervals.getFirstKey(1005) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_GET, intervals.getFirstKey(1006) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_LOCAL_INVALIDATE, intervals.getFirstKey(1002) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_LOCAL_DESTROY, intervals.getFirstKey(1004) - 1);
        BBoard.getInstance().getSharedMap().put("lastKillTime", new Long(0L));
        InitImageBB.getBB().printSharedMap();
        InitImageBB.getBB().printSharedCounters();
    }

    public static void initBridgeServer() {
        CacheHelper.createCache(ConfigPrms.getCacheConfig());
        RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        BridgeHelper.startBridgeServer(ConfigPrms.getBridgeConfig());
    }

    public static synchronized void HydraTask_initialize() {
        if (testInstance == null) {
            testInstance = new InterestPolicyTest();
            ((InterestPolicyTest)testInstance).initInstance();
        }
    }

    @Override
    public void initInstance() {
        String key;
        int i;
        super.initInstance();
        this.supportsConcurrentMap = true;
        Cache cache = CacheHelper.createCache(ConfigPrms.getCacheConfig());
        this.aRegion = RegionHelper.createRegion(REGION_NAME, ConfigPrms.getRegionConfig());
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            HashMap map;
            Log.getLogWriter().info(" VM Durable Client Id is " + VmDurableId);
            if (!DurableClientsBB.getBB().getSharedMap().containsKey(VmDurableId)) {
                map = new HashMap();
                map.put("CRASH COUNT", new Integer(0));
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            } else {
                map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
                int crashCount = (Integer)map.get("CRASH COUNT");
                map.put("CRASH COUNT", new Integer(++crashCount));
                DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
            }
        }
        CQUtil.initialize();
        CQUtil.initializeCQService();
        CQUtil.registerCQ(this.aRegion);
        keyList = new ArrayList();
        partialKeyList = new ArrayList();
        partial_numDestroyKeys = 0;
        partial_numInvalidateKeys = 0;
        partial_numUpdateKeys = 0;
        int numKeyIntervalKeys = this.keyIntervals.getNumKeys();
        for (int i2 = 1; i2 <= numKeyIntervalKeys; ++i2) {
            String key2 = NameFactory.getObjectNameForCounter(i2);
            keyList.add(key2);
            if (i2 % 2 != 0) continue;
            partialKeyList.add(key2);
            if (this.keyIntervals.keyInRange(1003, i2)) {
                ++partial_numDestroyKeys;
            }
            if (this.keyIntervals.keyInRange(1001, i2)) {
                ++partial_numInvalidateKeys;
            }
            if (!this.keyIntervals.keyInRange(1005, i2)) continue;
            ++partial_numUpdateKeys;
        }
        int partialKeysFromKeyIntervals = partialKeyList.size();
        for (i = numKeyIntervalKeys + 1; i <= numKeyIntervalKeys + this.numNewKeys; ++i) {
            key = NameFactory.getObjectNameForCounter(i);
            keyList.add(key);
            partialKeyList.add(key);
        }
        for (i = numKeyIntervalKeys + this.numNewKeys + 1; i <= numKeyIntervalKeys + this.numNewKeys + 100; ++i) {
            key = NameFactory.getObjectNameForCounter(i);
            keyList.add(key);
            partialKeyList.add(key);
        }
        Log.getLogWriter().info("keyList size is " + keyList.size());
        Log.getLogWriter().info("partialKeyList size is " + partialKeyList.size());
        Log.getLogWriter().info("partial_numDestroyKeys is " + partial_numDestroyKeys);
        Log.getLogWriter().info("partial_numInvalidateKeys is " + partial_numInvalidateKeys);
        Log.getLogWriter().info("partial_numUpdateKeys is " + partial_numUpdateKeys);
        static_RI_noops_keysValues = new ExpectedRegionContents(true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false);
        static_RI_noops_keysValues.exactSize(this.keyIntervals.getNumKeys());
        static_RI_noops_keys = new ExpectedRegionContents(true, false, true, false, true, false, true, false, true, false, true, false, true, false, false, false, false, false);
        static_RI_noops_keys.exactSize(this.keyIntervals.getNumKeys());
        static_RI_noops_none = new ExpectedRegionContents(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false);
        static_RI_noops_none.exactSize(0);
        staticPartial_RI_noops_keysValues = (ExpectedRegionContents)static_RI_noops_keysValues.clone();
        staticPartial_RI_noops_keysValues.exactSize(partialKeyList.size() - this.numNewKeys - 100);
        staticPartial_RI_noops_keys = (ExpectedRegionContents)static_RI_noops_keys.clone();
        staticPartial_RI_noops_keys.exactSize(partialKeyList.size() - this.numNewKeys - 100);
        staticPartial_RI_noops_none = (ExpectedRegionContents)static_RI_noops_none.clone();
        int numDestroys = this.keyIntervals.getNumKeys(1003);
        static_ops_RI_keysValues = new ExpectedRegionContents(true, true, true, false, true, true, false, false, true, true, true, true, true, true, true, true, true, true);
        static_ops_RI_keysValues.exactSize(this.keyIntervals.getNumKeys() - numDestroys + this.numNewKeys);
        static_ops_RI_keys = new ExpectedRegionContents(true, false, true, false, true, false, false, false, true, false, true, false, true, false, true, false, true, true);
        static_ops_RI_keys.exactSize(this.keyIntervals.getNumKeys() - numDestroys + this.numNewKeys);
        static_ops_RI_none = new ExpectedRegionContents(false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, true);
        static_ops_RI_none.exactSize(0);
        staticPartial_ops_RI_keysValues = (ExpectedRegionContents)static_ops_RI_keysValues.clone();
        staticPartial_ops_RI_keysValues.exactSize(partialKeysFromKeyIntervals - partial_numDestroyKeys + this.numNewKeys);
        staticPartial_ops_RI_keys = (ExpectedRegionContents)static_ops_RI_keys.clone();
        staticPartial_ops_RI_keys.exactSize(partialKeysFromKeyIntervals - partial_numDestroyKeys + this.numNewKeys);
        staticPartial_ops_RI_none = (ExpectedRegionContents)static_ops_RI_none.clone();
        static_RI_ops_keysValues = new ExpectedRegionContents(true, true, true, false, true, true, false, false, true, true, true, true, true, true, true, true, true, true);
        static_RI_ops_keysValues.exactSize(this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1003) + this.numNewKeys);
        staticPartial_RI_ops_keysValues = (ExpectedRegionContents)static_RI_ops_keysValues.clone();
        staticPartial_RI_ops_keysValues.exactSize(partialKeyList.size() - partial_numDestroyKeys - 100);
        static_RI_ops_keys = new ExpectedRegionContents(true, false, true, false, true, false, false, false, true, false, true, true, true, false, true, true, true, true);
        static_RI_ops_keys.exactSize(this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1003) + this.numNewKeys);
        staticPartial_RI_ops_keys = (ExpectedRegionContents)static_RI_ops_keys.clone();
        staticPartial_RI_ops_keys.exactSize(partialKeyList.size() - partial_numDestroyKeys - 100);
        static_RI_ops_none = new ExpectedRegionContents(false, false, false, false, false, false, false, false, false, false, true, true, false, false, true, true, true, true);
        static_RI_ops_none.exactSize(this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1000) - this.keyIntervals.getNumKeys(1001) - this.keyIntervals.getNumKeys(1002) - this.keyIntervals.getNumKeys(1003) - this.keyIntervals.getNumKeys(1004) - this.keyIntervals.getNumKeys(1006) + this.numNewKeys);
        staticPartial_RI_ops_none = (ExpectedRegionContents)static_RI_ops_none.clone();
        staticPartial_RI_ops_none.exactSize(partial_numUpdateKeys + this.numNewKeys);
        dynamicKeysValues = new ExpectedRegionContents(true, true, true);
        dynamicKeysValues.containsValue_invalidate(false);
        dynamicKeysValues.containsKey_destroy(false);
        dynamicKeysValues.containsValue_destroy(false);
        dynamicKeysValues.valueIsUpdated(true);
        dynamicKeysValues.exactSize(this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1003) + this.numNewKeys);
        dynamicKeys = new ExpectedRegionContents(true, false, true);
        dynamicKeys.containsKey_destroy(null);
        dynamicKeys.containsValue_update(null);
        dynamicKeys.containsValue_newKey(null);
        dynamicKeys.valueIsUpdated(true);
        dynamicKeysValues.exactSize(this.keyIntervals.getNumKeys() - this.keyIntervals.getNumKeys(1003) + this.numNewKeys);
        dynamicNone = new ExpectedRegionContents(false, false, true);
        dynamicNone.containsKey_invalidate(null);
        dynamicNone.containsKey_update(null);
        dynamicNone.containsValue_update(null);
        dynamicNone.containsKey_newKey(null);
        dynamicNone.containsValue_newKey(null);
        dynamicNone.valueIsUpdated(true);
        dynamicPartialKeysValues = (ExpectedRegionContents)dynamicKeysValues.clone();
        dynamicPartialKeysValues.exactSize(partialKeysFromKeyIntervals - partial_numDestroyKeys + this.numNewKeys);
        dynamicPartialKeys = (ExpectedRegionContents)dynamicKeys.clone();
        dynamicPartialKeys.exactSize(partialKeysFromKeyIntervals - partial_numDestroyKeys + this.numNewKeys);
        dynamicPartialNone = (ExpectedRegionContents)dynamicNone.clone();
    }

    public static void HydraTask_loadRegion() {
        testInstance.loadRegion();
    }

    public static void killClient() {
        try {
            MasterController.sleepForMs(1000);
            ClientVmInfo clientVmInfo = ClientVmMgr.stop("Killing the VM", -21, -30);
        }
        catch (ClientVmNotFoundException e) {
            Log.getLogWriter().warning(" Exception while killing client ", (Throwable)e);
        }
    }

    public static void killClientWithCacheClose() {
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            Cache cache = CacheHelper.getCache();
            cache.close(true);
        }
        testInstance.initInstance();
    }

    public static void recycleClientWithCacheClose() {
        if (DistributedSystemHelper.getDistributedSystem() != null) {
            Cache cache = CacheHelper.getCache();
            cache.close(true);
        }
        testInstance.initInstance();
        ((InterestPolicyTest)testInstance).renewSubscription();
    }

    protected void renewSubscription() {
        switch (subscription) {
            case 1: {
                ((InterestPolicyTest)testInstance).registerInterest("ALL_KEYS");
                break;
            }
            case 2: {
                ((InterestPolicyTest)testInstance).registerInterest(keyList);
                break;
            }
            case 3: {
                ((InterestPolicyTest)testInstance).registerInterest(partialKeyList);
                break;
            }
            case 4: {
                ((InterestPolicyTest)testInstance).registerInterestRegex();
                break;
            }
            default: {
                throw new TestException("Unknown subscription type " + subscription);
            }
        }
    }

    public static void HydraTask_registerInterestSingle() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        test.registerInterestSingle(false, null);
    }

    public static void HydraTask_registerInterestSingle_RI_ops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        ExpectedRegionContents expected = null;
        if (policy.isKeysValues()) {
            expected = static_RI_ops_keysValues;
        } else if (policy.isKeys()) {
            expected = static_RI_ops_keys;
        } else if (policy.isNone()) {
            expected = static_RI_ops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.registerInterestSingle(false, expected);
    }

    public static void HydraTask_registerInterestSingle_RI_noops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        ExpectedRegionContents expected = null;
        if (policy.isKeysValues()) {
            expected = static_RI_noops_keysValues;
        } else if (policy.isKeys()) {
            expected = static_RI_noops_keys;
        } else if (policy.isNone()) {
            expected = static_RI_noops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.registerInterestSingle(false, expected);
    }

    public static void HydraTask_registerInterestSingle_ops_RI() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        ExpectedRegionContents expected = null;
        if (policy.isKeysValues()) {
            expected = static_ops_RI_keysValues;
        } else if (policy.isKeys()) {
            expected = static_ops_RI_keys;
        } else if (policy.isNone()) {
            expected = static_ops_RI_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.registerInterestSingle(false, expected);
    }

    public static void HydraTask_registerInterestList() {
        subscription = 2;
        ((InterestPolicyTest)testInstance).registerInterest(keyList);
    }

    public static void HydraTask_registerInterestPartialList() {
        subscription = 3;
        ((InterestPolicyTest)testInstance).registerInterest(partialKeyList);
    }

    public static void HydraTask_registerInterestAllKeys() {
        subscription = 1;
        ((InterestPolicyTest)testInstance).registerInterest("ALL_KEYS");
    }

    public static void HydraTask_registerInterestRegex() {
        subscription = 4;
        ((InterestPolicyTest)testInstance).registerInterestRegex();
    }

    public static void HydraTask_verifyRegionContents_RI_noops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        ExpectedRegionContents expected = null;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        if (policy.isKeysValues()) {
            expected = static_RI_noops_keysValues;
        } else if (policy.isKeys()) {
            expected = static_RI_noops_keys;
        } else if (policy.isNone()) {
            expected = static_RI_noops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(false, expected);
    }

    public static void HydraTask_verifyRegionContents_RI_ops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        ExpectedRegionContents expected = null;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        if (policy.isKeysValues()) {
            expected = static_RI_ops_keysValues;
        } else if (policy.isKeys()) {
            expected = static_RI_ops_keys;
        } else if (policy.isNone()) {
            expected = static_RI_ops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(false, expected);
    }

    public static void HydraTask_verifyRegionContents_ops_RI() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        ExpectedRegionContents expected = null;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        if (policy.isKeysValues()) {
            expected = static_ops_RI_keysValues;
        } else if (policy.isKeys()) {
            expected = static_ops_RI_keys;
        } else if (policy.isNone()) {
            expected = static_ops_RI_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(false, expected);
    }

    public static void HydraTask_verifyPartialRegionContents_RI_noops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        ExpectedRegionContents expected = null;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        if (policy.isKeysValues()) {
            expected = staticPartial_RI_noops_keysValues;
        } else if (policy.isKeys()) {
            expected = staticPartial_RI_noops_keys;
        } else if (policy.isNone()) {
            expected = staticPartial_RI_noops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(true, expected);
    }

    public static void HydraTask_verifyPartialRegionContents_RI_ops() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        ExpectedRegionContents expected = null;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        if (policy.isKeysValues()) {
            expected = staticPartial_RI_ops_keysValues;
        } else if (policy.isKeys()) {
            expected = staticPartial_RI_ops_keys;
        } else if (policy.isNone()) {
            expected = staticPartial_RI_ops_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(true, expected);
    }

    public static void HydraTask_verifyPartialRegionContents_ops_RI() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        ExpectedRegionContents expected = null;
        if (policy.isKeysValues()) {
            expected = staticPartial_ops_RI_keysValues;
        } else if (policy.isKeys()) {
            expected = staticPartial_ops_RI_keys;
        } else if (policy.isNone()) {
            expected = staticPartial_ops_RI_none;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(true, expected);
    }

    public static void HydraTask_verifyRegionContentsDynamic() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        ExpectedRegionContents expected = test.getDynamicExpected(policy);
        test.verifyRegionContents(false, expected);
    }

    public static void HydraTask_verifyPartialRegionContentsDynamic() throws Exception {
        InterestPolicyTest test = (InterestPolicyTest)testInstance;
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        ExpectedRegionContents expected = null;
        if (policy.isKeysValues()) {
            expected = dynamicPartialKeysValues;
        } else if (policy.isKeys()) {
            expected = dynamicPartialKeys;
        } else if (policy.isNone()) {
            expected = dynamicPartialNone;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        test.verifyRegionContents(true, expected);
    }

    public static void HydraTask_waitForSilence() {
        SilenceListener.waitForSilence(30L, 2000L);
    }

    protected void registerInterestSingle(boolean isPartial, ExpectedRegionContents expected) throws Exception {
        int NUM_CASES = 3;
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        Log.getLogWriter().info("Using expected " + expected);
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        StringBuffer errStr = new StringBuffer();
        for (int i = 0; i < keyList.size(); ++i) {
            Object key = keyList.get(i);
            try {
                Log.getLogWriter().info("Calling registerInterest with single key of interest: " + TestHelper.toString(key) + ", policy: " + policy);
                long start = System.currentTimeMillis();
                this.aRegion.registerInterest(key, policy);
                long l = System.currentTimeMillis();
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (expected == null) continue;
            try {
                Log.getLogWriter().info("Verifying entry for key " + key);
                this.verifyEntry(key, false, expected);
                continue;
            }
            catch (TestException e) {
                Log.getLogWriter().info("Detected problem: " + e);
                errStr.append(e.getMessage() + "\n");
            }
        }
        if (errStr.length() != 0) {
            int strLimit = 1000;
            String tmp = errStr.toString();
            if (tmp.length() > 1000) {
                Log.getLogWriter().info(errStr.toString());
                throw new TestException("Validate failed, see logs for all errors, partial errors are: " + tmp.substring(0, 1000) + "...");
            }
            throw new TestException(tmp);
        }
        Log.getLogWriter().info("In registerInterestSingle, verified " + keyList.size() + " keys");
    }

    protected void registerInterest(Object keysOfInterest) {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            if (BBoard.getInstance().getSharedMap().containsKey(VmDurableId)) {
                policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            }
            BBoard.getInstance().getSharedMap().put(VmDurableId, policy);
            Log.getLogWriter().info("Policy is " + policy.toString());
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            map.put("Policy", policy);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        try {
            Log.getLogWriter().info("Calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            if (!VmDurableId.equals("")) {
                this.aRegion.registerInterest(keysOfInterest, policy, true);
                Log.getLogWriter().info("durable client invoked register interest");
                CacheHelper.getCache().readyForEvents();
                Log.getLogWriter().info("durable client invoked readyForEvents()");
            } else {
                Log.getLogWriter().info("Doing non-durable register interest");
                this.aRegion.registerInterest(keysOfInterest, policy);
            }
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Done calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void registerInterestRegex() {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        if (size != 0) {
            throw new TestException("Expected region to be size 0, but it is " + size);
        }
        int testCase = (int)BBoard.getInstance().getSharedCounters().incrementAndRead(BBoard.testCase);
        HydraVector resultPolicyVec = TestConfig.tab().vecAt(HctPrms.resultPolicy);
        policy = TestHelper.getResultPolicy((String)resultPolicyVec.get(testCase % resultPolicyVec.size()));
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            if (BBoard.getInstance().getSharedMap().containsKey(VmDurableId)) {
                policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            }
            BBoard.getInstance().getSharedMap().put(VmDurableId, policy);
            Log.getLogWriter().info("Policy is " + policy.toString());
            HashMap map = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
            map.put("Policy", policy);
            DurableClientsBB.getBB().getSharedMap().put(VmDurableId, map);
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        String keysOfInterest = this.getRegex();
        try {
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            if (!VmDurableId.equals("")) {
                this.aRegion.registerInterestRegex(keysOfInterest, policy, true);
                Log.getLogWriter().info("durable client invoked register interest");
                CacheHelper.getCache().readyForEvents();
                Log.getLogWriter().info("durable client invoked readyForEvents()");
            } else {
                Log.getLogWriter().info("Doing non-durable register interest");
                this.aRegion.registerInterestRegex(keysOfInterest, policy);
            }
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected String getRegex() {
        String regex = "[a-zA-Z]+_[0-9]+";
        return regex;
    }

    protected ExpectedRegionContents getDynamicExpected(InterestResultPolicy policy) {
        ExpectedRegionContents expected;
        if (policy.isKeysValues()) {
            expected = dynamicKeysValues;
        } else if (policy.isKeys()) {
            expected = dynamicKeys;
        } else if (policy.isNone()) {
            expected = dynamicNone;
        } else {
            throw new TestException("Unknown policy " + policy);
        }
        Log.getLogWriter().info("Verifying with " + expected);
        return expected;
    }

    public void verifyRegionContents(boolean isPartial, ExpectedRegionContents expected) throws Exception {
        StringBuffer errStr = new StringBuffer();
        long numKeys = this.aRegion.keys().size();
        Log.getLogWriter().info("In verifyRegionContents, region has " + numKeys + " keys " + expected);
        int expectedNumKeys = -1;
        if (expected.exactSize() != null) {
            expectedNumKeys = expected.exactSize();
            Log.getLogWriter().info("Expecting exact size of region " + expectedNumKeys);
            if ((long)expectedNumKeys != numKeys) {
                String tmpStr = "Expected " + expectedNumKeys + " keys, but there are " + numKeys;
                Log.getLogWriter().info(tmpStr);
                errStr.append(tmpStr + "\n");
            }
        } else if (expected.minSize() != null && expected.maxSize() != null) {
            int minSize = expected.minSize();
            int maxSize = expected.maxSize();
            Log.getLogWriter().info("Expecting min region size " + minSize + ", max region size " + maxSize);
            if (numKeys < (long)minSize || numKeys > (long)maxSize) {
                String tmpStr = "Expected a minimum of " + minSize + " keys, maximum of " + maxSize + ", but there are " + numKeys;
                Log.getLogWriter().info(tmpStr);
                errStr.append(tmpStr + "\n");
            }
        } else {
            Log.getLogWriter().info("Not checking size of region, no size specified in " + expected);
        }
        HashSet keysToCheck = new HashSet(keyList);
        keysToCheck.addAll(this.aRegion.keys());
        for (Object key : keysToCheck) {
            try {
                this.verifyEntry(key, isPartial, expected);
            }
            catch (TestException e) {
                Log.getLogWriter().info(TestHelper.getStackTrace(e));
                errStr.append(e.getMessage() + "\n");
            }
        }
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        if (errStr.length() != 0) {
            int strLimit = 1000;
            String tmp = errStr.toString();
            if (tmp.length() > 1000) {
                Log.getLogWriter().info(errStr.toString());
                throw new TestException("Validate failed, see logs for all errors, partial errors are: " + tmp.substring(0, 1000) + "...");
            }
            throw new TestException(tmp);
        }
        Log.getLogWriter().info("In verifyRegionContentsKeysValues, verified region with " + numKeys + " keys");
    }

    protected void verifyEntry(Object key, boolean isPartial, ExpectedRegionContents expected) throws Exception {
        long i = NameFactory.getCounterForName(key);
        if (isPartial && !partialKeyList.contains(key)) {
            this.checkContainsKey(key, false, "key was not registered");
        } else if (i >= (long)this.keyIntervals.getFirstKey(1000) && i <= (long)this.keyIntervals.getLastKey(1000)) {
            this.checkContainsKey(key, expected.containsKey_none(), "key was untouched");
            this.checkContainsValueForKey(key, expected.containsValue_none(), "key was untouched");
            if (expected.getAllowed_none()) {
                Object value = this.aRegion.get(key);
                this.checkValue(key, value);
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1006) && i <= (long)this.keyIntervals.getLastKey(1006)) {
            this.checkContainsKey(key, expected.containsKey_get(), "get key");
            this.checkContainsValueForKey(key, expected.containsValue_get(), "get key");
            if (expected.getAllowed_get()) {
                Object value = this.aRegion.get(key);
                this.checkValue(key, value);
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1001) && i <= (long)this.keyIntervals.getLastKey(1001)) {
            this.checkContainsKey(key, expected.containsKey_invalidate(), "key was invalidated (Bug 35303)");
            Boolean expectValue = expected.containsValue_invalidate();
            this.checkContainsValueForKey(key, expectValue, "key was invalidated (Bug 35303)");
            if (expected.getAllowed_invalidate()) {
                Object value = this.aRegion.get(key);
                if (expectValue != null && expectValue.booleanValue()) {
                    this.checkValue(key, value);
                } else if (value != null) {
                    throw new TestException("Bug 35303, after calling get(" + key + "), expected invalidated value to be null but it is " + TestHelper.toString(value));
                }
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1002) && i <= (long)this.keyIntervals.getLastKey(1002)) {
            this.checkContainsKey(key, expected.containsKey_localInvalidate(), "key was locally invalidated");
            this.checkContainsValueForKey(key, expected.containsValue_localInvalidate(), "key was locally invalidated");
            if (expected.getAllowed_localInvalidate()) {
                Object value = this.aRegion.get(key);
                this.checkValue(key, value);
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1003) && i <= (long)this.keyIntervals.getLastKey(1003)) {
            this.checkContainsKey(key, expected.containsKey_destroy(), "key was destroyed");
            Boolean expectValue = expected.containsValue_destroy();
            this.checkContainsValueForKey(key, expectValue, "key was destroyed");
            if (expected.getAllowed_destroy()) {
                Object value = this.aRegion.get(key);
                if (expectValue != null && expectValue.booleanValue()) {
                    this.checkValue(key, value);
                } else if (value != null) {
                    throw new TestException("Expected value for " + key + " to be null");
                }
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1004) && i <= (long)this.keyIntervals.getLastKey(1004)) {
            this.checkContainsKey(key, expected.containsKey_localDestroy(), "key was locally destroyed");
            this.checkContainsValueForKey(key, expected.containsValue_localDestroy(), "key was locally destroyed");
            if (expected.getAllowed_localDestroy()) {
                Object value = this.aRegion.get(key);
                this.checkValue(key, value);
            }
        } else if (i >= (long)this.keyIntervals.getFirstKey(1005) && i <= (long)this.keyIntervals.getLastKey(1005)) {
            this.checkContainsKey(key, expected.containsKey_update(), "key was updated");
            this.checkContainsValueForKey(key, expected.containsValue_update(), "key was updated");
            if (expected.getAllowed_update()) {
                Object value = this.aRegion.get(key);
                if (expected.valueIsUpdated()) {
                    this.checkUpdatedValue(key, value);
                } else {
                    this.checkValue(key, value);
                }
            }
        } else if (i > (long)this.keyIntervals.getNumKeys() && i <= (long)(this.keyIntervals.getNumKeys() + this.numNewKeys)) {
            this.checkContainsKey(key, expected.containsKey_newKey(), "key was new");
            this.checkContainsValueForKey(key, expected.containsValue_newKey(), "key was new");
            if (expected.getAllowed_newKey()) {
                Object value = this.aRegion.get(key);
                this.checkValue(key, value);
            }
        } else {
            this.checkContainsKey(key, false, "key was never used");
            this.checkContainsValueForKey(key, false, "key was never used");
        }
    }

    protected void checkContainsKey(Object key, Boolean expected, String logStr) {
        if (expected != null) {
            boolean bool = expected;
            boolean containsKey = this.aRegion.containsKey(key);
            if (containsKey != bool) {
                throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey + ": " + logStr);
            }
        }
    }

    protected void checkContainsValueForKey(Object key, Boolean expected, String logStr) {
        if (expected != null) {
            boolean bool = expected;
            boolean containsValue = this.aRegion.containsValueForKey(key);
            if (containsValue != bool) {
                throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue + ": " + logStr);
            }
        }
    }

    public static void killServer() throws ClientVmNotFoundException {
        Long lastKill;
        Region region = RegionHelper.getRegion(REGION_NAME);
        Set active = ClientHelper.getActiveServers(region);
        int minServersRequiredAlive = 3;
        if (active.size() < minServersRequiredAlive) {
            Log.getLogWriter().info("No kill executed , a minimum of " + minServersRequiredAlive + " servers have to be kept alive");
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - (lastKill = (Long)BBoard.getInstance().getSharedMap().get("lastKillTime"));
        if (diff < killInterval) {
            Log.getLogWriter().info("No kill executed");
            return;
        }
        BBoard.getInstance().getSharedMap().put("lastKillTime", new Long(now));
        List<BridgeHelper.Endpoint> endpoints = BridgeHelper.getEndpoints();
        int index = rand.nextInt(endpoints.size() - 1);
        BridgeHelper.Endpoint endpoint = endpoints.get(index);
        ClientVmInfo target = new ClientVmInfo(endpoint);
        target = ClientVmMgr.stop("Killing random cache server", -21, -31, target);
        Log.getLogWriter().info("Server Killed : " + target);
        int sleepSec = TestConfig.tab().intAt(DurableClientsPrms.restartWaitSec, 1);
        Log.getLogWriter().info("Sleeping for " + sleepSec + " seconds");
        MasterController.sleepForMs(sleepSec * 1000);
        active = ClientHelper.getActiveServers(region);
        ArrayList<Object> list = new ArrayList<ServerLocation>(active);
        ServerLocation server = new ServerLocation(endpoint.getHost(), endpoint.getPort());
        String serverHost = server.getHostName();
        int serverPort = server.getPort();
        String server1 = serverHost + ":" + serverPort;
        if (InterestPolicyTest.isAvailable(server1, active, list)) {
            Log.getLogWriter().info("ERROR: Killed server " + server + " found in Active Server List: " + active);
        }
        ClientVmMgr.start("Restarting the cache server", target);
        int sleepMs = ClientHelper.getRetryInterval(region) + 1000;
        Log.getLogWriter().info("Sleeping for " + sleepMs + " ms");
        MasterController.sleepForMs(sleepMs);
        active = ClientHelper.getActiveServers(region);
        list = new ArrayList(active);
        if (InterestPolicyTest.isAvailable(server1, active, list)) {
            Log.getLogWriter().info("Restarted server " + server + " found in Active Server List: " + active);
        }
    }

    private static boolean isAvailable(String server1, Set active, List<ServerLocation> list) {
        boolean isAvailable = false;
        for (int i = 0; i < list.size(); ++i) {
            String hostName = list.get(i).getHostName();
            int port = list.get(i).getPort();
            String serverName = hostName.substring(0, hostName.indexOf(".")) + ":" + port;
            if (!serverName.equalsIgnoreCase(server1)) continue;
            isAvailable = true;
            break;
        }
        return isAvailable;
    }

    public static void HydraTask_nondurable_registerInterestList() {
        ((InterestPolicyTest)testInstance).nondurable_registerInterest(keyList);
    }

    public static void HydraTask_nondurable_registerInterestPartialList() {
        ((InterestPolicyTest)testInstance).nondurable_registerInterest(partialKeyList);
    }

    public static void HydraTask_nondurable_registerInterestAllKeys() {
        ((InterestPolicyTest)testInstance).nondurable_registerInterest("ALL_KEYS");
    }

    public static void HydraTask_nondurable_registerInterestRegex() {
        ((InterestPolicyTest)testInstance).nondurable_registerInterestRegex();
    }

    protected void nondurable_registerInterest(Object keysOfInterest) {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        try {
            Log.getLogWriter().info("Calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            this.aRegion.registerInterest(keysOfInterest, policy);
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Done calling registerInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void nondurable_registerInterestRegex() {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling register interest, region size is " + size);
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        if (!VmDurableId.equals("")) {
            policy = (InterestResultPolicy)BBoard.getInstance().getSharedMap().get(VmDurableId);
            Log.getLogWriter().info("Policy is " + policy.toString());
        }
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        String keysOfInterest = this.getRegex();
        try {
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy);
            long start = System.currentTimeMillis();
            this.aRegion.registerInterestRegex(keysOfInterest, policy);
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Calling registerInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", policy: " + policy + ", time to register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_unRegisterInterestList() {
        ((InterestPolicyTest)testInstance).unRegisterInterest(keyList);
    }

    public static void HydraTask_unRegisterInterestPartialList() {
        ((InterestPolicyTest)testInstance).unRegisterInterest(partialKeyList);
    }

    public static void HydraTask_unRegisterInterestAllKeys() {
        ((InterestPolicyTest)testInstance).unRegisterInterest("ALL_KEYS");
    }

    public static void HydraTask_unRegisterInterestRegex() {
        ((InterestPolicyTest)testInstance).unRegisterInterestRegex();
    }

    protected void unRegisterInterest(Object keysOfInterest) {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling unregister interest, region size is " + size);
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        try {
            Log.getLogWriter().info("Calling unregisterInterest with keys of interest: " + TestHelper.toString(keysOfInterest));
            long start = System.currentTimeMillis();
            this.aRegion.unregisterInterest(keysOfInterest);
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Done calling unregisterInterest with keys of interest: " + TestHelper.toString(keysOfInterest) + ", time to un register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    protected void unRegisterInterestRegex() {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("Before calling unregister interest, region size is " + size);
        int sleepBeforeRegisterInterest = TestConfig.tab().intAt(HctPrms.sleepBeforeRegisterInterest, 0);
        Log.getLogWriter().info("Sleeping for " + sleepBeforeRegisterInterest + " millis");
        MasterController.sleepForMs(sleepBeforeRegisterInterest);
        String keysOfInterest = this.getRegex();
        try {
            Log.getLogWriter().info("Calling unregisterInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest));
            long start = System.currentTimeMillis();
            this.aRegion.unregisterInterestRegex(keysOfInterest);
            long end = System.currentTimeMillis();
            Log.getLogWriter().info("Calling unregisterInterestRegex with keys of interest: " + TestHelper.toString(keysOfInterest) + ", time to un register interest was " + (end - start) + " millis");
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyRegionContents_UR() {
        ((InterestPolicyTest)testInstance).verifyRegionContents_UR();
    }

    protected void verifyRegionContents_UR() {
        int size = this.aRegion.keys().size();
        Log.getLogWriter().info("The region size is " + size);
        if (size != 0) {
            throw new TestException(" The region expected to be empty but has " + size + " entries");
        }
    }

    public static void validateEventCounters() {
        String VmDurableId = InternalDistributedSystem.getAnyInstance().getConfig().getDurableClientId();
        HashMap currentVmMap = (HashMap)DurableClientsBB.getBB().getSharedMap().get(VmDurableId);
        if (currentVmMap.isEmpty()) {
            throw new TestException("The map of threads is empty for the Vm " + VmDurableId);
        }
        int currentVmCrashCount = (Integer)currentVmMap.get("CRASH COUNT");
        HashSet currentVmSet = (HashSet)currentVmMap.get("OPS KEYS : ");
        InterestResultPolicy currentPolicy = (InterestResultPolicy)currentVmMap.get("Policy");
        if (currentVmSet == null) {
            if (currentPolicy.equals(InterestResultPolicy.NONE)) {
                currentVmSet = new HashSet();
            } else {
                throw new TestException(VmDurableId + " with InterestResultPolicy." + currentPolicy + " did not process any events.");
            }
        }
        Iterator iterator = DurableClientsBB.getBB().getSharedMap().getMap().entrySet().iterator();
        Map.Entry entry = null;
        Object key = null;
        Object value = null;
        Log.getLogWriter().info(VmDurableId + " with resultPolicy " + currentVmMap.get("Policy") + " and " + currentVmCrashCount + " killClient tasks processed events for " + currentVmSet.size() + " entries");
        while (iterator.hasNext()) {
            entry = iterator.next();
            key = entry.getKey();
            value = entry.getValue();
            HashMap otherVmMap = value;
            int otherVmCrashCount = (Integer)otherVmMap.get("CRASH COUNT");
            HashSet otherVmSet = (HashSet)otherVmMap.get("OPS KEYS : ");
            InterestResultPolicy otherPolicy = (InterestResultPolicy)otherVmMap.get("Policy");
            if (otherVmSet == null) {
                if (otherPolicy.equals(InterestResultPolicy.NONE)) {
                    otherVmSet = new HashSet();
                } else {
                    throw new TestException(key + "with InterestResultPolicy." + otherPolicy + " did not process any events.");
                }
            }
            if (currentVmCrashCount == 0 || otherVmCrashCount != 0 || otherVmMap.get("Policy") == null || !otherVmMap.get("Policy").equals(currentVmMap.get("Policy"))) continue;
            Log.getLogWriter().info(key + " with resultPolicy " + otherVmMap.get("Policy") + " and " + otherVmCrashCount + " killClient tasks processed events for " + otherVmSet.size() + " entries");
            if (currentVmSet.size() == otherVmSet.size()) {
                Log.getLogWriter().info(" Both " + VmDurableId + " and " + key + " processed events for " + otherVmSet.size() + " entries (as expected).");
                continue;
            }
            StringBuffer aStr = new StringBuffer();
            HashSet extraEvents = new HashSet(currentVmSet);
            extraEvents.removeAll(otherVmSet);
            if (extraEvents.size() != 0) {
                Log.getLogWriter().info(VmDurableId + " processed " + extraEvents.size() + " (extra) event entries " + extraEvents + "\n");
            }
            HashSet missingEvents = new HashSet(otherVmSet);
            missingEvents.removeAll(currentVmSet);
            if (missingEvents.size() == 0) continue;
            aStr.append(VmDurableId + " missed events for " + missingEvents.size() + " entries " + missingEvents);
            aStr.append(VmDurableId + " processed events for " + currentVmSet.size() + " entries and " + key + " processed events for " + otherVmSet.size() + " entries.  Both have resultPolicy " + currentVmMap.get("Policy") + "\n");
            throw new TestException(aStr.toString());
        }
    }

    static {
        killInterval = 60000L;
        rand = new Random();
    }
}

