/*
 * Decompiled with CFR 0.152.
 */
package hct;

import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.LoaderHelper;
import hct.HctPrms;
import hydra.ConfigHashtable;
import hydra.GsRandom;
import hydra.MasterController;
import hydra.TestConfig;
import java.io.Serializable;
import java.util.Properties;
import objects.ConfigurableObject;
import objects.SizedString;

public class DatabaseLoader
implements CacheLoader,
Declarable {
    static GsRandom rand = new GsRandom();
    static boolean isDisabled;
    static TestConfig config;
    static ConfigHashtable tab;

    public void init(Properties p) {
    }

    public void close() {
    }

    public Object load(LoaderHelper helper) throws CacheLoaderException {
        int sleepMs;
        String key = (String)helper.getKey();
        if (key.equals("disableDatabase")) {
            isDisabled = true;
        }
        if (key.equals("enableDatabase")) {
            isDisabled = false;
        }
        if (isDisabled) {
            int timeout = config.getPoolDescription("brloader").getReadTimeout();
            MasterController.sleepForMs(timeout + 200);
            return null;
        }
        Object newObj = null;
        String objtype = tab.stringAt(HctPrms.objectType);
        String index = key.substring(key.indexOf(95) + 1);
        if (objtype.equals("bytearray") || objtype.equals("string")) {
            newObj = SizedString.init(Integer.parseInt(index));
            if (objtype.equals("bytearray")) {
                newObj = ((String)newObj).getBytes();
            }
        } else if (objtype.equals("xmlstring")) {
            newObj = DatabaseLoader.makeDataString(key);
        } else {
            Class<?> c;
            try {
                c = Class.forName(objtype);
            }
            catch (ClassNotFoundException nfe) {
                throw new CacheLoaderException("Database loader cannot find class " + objtype);
            }
            catch (Exception ex) {
                throw new CacheLoaderException("Error for class " + objtype, (Throwable)ex);
            }
            try {
                newObj = c.newInstance();
                ((ConfigurableObject)newObj).init(Integer.parseInt(index));
            }
            catch (NumberFormatException e) {
                throw new CacheLoaderException("Could not get index for key: " + key);
            }
            catch (Exception ex) {
                throw new CacheLoaderException("Error creating instance of " + objtype, (Throwable)ex);
            }
        }
        if ((sleepMs = tab.intAt(HctPrms.dbLoadTimeMs)) > 0) {
            MasterController.sleepForMs(sleepMs);
        }
        if (tab.booleanAt(HctPrms.debug)) {
            System.out.println("DatabaseLoader returning " + newObj + " for key " + key);
        }
        return newObj;
    }

    private static String makeDataString(String objName) {
        NodeData nd = DatabaseLoader.chooseNodeValues();
        nd.id = objName;
        return DatabaseLoader.createNodeFromData(nd);
    }

    private static NodeData chooseNodeValues() {
        NodeData vals = new NodeData();
        vals.isDeposit = rand.nextBoolean();
        vals.dollars = rand.nextInt(3000);
        vals.cents = rand.nextInt(99);
        vals.expenseType = -1;
        if (vals.isDeposit) {
            vals.agent = 14 + rand.nextInt(2);
        } else {
            vals.agent = rand.nextInt(13);
            vals.expenseType = rand.nextInt(20);
        }
        return vals;
    }

    public static String createNodeFromData(NodeData nd) {
        StringBuffer buf = new StringBuffer();
        buf.append("***" + nd.id + "***");
        buf.append("<?xml version=\"1.0\"?>");
        if (nd.isDeposit) {
            buf.append("<deposit id=\"" + nd.id + "\">");
        } else {
            buf.append("<withdrawal id=\"" + nd.id + "\">");
            buf.append("<expenseType>");
            buf.append(nd.expenseType);
            buf.append("</expenseType>");
        }
        buf.append("<amount isBig=\"" + (nd.dollars >= 2000));
        buf.append("\"> ");
        buf.append(nd.dollars + "." + nd.cents);
        buf.append("</amount>");
        buf.append("<description>");
        int agent = nd.agent;
        if (agent == 0) {
            buf.append("<name>Fred Meyer</name> <addr>aaaaaaaaa</addr>");
        } else if (agent == 1) {
            buf.append("<name>Fred Meyer</name> <addr>bbbbbbbbb</addr>");
        } else if (agent == 2) {
            buf.append("<name>Fred Meyer</name> <addr>ccccccccc</addr>");
        } else if (agent == 3) {
            buf.append("<name>Fred Meyer</name> <addr>ddddddddd</addr>");
        } else if (agent == 4) {
            buf.append("<name>Fred Meyer</name> <addr>eeeeeeeee</addr>");
        } else if (agent == 5) {
            buf.append("<name>Target</name> <addr>fffffffff</addr>");
        } else if (agent == 6) {
            buf.append("<name>Target</name> <addr>ggggggggg</addr>");
        } else if (agent == 7) {
            buf.append("<name>Target</name> <addr>hhhhhhhhh</addr>");
        } else if (agent == 8) {
            buf.append("<name>Target</name> <addr>iiiiiiiii</addr>");
        } else if (agent == 9) {
            buf.append("<name>Target</name> <addr>jjjjjjjjj</addr>");
        } else if (agent == 10) {
            buf.append("<name>SafewayA</name> <addr>kkkkkkkkk</addr>");
        } else if (agent == 11) {
            buf.append("<name>SafewayB</name> <addr>lllllllll</addr>");
        } else if (agent == 12) {
            buf.append("<name>Safeway</name> <addr>mmmmmmmmm</addr>");
        } else if (agent == 13) {
            buf.append("<name>Safeway</name> <addr>nnnnnnnnn</addr>");
        } else if (agent == 14) {
            buf.append("<name>MakeMoreMoney,Inc.</name> <addr>ooooooooo</addr>");
        } else if (agent == 15) {
            buf.append("<name>\"Social Security\"</name> <addr>nnnnnnnnn</addr>");
        } else if (agent == 16) {
            buf.append("<name>'\"Rich Uncle\"</name> <addr>nnnnnnnnn</addr>");
        }
        buf.append("</description>");
        if (nd.isDeposit) {
            buf.append("</deposit>");
        } else {
            buf.append("</withdrawal>");
        }
        return buf.toString();
    }

    static {
        config = TestConfig.getInstance();
        tab = TestConfig.tab();
    }

    static class NodeData
    implements Serializable {
        public boolean isDeposit;
        public String id = "none";
        public int dollars;
        public int cents;
        public int agent;
        public int expenseType;

        NodeData() {
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            if (this.isDeposit) {
                buf.append("deposit, $");
            } else {
                buf.append("withdrawal, $");
            }
            buf.append(this.dollars + "." + this.cents);
            buf.append(", agent " + this.agent);
            buf.append(", expenseType " + this.expenseType);
            return buf.toString();
        }
    }
}

