/*
 * Decompiled with CFR 0.152.
 */
package getInitialImage;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.ConflictException;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionExistsException;
import com.gemstone.gemfire.cache.TimeoutException;
import com.gemstone.gemfire.cache.execute.Execution;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.internal.cache.DiskRegion;
import com.gemstone.gemfire.internal.cache.DistributedRegion;
import com.gemstone.gemfire.internal.cache.InitialImageOperation;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import delta.DeltaValueHolder;
import getInitialImage.GiiListener;
import getInitialImage.GiiWriter;
import getInitialImage.InitImageBB;
import getInitialImage.InitImagePrms;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import parReg.ParRegPrms;
import parReg.colocation.Month;
import parReg.execute.RegionOperationsFunction;
import pdx.PdxTest;
import pdx.PdxTestVersionHelper;
import util.BaseValueHolder;
import util.CacheDefPrms;
import util.CacheDefinition;
import util.CachePrms;
import util.CacheUtil;
import util.EventCountersBB;
import util.KeyIntervals;
import util.NameBB;
import util.NameFactory;
import util.RandomValues;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;
import util.ValueHolder;
import util.ValueHolderPrms;

public class InitImageTest {
    protected static InitImageTest testInstance;
    protected static final String REGION_NAME = "TestRegion";
    protected RandomValues randomValues = null;
    protected int numNewKeys;
    public KeyIntervals keyIntervals;
    protected int totalNumKeys;
    public Region aRegion;
    protected long createRegionDurationMS = 0L;
    protected long giiDurationMS = 0L;
    protected SharedCounters sc;
    protected int sleepMSAfterOps = -1;
    protected boolean supportsConcurrentMap = true;
    protected static final int INVALIDATE = 1;
    protected static final int LOCAL_INVALIDATE = 2;
    protected static final int DESTROY = 3;
    protected static final int LOCAL_DESTROY = 4;
    protected static final int UPDATE_EXISTING_KEY = 5;
    protected static final int GET = 6;
    protected static final int ADD_NEW_KEY = 7;
    protected static final int PUTALL_NEW_KEY = 8;
    protected static final int FIRST_OP = 1;
    protected static final int LAST_OP = 8;
    protected static final int[] operations;
    protected final long LOG_INTERVAL_MILLIS = 10000L;
    static final String objectType;

    protected static synchronized void initializeRegion(DataPolicy dataPolicy) {
        if (testInstance == null) {
            testInstance = new InitImageTest();
            testInstance.initRegion(dataPolicy);
            testInstance.initInstance();
        }
    }

    protected static synchronized void initializeInstance() {
        if (testInstance == null) {
            testInstance = new InitImageTest();
            testInstance.initInstance();
        }
    }

    protected void initRegion(DataPolicy dataPolicy) {
        CacheLoader loader = this.getCacheLoader();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        regDef.setDataPolicy(dataPolicy);
        Log.getLogWriter().info("Using RegionDefinition " + regDef + " to create region");
        this.aRegion = regDef.createRootRegion(CacheUtil.createCache(), REGION_NAME, null, loader, null);
        if (dataPolicy.equals(DataPolicy.NORMAL) || dataPolicy.equals(DataPolicy.EMPTY)) {
            this.supportsConcurrentMap = false;
        }
        this.sleepMSAfterOps = 30000;
    }

    public void initInstance() {
        this.numNewKeys = TestConfig.tab().intAt(InitImagePrms.numNewKeys, -1);
        this.keyIntervals = (KeyIntervals)InitImageBB.getBB().getSharedMap().get(InitImageBB.KEY_INTERVALS);
        Log.getLogWriter().info("initInstance, keyIntervals read from blackboard = " + this.keyIntervals.toString());
        int numDestroyed = this.keyIntervals.getNumKeys(1003);
        int numKeyIntervals = this.keyIntervals.getNumKeys();
        this.totalNumKeys = numKeyIntervals + this.numNewKeys - numDestroyed;
        this.sc = InitImageBB.getBB().getSharedCounters();
        this.randomValues = new RandomValues();
        Log.getLogWriter().info("numKeyIntervals is " + numKeyIntervals);
        Log.getLogWriter().info("numNewKeys is " + this.numNewKeys);
        Log.getLogWriter().info("numDestroyed is " + numDestroyed);
        Log.getLogWriter().info("totalNumKeys is " + this.totalNumKeys);
        InitialImageOperation.slowImageProcessing = TestConfig.tab().intAt(InitImagePrms.giiPerEntrySleepMS, 0);
    }

    public static synchronized void StartTask_initialize() {
        String giiSourceDataPolicy = TestConfig.tab().stringAt(InitImagePrms.giiSourceDataPolicy);
        StringTokenizer tokenizer = new StringTokenizer(giiSourceDataPolicy, "-");
        int numTokens = tokenizer.countTokens();
        if (numTokens != 2) {
            throw new TestException("Unable to get two dataPolicy attributes from InitImagePrms.giiSourceDataPolicy" + giiSourceDataPolicy);
        }
        String dataPolicy1 = tokenizer.nextToken();
        String dataPolicy2 = tokenizer.nextToken();
        InitImageBB.getBB().getSharedMap().put(InitImageBB.DATAPOLICY1_ATTR, dataPolicy1);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.DATAPOLICY2_ATTR, dataPolicy2);
        boolean useTransactions = InitImagePrms.useTransactions();
        int numKeys = TestConfig.tab().intAt(InitImagePrms.numKeys);
        KeyIntervals intervals = null;
        intervals = !TestHelper.getDataPolicy(dataPolicy2).withReplication() && !useTransactions ? new KeyIntervals(numKeys) : new KeyIntervals(new int[]{1000, 1001, 1003, 1005, 1006}, numKeys);
        InitImageBB.getBB().getSharedMap().put(InitImageBB.KEY_INTERVALS, intervals);
        Log.getLogWriter().info("Created keyIntervals: " + intervals);
        SharedCounters sc = InitImageBB.getBB().getSharedCounters();
        sc.setIfLarger(InitImageBB.LASTKEY_INVALIDATE, intervals.getFirstKey(1001) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_LOCAL_INVALIDATE, intervals.getFirstKey(1002) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_DESTROY, intervals.getFirstKey(1003) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_LOCAL_DESTROY, intervals.getFirstKey(1004) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY, intervals.getFirstKey(1005) - 1);
        sc.setIfLarger(InitImageBB.LASTKEY_GET, intervals.getFirstKey(1006) - 1);
        InitImageBB.getBB().printSharedMap();
        InitImageBB.getBB().printSharedCounters();
    }

    public static void HydraTask_loadRegion() {
        String dataPolicyStr = TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute, null);
        if (dataPolicyStr != null) {
            throw new TestException("This task must get its dataPolicy attribute from InitimageBB.giiSourceDataPolicy, but the task attribute also specified dataPolicy " + dataPolicyStr);
        }
        dataPolicyStr = (String)InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY1_ATTR);
        DataPolicy dataPolicyAttr = TestHelper.getDataPolicy(dataPolicyStr);
        InitImageTest.initializeRegion(dataPolicyAttr);
        testInstance.loadRegion();
    }

    public static void HydraTask_loadRegionWithGets() {
        String dataPolicyStr = TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute, null);
        if (dataPolicyStr != null) {
            throw new TestException("This task must get its dataPolicy attribute from InitimageBB.giiSourceDataPolicy, but the task attribute also specified dataPolicy" + dataPolicyStr);
        }
        dataPolicyStr = (String)InitImageBB.getBB().getSharedMap().get(InitImageBB.DATAPOLICY2_ATTR);
        DataPolicy dataPolicyAttr = TestHelper.getDataPolicy(dataPolicyStr);
        InitImageTest.initializeRegion(dataPolicyAttr);
        testInstance.loadRegionWithGets();
    }

    public static void HydraTask_doOps() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        testInstance.doOps(availableOps);
    }

    public static void HydraTask_doPutAllNewKey() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.set(8);
        testInstance.doOps(availableOps);
    }

    public static void HydraTask_doGetInitImage() {
        InitImageTest.initializeInstance();
        testInstance.doGetInitImage(true);
    }

    public static void HydraTask_doGetInitImageWithoutMonitor() {
        InitImageTest.initializeInstance();
        testInstance.doGetInitImage(false);
    }

    public static void HydraTask_blockedGetRegion() {
        InitImageTest.initializeInstance();
        testInstance.blockedGetRegion();
    }

    public static void HydraTask_verifyRegionContents() {
        try {
            testInstance.verifyRegionContents();
        }
        catch (Exception e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
    }

    public static void HydraTask_verifyEventCounters() {
        testInstance.verifyEventCounters();
    }

    public static synchronized void HydraTask_initCache() {
        if (CacheUtil.getCache() == null) {
            CacheDefinition cacheDef = CacheDefinition.createCacheDefinition(CacheDefPrms.cacheSpecs, "cache1");
            cacheDef.createCache();
        }
    }

    public static void HydraTask_verifyNonBlocking() {
        testInstance.verifyNonBlocking();
    }

    public static void HydraTask_doNewKeyGets() {
        testInstance.doNewKeyGets();
    }

    public static void HydraTask_doCacheWriterTest() {
        InitImageTest.initializeRegion(null);
        testInstance.doOpsPlusPuts();
    }

    public static void HydraTask_verifyCacheWriterTest() {
        testInstance.verifyCacheWriterTest();
    }

    protected void doGetInitImage(boolean withMonitor) {
        final StringBuffer errStr = new StringBuffer();
        Thread monitorThread = new Thread(new Runnable(){

            /*
             * Exception decompiling
             */
            @Override
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        });
        if (withMonitor) {
            monitorThread.start();
        }
        long begin = 0L;
        long end = 0L;
        Cache aCache = CacheUtil.createCache();
        RegionDefinition regDef = RegionDefinition.createRegionDefinition();
        boolean useTransactions = InitImagePrms.useTransactions();
        regDef.setDataPolicy(TestHelper.getDataPolicy(TestConfig.tasktab().stringAt(CachePrms.dataPolicyAttribute)));
        CacheWriter writer = this.getCacheWriter();
        CacheLoader loader = this.getCacheLoader();
        RegionAttributes attr = regDef.getRegionAttributes(new GiiListener(), loader, writer);
        if (useTransactions) {
            TxHelper.begin();
        }
        try {
            Log.getLogWriter().info("In doGetinitImage, creating VM region TestRegion with " + TestHelper.regionAttributesToString(attr));
            begin = System.currentTimeMillis();
            this.aRegion = aCache.createVMRegion(REGION_NAME, attr);
            end = System.currentTimeMillis();
            Log.getLogWriter().info("In doGetinitImage, done creating VM region TestRegion");
            int nbrOfGiiInProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
            Log.getLogWriter().info("In doGetinitImage, checking TestRegion for in progress: nbrOfGiiInProgress=" + nbrOfGiiInProgress);
            if (nbrOfGiiInProgress > 0) {
                throw new TestException("After creating region, GII is still in progress ");
            }
        }
        catch (RegionExistsException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        if (useTransactions) {
            TxHelper.commitExpectSuccess();
        }
        this.createRegionDurationMS = end - begin;
        int regionSize = this.aRegion.keys().size();
        Log.getLogWriter().info("In doGetInitImage, creating region took " + this.createRegionDurationMS + " millis, current region size is " + regionSize);
        if (InitImagePrms.giiHasSourceMember()) {
            if (regionSize == 0) {
                throw new TestException("After creating region, unexpected size " + regionSize);
            }
        } else if (regionSize != 0) {
            throw new TestException("After creating region, expected region size to be 0 (there are no source members for gii), but the size is " + regionSize);
        }
        if (withMonitor) {
            InitImageTest.waitForLocalGiiCompleted();
            try {
                monitorThread.join(30000L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        if (errStr.length() != 0) {
            throw new TestException(errStr);
        }
    }

    protected void blockedGetRegion() {
        Cache aCache = CacheUtil.createCache();
        InitImageTest.waitForLocalGiiToBegin();
        Log.getLogWriter().info("In blockedGetRegion, getting region TestRegion");
        long start = System.currentTimeMillis();
        Region myRegion = aCache.getRegion(REGION_NAME);
        long end = System.currentTimeMillis();
        Log.getLogWriter().info("In blockedGetRegion, done getting region TestRegion");
        long duration = end - start;
        Log.getLogWriter().info("In blockedGetRegion, region creation took " + duration + " millis");
        int numCompleted = TestHelper.getStat_getInitialImagesCompleted(REGION_NAME);
        if (numCompleted > 1) {
            throw new TestException("Expected only 1 getInitialImage to be completed, but num completed is " + numCompleted);
        }
        float blockPercent = (float)duration / (float)this.giiDurationMS * 100.0f;
        if (blockPercent < 75.0f) {
            throw new TestException("Expected the thread that blocked on getInitialImage to have a similar time to the thread that did the getInitialImage, blocked thread millis: " + duration + ", getInitialImage time: " + this.giiDurationMS);
        }
    }

    public void loadRegion() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int numKeysToCreate = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec, -1L);
        long minTaskGranularityMS = -1L;
        if (minTaskGranularitySec != -1L) {
            minTaskGranularityMS = minTaskGranularitySec * 1000L;
        }
        long startTime = System.currentTimeMillis();
        do {
            long shouldAddCount;
            if ((shouldAddCount = this.sc.incrementAndRead(InitImageBB.SHOULD_ADD_COUNT)) > (long)numKeysToCreate) {
                String aStr = "In loadRegion, shouldAddCount is " + shouldAddCount + ", numOriginalKeysCreated is " + this.sc.read(InitImageBB.NUM_ORIGINAL_KEYS_CREATED) + ", numKeysToCreate is " + numKeysToCreate + ", region size is " + this.aRegion.size();
                Log.getLogWriter().info(aStr);
                NameBB.getBB().printSharedCounters();
                throw new StopSchedulingTaskOnClientOrder(aStr);
            }
            String key = NameFactory.getNextPositiveObjectName();
            boolean useCacheLoader = TestConfig.tab().booleanAt(InitImagePrms.useCacheLoader);
            try {
                if (useCacheLoader) {
                    Object object = this.aRegion.get((Object)key);
                } else {
                    Object value = this.getValueToAdd(key);
                    if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                        Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
                        InitImageBB.getBB().getSharedMap().put(key, callBackArg);
                        if (TestConfig.tab().booleanAt(InitImagePrms.isFunctionExecutionTest, false)) {
                            Log.getLogWriter().info("Populating with function execution.");
                            ArrayList<Object> aList = new ArrayList<Object>();
                            aList.add("addKey");
                            aList.add(RemoteTestModule.getCurrentThread().getThreadId());
                            HashSet<String> keySet = new HashSet<String>();
                            keySet.add(key);
                            RegionOperationsFunction addKeyFunction = new RegionOperationsFunction();
                            Execution dataSet = FunctionService.onRegion((Region)this.aRegion);
                            try {
                                ResultCollector drc = dataSet.withFilter(keySet).withArgs(aList).execute((Function)addKeyFunction);
                                drc.getResult();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                throw new TestException("Got this exception " + e.getMessage() + " Cause " + e.getCause(), e);
                            }
                        } else {
                            this.aRegion.put((Object)key, value, (Object)callBackArg);
                        }
                    } else {
                        this.aRegion.put((Object)key, value);
                    }
                }
                this.sc.increment(InitImageBB.NUM_ORIGINAL_KEYS_CREATED);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Added " + NameFactory.getPositiveNameCounter() + " out of " + numKeysToCreate + " entries into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        } while (minTaskGranularitySec == -1L || System.currentTimeMillis() - startTime < minTaskGranularityMS);
    }

    public void loadRegionWithGets() {
        long LOG_INTERVAL_MILLIS = 10000L;
        int totalSize = this.keyIntervals.getNumKeys();
        long lastLogTime = System.currentTimeMillis();
        while (true) {
            long numGets;
            if ((numGets = this.sc.incrementAndRead(InitImageBB.NUM_GETS)) > (long)totalSize) {
                Log.getLogWriter().info("In loadRegionWithGets, regionSize is " + this.aRegion.keys().size());
                return;
            }
            String key = NameFactory.getObjectNameForCounter(numGets);
            try {
                Object aValue = this.aRegion.get((Object)key);
                if (aValue == null) {
                    throw new TestException("Unexpected value " + aValue + " from getting key " + key);
                }
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Got " + this.sc.read(InitImageBB.NUM_GETS) + " out of " + totalSize + " entries into " + TestHelper.regionToString(this.aRegion, false));
            lastLogTime = System.currentTimeMillis();
        }
    }

    public void doOps(BitSet availableOps) {
        boolean useTransactions = InitImagePrms.useTransactions();
        while (availableOps.cardinality() != 0) {
            int whichOp = this.getOp(availableOps, operations.length);
            boolean doneWithOps = false;
            if (useTransactions) {
                TxHelper.begin();
            }
            switch (whichOp) {
                case 7: {
                    doneWithOps = this.addNewKey();
                    break;
                }
                case 8: {
                    if (useTransactions) {
                        doneWithOps = true;
                        break;
                    }
                    doneWithOps = this.putAllNewKey();
                    break;
                }
                case 1: {
                    doneWithOps = this.invalidate();
                    break;
                }
                case 3: {
                    doneWithOps = this.destroy();
                    break;
                }
                case 5: {
                    doneWithOps = this.updateExistingKey();
                    break;
                }
                case 6: {
                    doneWithOps = this.get();
                    break;
                }
                case 2: {
                    doneWithOps = this.localInvalidate();
                    break;
                }
                case 4: {
                    doneWithOps = this.localDestroy();
                    break;
                }
                default: {
                    throw new TestException("Unknown operation " + whichOp);
                }
            }
            if (useTransactions) {
                try {
                    TxHelper.commit();
                }
                catch (ConflictException e) {
                    throw new TestException("Unexpected ConflictException " + TestHelper.getStackTrace(e));
                }
            }
            if (!doneWithOps) continue;
            Log.getLogWriter().info("Done with operation " + whichOp);
            availableOps.clear(whichOp);
        }
        Log.getLogWriter().info("Done in doOps");
        if (this.sleepMSAfterOps > 0) {
            try {
                Log.getLogWriter().info("Sleeping for " + this.sleepMSAfterOps + " millis to allow ops to be distributed");
                Thread.sleep(this.sleepMSAfterOps);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
    }

    protected boolean addNewKey() {
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from addNewKey");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        boolean useCacheLoader = TestConfig.tab().booleanAt(InitImagePrms.useCacheLoader);
        if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
            Month callBackArg = Month.months[TestConfig.tab().getRandGen().nextInt(11)];
            InitImageBB.getBB().getSharedMap().put(key, callBackArg);
        }
        this.checkContainsValueForKey(key, false, "before addNewKey");
        try {
            if (useCacheLoader) {
                boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
                long start = System.currentTimeMillis();
                this.aRegion.get((Object)key);
                long end = System.currentTimeMillis();
                boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
                long duration = end - start;
                Log.getLogWriter().info("Done adding new key " + key + " with get, time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.numNewKeys - numNewKeysCreated));
                this.sc.setIfLarger(InitImageBB.MAX_TIME_NEW_KEY, duration);
                if (inProgressBefore && inProgressAfter) {
                    this.sc.increment(InitImageBB.NEW_KEY_COMPLETED);
                }
            } else {
                BaseValueHolder value = this.createObject(key, this.randomValues);
                boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
                long start = System.currentTimeMillis();
                if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                    Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                    this.aRegion.put((Object)key, (Object)value, (Object)callBackArg);
                    Log.getLogWriter().info("Inside addNewKey(), did create with callback");
                } else if (this.supportsConcurrentMap && TestConfig.tab().getRandGen().nextBoolean()) {
                    Log.getLogWriter().info("Adding new key " + key + " with putIfAbsent");
                    this.aRegion.putIfAbsent((Object)key, (Object)value);
                    Log.getLogWriter().info("Done with putIfAbsent for " + key);
                } else {
                    this.aRegion.put((Object)key, (Object)value);
                }
                long end = System.currentTimeMillis();
                boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
                long duration = end - start;
                Log.getLogWriter().info("Done adding new key " + key + " with put, time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.numNewKeys - numNewKeysCreated));
                this.sc.setIfLarger(InitImageBB.MAX_TIME_NEW_KEY, duration);
                if (inProgressBefore && inProgressAfter) {
                    this.sc.increment(InitImageBB.NEW_KEY_COMPLETED);
                }
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected boolean putAllNewKey() {
        long numNewKeysCreated = this.sc.incrementAndRead(InitImageBB.NUM_NEW_KEYS_CREATED);
        if (numNewKeysCreated > (long)this.numNewKeys) {
            Log.getLogWriter().info("All new keys created; returning from putAllNewKey");
            return true;
        }
        String key = NameFactory.getNextPositiveObjectName();
        boolean useCacheLoader = TestConfig.tab().booleanAt(InitImagePrms.useCacheLoader);
        this.checkContainsValueForKey(key, false, "before addNewKey");
        try {
            if (useCacheLoader) {
                boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
                long start = System.currentTimeMillis();
                this.aRegion.get((Object)key);
                long end = System.currentTimeMillis();
                boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
                long duration = end - start;
                Log.getLogWriter().info("Done adding new key " + key + " with get, time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.numNewKeys - numNewKeysCreated));
                this.sc.setIfLarger(InitImageBB.MAX_TIME_NEW_KEY, duration);
                if (inProgressBefore && inProgressAfter) {
                    this.sc.increment(InitImageBB.NEW_KEY_COMPLETED);
                }
            } else {
                BaseValueHolder value = this.createObject(key, this.randomValues);
                boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
                long start = System.currentTimeMillis();
                HashMap<String, BaseValueHolder> map = new HashMap<String, BaseValueHolder>();
                map.put(key, value);
                this.aRegion.putAll(map);
                long end = System.currentTimeMillis();
                boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
                long duration = end - start;
                Log.getLogWriter().info("Done adding new key " + key + " with putall, time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.numNewKeys - numNewKeysCreated));
                this.sc.setIfLarger(InitImageBB.MAX_TIME_NEW_KEY, duration);
                if (inProgressBefore && inProgressAfter) {
                    this.sc.increment(InitImageBB.NEW_KEY_COMPLETED);
                }
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return numNewKeysCreated >= (long)this.numNewKeys;
    }

    protected boolean updateExistingKey() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_UPDATE_EXISTING_KEY);
        if (!this.keyIntervals.keyInRange(1005, nextKey)) {
            Log.getLogWriter().info("All existing keys updated; returning from updateExistingKey");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        try {
            BaseValueHolder existingValue = (BaseValueHolder)this.aRegion.get((Object)key);
            BaseValueHolder newValue = this.createObject(key, this.randomValues);
            if (existingValue == null) {
                throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
            }
            if (existingValue.myValue instanceof String) {
                throw new TestException("Trying to update a key which was already updated: " + existingValue.myValue);
            }
            newValue.myValue = "updated_" + NameFactory.getCounterForName(key);
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                this.aRegion.put((Object)key, (Object)newValue, (Object)callBackArg);
                Log.getLogWriter().info("Inside update(), did update with callback");
            } else if (this.supportsConcurrentMap && TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("Replacing existing key " + key + " with value " + TestHelper.toString(newValue));
                this.aRegion.replace((Object)key, (Object)newValue);
                Log.getLogWriter().info("Replaced key " + key);
            } else {
                this.aRegion.put((Object)key, (Object)newValue);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done updating existing key " + key + " with value " + TestHelper.toString(newValue) + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1005) - nextKey));
            this.sc.setIfLarger(InitImageBB.MAX_TIME_UPDATE_EXISTING_KEY, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.UPDATE_EXISTING_KEY_COMPLETED);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1005);
    }

    protected boolean localInvalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1002, nextKey)) {
            Log.getLogWriter().info("All local invalidates completed; returning from localInvalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        try {
            this.checkContainsValueForKey(key, true, "before localInvalidate");
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                this.aRegion.localInvalidate((Object)key, (Object)callBackArg);
                Log.getLogWriter().info("Inside local invalidate(), did invalidate with callback");
            } else {
                this.aRegion.localInvalidate((Object)key);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done locally invalidating " + key + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1002) - nextKey));
            this.sc.setIfLarger(InitImageBB.MAX_TIME_LOCAL_INVALIDATE, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.LOCAL_INVALIDATE_COMPLETED);
            }
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1002);
    }

    protected boolean invalidate() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_INVALIDATE);
        if (!this.keyIntervals.keyInRange(1001, nextKey)) {
            Log.getLogWriter().info("All existing keys invalidated; returning from invalidate");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        this.checkContainsValueForKey(key, true, "before invalidate");
        try {
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                this.aRegion.invalidate((Object)key, (Object)callBackArg);
                Log.getLogWriter().info("Inside invalidate(), did invalidate with callback");
            } else {
                this.aRegion.invalidate((Object)key);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done invalidating " + key + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1001) - nextKey));
            this.sc.setIfLarger(InitImageBB.MAX_TIME_INVALIDATE, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.INVALIDATE_COMPLETED);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1001);
    }

    protected boolean localDestroy() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_LOCAL_DESTROY);
        if (!this.keyIntervals.keyInRange(1004, nextKey)) {
            Log.getLogWriter().info("All local destroys completed; returning from localDestroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        this.checkContainsValueForKey(key, true, "before localDestroy");
        try {
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                this.aRegion.localDestroy((Object)key, (Object)callBackArg);
                Log.getLogWriter().info("Inside local destroy(), did destroy with callback");
            } else {
                this.aRegion.localDestroy((Object)key);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done locally destroying " + key + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1004) - nextKey));
            this.sc.setIfLarger(InitImageBB.MAX_TIME_LOCAL_DESTROY, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.LOCAL_DESTROY_COMPLETED);
            }
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1004);
    }

    protected boolean destroy() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_DESTROY);
        if (!this.keyIntervals.keyInRange(1003, nextKey)) {
            Log.getLogWriter().info("All destroys completed; returning from destroy");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        Log.getLogWriter().info("Destroying " + key);
        this.checkContainsValueForKey(key, true, "before destroy");
        try {
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                this.aRegion.destroy((Object)key, (Object)callBackArg);
                Log.getLogWriter().info("Inside destroy(), did destroy with callback");
            } else if (this.supportsConcurrentMap && TestConfig.tab().getRandGen().nextBoolean()) {
                Log.getLogWriter().info("Removing " + key);
                this.aRegion.remove((Object)key, this.aRegion.get((Object)key));
                Log.getLogWriter().info("Done removing " + key);
            } else {
                this.aRegion.destroy((Object)key);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done Destroying " + key + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1003) - nextKey));
            this.sc.setIfLarger(InitImageBB.MAX_TIME_DESTROY, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.DESTROY_COMPLETED);
            }
        }
        catch (CacheWriterException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (EntryNotFoundException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1003);
    }

    protected boolean get() {
        long nextKey = this.sc.incrementAndRead(InitImageBB.LASTKEY_GET);
        if (!this.keyIntervals.keyInRange(1006, nextKey)) {
            Log.getLogWriter().info("All gets completed; returning from get");
            return true;
        }
        String key = NameFactory.getObjectNameForCounter(nextKey);
        try {
            boolean inProgressBefore = InitImageTest.isAnyGiiInProgress();
            long start = System.currentTimeMillis();
            Object existingValue = null;
            if (TestConfig.tab().booleanAt(ParRegPrms.isWithRoutingResolver, false)) {
                Month callBackArg = (Month)InitImageBB.getBB().getSharedMap().get(key);
                existingValue = this.aRegion.get((Object)key, (Object)callBackArg);
                Log.getLogWriter().info("Inside get(), did get with callback");
            } else {
                existingValue = this.aRegion.get((Object)key);
            }
            long end = System.currentTimeMillis();
            boolean inProgressAfter = InitImageTest.isAnyGiiInProgress();
            long duration = end - start;
            Log.getLogWriter().info("Done getting " + key + " time was " + duration + " millis; inProgressBefore: " + inProgressBefore + ", inProgressAfter: " + inProgressAfter + ", num remaining: " + ((long)this.keyIntervals.getLastKey(1006) - nextKey));
            if (existingValue == null) {
                throw new TestException("Get of key " + key + " returned unexpected " + existingValue);
            }
            this.sc.setIfLarger(InitImageBB.MAX_TIME_GET, duration);
            if (inProgressBefore && inProgressAfter) {
                this.sc.increment(InitImageBB.GET_COMPLETED);
            }
        }
        catch (TimeoutException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        catch (CacheLoaderException e) {
            throw new TestException(TestHelper.getStackTrace(e));
        }
        return nextKey >= (long)this.keyIntervals.getLastKey(1006);
    }

    protected void doNewKeyGets() {
        InitImageTest.waitForAnyGiiToBegin();
        int newKeyGetsReturnedNull = 0;
        int newKeyGetsReturnedLoaderValue = 0;
        Log.getLogWriter().info("Beginning new key gets...");
        while (InitImageTest.isAnyGiiInProgress()) {
            String key = NameFactory.getNextPositiveObjectName();
            Object value = null;
            try {
                long start = System.currentTimeMillis();
                value = this.aRegion.get((Object)key);
                long end = System.currentTimeMillis();
                this.sc.setIfLarger(InitImageBB.MAX_TIME_GET, end - start);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            if (value == null) {
                ++newKeyGetsReturnedNull;
                continue;
            }
            if (value.getClass() == String.class) {
                String strValue = (String)value;
                if (strValue.equals("String from getInitialImage.GiiLoader: " + key)) {
                    ++newKeyGetsReturnedLoaderValue;
                    continue;
                }
                throw new TestException("Expected get to return value from GiiLoader, but got " + TestHelper.toString(value));
            }
            throw new TestException("Expected get to return String from GiiLoader, but got " + TestHelper.toString(value));
        }
        long maxTime = this.sc.read(InitImageBB.MAX_TIME_GET);
        Log.getLogWriter().info("Done with new key gets, newKeyGetsReturnedNull: " + newKeyGetsReturnedNull + ", numKeyGetsReturnedLoaderValue: " + newKeyGetsReturnedLoaderValue + ", maxGetTime: " + maxTime + " millis");
        double percent = (double)newKeyGetsReturnedLoaderValue / (double)newKeyGetsReturnedNull * 100.0;
        if (percent > 1.0) {
            throw new TestException("Getting new keys might not have returned null from cache loader installed in region doing a getInitialImage, number of new key gets that returned null during gii: " + newKeyGetsReturnedNull + ", number of new key gets that returned a value from GiiLoader: " + newKeyGetsReturnedLoaderValue);
        }
        int threshold = 10;
        if (newKeyGetsReturnedNull <= threshold) {
            throw new TestException("Suspiciously low number of gets " + newKeyGetsReturnedNull);
        }
        int MS_TO_WAIT_FOR_NET_LOADER = 1777;
        long endTimeWaitForNetLoader = System.currentTimeMillis() + 1777L;
        while (!((DistributedRegion)this.aRegion).hasNetLoader()) {
            if (System.currentTimeMillis() > endTimeWaitForNetLoader) {
                throw new TestException("No net loader for region " + this.aRegion + " after waiting " + 1777 + "ms.");
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        long waitTime = System.currentTimeMillis() - (endTimeWaitForNetLoader - 1777L);
        if (waitTime > 0L) {
            Log.getLogWriter().info("Had to wait " + waitTime + "ms for net loader to be available after gii completed.");
        }
        Log.getLogWriter().info("GetInitialImage inProgress is " + InitImageTest.isAnyGiiInProgress() + ", doing more new key gets...");
        long timeToRunMS = 30000L;
        long startTime = System.currentTimeMillis();
        newKeyGetsReturnedLoaderValue = 0;
        newKeyGetsReturnedNull = 0;
        StringBuffer errStr = new StringBuffer();
        do {
            try {
                String key = NameFactory.getNextPositiveObjectName();
                Object value = this.aRegion.get((Object)key);
                if (value == null) {
                    ++newKeyGetsReturnedNull;
                    String aStr = new Date() + " GiiInProgress is " + InitImageTest.isAnyGiiInProgress() + ", expected a value from the GiiLoader for " + key + ", but got " + value + "; number of non-null values return from loader so far: " + newKeyGetsReturnedLoaderValue;
                    Log.getLogWriter().info(aStr);
                    errStr.append(aStr + "\n");
                    continue;
                }
                if (value instanceof String) {
                    String strValue = (String)value;
                    if (strValue.equals("String from getInitialImage.GiiLoader: " + key)) {
                        ++newKeyGetsReturnedLoaderValue;
                        continue;
                    }
                    throw new TestException("GiiInProgress is " + InitImageTest.isAnyGiiInProgress() + ", expected a value from the GiiLoader for " + key + ", but got " + TestHelper.toString(value));
                }
                throw new TestException("GiiInProgress is " + InitImageTest.isAnyGiiInProgress() + ", expected a value from the GiiLoader for " + key + ", but got " + TestHelper.toString(value));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("After getInitialImageCompleted, got " + newKeyGetsReturnedLoaderValue + " values from GiiLoader, got " + newKeyGetsReturnedNull + " null values");
        if (newKeyGetsReturnedNull != 0) {
            throw new TestException("After gii finished, got unexpected null values from loader; num null values " + newKeyGetsReturnedNull + ", num non-null values " + newKeyGetsReturnedLoaderValue + "\n" + errStr.toString());
        }
    }

    protected void doOpsPlusPuts() {
        BitSet availableOps = new BitSet(operations.length);
        availableOps.flip(1, 9);
        testInstance.doOps(availableOps);
        InitImageTest.waitForAllGiiToComplete();
        InitImageBB.getBB().printSharedCounters();
        Log.getLogWriter().info("GetInitialImage inProgress is " + InitImageTest.isAnyGiiInProgress());
        long timeToRunMS = 30000L;
        long startTime = System.currentTimeMillis();
        int putCount = 0;
        do {
            try {
                String key = NameFactory.getNextPositiveObjectName();
                String value = "put to invoke cache writer: " + key;
                this.aRegion.put((Object)key, (Object)value);
                ++putCount;
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        } while (System.currentTimeMillis() - startTime < timeToRunMS);
        Log.getLogWriter().info("After getInitialImageCompleted, put " + putCount);
    }

    public void verifyRegionContents() {
        InitImageBB.getBB().printSharedCounters();
        NameBB.getBB().printSharedCounters();
        StringBuffer errStr = new StringBuffer();
        long numKeys = this.aRegion.size();
        if ((long)this.totalNumKeys != numKeys) {
            String tmpStr = "Expected " + this.totalNumKeys + " keys, but there are " + numKeys;
            Log.getLogWriter().info(tmpStr);
            errStr.append(tmpStr + "\n");
        }
        Log.getLogWriter().info("In verifyRegionContents, region has " + numKeys + " keys");
        int numKeysToCheck = this.keyIntervals.getNumKeys() + this.numNewKeys;
        Log.getLogWriter().info("In verifyRegionContents, iterating through " + numKeysToCheck + " key names");
        long lastLogTime = System.currentTimeMillis();
        for (int i = 1; i <= numKeysToCheck; ++i) {
            String key = NameFactory.getObjectNameForCounter(i);
            try {
                Object value;
                if (i >= this.keyIntervals.getFirstKey(1000) && i <= this.keyIntervals.getLastKey(1000) || i >= this.keyIntervals.getFirstKey(1006) && i <= this.keyIntervals.getLastKey(1006)) {
                    this.checkContainsKey(key, true, "key was untouched");
                    this.checkContainsValueForKey(key, true, "key was untouched");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1001) && i <= this.keyIntervals.getLastKey(1001)) {
                    this.checkContainsKey(key, true, "key was invalidated");
                    this.checkContainsValueForKey(key, false, "key was invalidated");
                } else if (i >= this.keyIntervals.getFirstKey(1002) && i <= this.keyIntervals.getLastKey(1002)) {
                    this.checkContainsKey(key, true, "key was locally invalidated");
                    this.checkContainsValueForKey(key, true, "key was locally invalidated");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1003) && i <= this.keyIntervals.getLastKey(1003)) {
                    this.checkContainsKey(key, false, "key was destroyed");
                    this.checkContainsValueForKey(key, false, "key was destroyed");
                } else if (i >= this.keyIntervals.getFirstKey(1004) && i <= this.keyIntervals.getLastKey(1004)) {
                    this.checkContainsKey(key, true, "key was locally destroyed");
                    this.checkContainsValueForKey(key, true, "key was locally destroyed");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                } else if (i >= this.keyIntervals.getFirstKey(1005) && i <= this.keyIntervals.getLastKey(1005)) {
                    this.checkContainsKey(key, true, "key was updated");
                    this.checkContainsValueForKey(key, true, "key was updated");
                    value = this.aRegion.get((Object)key);
                    this.checkUpdatedValue(key, value);
                } else if (i > this.keyIntervals.getNumKeys()) {
                    this.checkContainsKey(key, true, "key was new");
                    this.checkContainsValueForKey(key, true, "key was new");
                    value = this.aRegion.get((Object)key);
                    this.checkValue(key, value);
                }
            }
            catch (TestException e) {
                Log.getLogWriter().info(TestHelper.getStackTrace(e));
                errStr.append(e.getMessage() + "\n");
            }
            if (System.currentTimeMillis() - lastLogTime <= 10000L) continue;
            Log.getLogWriter().info("Verified key " + i + " out of " + this.totalNumKeys);
            lastLogTime = System.currentTimeMillis();
        }
        if (errStr.length() > 0) {
            throw new TestException(errStr.toString());
        }
    }

    public void verifyNonBlocking() {
        InitImageBB.getBB().printSharedCounters();
        long threshold = 10L;
        long completed = this.sc.read(InitImageBB.INVALIDATE_COMPLETED);
        if (this.keyIntervals.getNumKeys(1001) > 0 && completed <= threshold) {
            throw new TestException("Invalidate might have blocked during getInitialImage, num invalidates completed during getInitialImage: " + completed + ", total num invalidates: " + this.keyIntervals.getNumKeys(1001));
        }
        completed = this.sc.read(InitImageBB.LOCAL_INVALIDATE_COMPLETED);
        if (this.keyIntervals.getNumKeys(1002) > 0 && completed <= threshold) {
            throw new TestException("Local invalidate might have blocked during getInitialImage, num local invalidates completed during getInitialImage: " + completed + ", total num local invalidates: " + this.keyIntervals.getNumKeys(1002));
        }
        completed = this.sc.read(InitImageBB.DESTROY_COMPLETED);
        if (this.keyIntervals.getNumKeys(1003) > 0 && completed <= threshold) {
            throw new TestException("Destroy might have blocked during getInitialImage, num destroys completed during getInitialImage: " + completed + ", total num destroys: " + this.keyIntervals.getNumKeys(1003));
        }
        completed = this.sc.read(InitImageBB.LOCAL_DESTROY_COMPLETED);
        if (this.keyIntervals.getNumKeys(1004) > 0 && completed <= threshold) {
            throw new TestException("Local destroy might have blocked during getInitialImage, num local destroys completed during getInitialImage: " + completed + ", total num local destroys: " + this.keyIntervals.getNumKeys(1004));
        }
        completed = this.sc.read(InitImageBB.NEW_KEY_COMPLETED);
        if (this.numNewKeys > 0 && completed <= threshold) {
            throw new TestException("Adding new keys might have blocked during getInitialImage, num new keys added during getInitialImage: " + completed + ", total num new keys: " + this.numNewKeys);
        }
        completed = this.sc.read(InitImageBB.UPDATE_EXISTING_KEY_COMPLETED);
        if (this.keyIntervals.getNumKeys(1005) > 0 && completed <= threshold) {
            throw new TestException("Updating existing keys might have blocked during getInitialImage, num updates completed during getInitialImage: " + completed + ", total num updates: " + this.keyIntervals.getNumKeys(1005));
        }
        completed = this.sc.read(InitImageBB.GET_COMPLETED);
        if (this.keyIntervals.getNumKeys(1006) > 0 && completed <= threshold) {
            throw new TestException("Gets might have blocked during getInitialImage, num gets completed during getInitialImage: " + completed + ", total num gets: " + this.keyIntervals.getNumKeys(1006));
        }
        Log.getLogWriter().info("time to create region: " + this.createRegionDurationMS + " millis");
        threshold = (int)((double)this.giiDurationMS * 0.9);
        long maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_INVALIDATE);
        if (maxTimeMS > threshold) {
            throw new TestException("Invalidate might have blocked during getIntialImage, max time for an invalidate: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_LOCAL_INVALIDATE);
        if (maxTimeMS > threshold) {
            throw new TestException("Local invalidate might have blocked during getIntialImage, max time for a local invalidate: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_DESTROY);
        if (maxTimeMS > threshold) {
            throw new TestException("Destroy might have blocked during getIntialImage, max time for a destroy: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_LOCAL_DESTROY);
        if (maxTimeMS > threshold) {
            throw new TestException("Local destroy might have blocked during getIntialImage, max time for a local destroy: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_NEW_KEY);
        if (maxTimeMS > threshold) {
            throw new TestException("Creating a new key might have blocked during getIntialImage, max time for creating a new key: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_UPDATE_EXISTING_KEY);
        if (maxTimeMS > threshold) {
            throw new TestException("Updating an existing key might have blocked during getIntialImage, max time for updating an existing key: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
        maxTimeMS = this.sc.read(InitImageBB.MAX_TIME_GET);
        if (maxTimeMS > threshold) {
            throw new TestException("Getting might have blocked during getIntialImage, max time for a get: " + maxTimeMS + " millis, time to create region: " + this.createRegionDurationMS + " millis");
        }
    }

    protected void verifyEventCounters() {
        long threshold = 10L;
        EventCountersBB.getBB().printSharedCounters();
        long[] eventCounters = EventCountersBB.getBB().getSharedCounters().getCounterValues();
        long counter = eventCounters[EventCountersBB.numAfterCreateEvents_isDist] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotDist];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isExp] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotExp];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isRemote] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotRemote];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isLoad] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isLocalLoad] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotLocalLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(local load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isNetLoad] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotNetLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(net load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterCreateEvents_isNetSearch] + eventCounters[EventCountersBB.numAfterCreateEvents_isNotNetSearch];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterCreateEvents(net search sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isDist] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotDist];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isExp] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotExp];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isRemote] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotRemote];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isLoad] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isLocalLoad] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotLocalLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(local load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isNetLoad] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotNetLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(net load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterDestroyEvents_isNetSearch] + eventCounters[EventCountersBB.numAfterDestroyEvents_isNotNetSearch];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterDestroyEvents(net search sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isDist] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotDist];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isExp] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotExp];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isRemote] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotRemote];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isLoad] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isLocalLoad] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotLocalLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(local load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isNetLoad] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotNetLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(net load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterInvalidateEvents_isNetSearch] + eventCounters[EventCountersBB.numAfterInvalidateEvents_isNotNetSearch];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterInvalidateEvents(net search sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isDist] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotDist];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isExp] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotExp];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isRemote] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotRemote];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isLoad] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isLocalLoad] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotLocalLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(local load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isNetLoad] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotNetLoad];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(net load sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterUpdateEvents_isNetSearch] + eventCounters[EventCountersBB.numAfterUpdateEvents_isNotNetSearch];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterUpdateEvents(net search sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isDist] + eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isNotDist];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionDestroyEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isExp] + eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isNotExp];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionDestroyEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isRemote] + eventCounters[EventCountersBB.numAfterRegionDestroyEvents_isNotRemote];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionDestroyEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isDist] + eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isNotDist];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionInvalidateEvents(dist sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isExp] + eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isNotExp];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionInvalidateEvents(exp sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isRemote] + eventCounters[EventCountersBB.numAfterRegionInvalidateEvents_isNotRemote];
        if (counter > 0L) {
            throw new TestException("Event listener might have been invoked during getInitialImage, numAfterRegionInvalidateEvents(remote sum) count (during gii): " + counter);
        }
        counter = eventCounters[EventCountersBB.numClose];
        if (counter > threshold) {
            throw new TestException("Event listener might have been invoked during getInitialImage, num close count (during gii): " + counter);
        }
    }

    protected void verifyCacheWriterTest() {
        InitImageBB.getBB().printSharedCounters();
        long duringGii = InitImageBB.getBB().getSharedCounters().read(InitImageBB.CACHE_WRITER_INVOKED_DURING_GII);
        long noGii = InitImageBB.getBB().getSharedCounters().read(InitImageBB.CACHE_WRITER_INVOKED_NO_GII);
        int threshold = 3;
        if (duringGii > (long)threshold) {
            throw new TestException("GiiWriter might have been invoked during getInitialImage, number of cache writer invocations while gii was in progress: " + duringGii);
        }
        if (noGii < (long)threshold) {
            throw new TestException("GiiWriter might not have been invoked without getInitialImage in progress, number of cache writer invocations while gii was not in progress: " + noGii);
        }
    }

    protected void checkContainsKey(Object key, boolean expected, String logStr) {
        boolean containsKey = this.aRegion.containsKey(key);
        if (containsKey != expected) {
            throw new TestException("Expected containsKey(" + key + ") to be " + expected + ", but it was " + containsKey + ": " + logStr);
        }
    }

    protected void checkContainsValueForKey(Object key, boolean expected, String logStr) {
        boolean containsValue = this.aRegion.containsValueForKey(key);
        if (containsValue != expected) {
            throw new TestException("Expected containsValueForKey(" + key + ") to be " + expected + ", but it was " + containsValue + ": " + logStr);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkValue(Object key, Object value) {
        Object baseValue = PdxTestVersionHelper.toBaseObject(value);
        if (!(baseValue instanceof BaseValueHolder)) throw new TestException("For key " + key + ", expected value " + TestHelper.toString(baseValue) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)baseValue;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof Long)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a Long for " + TestHelper.toString(vh));
        Long aLong = (Long)vh.myValue;
        long longValue = aLong;
        if (keyCounter == longValue) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void checkUpdatedValue(Object key, Object value) {
        Object baseObject = PdxTestVersionHelper.toBaseObject(value);
        if (!(baseObject instanceof BaseValueHolder)) throw new TestException("Expected value " + TestHelper.toString(baseObject) + " to be a ValueHolder");
        BaseValueHolder vh = (BaseValueHolder)baseObject;
        long keyCounter = NameFactory.getCounterForName(key);
        if (!(vh.myValue instanceof String)) throw new TestException("Expected ValueHolder.myValue for key " + key + " to be a String indicating it was updated, but the value for this key is " + TestHelper.toString(vh));
        String aStr = (String)vh.myValue;
        String expectedStr = "updated_" + keyCounter;
        if (aStr.equals(expectedStr)) return;
        throw new TestException("Inconsistent ValueHolder.myValue for key " + key + ":" + TestHelper.toString(vh));
    }

    protected int getOp(BitSet bs, int bsSize) {
        int randInt;
        while (!bs.get(randInt = TestConfig.tab().getRandGen().nextInt(1, bsSize))) {
        }
        return randInt;
    }

    protected CacheLoader getCacheLoader() {
        boolean useCacheLoader = TestConfig.tasktab().booleanAt(InitImagePrms.useCacheLoader, false);
        if (useCacheLoader) {
            try {
                String cacheLoaderClassName = TestConfig.tasktab().stringAt(InitImagePrms.cacheLoaderClass);
                Class<?> cacheLoaderClass = Class.forName(cacheLoaderClassName);
                CacheLoader loader = (CacheLoader)cacheLoaderClass.newInstance();
                return loader;
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        return null;
    }

    protected CacheWriter getCacheWriter() {
        boolean useCacheWriter = TestConfig.tasktab().booleanAt(InitImagePrms.useCacheWriter, false);
        if (useCacheWriter) {
            return new GiiWriter();
        }
        return null;
    }

    protected Object getValueToAdd(Object key) {
        return this.createObject((String)key);
    }

    protected BaseValueHolder createObject(Object key) {
        return this.createObject(key, this.randomValues);
    }

    protected BaseValueHolder createObject(Object key, RandomValues values) {
        if (objectType.equals("delta.DeltaValueHolder")) {
            return new DeltaValueHolder((String)key, values);
        }
        if (objectType.equals("util.PdxVersionedValueHolder") || objectType.equals("util.VersionedValueHolder")) {
            return PdxTest.getVersionedValueHolder(objectType, (String)key, values);
        }
        return new ValueHolder((String)key, values);
    }

    protected Set getRegionKeySet(Region aRegion) {
        return aRegion.keys();
    }

    protected static boolean isLocalGiiInProgress() {
        int inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        if (inProgress > 1) {
            throw new TestException("Expected local gii in progress to always be 0 or 1, but it is " + inProgress);
        }
        return inProgress > 0;
    }

    protected static boolean isLocalGiiInProgress(Region aRegion) {
        if (aRegion == null) {
            return false;
        }
        boolean inProgress = !((LocalRegion)aRegion).isInitialized();
        return inProgress;
    }

    protected static boolean hasLocalGiiCompleted() {
        return TestHelper.getStat_getInitialImagesCompleted(REGION_NAME) > 0;
    }

    protected static boolean isAnyGiiInProgress() {
        return InitImageBB.getBB().getSharedCounters().read(InitImageBB.GII_IN_PROGRESS) > 0L;
    }

    public static void waitForAnyGiiToBegin() {
        Log.getLogWriter().info("Waiting for getInitialImage to begin in any VM...");
        SharedCounters counters = InitImageBB.getBB().getSharedCounters();
        while (counters.read(InitImageBB.GII_IN_PROGRESS) <= 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done waiting for getInitialImage to begin in any VM");
    }

    protected static void waitForAllGiiToComplete() {
        Log.getLogWriter().info("Waiting for getInitialImage to complete in all VMs...");
        SharedCounters counters = InitImageBB.getBB().getSharedCounters();
        while (counters.read(InitImageBB.GII_IN_PROGRESS) > 0L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        Log.getLogWriter().info("Done waiting for getInitialImage to complete in all VMs");
    }

    protected static void waitForLocalGiiToBegin() {
        long MAX_WAIT_MILLIS = 300000L;
        Log.getLogWriter().info("Waiting 300000 millis for getIntialImage to begin...");
        long start = System.currentTimeMillis();
        int inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        while (inProgress <= 0 && System.currentTimeMillis() - start < 300000L) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            inProgress = TestHelper.getStat_getInitialImagesInProgress(REGION_NAME);
        }
        Log.getLogWriter().info("Done waiting 300000 millis for getIntialImage to begin, inProgress is " + inProgress);
        if (inProgress <= 0) {
            throw new TestException("Waited 300000 for getInitialImage to begin, but inProgress is " + inProgress);
        }
    }

    protected static void waitForLocalGiiCompleted() {
        long giiCompleted;
        long MAX_WAIT_MILLIS = 300000L;
        Log.getLogWriter().info("Waiting 300000 millis for getIntialImage to complete...");
        long start = System.currentTimeMillis();
        while ((giiCompleted = (long)TestHelper.getStat_getInitialImagesCompleted(REGION_NAME)) <= 0L && System.currentTimeMillis() - start < 300000L) {
        }
        Log.getLogWriter().info("Done waiting 300000 millis for getIntialImage to complete, giiCompleted is " + giiCompleted);
        if (giiCompleted <= 0L) {
            throw new TestException("Waited 300000 for getInitialImage to complete, but giiCompleted is " + giiCompleted);
        }
    }

    public static void HydraTask_verifyGII() {
        testInstance.verifyGII();
    }

    private void verifyGII() {
        StringBuffer aStr = new StringBuffer("verifyGII invoked. ");
        String regionName = InitImageTest.testInstance.aRegion.getName();
        DiskRegion diskRegion = ((LocalRegion)InitImageTest.testInstance.aRegion).getDiskRegion();
        if (diskRegion != null && diskRegion.getStats().getRemoteInitializations() == 0) {
            aStr.append(regionName + " was recovered from disk (Remote Initializations = " + diskRegion.getStats().getRemoteInitializations() + ").");
        } else {
            int giisCompleted = TestHelper.getStat_getInitialImagesCompleted(regionName);
            int deltaGiisCompleted = TestHelper.getStat_deltaGetInitialImagesCompleted(regionName);
            if (giisCompleted < 1 || deltaGiisCompleted > 0) {
                throw new TestException("Did not perform expected type of GII. Expected a full GII for region " + InitImageTest.testInstance.aRegion.getFullPath() + " GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted);
            }
            aStr.append(regionName + " Remote Initialization (GII): GIIsCompleted = " + giisCompleted + " DeltaGIIsCompleted = " + deltaGiisCompleted + ".");
        }
        Log.getLogWriter().info(aStr.toString());
    }

    static {
        operations = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        objectType = TestConfig.tab().stringAt(ValueHolderPrms.objectType, "util.ValueHolder");
    }
}

