/*
 * Decompiled with CFR 0.152.
 */
package expiration;

import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.TimeoutException;
import expiration.ExpirPrms;
import expiration.ExpirationBB;
import expiration.IdleTODestroyBB;
import expiration.IdleTODestroyListener;
import expiration.IdleTOInvalBB;
import expiration.IdleTOInvalListener;
import expiration.IdleTOLocalDestroyBB;
import expiration.IdleTOLocalDestroyListener;
import expiration.IdleTOLocalInvalBB;
import expiration.IdleTOLocalInvalListener;
import expiration.TTLDestroyBB;
import expiration.TTLDestroyListener;
import expiration.TTLInvalBB;
import expiration.TTLInvalListener;
import expiration.TTLLocalDestroyBB;
import expiration.TTLLocalDestroyListener;
import expiration.TTLLocalInvalBB;
import expiration.TTLLocalInvalListener;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.Blackboard;
import java.util.Arrays;
import java.util.Map;
import util.CacheUtil;
import util.RegionDefPrms;
import util.RegionDefinition;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;
import util.TxHelper;

public class ExpirationTest {
    protected static ExpirationTest testInstance;
    protected static String[] regionNames;
    protected static final int TTLDestroyIndex = 0;
    protected static final int TTLLocalDestroyIndex = 1;
    protected static final int TTLInvalIndex = 2;
    protected static final int TTLLocalInvalIndex = 3;
    protected static final int IdleTODestroyIndex = 4;
    protected static final int IdleTOLocalDestroyIndex = 5;
    protected static final int IdleTOInvalIndex = 6;
    protected static final int IdleTOLocalInvalIndex = 7;
    protected static final int numRegions = 8;
    protected static String[] regionListenerClassNames;
    protected static String[] threadGroupNames;

    public static synchronized void HydraTask_initializeControlThread() {
        if (testInstance == null) {
            testInstance = new ExpirationTest();
            testInstance.initializeControlThread();
        }
    }

    public static void StartTask_initialize() {
        for (int i = 0; i < regionNames.length; ++i) {
            RegionDefinition regDef = RegionDefinition.createRegionDefinition(RegionDefPrms.regionSpecs, regionNames[i]);
            ExpirationBB.getBB().getSharedMap().put(regionNames[i], regDef);
        }
    }

    protected void initializeControlThread() {
        for (int i = 0; i < regionNames.length; ++i) {
            RegionDefinition regDef = (RegionDefinition)ExpirationBB.getBB().getSharedMap().get(regionNames[i]);
            CacheListener listener = null;
            try {
                Class<?> listenerClass = Class.forName(regionListenerClassNames[i]);
                listener = (CacheListener)listenerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            regDef.createRootRegion(CacheUtil.createCache(), regionNames[i], listener, null, null);
            regDef.setEntryIdleTimeoutSec(null);
            regDef.setEntryIdleTimeoutAction(null);
            regDef.setEntryTTLSec(null);
            regDef.setEntryTTLAction(null);
            regDef.setRegionIdleTimeoutSec(null);
            regDef.setRegionIdleTimeoutAction(null);
            regDef.setRegionTTLSec(null);
            regDef.setRegionTTLAction(null);
            regDef.setMirroring(MirrorType.KEYS_VALUES);
            ExpirationBB.getBB().getSharedMap().put(regionNames[i], regDef);
        }
    }

    public static synchronized void HydraTask_initializeVerifyThread() {
        if (testInstance == null) {
            testInstance = new ExpirationTest();
            testInstance.initializeVerifyThread();
        }
    }

    protected void initializeVerifyThread() {
        Map bbMap = ExpirationBB.getBB().getSharedMap().getMap();
        for (String regionName : bbMap.keySet()) {
            RegionDefinition regDef = (RegionDefinition)bbMap.get(regionName);
            CacheListener listener = null;
            try {
                String className = regionListenerClassNames[Arrays.asList(regionNames).indexOf(regionName)];
                Class<?> listenerClass = Class.forName(className);
                listener = (CacheListener)listenerClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (IllegalAccessException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (InstantiationException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            regDef.createRootRegion(CacheUtil.createCache(), regionName, listener, null, null);
        }
    }

    public static void HydraTask_logRegionContents() {
        for (int i = 0; i < regionNames.length; ++i) {
            testInstance.logRegionContents(regionNames[i]);
        }
    }

    public static void HydraTask_syncAndLog() {
        TestHelper.waitForCounter(ExpirationBB.getBB(), "DoneWithTask", ExpirationBB.DoneWithTask, 8L, true, -1L);
        ExpirationTest.HydraTask_logRegionContents();
        ExpirationBB.getBB().getSharedCounters().increment(ExpirationBB.DoneLoggingRegion);
        TestHelper.waitForCounter(ExpirationBB.getBB(), "DoneLoggingRegion", ExpirationBB.DoneLoggingRegion, TestHelper.getNumThreads(), true, -1L);
    }

    public static void HydraTask_controlEntryTTLDestroy() throws Throwable {
        try {
            testInstance.controlEntryTTLDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryTTLLocalDestroy() throws Throwable {
        try {
            testInstance.controlEntryTTLLocalDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryTTLInval() throws Throwable {
        try {
            testInstance.controlEntryTTLInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryTTLLocalInval() throws Throwable {
        try {
            testInstance.controlEntryTTLLocalInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryIdleTODestroy() throws Throwable {
        try {
            testInstance.controlEntryIdleTODestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryIdleTOLocalDestroy() throws Throwable {
        try {
            testInstance.controlEntryIdleTOLocalDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryIdleTOInval() throws Throwable {
        try {
            testInstance.controlEntryIdleTOInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlEntryIdleTOLocalInval() throws Throwable {
        try {
            testInstance.controlEntryIdleTOLocalInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionTTLDestroy() throws Throwable {
        try {
            testInstance.controlRegionTTLDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionTTLLocalDestroy() throws Throwable {
        try {
            testInstance.controlRegionTTLLocalDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionTTLInval() throws Throwable {
        try {
            testInstance.controlRegionTTLInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionTTLLocalInval() throws Throwable {
        try {
            testInstance.controlRegionTTLLocalInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionIdleTODestroy() throws Throwable {
        try {
            testInstance.controlRegionIdleTODestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionIdleTOLocalDestroy() throws Throwable {
        try {
            testInstance.controlRegionIdleTOLocalDestroy();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionIdleTOInval() throws Throwable {
        try {
            testInstance.controlRegionIdleTOInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public static void HydraTask_controlRegionIdleTOLocalInval() throws Throwable {
        try {
            testInstance.controlRegionIdleTOLocalInval();
        }
        catch (VirtualMachineError e) {
            SystemFailure.initiateFailure((Error)e);
            throw e;
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            testInstance.wrapUp();
        }
    }

    public void controlEntryTTLDestroy() {
        String regionName = regionNames[0];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(TTLDestroyBB.getBB(), "numAfterCreateEvents_isNotExp", TTLDestroyBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLDestroyBB.getBB(), "numAfterDestroyEvents_isRemote", TTLDestroyBB.numAfterDestroyEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLDestroyBB.getBB(), "numAfterDestroyEvents_isNotRemote", TTLDestroyBB.numAfterDestroyEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        int regionSize = aRegion.keys().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        this.checkEntryEventsForDestroy(TTLDestroyBB.getBB(), numKeys);
        TTLDestroyBB.getBB().printSharedCounters();
        TTLDestroyBB.getBB().zeroAllCounters();
    }

    public void controlEntryTTLLocalDestroy() {
        String regionName = regionNames[1];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        TestHelper.waitForCounter(TTLLocalDestroyBB.getBB(), "numAfterCreateEvents_isNotExp", TTLLocalDestroyBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLLocalDestroyBB.getBB(), "numAfterDestroyEvents_isNotRemote", TTLLocalDestroyBB.numAfterDestroyEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        int regionSize = aRegion.keys().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        this.checkEntryEventsForLocalDestroy(TTLLocalDestroyBB.getBB(), numKeys);
        TTLLocalDestroyBB.getBB().printSharedCounters();
        TTLLocalDestroyBB.getBB().zeroAllCounters();
    }

    public void controlEntryTTLInval() {
        String regionName = regionNames[2];
        int numKeys = this.populateRegion(regionName);
        String key2 = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key2 + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key2, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterCreateEvents_isNotExp", TTLInvalBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterInvalidateEvents_isRemote", TTLInvalBB.numAfterInvalidateEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterInvalidateEvents_isNotRemote", TTLInvalBB.numAfterInvalidateEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        for (String key2 : aRegion.keys()) {
            try {
                Object value = aRegion.get((Object)key2);
                if (value == null) continue;
                throw new TestException("Found key " + key2 + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        this.checkEntryEventsForInvalidate(TTLInvalBB.getBB(), numKeys);
        TTLInvalBB.getBB().printSharedCounters();
        TTLInvalBB.getBB().zeroAllCounters();
    }

    public void controlEntryTTLLocalInval() {
        String regionName = regionNames[3];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        TestHelper.waitForCounter(TTLLocalInvalBB.getBB(), "numAfterCreateEvents_isNotExp", TTLLocalInvalBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLLocalInvalBB.getBB(), "numAfterInvalidateEvents_isNotRemote", TTLLocalInvalBB.numAfterInvalidateEvents_isNotRemote, numKeys, true, 600000L);
        this.checkEntryEventsForLocalInvalidate(TTLLocalInvalBB.getBB(), numKeys);
        TTLLocalInvalBB.getBB().printSharedCounters();
        TTLLocalInvalBB.getBB().zeroAllCounters();
    }

    public void controlEntryIdleTODestroy() {
        String regionName = regionNames[4];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(IdleTODestroyBB.getBB(), "numAfterCreateEvents_isNotExp", IdleTODestroyBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTODestroyBB.getBB(), "numAfterDestroyEvents_isRemote", IdleTODestroyBB.numAfterDestroyEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTODestroyBB.getBB(), "numAfterDestroyEvents_isNotRemote", IdleTODestroyBB.numAfterDestroyEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        int regionSize = aRegion.keys().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        this.checkEntryEventsForDestroy(IdleTODestroyBB.getBB(), numKeys);
        IdleTODestroyBB.getBB().printSharedCounters();
        IdleTODestroyBB.getBB().zeroAllCounters();
    }

    public void controlEntryIdleTOLocalDestroy() {
        String regionName = regionNames[5];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        TestHelper.waitForCounter(IdleTOLocalDestroyBB.getBB(), "numAfterCreateEvents_isNotExp", IdleTOLocalDestroyBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTOLocalDestroyBB.getBB(), "numAfterDestroyEvents_isNotRemote", IdleTOLocalDestroyBB.numAfterDestroyEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        int regionSize = aRegion.keys().size();
        if (regionSize != 0) {
            throw new TestException("Expected region to have all its entries destroyed, but it has " + regionSize + " keys");
        }
        this.checkEntryEventsForLocalDestroy(IdleTOLocalDestroyBB.getBB(), numKeys);
        IdleTOLocalDestroyBB.getBB().printSharedCounters();
        IdleTOLocalDestroyBB.getBB().zeroAllCounters();
    }

    public void controlEntryIdleTOInval() {
        String regionName = regionNames[6];
        int numKeys = this.populateRegion(regionName);
        String key2 = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key2 + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key2, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(IdleTOInvalBB.getBB(), "numAfterCreateEvents_isNotExp", IdleTOInvalBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTOInvalBB.getBB(), "numAfterInvalidateEvents_isRemote", IdleTOInvalBB.numAfterInvalidateEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTOInvalBB.getBB(), "numAfterInvalidateEvents_isNotRemote", IdleTOInvalBB.numAfterInvalidateEvents_isNotRemote, numKeys, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        for (String key2 : aRegion.keys()) {
            try {
                Object value = aRegion.get((Object)key2);
                if (value == null) continue;
                throw new TestException("Found key " + key2 + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        this.checkEntryEventsForInvalidate(IdleTOInvalBB.getBB(), numKeys);
        IdleTOInvalBB.getBB().printSharedCounters();
        IdleTOInvalBB.getBB().zeroAllCounters();
    }

    public void controlEntryIdleTOLocalInval() {
        String regionName = regionNames[7];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        TestHelper.waitForCounter(IdleTOLocalInvalBB.getBB(), "numAfterCreateEvents_isNotExp", IdleTOLocalInvalBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTOLocalInvalBB.getBB(), "numAfterInvalidateEvents_isNotRemote", IdleTOLocalInvalBB.numAfterInvalidateEvents_isNotRemote, numKeys, true, 600000L);
        this.checkEntryEventsForLocalInvalidate(IdleTOLocalInvalBB.getBB(), numKeys);
        IdleTOLocalInvalBB.getBB().printSharedCounters();
        IdleTOLocalInvalBB.getBB().zeroAllCounters();
    }

    public void controlRegionTTLDestroy() {
        String regionName = regionNames[0];
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            this.populateRegion(regionName);
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(TTLDestroyBB.getBB(), "numAfterRegionDestroyEvents_isRemote", TTLDestroyBB.numAfterRegionDestroyEvents_isRemote, numRemoteVMs, true, 600000L);
        TestHelper.waitForCounter(TTLDestroyBB.getBB(), "numAfterRegionDestroyEvents_isNotRemote", TTLDestroyBB.numAfterRegionDestroyEvents_isNotRemote, 1L, true, 600000L);
        try {
            aRegion.keys().size();
            throw new TestException("Expected exception for region destroy, but did not get one");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            this.checkRegionEventsForDestroy(TTLDestroyBB.getBB());
            TTLDestroyBB.getBB().printSharedCounters();
            TTLDestroyBB.getBB().zeroAllCounters();
            return;
        }
    }

    public void controlRegionTTLLocalDestroy() {
        String regionName = regionNames[1];
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            this.populateRegion(regionName);
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        TestHelper.waitForCounter(TTLLocalDestroyBB.getBB(), "numAfterRegionDestroyEvents_isNotRemote", TTLLocalDestroyBB.numAfterRegionDestroyEvents_isNotRemote, 1L, true, 600000L);
        try {
            aRegion.keys().size();
            throw new TestException("Expected exception for region destroy, but did not get one");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            this.checkRegionEventsForLocalDestroy(TTLLocalDestroyBB.getBB());
            TTLLocalDestroyBB.getBB().printSharedCounters();
            TTLLocalDestroyBB.getBB().zeroAllCounters();
            return;
        }
    }

    public void controlRegionTTLInval() {
        String regionName = regionNames[2];
        int numKeys = this.populateRegion(regionName);
        String key2 = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key2 + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key2, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterCreateEvents_isNotExp", TTLInvalBB.numAfterCreateEvents_isNotExp, numVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterRegionInvalidateEvents_isRemote", TTLInvalBB.numAfterRegionInvalidateEvents_isRemote, numRemoteVMs, true, 600000L);
        TestHelper.waitForCounter(TTLInvalBB.getBB(), "numAfterRegionInvalidateEvents_isNotRemote", TTLInvalBB.numAfterRegionInvalidateEvents_isNotRemote, 1L, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        for (String key2 : aRegion.keys()) {
            try {
                Object value = aRegion.get((Object)key2);
                if (value == null) continue;
                throw new TestException("Found key " + key2 + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        this.checkRegionEventsForInvalidate(TTLInvalBB.getBB(), numKeys);
        TTLInvalBB.getBB().printSharedCounters();
        TTLInvalBB.getBB().zeroAllCounters();
    }

    public void controlRegionTTLLocalInval() {
        String regionName = regionNames[3];
        int numKeys = this.populateRegion(regionName);
        String key = regionName + "_numKeys";
        Log.getLogWriter().info("Putting " + key + ", " + numKeys + " into ExpirationBB");
        ExpirationBB.getBB().getSharedMap().put(key, new Integer(numKeys));
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(TTLLocalInvalBB.getBB(), "numAfterCreateEvents_isRemote", TTLLocalInvalBB.numAfterCreateEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(TTLLocalInvalBB.getBB(), "numAfterRegionInvalidateEvents_isNotRemote", TTLLocalInvalBB.numAfterRegionInvalidateEvents_isNotRemote, 1L, true, 600000L);
        this.checkRegionEventsForLocalInvalidate(TTLLocalInvalBB.getBB(), numKeys);
        TTLLocalInvalBB.getBB().printSharedCounters();
        TTLLocalInvalBB.getBB().zeroAllCounters();
    }

    public void controlRegionIdleTODestroy() {
        String regionName = regionNames[4];
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            this.populateRegion(regionName);
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(IdleTODestroyBB.getBB(), "numAfterRegionDestroyEvents_isRemote", IdleTODestroyBB.numAfterRegionDestroyEvents_isRemote, numRemoteVMs, true, 600000L);
        TestHelper.waitForCounter(IdleTODestroyBB.getBB(), "numAfterRegionDestroyEvents_isNotRemote", IdleTODestroyBB.numAfterRegionDestroyEvents_isNotRemote, 1L, true, 600000L);
        try {
            aRegion.keys().size();
            throw new TestException("Expected exception for region destroy, but did not get one");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            this.checkRegionEventsForDestroy(IdleTODestroyBB.getBB());
            IdleTODestroyBB.getBB().printSharedCounters();
            IdleTODestroyBB.getBB().zeroAllCounters();
            return;
        }
    }

    public void controlRegionIdleTOLocalDestroy() {
        String regionName = regionNames[5];
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        try {
            this.populateRegion(regionName);
        }
        catch (RegionDestroyedException regionDestroyedException) {
            // empty catch block
        }
        TestHelper.waitForCounter(IdleTOLocalDestroyBB.getBB(), "numAfterRegionDestroyEvents_isNotRemote", IdleTOLocalDestroyBB.numAfterRegionDestroyEvents_isNotRemote, 1L, true, 600000L);
        try {
            aRegion.keys().size();
            throw new TestException("Expected exception for region destroy, but did not get one");
        }
        catch (RegionDestroyedException regionDestroyedException) {
            this.checkRegionEventsForLocalDestroy(IdleTOLocalDestroyBB.getBB());
            IdleTOLocalDestroyBB.getBB().printSharedCounters();
            IdleTOLocalDestroyBB.getBB().zeroAllCounters();
            return;
        }
    }

    public void controlRegionIdleTOInval() {
        String regionName = regionNames[6];
        int numKeys = this.populateRegion(regionName);
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(IdleTOInvalBB.getBB(), "numAfterRegionInvalidateEvents_isRemote", IdleTOInvalBB.numAfterRegionInvalidateEvents_isRemote, numRemoteVMs, true, 600000L);
        TestHelper.waitForCounter(IdleTOInvalBB.getBB(), "numAfterRegionInvalidateEvents_isNotRemote", IdleTOInvalBB.numAfterRegionInvalidateEvents_isNotRemote, 1L, true, 600000L);
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        for (Object key : aRegion.keys()) {
            try {
                Object value = aRegion.get(key);
                if (value == null) continue;
                throw new TestException("Found key " + key + " with non-null value " + value);
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheLoaderException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
        }
        this.checkRegionEventsForInvalidate(IdleTOInvalBB.getBB(), numKeys);
        IdleTOInvalBB.getBB().printSharedCounters();
        IdleTOInvalBB.getBB().zeroAllCounters();
    }

    public void controlRegionIdleTOLocalInval() {
        String regionName = regionNames[7];
        int numKeys = this.populateRegion(regionName);
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        TestHelper.waitForCounter(IdleTOLocalInvalBB.getBB(), "numAfterCreateEvents_isRemote", IdleTOLocalInvalBB.numAfterCreateEvents_isRemote, numRemoteVMs * numKeys, true, 600000L);
        TestHelper.waitForCounter(IdleTOLocalInvalBB.getBB(), "numAfterRegionInvalidateEvents_isNotRemote", IdleTOLocalInvalBB.numAfterRegionInvalidateEvents_isNotRemote, 1L, true, 600000L);
        this.checkRegionEventsForLocalInvalidate(IdleTOLocalInvalBB.getBB(), numKeys);
        IdleTOLocalInvalBB.getBB().printSharedCounters();
        IdleTOLocalInvalBB.getBB().zeroAllCounters();
    }

    protected int populateRegion(String regionName) {
        Cache theCache = CacheUtil.getCache();
        Region aRegion = theCache.getRegion(regionName);
        Log.getLogWriter().info("Populating region " + regionName + ", aRegion is " + TestHelper.regionToString(aRegion, true));
        String keyPrefix = regionName + "_";
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long msToRun = minTaskGranularitySec * 1000L;
        Log.getLogWriter().info("Putting for " + msToRun + " ms");
        int numKeys = 0;
        long startTimeMs = System.currentTimeMillis();
        do {
            String key = keyPrefix + ++numKeys;
            Long value = new Long(numKeys);
            try {
                Log.getLogWriter().info("Putting key " + key + ", value " + value + " into region " + regionName);
                if (TestConfig.tab().booleanAt(ExpirPrms.useTransactions, false)) {
                    TxHelper.begin();
                }
                long putStart = System.currentTimeMillis();
                aRegion.put((Object)key, (Object)value);
                long putEnd = System.currentTimeMillis();
                long duration = putEnd - putStart;
                Log.getLogWriter().info("Done putting key " + key + ", value " + value + " into region " + regionName + ", put took " + duration + " ms");
            }
            catch (TimeoutException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            catch (CacheWriterException e) {
                throw new TestException(TestHelper.getStackTrace(e));
            }
            finally {
                if (TxHelper.exists()) {
                    TxHelper.commitExpectSuccess();
                }
            }
        } while (System.currentTimeMillis() - startTimeMs < msToRun);
        Log.getLogWriter().info("Done putting into " + regionName + " for " + msToRun + " ms, put " + numKeys + " keys/values");
        return numKeys;
    }

    protected void checkEntryEventsForDestroy(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        if (bb instanceof TTLDestroyBB) {
            ((TTLDestroyBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTODestroyBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkEntryEventsForLocalDestroy(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numEntries, numEntries, 0L, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        if (bb instanceof TTLLocalDestroyBB) {
            ((TTLLocalDestroyBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOLocalDestroyBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkEntryEventsForInvalidate(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        if (bb instanceof TTLInvalBB) {
            ((TTLInvalBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOInvalBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkEntryEventsForLocalInvalidate(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, numEntries, numEntries, 0L, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
        if (bb instanceof TTLLocalInvalBB) {
            ((TTLLocalInvalBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOLocalInvalBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkRegionEventsForDestroy(Blackboard bb) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{-1L, 0L, 0L, -1L, -1L, -1L, 0L, -1L, 0L, -1L, 0L, -1L, 0L, -1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, numVMs, 0L, numVMs, 0L, numRemoteVMs, 1L, 0L, 0L, 0L, 0L, 0L, 0L, numVMs};
        if (bb instanceof TTLDestroyBB) {
            ((TTLDestroyBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTODestroyBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkRegionEventsForLocalDestroy(Blackboard bb) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        long[] expectedValues = new long[]{-1L, 0L, 0L, -1L, -1L, -1L, 0L, -1L, 0L, -1L, 0L, -1L, 0L, -1L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1L, 0L, 0L, 0L, 0L, 0L, 0L, 1L};
        if (bb instanceof TTLLocalDestroyBB) {
            ((TTLLocalDestroyBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOLocalDestroyBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkRegionEventsForInvalidate(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, numVMs, 0L, numVMs, 0L, numRemoteVMs, 1L, 0L};
        if (bb instanceof TTLInvalBB) {
            ((TTLInvalBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOInvalBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void checkRegionEventsForLocalInvalidate(Blackboard bb, int numEntries) {
        Log.getLogWriter().info("Checking event counters in " + bb.getClass().getName());
        int numVMs = TestHelper.getNumVMs();
        int numRemoteVMs = numVMs - 1;
        long[] expectedValues = new long[]{numVMs * numEntries, 0L, 0L, numVMs * numEntries, numRemoteVMs * numEntries, numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, numVMs * numEntries, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 1L, 0L, 0L, 1L, 0L};
        if (bb instanceof TTLLocalInvalBB) {
            ((TTLLocalInvalBB)bb).checkEventCounters(expectedValues);
        } else {
            ((IdleTOLocalInvalBB)bb).checkEventCounters(expectedValues);
        }
        Log.getLogWriter().info("Done checking event counters in " + bb.getClass().getName() + ", no errors detected");
    }

    protected void logRegionContents(String regionName) {
        Region aRegion = CacheUtil.getCache().getRegion(regionName);
        if (aRegion == null) {
            Log.getLogWriter().info("Cannot log region " + regionName + ", aRegion is null (it does not exist)");
            return;
        }
        String key = aRegion.getName() + "_numKeys";
        Object anObj = ExpirationBB.getBB().getSharedMap().get(key);
        if (anObj == null) {
            Log.getLogWriter().info("Blackboard map for " + key + " is null");
        } else {
            int numKeys = (Integer)anObj;
            Log.getLogWriter().info("Logging region contents for region " + aRegion.getName() + " based on numKeys " + numKeys + "\n" + this.regionContentsToString(aRegion, numKeys));
        }
    }

    protected String regionContentsToString(Region aRegion, int numKeys) {
        StringBuffer aStr = new StringBuffer();
        aStr.append("Region " + aRegion.getName() + " has " + aRegion.keys().size() + " keys\n");
        int startRange = 1;
        boolean currentContainsKey = true;
        boolean currentContainsValueForKey = true;
        for (int i = 1; i <= numKeys; ++i) {
            String key = aRegion.getName() + "_" + i;
            boolean containsKey = aRegion.containsKey((Object)key);
            boolean containsValueForKey = aRegion.containsValueForKey((Object)key);
            if (i == 1) {
                currentContainsKey = containsKey;
                currentContainsValueForKey = containsValueForKey;
                continue;
            }
            if (i == numKeys) {
                aStr.append(startRange + " - " + i + ", containsKey: " + currentContainsKey + ", containsValue: " + currentContainsValueForKey + "\n");
                continue;
            }
            if (containsKey == currentContainsKey) {
                if (containsValueForKey != currentContainsValueForKey) {
                    aStr.append(startRange + " - " + (i - 1) + ", containsKey: " + currentContainsKey + ", containsValue: " + currentContainsValueForKey + "\n");
                    startRange = i;
                }
            } else {
                aStr.append(startRange + " - " + (i - 1) + ", containsKey: " + currentContainsKey + ", containsValue: " + currentContainsValueForKey + "\n");
                startRange = i;
            }
            currentContainsKey = containsKey;
            currentContainsValueForKey = containsValueForKey;
        }
        return aStr.toString();
    }

    protected void wrapUp() {
        ExpirationBB.getBB().getSharedCounters().increment(ExpirationBB.DoneWithTask);
        TestHelper.waitForCounter(ExpirationBB.getBB(), "DoneWithTask", ExpirationBB.DoneWithTask, 8L, true, -1L);
        ExpirationTest.HydraTask_logRegionContents();
        ExpirationBB.getBB().getSharedCounters().increment(ExpirationBB.DoneLoggingRegion);
    }

    static {
        regionNames = new String[8];
        ExpirationTest.regionNames[0] = "TTLDestroy";
        ExpirationTest.regionNames[1] = "TTLLocalDestroy";
        ExpirationTest.regionNames[2] = "TTLInval";
        ExpirationTest.regionNames[3] = "TTLLocalInval";
        ExpirationTest.regionNames[4] = "IdleTODestroy";
        ExpirationTest.regionNames[5] = "IdleTOLocalDestroy";
        ExpirationTest.regionNames[6] = "IdleTOInval";
        ExpirationTest.regionNames[7] = "IdleTOLocalInval";
        regionListenerClassNames = new String[8];
        ExpirationTest.regionListenerClassNames[0] = TTLDestroyListener.class.getName();
        ExpirationTest.regionListenerClassNames[1] = TTLLocalDestroyListener.class.getName();
        ExpirationTest.regionListenerClassNames[2] = TTLInvalListener.class.getName();
        ExpirationTest.regionListenerClassNames[3] = TTLLocalInvalListener.class.getName();
        ExpirationTest.regionListenerClassNames[4] = IdleTODestroyListener.class.getName();
        ExpirationTest.regionListenerClassNames[5] = IdleTOLocalDestroyListener.class.getName();
        ExpirationTest.regionListenerClassNames[6] = IdleTOInvalListener.class.getName();
        ExpirationTest.regionListenerClassNames[7] = IdleTOLocalInvalListener.class.getName();
        threadGroupNames = new String[8];
        ExpirationTest.threadGroupNames[0] = "verifyTTLDestroyThreads";
        ExpirationTest.threadGroupNames[1] = "verifyTTLLocalDestroyThreads";
        ExpirationTest.threadGroupNames[2] = "verifyTTLInvalThreads";
        ExpirationTest.threadGroupNames[3] = "verifyTTLLocalInvalThreads";
        ExpirationTest.threadGroupNames[4] = "verifyIdleTODestroyThreads";
        ExpirationTest.threadGroupNames[5] = "verifyIdleTOLocalDestroyThreads";
        ExpirationTest.threadGroupNames[6] = "verifyIdleTOInvalThreads";
        ExpirationTest.threadGroupNames[7] = "verifyIdleTOLocalInvalThreads";
    }
}

