/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.EntryExistsException;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.gemstone.gemfire.cache.RegionEvent;
import event.EventPrms;
import event.ProxyEventTest;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.TestConfig;
import java.util.Properties;
import util.AbstractListener;
import util.CacheUtil;
import util.TestException;
import util.TestHelper;

public class ShadowListener
extends AbstractListener
implements CacheListener,
Declarable {
    protected boolean isCarefulValidation;
    private boolean useTransactions;

    public ShadowListener() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
        this.useTransactions = tab.booleanAt(EventPrms.useTransactions, false);
    }

    public ShadowListener(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void afterCreate(EntryEvent event) {
        this.logCall("afterCreate", (CacheEvent)event);
        if (CacheUtil.getCache().isClosed()) {
            return;
        }
        final Region shadow = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.shadowRegionName);
        final Object key = event.getKey();
        final Object val = event.getNewValue();
        String threadName = "ShadowListener_CreateThread";
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Log.getLogWriter().info("Creating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
                try {
                    shadow.create(key, val);
                }
                catch (CacheClosedException cacheClosedException) {
                }
                catch (RegionDestroyedException e) {
                    if (ShadowListener.this.isCarefulValidation) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ShadowListener: afterCreate() caught exception " + (Object)((Object)e) + " while creating ShadowRegion (expected with concurrent execution); continuing with test");
                }
                catch (EntryExistsException e) {
                    if (ShadowListener.this.isCarefulValidation) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ShadowListener: afterCreate() caught exception " + (Object)((Object)e) + "while creating entry in ShadowRegion (expected with concurrent execution); continuing with test");
                }
                Log.getLogWriter().info("Done Creating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
            }
        }, threadName);
        workThread.start();
    }

    public void afterDestroy(EntryEvent event) {
        this.logCall("afterDestroy", (CacheEvent)event);
        if (CacheUtil.getCache().isClosed()) {
            return;
        }
        final Region shadow = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.shadowRegionName);
        final Object key = event.getKey();
        final Operation op = event.getOperation();
        String threadName = "ShadowListener_DestroyThread";
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Log.getLogWriter().info("Destroying key (" + key + ") in region named " + shadow.getName());
                try {
                    if (op.equals(Operation.LOCAL_DESTROY)) {
                        shadow.localDestroy(key);
                    } else {
                        shadow.destroy(key);
                    }
                }
                catch (CacheClosedException cacheClosedException) {
                }
                catch (EntryNotFoundException e) {
                    if (ShadowListener.this.isCarefulValidation) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ShadowListener: afterDestroy() caught exception " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    return;
                }
                Log.getLogWriter().info("Done Destroying key(" + key + ") in region named " + shadow.getName());
            }
        }, threadName);
        workThread.start();
    }

    public void afterInvalidate(EntryEvent event) {
        this.logCall("afterInvalidate", (CacheEvent)event);
        if (CacheUtil.getCache().isClosed()) {
            return;
        }
        final Region shadow = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.shadowRegionName);
        final Object key = event.getKey();
        final Operation op = event.getOperation();
        String threadName = "ShadowListener_InvalidateThread";
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                Log.getLogWriter().info("Invalidating key(" + key + ") in region named " + shadow.getName());
                try {
                    if (op.equals(Operation.LOCAL_INVALIDATE)) {
                        shadow.localInvalidate(key);
                    } else {
                        shadow.invalidate(key);
                    }
                }
                catch (CacheClosedException cacheClosedException) {
                }
                catch (EntryNotFoundException e) {
                    if (ShadowListener.this.isCarefulValidation) {
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                    Log.getLogWriter().info("ShadowListener: afterInvalidate caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    return;
                }
                Log.getLogWriter().info("Done Invalidating key(" + key + ") in region named " + shadow.getName());
            }
        }, threadName);
        workThread.start();
    }

    public void afterUpdate(EntryEvent event) {
        this.logCall("afterUpdate", (CacheEvent)event);
        if (CacheUtil.getCache().isClosed()) {
            return;
        }
        final Region shadow = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.shadowRegionName);
        final Object key = event.getKey();
        final Object val = event.getNewValue();
        String threadName = "ShadowListener_UpdateThread";
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (val != null) {
                    Log.getLogWriter().info("Updating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
                    try {
                        shadow.put(key, val);
                        Log.getLogWriter().info("Done Updating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
                    }
                    catch (CacheClosedException cacheClosedException) {}
                } else {
                    Log.getLogWriter().info("Invalidating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
                    try {
                        shadow.invalidate(key);
                        Log.getLogWriter().info("Done Invalidating key/value pair (" + key + ", " + val + ") in region named " + shadow.getName());
                    }
                    catch (CacheClosedException cacheClosedException) {
                    }
                    catch (EntryNotFoundException e) {
                        if (ShadowListener.this.isCarefulValidation) {
                            throw new TestException(TestHelper.getStackTrace(e));
                        }
                        Log.getLogWriter().info("ShadowListener: afterUpdate (invalidate) caught " + (Object)((Object)e) + " (expected with concurrent execution); continuing with test");
                    }
                }
            }
        }, threadName);
        workThread.start();
    }

    public void afterRegionCreate(RegionEvent event) {
        this.logCall("afterRegionCreate", (CacheEvent)event);
    }

    public void afterRegionDestroy(RegionEvent event) {
        this.logCall("afterRegionDestroy", (CacheEvent)event);
    }

    public void afterRegionInvalidate(RegionEvent event) {
        this.logCall("afterRegionInvalidate", (CacheEvent)event);
    }

    public void afterRegionLive(RegionEvent event) {
        this.logCall("afterRegionLive", (CacheEvent)event);
    }

    public void afterRegionClear(RegionEvent event) {
        this.logCall("afterRegionClear", (CacheEvent)event);
        if (CacheUtil.getCache().isClosed()) {
            return;
        }
        final Region shadow = CacheUtil.getCache().getRegion(ProxyEventTest.eventTest.shadowRegionName);
        String threadName = "ShadowListener_ClearRegionThread";
        Thread workThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block3: {
                    try {
                        shadow.clear();
                    }
                    catch (CacheClosedException cacheClosedException) {
                    }
                    catch (RegionDestroyedException e) {
                        if (!ShadowListener.this.isCarefulValidation) break block3;
                        throw new TestException(TestHelper.getStackTrace(e));
                    }
                }
            }
        }, threadName);
        workThread.start();
    }

    public void close() {
        this.logCall("close", null);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

