/*
 * Decompiled with CFR 0.152.
 */
package event;

import com.gemstone.gemfire.cache.CacheEvent;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.Operation;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.cache.Token;
import diskReg.DiskRegUtil;
import event.EventBB;
import event.EventPrms;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.Prms;
import hydra.ProcessMgr;
import hydra.TestConfig;
import hydra.blackboard.SharedMap;
import java.util.Properties;
import util.AbstractWriter;
import util.BaseValueHolder;
import util.TestException;
import util.TestHelper;
import util.WriterCountersBB;

public class CMWriter
extends AbstractWriter
implements CacheWriter,
Declarable {
    private boolean isCarefulValidation;
    private boolean useTransactions;

    public CMWriter() {
        TestConfig config = TestConfig.getInstance();
        ConfigHashtable tab = config.getParameters();
        this.isCarefulValidation = tab.booleanAt(Prms.serialExecution);
        this.useTransactions = tab.booleanAt(EventPrms.useTransactions, false);
    }

    public CMWriter(boolean isCarefulValidation) {
        this.isCarefulValidation = isCarefulValidation;
    }

    public void beforeCreate(EntryEvent event) {
        this.logCall("beforeCreate", (CacheEvent)event);
        this.incrementBeforeCreateCounters(event, WriterCountersBB.getBB());
        this.checkVM();
        String sKey = (String)event.getKey();
        this.compareValueInVM("beforeCreate", event);
    }

    public void beforeDestroy(EntryEvent event) {
        this.logCall("beforeDestroy", (CacheEvent)event);
        this.incrementBeforeDestroyCounters(event, WriterCountersBB.getBB());
        this.checkVM();
        this.compareValueInVM("beforeDestroy", event);
    }

    public void beforeUpdate(EntryEvent event) {
        this.logCall("beforeUpdate", (CacheEvent)event);
        this.incrementBeforeUpdateCounters(event, WriterCountersBB.getBB());
        this.checkVM();
        this.compareValueInVM("beforeUpdate", event);
    }

    public void beforeRegionDestroy(RegionEvent event) {
        this.logCall("beforeRegionDestroy", (CacheEvent)event);
        this.incrementBeforeRegionDestroyCounters(event, WriterCountersBB.getBB());
        this.checkVM();
        if (!event.getOperation().equals(Operation.CACHE_CLOSE) && this.isCarefulValidation) {
            Region region = event.getRegion();
            try {
                region.size();
            }
            catch (Exception e) {
                this.throwException("CMWriter: beforeRegionDestroy() caught " + e + " during beforeRegionDestroy");
            }
        }
    }

    public void beforeRegionClear(RegionEvent event) {
        this.logCall("beforeRegionClear", (CacheEvent)event);
        if (!this.isCarefulValidation) {
            return;
        }
        Region region = event.getRegion();
        try {
            region.size();
        }
        catch (Exception e) {
            this.throwException("CMWriter: beforeRegionClear() caught " + e + " during beforeRegionClear");
        }
    }

    public void close() {
        this.logCall("close", null);
    }

    private void compareValueInVM(String callbackMethod, EntryEvent event) {
        if (!this.isCarefulValidation) {
            return;
        }
        Object key = event.getKey();
        Object expectedValue = event.getOldValue();
        Region region = event.getRegion();
        Object actualValue = DiskRegUtil.getValueInVM(region, key);
        if (this.useTransactions) {
            return;
        }
        String sActualValue = actualValue == null ? "null" : TestHelper.toString(actualValue);
        String sExpectedValue = expectedValue == null ? "null" : TestHelper.toString(expectedValue);
        Log.getLogWriter().info("CMWriter: " + callbackMethod + "(): comparing expectedValue " + sExpectedValue + " against actualValue " + sActualValue + " for key = " + key);
        String myException = null;
        if (expectedValue == null) {
            if (!event.isOldValueAvailable()) {
                if (actualValue == null) {
                    Log.getLogWriter().info("CMWriter: " + callbackMethod + "() expected " + sExpectedValue + " but getValueInVM() returned null");
                } else {
                    myException = "CMWriter: " + callbackMethod + "() since oldValue was unavailable for key " + key + " expected actualValue to be null but instead found value of " + sActualValue;
                }
            } else if (actualValue != null && !Token.isInvalid((Object)actualValue)) {
                myException = "CMWriter: " + callbackMethod + "() expects null or INVALID value, but found " + sActualValue;
            }
        } else if (expectedValue instanceof BaseValueHolder && actualValue instanceof BaseValueHolder) {
            if (!((BaseValueHolder)actualValue).equals((BaseValueHolder)expectedValue)) {
                myException = "CMWriter: " + callbackMethod + "() expects to find oldValue " + sExpectedValue + " for key " + key + " but instead found value of " + sActualValue;
            }
        } else if (actualValue == null) {
            myException = "CMWriter: " + callbackMethod + "() expects " + sExpectedValue + " but received an actualValue of null";
        } else if (!actualValue.equals(expectedValue)) {
            myException = "CMWriter: " + callbackMethod + "() expects to find oldValue " + sExpectedValue + " for key " + key + " but instead found value of " + sActualValue;
        }
        if (myException != null) {
            this.throwException(myException);
        }
    }

    protected void checkVM() {
        int myPID = ProcessMgr.getProcessId();
        if (this.whereIWasRegistered != myPID) {
            String errStr = "Expected cacheWriter to be invoked in VM " + this.whereIWasRegistered + ", but it was invoked in " + myPID + ": " + this.toString() + "; see system.log for call stack";
            SharedMap aMap = EventBB.getBB().getSharedMap();
            aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
            Log.getLogWriter().info(errStr);
            throw new TestException(errStr);
        }
    }

    protected void throwException(String errStr) {
        SharedMap aMap = EventBB.getBB().getSharedMap();
        aMap.put(TestHelper.EVENT_ERROR_KEY, errStr + " " + TestHelper.getStackTrace());
        Log.getLogWriter().info(errStr);
        throw new TestException(errStr);
    }

    public void init(Properties prop) {
        this.logCall("init(Properties)", null);
    }
}

