/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import dlock.DLockTestException;
import dlock.Lockable;
import hydra.Log;
import java.io.Serializable;

public class Info
implements Serializable {
    private Object name;
    private Lockable wrapper;
    private boolean locked;
    private long locks;
    private long unlocks;
    private long reads;
    private long updates;
    private boolean debugFine = false;

    public Info(Object name, Lockable wrapper) {
        this.name = name;
        this.wrapper = wrapper;
        this.locked = false;
        this.locks = 0L;
        this.unlocks = 0L;
        this.reads = 0L;
        this.updates = 0L;
        this.debugFine = Log.getLogWriter().fineEnabled();
    }

    public Object getName() {
        return this.name;
    }

    public Lockable getWrapper() {
        return this.wrapper;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public long getLocks() {
        return this.locks;
    }

    public void incrementLocks() {
        ++this.locks;
        if (this.debugFine) {
            Log.getLogWriter().fine("Details " + this.name + "; incremented locks: " + this.toString());
        }
    }

    public long getUnlocks() {
        return this.unlocks;
    }

    public void incrementUnlocks() {
        ++this.unlocks;
        if (this.debugFine) {
            Log.getLogWriter().fine("Details " + this.name + "; incremented unlocks: " + this.toString());
        }
    }

    public long getReads() {
        return this.reads;
    }

    public void incrementReads() {
        ++this.reads;
        if (this.debugFine) {
            Log.getLogWriter().fine("Details " + this.name + "; incremented reads: " + this.toString());
        }
    }

    public long getUpdates() {
        return this.updates;
    }

    public void incrementUpdates() {
        ++this.updates;
        if (this.debugFine) {
            Log.getLogWriter().fine("Details " + this.name + "; incremented updates: " + this.toString());
        }
    }

    public void addInfo(Info info) {
        if (!this.getName().equals(info.getName())) {
            throw new DLockTestException("Mismatched name!!!");
        }
        if (!this.getWrapper().getClass().getName().equals(info.getWrapper().getClass().getName())) {
            throw new DLockTestException("Mismatched wrapper!!! " + this.getWrapper().getClass().getName() + " != " + info.getWrapper().getClass().getName());
        }
        if (this.isLocked() || info.isLocked()) {
            throw new DLockTestException("Object still locked!!!");
        }
        this.locks += info.getLocks();
        this.unlocks += info.getUnlocks();
        this.reads += info.getReads();
        this.updates += info.getUpdates();
        Log.getLogWriter().info("Info for name " + this.name + "; added info: " + this.toString());
    }

    public String toShortString() {
        return this.name + " (" + this.wrapper.getClass().getName() + ")";
    }

    public String toString() {
        return this.name + " locks=" + this.locks + " unlocks=" + this.unlocks + " reads=" + this.reads + " updates=" + this.updates;
    }
}

