/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.internal.locks.DLockService;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockUtil;
import hydra.ConfigHashtable;
import hydra.Log;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import util.TestException;
import util.TestHelper;
import util.TestHelperPrms;

public class FairnessTest {
    protected static final String ObjectToLock = "objectToLock";

    public static void HydraTask_fairnessTest() {
        FairnessTest testInstance = new FairnessTest();
        testInstance.doFairnessTest();
    }

    public static void HydraTask_verify() {
        FairnessTest testInstance = new FairnessTest();
        testInstance.verify();
    }

    private void doFairnessTest() {
        DistributedLockService dls = DLockUtil.getLockService();
        this.makeSureDLSIsReady(dls);
        if (dls.isLockGrantor()) {
            return;
        }
        long minTaskGranularitySec = TestConfig.tab().longAt(TestHelperPrms.minTaskGranularitySec);
        long minTaskGranularityMS = minTaskGranularitySec * 1000L;
        int totalVMs = TestHelper.getNumVMs();
        int totalThreads = TestHelper.getNumThreads();
        int threadsPerVM = totalThreads / totalVMs;
        int numThreads = totalThreads - threadsPerVM;
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedCounters sc = bb.getSharedCounters();
        long counterValue = sc.incrementAndRead(DLockBlackboard.ReadyToLock);
        if (counterValue > (long)numThreads) {
            throw new TestException("This task might have been invoked more than once; it is intented to run once per thread");
        }
        TestHelper.waitForCounter(bb, "DLockBlackboard.ReadyToLock", DLockBlackboard.ReadyToLock, numThreads, true, 300000L);
        long startLoopTime = System.currentTimeMillis();
        int lockCount = 0;
        do {
            dls.lock((Object)ObjectToLock, -1L, -1L);
            dls.unlock((Object)ObjectToLock);
            ++lockCount;
        } while (System.currentTimeMillis() - startLoopTime < minTaskGranularityMS);
        Log.getLogWriter().info("Done with task, obtained lock " + lockCount + " times");
        DLockBlackboard.getInstance().getSharedMap().put(Thread.currentThread().getName(), new Integer(lockCount));
    }

    private void makeSureDLSIsReady(DistributedLockService dls) {
        DLockService dlock = (DLockService)dls;
        dlock.getLockGrantorId();
    }

    protected void verify() {
        Map aMap = DLockBlackboard.getInstance().getSharedMap().getMap();
        int totalLocks = 0;
        Iterator it = new TreeMap(aMap).keySet().iterator();
        StringBuffer aStr = new StringBuffer();
        while (it.hasNext()) {
            String threadId = (String)it.next();
            int numLocks = (Integer)aMap.get(threadId);
            aStr.append(threadId + " obtained " + numLocks + " locks \n");
            totalLocks += numLocks;
        }
        Log.getLogWriter().info(aStr.toString());
        aStr = new StringBuffer();
        int totalVMs = TestHelper.getNumVMs();
        int totalThreads = TestHelper.getNumThreads();
        int threadsPerVM = totalThreads / totalVMs;
        int numThreads = totalThreads - threadsPerVM;
        it = aMap.keySet().iterator();
        int expectedLocks = totalLocks / numThreads;
        double devMultiplier = FairnessTest.tab().doubleAt(DLockPrms.fairnessDeviationMultiplier);
        if (devMultiplier == 0.0) {
            devMultiplier = 0.2;
        }
        int deviation = (int)((double)expectedLocks * devMultiplier);
        int lowThreshold = expectedLocks - deviation;
        int highThreshold = expectedLocks + deviation;
        Log.getLogWriter().info("Checking for fairness, numThreads is " + numThreads + ", totalLocks is " + totalLocks + ", expectedLocks is " + expectedLocks + ", deviation multiplier is " + devMultiplier + ", deviation is " + deviation + ", lowThreshold is " + lowThreshold + ", highThreshold is " + highThreshold);
        while (it.hasNext()) {
            String threadId = (String)it.next();
            int numLocks = (Integer)aMap.get(threadId);
            if (numLocks >= lowThreshold && numLocks <= highThreshold) continue;
            aStr.append("Expected thread " + threadId + " to have obtained between " + lowThreshold + " and " + highThreshold + " locks, but it obtained " + numLocks + "\n");
        }
        if (aStr.length() > 0) {
            throw new TestException(aStr.toString());
        }
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }
}

