/*
 * Decompiled with CFR 0.152.
 */
package dlock;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.LogWriter;
import com.gemstone.gemfire.distributed.DistributedLockService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.Assert;
import dlock.DLockBlackboard;
import dlock.DLockPrms;
import dlock.DLockTestException;
import dlock.DLockUtil;
import hydra.ConfigHashtable;
import hydra.DistributedConnectionMgr;
import hydra.Log;
import hydra.RemoteTestModule;
import hydra.StopSchedulingTaskOnClientOrder;
import hydra.TestConfig;
import hydra.blackboard.SharedCounters;
import hydra.blackboard.SharedMap;
import java.io.Serializable;
import java.util.LinkedList;
import util.TestException;
import util.TestHelper;

public class ElderTest {
    protected static final String ObjectToLock = "objectToLock";
    private static final String MEMBER_START_ORDER = "MemberStartOrder";
    private static final String ELDER_CLIENT_NAME = "ElderClientName";
    private static final String ELDER_ID = "ElderId";

    public static void initTask() {
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedMap aMap = bb.getSharedMap();
        aMap.put(MEMBER_START_ORDER, new LinkedList());
    }

    public static void initElderTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.initElder();
    }

    private void initElder() {
        LinkedList startOrderList = null;
        String clientName = RemoteTestModule.getMyClientName();
        DLockBlackboard bb = DLockBlackboard.getInstance();
        startOrderList = (LinkedList)bb.getSharedMap().get(MEMBER_START_ORDER);
        startOrderList.add(clientName);
        ElderTest.log().info(clientName + " added to startOrderList");
        bb.getSharedMap().put(MEMBER_START_ORDER, startOrderList);
        ElderTest.log().info("Client: " + clientName + " start order is: " + startOrderList.size());
        DistributedLockService dls = DLockUtil.getLockService();
        boolean result = dls.lock((Object)ObjectToLock, -1L, -1L);
        ElderTest.log().info("Client: " + clientName + " got lock: " + result);
        dls.unlock((Object)ObjectToLock);
        DLockBlackboard.printBlackboard();
    }

    public static void disruptElderTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.disruptElder();
    }

    private void disruptElder() {
        LinkedList startOrderList = null;
        String clientName = RemoteTestModule.getMyClientName();
        ElderTest.log().info("ClientName is: " + clientName);
        DLockBlackboard bb = DLockBlackboard.getInstance();
        SharedCounters sc = bb.getSharedCounters();
        startOrderList = (LinkedList)bb.getSharedMap().get(MEMBER_START_ORDER);
        if (startOrderList.isEmpty()) {
            ElderTest.log().info("Disrupted all elders");
            throw new StopSchedulingTaskOnClientOrder();
        }
        ElderTest.log().info("calling verifyElder at start of disruptElder");
        this.verifyElder();
        int numThreads = ElderTest.tab().intAt(DLockPrms.numEldersToDisrupt);
        int waitLimit = -1;
        sc.zero(DLockBlackboard.DoneWithTask);
        sc.increment(DLockBlackboard.ReadyToLock);
        TestHelper.waitForCounter(bb, "DLockBlackboard.ReadyToLock", DLockBlackboard.ReadyToLock, numThreads, true, waitLimit);
        if (startOrderList.contains(clientName) && clientName.equals(bb.getSharedMap().get(ELDER_CLIENT_NAME))) {
            ElderTest.log().info("disrupting elder...which is: " + clientName);
            startOrderList.removeFirst();
            DistributedConnectionMgr.disconnect();
            DistributedConnectionMgr.connect();
            bb.getSharedMap().put(MEMBER_START_ORDER, startOrderList);
            ElderTest.log().info("Client: " + clientName + " start order is: " + startOrderList.size());
            ElderTest.log().info("#### requesting DistributedLockService");
            DistributedLockService dls = DLockUtil.getLockService();
            ElderTest.log().info("#### got DistributedLockService");
            if (dls.isLockGrantor()) {
                ElderTest.log().info("checking for grantor to force Elder selection");
            }
            ElderTest.log().info("#### requesting lock...");
            boolean result = dls.lock((Object)ObjectToLock, -1L, -1L);
            ElderTest.log().info("Client: " + clientName + " got lock: " + result);
            ElderTest.log().info("#### requesting unlock...");
            dls.unlock((Object)ObjectToLock);
            ElderTest.log().info("#### unlock done.");
        }
        sc.increment(DLockBlackboard.DoneWithTask);
        TestHelper.waitForCounter(bb, "DLockBlackboard.DoneWithTask", DLockBlackboard.DoneWithTask, numThreads, true, waitLimit);
        sc.zero(DLockBlackboard.ReadyToLock);
        ElderTest.log().info("Client: " + clientName + " calling identifyElder at end of disrupt");
        this.identifyElder();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            Log.getLogWriter().warning("Interrupted while sleeping", (Throwable)ex);
        }
    }

    public static void verifyElderTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.verifyElder();
    }

    private void verifyElder() {
        SharedMap aMap = DLockBlackboard.getInstance().getSharedMap();
        DLockBlackboard bb = DLockBlackboard.getInstance();
        LinkedList memberStartOrder = null;
        memberStartOrder = (LinkedList)bb.getSharedMap().get(MEMBER_START_ORDER);
        if (memberStartOrder.isEmpty()) {
            ElderTest.log().info("In verify test elders completed");
            return;
        }
        String testElder = (String)memberStartOrder.getFirst();
        ElderTest.log().info("Test says elder should be:  " + testElder);
        String elderClientName = (String)bb.getSharedMap().get(ELDER_CLIENT_NAME);
        ElderTest.log().info("Elder ClientName is: " + elderClientName);
        if (!testElder.equals(elderClientName)) {
            String s = "Test says elder is: " + testElder + " but elder is: " + elderClientName;
            throw new DLockTestException(s);
        }
        DistributedSystem system = this.getDistributedSystem();
        DM dm = ((InternalDistributedSystem)system).getDistributionManager();
        String clientName = RemoteTestModule.getMyClientName();
        InternalDistributedMember whoIThinkElderIs = dm.getElderId();
        Assert.assertTrue((whoIThinkElderIs != null ? 1 : 0) != 0, (Object)"null elder");
        Serializable elderId = (Serializable)bb.getSharedMap().get(ELDER_ID);
        if (!whoIThinkElderIs.equals(elderId)) {
            String s = "Client " + clientName + " says elder ID is: " + whoIThinkElderIs + " but elder ID is: " + elderId;
            throw new DLockTestException(s);
        }
    }

    public static void identifyElderTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.identifyElder();
    }

    private boolean identifyElder() {
        SharedMap map = DLockBlackboard.getInstance().getSharedMap();
        DistributedSystem system = this.getDistributedSystem();
        DM dm = ((InternalDistributedSystem)system).getDistributionManager();
        InternalDistributedMember whoIThinkElderIs = dm.getElderId();
        ElderTest.log().info("ElderID is: " + whoIThinkElderIs);
        Assert.assertTrue((whoIThinkElderIs != null ? 1 : 0) != 0, (Object)"null elder");
        boolean elderIsMe = whoIThinkElderIs.equals(dm.getId());
        if (elderIsMe) {
            ElderTest.log().info("Elder identified:  " + RemoteTestModule.getMyClientName());
            ElderTest.log().info("ElderID is: " + whoIThinkElderIs);
            map.put(ELDER_ID, whoIThinkElderIs);
            map.put(ELDER_CLIENT_NAME, RemoteTestModule.getMyClientName());
            return true;
        }
        return false;
    }

    public static void disconnectIfElderTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.disconnectIfElder();
    }

    private void disconnectIfElder() {
        if (this.identifyElder()) {
            ElderTest.log().info("Disconnecting... Elder is me: " + RemoteTestModule.getMyClientName());
            DistributedConnectionMgr.disconnect();
            DistributedConnectionMgr.connect();
        }
    }

    public static void becomeLockGrantorTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.becomeLockGrantor();
    }

    private void becomeLockGrantor() {
        String lockServiceName = "aLockService";
        DistributedLockService dls = this.getDistributedLockService(lockServiceName);
        if (!dls.isLockGrantor()) {
            int transferGrantorPercent = 10;
            if (TestConfig.tab().getRandGen().nextInt(1, 100) <= transferGrantorPercent) {
                ElderTest.log().info("requesting becomeLockGrantor");
                try {
                    dls.becomeLockGrantor();
                }
                catch (CancelException e) {
                    ElderTest.log().info("Caught exception " + (Object)((Object)e));
                }
            }
        }
    }

    public static void countGrantorsTask() {
        ElderTest testInstance = new ElderTest();
        testInstance.countGrantors();
    }

    private void countGrantors() {
        ElderTest.log().info("counting lock grantors");
        String lockServiceName = "aLockService";
        DistributedLockService dls = this.getDistributedLockService(lockServiceName);
        if (dls.isLockGrantor()) {
            ElderTest.log().info("is Lock Grantor ... incrementing count");
            DLockBlackboard bb = DLockBlackboard.getInstance();
            SharedCounters sc = bb.getSharedCounters();
            sc.increment(DLockBlackboard.NumGrantors);
        }
    }

    private DistributedLockService getDistributedLockService(String lockServiceName) {
        DistributedSystem dSystem = this.getDistributedSystem();
        if (dSystem == null) {
            throw new TestException("DistributedSystem is " + dSystem);
        }
        ElderTest.log().info("Getting DistributedLockService with name " + lockServiceName);
        DistributedLockService dls = DistributedLockService.getServiceNamed((String)lockServiceName);
        if (dls == null) {
            try {
                ElderTest.log().info("Creating DistributedLockService with name " + lockServiceName);
                dls = DistributedLockService.create((String)lockServiceName, (DistributedSystem)dSystem);
                Log.getLogWriter().info("Created " + dls);
            }
            catch (IllegalArgumentException ex) {
                Log.getLogWriter().info("Got expected Exception: Caught while creating dls " + ex);
                dls = DistributedLockService.getServiceNamed((String)lockServiceName);
            }
        }
        return dls;
    }

    private DistributedSystem getDistributedSystem() {
        if (DistributedConnectionMgr.isConnected()) {
            return DistributedConnectionMgr.getConnection();
        }
        return DistributedConnectionMgr.connect();
    }

    protected static LogWriter log() {
        return Log.getLogWriter();
    }

    protected static ConfigHashtable tab() {
        return TestConfig.tab();
    }
}

